/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.niws.loadbalancer;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.config.DynamicIntProperty;
import com.netflix.discovery.CacheRefreshedEvent;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaEvent;
import com.netflix.discovery.EurekaEventListener;
import com.netflix.loadbalancer.ServerListUpdater;
import com.netflix.niws.loadbalancer.LegacyEurekaClientProvider;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaNotificationServerListUpdater
implements ServerListUpdater {
    private static final Logger logger = LoggerFactory.getLogger(EurekaNotificationServerListUpdater.class);
    final AtomicBoolean updateQueued = new AtomicBoolean(false);
    private final AtomicBoolean isActive = new AtomicBoolean(false);
    private final AtomicLong lastUpdated = new AtomicLong(System.currentTimeMillis());
    private final Provider<EurekaClient> eurekaClientProvider;
    private final ExecutorService refreshExecutor;
    private volatile EurekaEventListener updateListener;
    private volatile EurekaClient eurekaClient;

    public static ExecutorService getDefaultRefreshExecutor() {
        return LazyHolder.SINGLETON.defaultServerListUpdateExecutor;
    }

    public EurekaNotificationServerListUpdater() {
        this(new LegacyEurekaClientProvider());
    }

    public EurekaNotificationServerListUpdater(Provider<EurekaClient> eurekaClientProvider) {
        this(eurekaClientProvider, EurekaNotificationServerListUpdater.getDefaultRefreshExecutor());
    }

    public EurekaNotificationServerListUpdater(Provider<EurekaClient> eurekaClientProvider, ExecutorService refreshExecutor) {
        this.eurekaClientProvider = eurekaClientProvider;
        this.refreshExecutor = refreshExecutor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void start(final ServerListUpdater.UpdateAction updateAction) {
        if (!this.isActive.compareAndSet(false, true)) {
            logger.info("Update listener already registered, no-op");
            return;
        }
        this.updateListener = new EurekaEventListener(){

            public void onEvent(EurekaEvent event) {
                if (event instanceof CacheRefreshedEvent) {
                    if (!EurekaNotificationServerListUpdater.this.updateQueued.compareAndSet(false, true)) {
                        logger.info("an update action is already queued, returning as no-op");
                        return;
                    }
                    if (!EurekaNotificationServerListUpdater.this.refreshExecutor.isShutdown()) {
                        try {
                            EurekaNotificationServerListUpdater.this.refreshExecutor.submit(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        updateAction.doUpdate();
                                        EurekaNotificationServerListUpdater.this.lastUpdated.set(System.currentTimeMillis());
                                    }
                                    catch (Exception e) {
                                        logger.warn("Failed to update serverList", (Throwable)e);
                                    }
                                    finally {
                                        EurekaNotificationServerListUpdater.this.updateQueued.set(false);
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            logger.warn("Error submitting update task to executor, skipping one round of updates", (Throwable)e);
                            EurekaNotificationServerListUpdater.this.updateQueued.set(false);
                        }
                    } else {
                        logger.debug("stopping EurekaNotificationServerListUpdater, as refreshExecutor has been shut down");
                        EurekaNotificationServerListUpdater.this.stop();
                    }
                }
            }
        };
        if (this.eurekaClient == null) {
            this.eurekaClient = (EurekaClient)this.eurekaClientProvider.get();
        }
        if (this.eurekaClient != null) {
            this.eurekaClient.registerEventListener(this.updateListener);
            return;
        }
        logger.error("Failed to register an updateListener to eureka client, eureka client is null");
        throw new IllegalStateException("Failed to start the updater, unable to register the update listener due to eureka client being null.");
    }

    public synchronized void stop() {
        if (this.isActive.compareAndSet(true, false)) {
            if (this.eurekaClient != null) {
                this.eurekaClient.unregisterEventListener(this.updateListener);
            }
        } else {
            logger.info("Not currently active, no-op");
        }
    }

    public String getLastUpdate() {
        return new Date(this.lastUpdated.get()).toString();
    }

    public long getDurationSinceLastUpdateMs() {
        return System.currentTimeMillis() - this.lastUpdated.get();
    }

    public int getNumberMissedCycles() {
        return 0;
    }

    public int getCoreThreads() {
        if (this.isActive.get() && this.refreshExecutor != null && this.refreshExecutor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.refreshExecutor).getCorePoolSize();
        }
        return 0;
    }

    private static class LazyHolder {
        private static final String CORE_THREAD = "EurekaNotificationServerListUpdater.ThreadPoolSize";
        private static final String QUEUE_SIZE = "EurekaNotificationServerListUpdater.queueSize";
        private static final LazyHolder SINGLETON = new LazyHolder();
        private final DynamicIntProperty poolSizeProp = new DynamicIntProperty("EurekaNotificationServerListUpdater.ThreadPoolSize", 2);
        private final DynamicIntProperty queueSizeProp = new DynamicIntProperty("EurekaNotificationServerListUpdater.queueSize", 1000);
        private final ThreadPoolExecutor defaultServerListUpdateExecutor;
        private final Thread shutdownThread;

        private LazyHolder() {
            int corePoolSize = this.getCorePoolSize();
            this.defaultServerListUpdateExecutor = new ThreadPoolExecutor(corePoolSize, corePoolSize * 5, 0L, TimeUnit.NANOSECONDS, new ArrayBlockingQueue<Runnable>(this.queueSizeProp.get()), new ThreadFactoryBuilder().setNameFormat("EurekaNotificationServerListUpdater-%d").setDaemon(true).build());
            this.poolSizeProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    int corePoolSize = this.getCorePoolSize();
                    defaultServerListUpdateExecutor.setCorePoolSize(corePoolSize);
                    defaultServerListUpdateExecutor.setMaximumPoolSize(corePoolSize * 5);
                }
            });
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    logger.info("Shutting down the Executor for EurekaNotificationServerListUpdater");
                    try {
                        defaultServerListUpdateExecutor.shutdown();
                        Runtime.getRuntime().removeShutdownHook(shutdownThread);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }

        private int getCorePoolSize() {
            int propSize = this.poolSizeProp.get();
            if (propSize > 0) {
                return propSize;
            }
            return 2;
        }
    }
}

