/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.registries.DispatchPredicate;
import org.dataloader.registries.ScheduledDataLoaderRegistry;
import org.dataloader.stats.Statistics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0016JF\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\u0006\u0010\r\u001a\u00020\u00062\u001c\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J*\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f\u0018\u00010\n\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0016\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\u0017H\u0016J\u001c\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00062\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nH\u0016J&\u0010 \u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00062\u000e\u0010\u001f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderRegistry;", "Lorg/dataloader/DataLoaderRegistry;", "()V", "dataLoaderRegistry", "scheduledDataLoaderRegistries", "", "", "combine", "registry", "computeIfAbsent", "Lorg/dataloader/DataLoader;", "K", "V", "key", "mappingFunction", "Ljava/util/function/Function;", "dispatchAll", "", "dispatchAllWithCount", "", "dispatchDepth", "getDataLoader", "getDataLoaders", "", "getDataLoadersMap", "", "getKeys", "", "getStatistics", "Lorg/dataloader/stats/Statistics;", "register", "dataLoader", "registerWithDispatchPredicate", "dispatchPredicate", "Lorg/dataloader/registries/DispatchPredicate;", "unregister", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDgsDataLoaderRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsDataLoaderRegistry.kt\ncom/netflix/graphql/dgs/internal/DgsDataLoaderRegistry\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,199:1\n76#2:200\n96#2,5:201\n215#2,2:206\n215#2,2:208\n215#2,2:210\n215#2,2:212\n215#2,2:214\n*S KotlinDebug\n*F\n+ 1 DgsDataLoaderRegistry.kt\ncom/netflix/graphql/dgs/internal/DgsDataLoaderRegistry\n*L\n106#1:200\n106#1:201,5\n114#1:206,2\n155#1:208,2\n169#1:210,2\n182#1:212,2\n192#1:214,2\n*E\n"})
public class DgsDataLoaderRegistry
extends DataLoaderRegistry {
    @NotNull
    private final Map<String, DataLoaderRegistry> scheduledDataLoaderRegistries = new ConcurrentHashMap();
    @NotNull
    private final DataLoaderRegistry dataLoaderRegistry = new DataLoaderRegistry();

    @NotNull
    public DataLoaderRegistry register(@NotNull String key, @NotNull DataLoader<?, ?> dataLoader) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(dataLoader, (String)"dataLoader");
        this.dataLoaderRegistry.register(key, dataLoader);
        return this;
    }

    @NotNull
    public final DataLoaderRegistry registerWithDispatchPredicate(@NotNull String key, @NotNull DataLoader<?, ?> dataLoader, @NotNull DispatchPredicate dispatchPredicate) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(dataLoader, (String)"dataLoader");
        Intrinsics.checkNotNullParameter((Object)dispatchPredicate, (String)"dispatchPredicate");
        ScheduledDataLoaderRegistry registry = ScheduledDataLoaderRegistry.newScheduledRegistry().register(key, dataLoader).dispatchPredicate(dispatchPredicate).build();
        this.scheduledDataLoaderRegistries.putIfAbsent(key, (DataLoaderRegistry)registry);
        return this;
    }

    @NotNull
    public <K, V> DataLoader<K, V> computeIfAbsent(@NotNull String key, @Nullable Function<String, DataLoader<?, ?>> mappingFunction) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Function<String, DataLoader<?, ?>> function = mappingFunction;
        Intrinsics.checkNotNull(function);
        DataLoader dataLoader = this.dataLoaderRegistry.computeIfAbsent(key, function);
        Intrinsics.checkNotNull((Object)dataLoader, (String)"null cannot be cast to non-null type org.dataloader.DataLoader<K of com.netflix.graphql.dgs.internal.DgsDataLoaderRegistry.computeIfAbsent, V of com.netflix.graphql.dgs.internal.DgsDataLoaderRegistry.computeIfAbsent>");
        return dataLoader;
    }

    @Nullable
    public DataLoaderRegistry combine(@NotNull DataLoaderRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        throw new UnsupportedOperationException("Cannot combine a DgsDataLoaderRegistry with another registry");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DataLoader<?, ?>> getDataLoaders() {
        void $this$flatMapTo$iv$iv;
        Map<String, DataLoaderRegistry> $this$flatMap$iv = this.scheduledDataLoaderRegistries;
        boolean $i$f$flatMap = false;
        Map<String, DataLoaderRegistry> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            List list = ((DataLoaderRegistry)it.getValue()).getDataLoaders();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataLoaders(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        List list = this.dataLoaderRegistry.getDataLoaders();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataLoaders(...)");
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    @NotNull
    public Map<String, DataLoader<?, ?>> getDataLoadersMap() {
        Map dataLoadersMap = null;
        dataLoadersMap = MapsKt.emptyMap();
        Map<String, DataLoaderRegistry> $this$forEach$iv = this.scheduledDataLoaderRegistries;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DataLoaderRegistry>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DataLoaderRegistry> element$iv;
            Map.Entry<String, DataLoaderRegistry> it = element$iv = iterator.next();
            boolean bl = false;
            Map map = it.getValue().getDataLoadersMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getDataLoadersMap(...)");
            dataLoadersMap = MapsKt.plus((Map)dataLoadersMap, (Map)map);
        }
        Map map = this.dataLoaderRegistry.getDataLoadersMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getDataLoadersMap(...)");
        return new LinkedHashMap(MapsKt.plus((Map)dataLoadersMap, (Map)map));
    }

    @NotNull
    public DataLoaderRegistry unregister(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.scheduledDataLoaderRegistries.remove(key);
        this.dataLoaderRegistry.unregister(key);
        return this;
    }

    @Nullable
    public <K, V> DataLoader<K, V> getDataLoader(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.dataLoaderRegistry.getDataLoader(key);
        if (object == null) {
            DataLoaderRegistry dataLoaderRegistry = this.scheduledDataLoaderRegistries.get(key);
            object = dataLoaderRegistry != null ? dataLoaderRegistry.getDataLoader(key) : null;
        }
        return object;
    }

    @NotNull
    public Set<String> getKeys() {
        Set<String> set = this.scheduledDataLoaderRegistries.keySet();
        Set set2 = this.dataLoaderRegistry.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getKeys(...)");
        return SetsKt.plus(set, (Iterable)set2);
    }

    public void dispatchAll() {
        Map<String, DataLoaderRegistry> $this$forEach$iv = this.scheduledDataLoaderRegistries;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DataLoaderRegistry>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DataLoaderRegistry> element$iv;
            Map.Entry<String, DataLoaderRegistry> it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().dispatchAll();
        }
        this.dataLoaderRegistry.dispatchAll();
    }

    public int dispatchAllWithCount() {
        int sum = 0;
        Map<String, DataLoaderRegistry> $this$forEach$iv = this.scheduledDataLoaderRegistries;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DataLoaderRegistry>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DataLoaderRegistry> element$iv;
            Map.Entry<String, DataLoaderRegistry> it = element$iv = iterator.next();
            boolean bl = false;
            sum += it.getValue().dispatchAllWithCount();
        }
        return sum += this.dataLoaderRegistry.dispatchAllWithCount();
    }

    public int dispatchDepth() {
        int totalDispatchDepth = 0;
        Map<String, DataLoaderRegistry> $this$forEach$iv = this.scheduledDataLoaderRegistries;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DataLoaderRegistry>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DataLoaderRegistry> element$iv;
            Map.Entry<String, DataLoaderRegistry> it = element$iv = iterator.next();
            boolean bl = false;
            totalDispatchDepth += it.getValue().dispatchDepth();
        }
        return totalDispatchDepth += this.dataLoaderRegistry.dispatchDepth();
    }

    @NotNull
    public Statistics getStatistics() {
        Statistics stats = null;
        stats = new Statistics();
        Map<String, DataLoaderRegistry> $this$forEach$iv = this.scheduledDataLoaderRegistries;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, DataLoaderRegistry>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DataLoaderRegistry> element$iv;
            Map.Entry<String, DataLoaderRegistry> it = element$iv = iterator.next();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stats.combine(it.getValue().getStatistics()), (String)"combine(...)");
        }
        Statistics statistics = stats.combine(this.dataLoaderRegistry.getStatistics());
        Intrinsics.checkNotNullExpressionValue((Object)statistics, (String)"combine(...)");
        stats = statistics;
        return stats;
    }
}

