/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DataLoaderInstrumentationExtensionProvider;
import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.DgsDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.DgsDataLoaderRegistryConsumer;
import com.netflix.graphql.dgs.DgsDispatchPredicate;
import com.netflix.graphql.dgs.exceptions.DgsUnnamedDataLoaderOnFieldException;
import com.netflix.graphql.dgs.exceptions.InvalidDataLoaderTypeException;
import com.netflix.graphql.dgs.exceptions.MultipleDataLoadersDefinedException;
import com.netflix.graphql.dgs.exceptions.UnsupportedSecuredDataLoaderException;
import com.netflix.graphql.dgs.internal.DefaultDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.utils.DataLoaderNameUtil;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;
import org.dataloader.registries.DispatchPredicate;
import org.dataloader.registries.ScheduledDataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 @2\u00020\u0001:\u0002@AB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J=\u0010\u001d\u001a\u00020\u001b\"\b\b\u0000\u0010\u001e*\u00020\u00012\u0006\u0010\u001f\u001a\u0002H\u001e2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0002\u0010&J\u0006\u0010'\u001a\u00020(J\u001a\u0010)\u001a\u00020(\"\u0004\b\u0000\u0010\u001e2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u001e0+JF\u0010,\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030-2\u000e\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00102\u0006\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020(2\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0002JZ\u0010,\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030-\"\u0004\b\u0000\u0010\u001e2\u000e\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00122\u0006\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u00152\f\u00105\u001a\b\u0012\u0004\u0012\u0002H\u001e0+2\u0006\u00101\u001a\u00020(2\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0002JF\u0010,\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030-2\u000e\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00172\u0006\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020(2\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0002JZ\u0010,\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030-\"\u0004\b\u0000\u0010\u001e2\u000e\u0010.\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00192\u0006\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u00152\f\u00105\u001a\b\u0012\u0004\u0012\u0002H\u001e0+2\u0006\u00101\u001a\u00020(2\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0002J\r\u00106\u001a\u00020\u001bH\u0001\u00a2\u0006\u0002\b7J6\u00108\u001a\u00020\u001b2\n\u00109\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010:\u001a\u00020;2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0002J4\u0010<\u001a\u0002H\u001e\"\u0006\b\u0000\u0010\u001e\u0018\u00012\u0006\u0010=\u001a\u0002H\u001e2\u0006\u0010>\u001a\u00020\u00152\f\u00102\u001a\b\u0012\u0004\u0012\u00020403H\u0082\b\u00a2\u0006\u0002\u0010?R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00120\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00170\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00190\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dataLoaderOptionsProvider", "Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "scheduleDuration", "Ljava/time/Duration;", "enableTickerMode", "", "(Lorg/springframework/context/ApplicationContext;Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;Ljava/util/concurrent/ScheduledExecutorService;Ljava/time/Duration;Z)V", "batchLoaders", "", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$LoaderHolder;", "Lorg/dataloader/BatchLoader;", "batchLoadersWithContext", "Lorg/dataloader/BatchLoaderWithContext;", "loaderMap", "", "", "mappedBatchLoaders", "Lorg/dataloader/MappedBatchLoader;", "mappedBatchLoadersWithContext", "Lorg/dataloader/MappedBatchLoaderWithContext;", "addDataLoaderComponents", "", "addDataLoaderFields", "addDataLoaders", "T", "dgsComponent", "targetClass", "Ljava/lang/Class;", "annotation", "Lcom/netflix/graphql/dgs/DgsDataLoader;", "dispatchPredicate", "Lorg/dataloader/registries/DispatchPredicate;", "(Ljava/lang/Object;Ljava/lang/Class;Lcom/netflix/graphql/dgs/DgsDataLoader;Lorg/dataloader/registries/DispatchPredicate;)V", "buildRegistry", "Lorg/dataloader/DataLoaderRegistry;", "buildRegistryWithContextSupplier", "contextSupplier", "Ljava/util/function/Supplier;", "createDataLoader", "Lorg/dataloader/DataLoader;", "batchLoader", "dgsDataLoader", "dataLoaderName", "dataLoaderRegistry", "extensionProviders", "", "Lcom/netflix/graphql/dgs/DataLoaderInstrumentationExtensionProvider;", "supplier", "findDataLoaders", "findDataLoaders$graphql_dgs", "registerDataLoader", "holder", "registry", "Lorg/dataloader/registries/ScheduledDataLoaderRegistry;", "wrappedDataLoader", "loader", "name", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Iterable;)Ljava/lang/Object;", "Companion", "LoaderHolder", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDgsDataLoaderProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsDataLoaderProvider.kt\ncom/netflix/graphql/dgs/internal/DgsDataLoaderProvider\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n259#1,5:314\n264#1,22:321\n259#1,5:343\n264#1,22:350\n259#1,5:372\n264#1,22:379\n259#1,5:401\n264#1,22:408\n17#2,5:293\n22#2:306\n1855#3,2:298\n1855#3,2:300\n1855#3,2:302\n1855#3,2:304\n1855#3:307\n1856#3:310\n1855#3:311\n1856#3:313\n1855#3,2:319\n1855#3,2:348\n1855#3,2:377\n1855#3,2:406\n1855#3,2:430\n1855#3,2:432\n1855#3,2:434\n1855#3,2:436\n1313#4,2:308\n1#5:312\n*S KotlinDebug\n*F\n+ 1 DgsDataLoaderProvider.kt\ncom/netflix/graphql/dgs/internal/DgsDataLoaderProvider\n*L\n170#1:314,5\n170#1:321,22\n186#1:343,5\n186#1:350,22\n206#1:372,5\n206#1:379,22\n225#1:401,5\n225#1:408,22\n76#1:293,5\n76#1:306\n82#1:298,2\n83#1:300,2\n84#1:302,2\n85#1:304,2\n99#1:307\n99#1:310\n129#1:311\n129#1:313\n170#1:319,2\n186#1:348,2\n206#1:377,2\n225#1:406,2\n263#1:430,2\n268#1:432,2\n273#1:434,2\n278#1:436,2\n103#1:308,2\n*E\n"})
public final class DgsDataLoaderProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final DgsDataLoaderOptionsProvider dataLoaderOptionsProvider;
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    private final Duration scheduleDuration;
    private final boolean enableTickerMode;
    @NotNull
    private final List<LoaderHolder<BatchLoader<?, ?>>> batchLoaders;
    @NotNull
    private final List<LoaderHolder<BatchLoaderWithContext<?, ?>>> batchLoadersWithContext;
    @NotNull
    private final List<LoaderHolder<MappedBatchLoader<?, ?>>> mappedBatchLoaders;
    @NotNull
    private final List<LoaderHolder<MappedBatchLoaderWithContext<?, ?>>> mappedBatchLoadersWithContext;
    @NotNull
    private final Map<String, String> loaderMap;
    @NotNull
    private static final Logger logger;

    public DgsDataLoaderProvider(@NotNull ApplicationContext applicationContext, @NotNull DgsDataLoaderOptionsProvider dataLoaderOptionsProvider, @NotNull ScheduledExecutorService scheduledExecutorService, @NotNull Duration scheduleDuration, boolean enableTickerMode) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)dataLoaderOptionsProvider, (String)"dataLoaderOptionsProvider");
        Intrinsics.checkNotNullParameter((Object)scheduledExecutorService, (String)"scheduledExecutorService");
        Intrinsics.checkNotNullParameter((Object)scheduleDuration, (String)"scheduleDuration");
        this.applicationContext = applicationContext;
        this.dataLoaderOptionsProvider = dataLoaderOptionsProvider;
        this.scheduledExecutorService = scheduledExecutorService;
        this.scheduleDuration = scheduleDuration;
        this.enableTickerMode = enableTickerMode;
        this.batchLoaders = new ArrayList();
        this.batchLoadersWithContext = new ArrayList();
        this.mappedBatchLoaders = new ArrayList();
        this.mappedBatchLoadersWithContext = new ArrayList();
        this.loaderMap = new LinkedHashMap();
    }

    public /* synthetic */ DgsDataLoaderProvider(ApplicationContext applicationContext, DgsDataLoaderOptionsProvider dgsDataLoaderOptionsProvider, ScheduledExecutorService scheduledExecutorService, Duration duration, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dgsDataLoaderOptionsProvider = new DefaultDataLoaderOptionsProvider();
        }
        if ((n & 4) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newSingleThreadScheduledExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"newSingleThreadScheduledExecutor(...)");
            scheduledExecutorService = scheduledExecutorService2;
        }
        if ((n & 8) != 0) {
            Duration duration2 = Duration.ofMillis(10L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
            duration = duration2;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(applicationContext, dgsDataLoaderOptionsProvider, scheduledExecutorService, duration, bl);
    }

    @NotNull
    public final DataLoaderRegistry buildRegistry() {
        return this.buildRegistryWithContextSupplier(buildRegistry.1.INSTANCE);
    }

    @NotNull
    public final <T> DataLoaderRegistry buildRegistryWithContextSupplier(@NotNull Supplier<T> contextSupplier) {
        LoaderHolder it;
        Intrinsics.checkNotNullParameter(contextSupplier, (String)"contextSupplier");
        ScheduledDataLoaderRegistry registry = ScheduledDataLoaderRegistry.newScheduledRegistry().scheduledExecutorService(this.scheduledExecutorService).tickerMode(this.enableTickerMode).schedule(this.scheduleDuration).dispatchPredicate(DispatchPredicate.DISPATCH_NEVER).build();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        List extensionProviders = this.applicationContext.getBeanProvider(DataLoaderInstrumentationExtensionProvider.class).orderedStream().toList();
        Iterable $this$forEach$iv = this.batchLoaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)registry);
            Intrinsics.checkNotNull(extensionProviders);
            this.registerDataLoader(it, registry, contextSupplier, extensionProviders);
        }
        $this$forEach$iv = this.batchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)registry);
            Intrinsics.checkNotNull(extensionProviders);
            this.registerDataLoader(it, registry, contextSupplier, extensionProviders);
        }
        $this$forEach$iv = this.mappedBatchLoaders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)registry);
            Intrinsics.checkNotNull(extensionProviders);
            this.registerDataLoader(it, registry, contextSupplier, extensionProviders);
        }
        $this$forEach$iv = this.mappedBatchLoadersWithContext;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LoaderHolder)element$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)registry);
            Intrinsics.checkNotNull(extensionProviders);
            this.registerDataLoader(it, registry, contextSupplier, extensionProviders);
        }
        long totalTime = System.currentTimeMillis() - start$iv;
        logger.debug("Created DGS dataloader registry in {}ms", (Object)totalTime);
        Intrinsics.checkNotNull((Object)registry);
        return (DataLoaderRegistry)registry;
    }

    @PostConstruct
    public final void findDataLoaders$graphql_dgs() {
        this.addDataLoaderComponents();
        this.addDataLoaderFields();
    }

    /*
     * WARNING - void declaration
     */
    private final void addDataLoaderFields() {
        Map dataLoaders = this.applicationContext.getBeansWithAnnotation(DgsComponent.class);
        Iterable $this$forEach$iv = dataLoaders.values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class javaClass = AopUtils.getTargetClass(dgsComponent);
            Field[] fieldArray = javaClass.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])fieldArray), (Function1)addDataLoaderFields.1.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Field field = (Field)element$iv2;
                boolean bl2 = false;
                if (AopUtils.isAopProxy(dgsComponent)) {
                    throw new UnsupportedSecuredDataLoaderException(dgsComponent.getClass());
                }
                DgsDataLoader annotation = field.getAnnotation(DgsDataLoader.class);
                ReflectionUtils.makeAccessible((Field)field);
                if (Intrinsics.areEqual((Object)annotation.name(), (Object)"NETFLIX_DGS_GENERATE_DATALOADER_NAME")) {
                    Intrinsics.checkNotNull((Object)field);
                    throw new DgsUnnamedDataLoaderOnFieldException(field);
                }
                Object get2 = field.get(dgsComponent);
                if (get2 instanceof BatchLoader) {
                    this.batchLoaders.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$6$lambda$5$createHolder(annotation, get2));
                    continue;
                }
                if (get2 instanceof BatchLoaderWithContext) {
                    this.batchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$6$lambda$5$createHolder(annotation, get2));
                    continue;
                }
                if (get2 instanceof MappedBatchLoader) {
                    this.mappedBatchLoaders.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$6$lambda$5$createHolder(annotation, get2));
                    continue;
                }
                if (get2 instanceof MappedBatchLoaderWithContext) {
                    this.mappedBatchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaderFields$lambda$6$lambda$5$createHolder(annotation, get2));
                    continue;
                }
                throw new InvalidDataLoaderTypeException(dgsComponent.getClass());
            }
        }
    }

    private final void addDataLoaderComponents() {
        Map dataLoaders = this.applicationContext.getBeansWithAnnotation(DgsDataLoader.class);
        Iterable $this$forEach$iv = dataLoaders.values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object v1;
            DgsDataLoader annotation;
            Class javaClass;
            Object dgsComponent;
            block3: {
                Object element$iv;
                dgsComponent = element$iv = iterator.next();
                boolean bl = false;
                javaClass = AopUtils.getTargetClass(dgsComponent);
                annotation = javaClass.getAnnotation(DgsDataLoader.class);
                Field[] fieldArray = javaClass.getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
                Sequence sequence = ArraysKt.asSequence((Object[])fieldArray);
                for (Object e : sequence) {
                    Field it = (Field)e;
                    boolean bl2 = false;
                    if (!it.isAnnotationPresent(DgsDispatchPredicate.class)) continue;
                    v1 = e;
                    break block3;
                }
                v1 = null;
            }
            Field predicateField = v1;
            if (predicateField != null) {
                ReflectionUtils.makeAccessible((Field)predicateField);
                Object dispatchPredicate = predicateField.get(dgsComponent);
                if (!(dispatchPredicate instanceof DispatchPredicate)) continue;
                Intrinsics.checkNotNull((Object)javaClass);
                Intrinsics.checkNotNull((Object)annotation);
                this.addDataLoaders(dgsComponent, javaClass, annotation, (DispatchPredicate)dispatchPredicate);
                continue;
            }
            Intrinsics.checkNotNull((Object)javaClass);
            Intrinsics.checkNotNull((Object)annotation);
            this.addDataLoaders(dgsComponent, javaClass, annotation, null);
        }
    }

    private final <T> void addDataLoaders(T dgsComponent, Class<?> targetClass, DgsDataLoader annotation, DispatchPredicate dispatchPredicate) {
        T t = dgsComponent;
        if (t instanceof BatchLoader) {
            this.batchLoaders.add(DgsDataLoaderProvider.addDataLoaders$createHolder$9(annotation, targetClass, dispatchPredicate, dgsComponent));
        } else if (t instanceof BatchLoaderWithContext) {
            this.batchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaders$createHolder$9(annotation, targetClass, dispatchPredicate, dgsComponent));
        } else if (t instanceof MappedBatchLoader) {
            this.mappedBatchLoaders.add(DgsDataLoaderProvider.addDataLoaders$createHolder$9(annotation, targetClass, dispatchPredicate, dgsComponent));
        } else if (t instanceof MappedBatchLoaderWithContext) {
            this.mappedBatchLoadersWithContext.add(DgsDataLoaderProvider.addDataLoaders$createHolder$9(annotation, targetClass, dispatchPredicate, dgsComponent));
        } else {
            throw new InvalidDataLoaderTypeException(dgsComponent.getClass());
        }
    }

    private final DataLoader<?, ?> createDataLoader(BatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        BatchLoader<?, ?> batchLoader2;
        DataLoaderOptions options;
        block14: {
            block15: {
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    BatchLoader<?, ?> wrappedBatchLoader$iv;
                    BatchLoader<?, ?> batchLoader3 = batchLoader;
                    if (batchLoader3 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, dataLoaderName);
                        }
                        batchLoader2 = wrappedBatchLoader$iv;
                        if (batchLoader2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        break block14;
                    }
                    if (batchLoader3 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        BatchLoader<?, ?> batchLoader4 = wrappedBatchLoader$iv;
                        if (batchLoader4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = batchLoader4;
                        break block14;
                    }
                    if (batchLoader3 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        BatchLoader<?, ?> batchLoader5 = wrappedBatchLoader$iv;
                        if (batchLoader5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                        }
                        batchLoader2 = batchLoader5;
                        break block14;
                    }
                    if (!(batchLoader3 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = batchLoader;
                    $this$forEach$iv$iv = extensionProviders;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                    }
                    BatchLoader<?, ?> batchLoader6 = wrappedBatchLoader$iv;
                    if (batchLoader6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoader<*, *>");
                    }
                    batchLoader2 = batchLoader6;
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            batchLoader2 = batchLoader;
        }
        BatchLoader<?, ?> extendedBatchLoader = batchLoader2;
        DataLoader dataLoader = DataLoaderFactory.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newDataLoader(...)");
        return dataLoader;
    }

    private final DataLoader<?, ?> createDataLoader(MappedBatchLoader<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        MappedBatchLoader<?, ?> mappedBatchLoader;
        DataLoaderOptions options;
        block14: {
            block15: {
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    MappedBatchLoader<?, ?> wrappedBatchLoader$iv;
                    MappedBatchLoader<?, ?> mappedBatchLoader2 = batchLoader;
                    if (mappedBatchLoader2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        MappedBatchLoader<?, ?> mappedBatchLoader3 = wrappedBatchLoader$iv;
                        if (mappedBatchLoader3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = mappedBatchLoader3;
                        break block14;
                    }
                    if (mappedBatchLoader2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        MappedBatchLoader<?, ?> mappedBatchLoader4 = wrappedBatchLoader$iv;
                        if (mappedBatchLoader4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        mappedBatchLoader = mappedBatchLoader4;
                        break block14;
                    }
                    if (mappedBatchLoader2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, dataLoaderName);
                        }
                        mappedBatchLoader = wrappedBatchLoader$iv;
                        if (mappedBatchLoader == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                        }
                        break block14;
                    }
                    if (!(mappedBatchLoader2 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = batchLoader;
                    $this$forEach$iv$iv = extensionProviders;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                    }
                    MappedBatchLoader<?, ?> mappedBatchLoader5 = wrappedBatchLoader$iv;
                    if (mappedBatchLoader5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoader<*, *>");
                    }
                    mappedBatchLoader = mappedBatchLoader5;
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            mappedBatchLoader = batchLoader;
        }
        MappedBatchLoader<?, ?> extendedBatchLoader = mappedBatchLoader;
        DataLoader dataLoader = DataLoaderFactory.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newMappedDataLoader(...)");
        return dataLoader;
    }

    private final <T> DataLoader<?, ?> createDataLoader(BatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        BatchLoaderWithContext<?, ?> batchLoaderWithContext;
        DataLoaderOptions options;
        block14: {
            block15: {
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader).setBatchLoaderContextProvider(supplier::get);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    BatchLoaderWithContext<?, ?> wrappedBatchLoader$iv;
                    BatchLoaderWithContext<?, ?> batchLoaderWithContext2 = batchLoader;
                    if (batchLoaderWithContext2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        BatchLoaderWithContext<?, ?> batchLoaderWithContext3 = wrappedBatchLoader$iv;
                        if (batchLoaderWithContext3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = batchLoaderWithContext3;
                        break block14;
                    }
                    if (batchLoaderWithContext2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, dataLoaderName);
                        }
                        batchLoaderWithContext = wrappedBatchLoader$iv;
                        if (batchLoaderWithContext == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        break block14;
                    }
                    if (batchLoaderWithContext2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        BatchLoaderWithContext<?, ?> batchLoaderWithContext4 = wrappedBatchLoader$iv;
                        if (batchLoaderWithContext4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                        }
                        batchLoaderWithContext = batchLoaderWithContext4;
                        break block14;
                    }
                    if (!(batchLoaderWithContext2 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = batchLoader;
                    $this$forEach$iv$iv = extensionProviders;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                    }
                    BatchLoaderWithContext<?, ?> batchLoaderWithContext5 = wrappedBatchLoader$iv;
                    if (batchLoaderWithContext5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.BatchLoaderWithContext<*, *>");
                    }
                    batchLoaderWithContext = batchLoaderWithContext5;
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            batchLoaderWithContext = batchLoader;
        }
        BatchLoaderWithContext<?, ?> extendedBatchLoader = batchLoaderWithContext;
        DataLoader dataLoader = DataLoaderFactory.newDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newDataLoader(...)");
        return dataLoader;
    }

    private final <T> DataLoader<?, ?> createDataLoader(MappedBatchLoaderWithContext<?, ?> batchLoader, DgsDataLoader dgsDataLoader, String dataLoaderName, Supplier<T> supplier, DataLoaderRegistry dataLoaderRegistry, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext;
        DataLoaderOptions options;
        block14: {
            block15: {
                options = this.dataLoaderOptionsProvider.getOptions(dataLoaderName, dgsDataLoader).setBatchLoaderContextProvider(supplier::get);
                if (batchLoader instanceof DgsDataLoaderRegistryConsumer) {
                    ((DgsDataLoaderRegistryConsumer)batchLoader).setDataLoaderRegistry(dataLoaderRegistry);
                }
                DgsDataLoaderProvider this_$iv = this;
                boolean $i$f$wrappedDataLoader = false;
                try {
                    DataLoaderInstrumentationExtensionProvider it$iv;
                    DataLoaderInstrumentationExtensionProvider element$iv$iv;
                    Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator;
                    boolean $i$f$forEach;
                    Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv$iv;
                    MappedBatchLoaderWithContext<?, ?> wrappedBatchLoader$iv;
                    MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext2 = batchLoader;
                    if (mappedBatchLoaderWithContext2 instanceof BatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext3 = wrappedBatchLoader$iv;
                        if (mappedBatchLoaderWithContext3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = mappedBatchLoaderWithContext3;
                        break block14;
                    }
                    if (mappedBatchLoaderWithContext2 instanceof BatchLoaderWithContext) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((BatchLoaderWithContext)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext4 = wrappedBatchLoader$iv;
                        if (mappedBatchLoaderWithContext4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = mappedBatchLoaderWithContext4;
                        break block14;
                    }
                    if (mappedBatchLoaderWithContext2 instanceof MappedBatchLoader) {
                        wrappedBatchLoader$iv = null;
                        wrappedBatchLoader$iv = batchLoader;
                        $this$forEach$iv$iv = extensionProviders;
                        $i$f$forEach = false;
                        iterator = $this$forEach$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            it$iv = element$iv$iv = iterator.next();
                            boolean bl = false;
                            wrappedBatchLoader$iv = it$iv.provide((MappedBatchLoader)wrappedBatchLoader$iv, dataLoaderName);
                        }
                        MappedBatchLoaderWithContext<?, ?> mappedBatchLoaderWithContext5 = wrappedBatchLoader$iv;
                        if (mappedBatchLoaderWithContext5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                        }
                        mappedBatchLoaderWithContext = mappedBatchLoaderWithContext5;
                        break block14;
                    }
                    if (!(mappedBatchLoaderWithContext2 instanceof MappedBatchLoaderWithContext)) break block15;
                    wrappedBatchLoader$iv = null;
                    wrappedBatchLoader$iv = batchLoader;
                    $this$forEach$iv$iv = extensionProviders;
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        it$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        wrappedBatchLoader$iv = it$iv.provide(wrappedBatchLoader$iv, dataLoaderName);
                    }
                    mappedBatchLoaderWithContext = wrappedBatchLoader$iv;
                    if (mappedBatchLoaderWithContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.dataloader.MappedBatchLoaderWithContext<*, *>");
                    }
                    break block14;
                }
                catch (NoSuchBeanDefinitionException ex$iv) {
                    Object[] objectArray = new Object[]{dataLoaderName, batchLoader, ex$iv};
                    logger.debug("Unable to wrap the [{} : {}]", objectArray);
                }
            }
            mappedBatchLoaderWithContext = batchLoader;
        }
        MappedBatchLoaderWithContext<?, ?> extendedBatchLoader = mappedBatchLoaderWithContext;
        DataLoader dataLoader = DataLoaderFactory.newMappedDataLoader(extendedBatchLoader, (DataLoaderOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)dataLoader, (String)"newMappedDataLoader(...)");
        return dataLoader;
    }

    private final void registerDataLoader(LoaderHolder<?> holder, ScheduledDataLoaderRegistry registry, Supplier<?> contextSupplier, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        DataLoader<?, ?> dataLoader;
        Object obj = holder.getTheLoader();
        if (obj instanceof BatchLoader) {
            dataLoader = this.createDataLoader((BatchLoader)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), (DataLoaderRegistry)registry, extensionProviders);
        } else if (obj instanceof BatchLoaderWithContext) {
            dataLoader = this.createDataLoader((BatchLoaderWithContext)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), contextSupplier, (DataLoaderRegistry)registry, extensionProviders);
        } else if (obj instanceof MappedBatchLoader) {
            dataLoader = this.createDataLoader((MappedBatchLoader)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), (DataLoaderRegistry)registry, extensionProviders);
        } else if (obj instanceof MappedBatchLoaderWithContext) {
            dataLoader = this.createDataLoader((MappedBatchLoaderWithContext)holder.getTheLoader(), holder.getAnnotation(), holder.getName(), contextSupplier, (DataLoaderRegistry)registry, extensionProviders);
        } else {
            throw new IllegalArgumentException("Data loader " + holder.getName() + " has unknown type");
        }
        DataLoader<?, ?> loader = dataLoader;
        if (registry.getKeys().contains(holder.getName())) {
            throw new MultipleDataLoadersDefinedException(holder.getTheLoader().getClass());
        }
        if (holder.getDispatchPredicate() == null) {
            registry.register(holder.getName(), loader, DispatchPredicate.DISPATCH_ALWAYS);
        } else {
            registry.register(holder.getName(), loader, holder.getDispatchPredicate());
        }
    }

    private final /* synthetic */ <T> T wrappedDataLoader(T loader, String name, Iterable<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders) {
        boolean $i$f$wrappedDataLoader = false;
        try {
            T t = loader;
            if (t instanceof BatchLoader) {
                BatchLoader<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (BatchLoader<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((BatchLoader)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
            if (t instanceof BatchLoaderWithContext) {
                BatchLoaderWithContext<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (BatchLoaderWithContext<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((BatchLoaderWithContext)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
            if (t instanceof MappedBatchLoader) {
                MappedBatchLoader<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (MappedBatchLoader<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((MappedBatchLoader)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
            if (t instanceof MappedBatchLoaderWithContext) {
                MappedBatchLoaderWithContext<?, ?> wrappedBatchLoader = null;
                wrappedBatchLoader = (MappedBatchLoaderWithContext<?, ?>)loader;
                Iterable<? extends DataLoaderInstrumentationExtensionProvider> $this$forEach$iv = extensionProviders;
                boolean $i$f$forEach = false;
                Iterator<? extends DataLoaderInstrumentationExtensionProvider> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    DataLoaderInstrumentationExtensionProvider element$iv;
                    DataLoaderInstrumentationExtensionProvider it = element$iv = iterator.next();
                    boolean bl = false;
                    wrappedBatchLoader = it.provide((MappedBatchLoaderWithContext)wrappedBatchLoader, name);
                }
                Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                return (T)wrappedBatchLoader;
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            Object[] objectArray = new Object[]{name, loader, ex};
            logger.debug("Unable to wrap the [{} : {}]", objectArray);
        }
        return loader;
    }

    private static final <T> LoaderHolder<T> addDataLoaderFields$lambda$6$lambda$5$createHolder(DgsDataLoader annotation, T t) {
        Intrinsics.checkNotNull((Object)annotation);
        return new LoaderHolder(t, annotation, annotation.name(), null, 8, null);
    }

    private static final <T> LoaderHolder<T> addDataLoaders$createHolder$9(DgsDataLoader $annotation, Class<?> $targetClass, DispatchPredicate $dispatchPredicate, T t) {
        return new LoaderHolder<T>(t, $annotation, DataLoaderNameUtil.INSTANCE.getDataLoaderName($targetClass, $annotation), $dispatchPredicate);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsDataLoaderProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DgsDataLoaderProvider.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0014\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J>\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$LoaderHolder;", "T", "", "theLoader", "annotation", "Lcom/netflix/graphql/dgs/DgsDataLoader;", "name", "", "dispatchPredicate", "Lorg/dataloader/registries/DispatchPredicate;", "(Ljava/lang/Object;Lcom/netflix/graphql/dgs/DgsDataLoader;Ljava/lang/String;Lorg/dataloader/registries/DispatchPredicate;)V", "getAnnotation", "()Lcom/netflix/graphql/dgs/DgsDataLoader;", "getDispatchPredicate", "()Lorg/dataloader/registries/DispatchPredicate;", "getName", "()Ljava/lang/String;", "getTheLoader", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/Object;Lcom/netflix/graphql/dgs/DgsDataLoader;Ljava/lang/String;Lorg/dataloader/registries/DispatchPredicate;)Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider$LoaderHolder;", "equals", "", "other", "hashCode", "", "toString", "graphql-dgs"})
    private static final class LoaderHolder<T> {
        private final T theLoader;
        @NotNull
        private final DgsDataLoader annotation;
        @NotNull
        private final String name;
        @Nullable
        private final DispatchPredicate dispatchPredicate;

        public LoaderHolder(T theLoader, @NotNull DgsDataLoader annotation, @NotNull String name, @Nullable DispatchPredicate dispatchPredicate) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.theLoader = theLoader;
            this.annotation = annotation;
            this.name = name;
            this.dispatchPredicate = dispatchPredicate;
        }

        public /* synthetic */ LoaderHolder(Object object, DgsDataLoader dgsDataLoader, String string, DispatchPredicate dispatchPredicate, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                dispatchPredicate = null;
            }
            this(object, dgsDataLoader, string, dispatchPredicate);
        }

        public final T getTheLoader() {
            return this.theLoader;
        }

        @NotNull
        public final DgsDataLoader getAnnotation() {
            return this.annotation;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final DispatchPredicate getDispatchPredicate() {
            return this.dispatchPredicate;
        }

        public final T component1() {
            return this.theLoader;
        }

        @NotNull
        public final DgsDataLoader component2() {
            return this.annotation;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @Nullable
        public final DispatchPredicate component4() {
            return this.dispatchPredicate;
        }

        @NotNull
        public final LoaderHolder<T> copy(T theLoader, @NotNull DgsDataLoader annotation, @NotNull String name, @Nullable DispatchPredicate dispatchPredicate) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new LoaderHolder<T>(theLoader, annotation, name, dispatchPredicate);
        }

        public static /* synthetic */ LoaderHolder copy$default(LoaderHolder loaderHolder, Object object, DgsDataLoader dgsDataLoader, String string, DispatchPredicate dispatchPredicate, int n, Object object2) {
            if ((n & 1) != 0) {
                object = loaderHolder.theLoader;
            }
            if ((n & 2) != 0) {
                dgsDataLoader = loaderHolder.annotation;
            }
            if ((n & 4) != 0) {
                string = loaderHolder.name;
            }
            if ((n & 8) != 0) {
                dispatchPredicate = loaderHolder.dispatchPredicate;
            }
            return loaderHolder.copy(object, dgsDataLoader, string, dispatchPredicate);
        }

        @NotNull
        public String toString() {
            return "LoaderHolder(theLoader=" + this.theLoader + ", annotation=" + this.annotation + ", name=" + this.name + ", dispatchPredicate=" + this.dispatchPredicate + ")";
        }

        public int hashCode() {
            int result = this.theLoader == null ? 0 : this.theLoader.hashCode();
            result = result * 31 + this.annotation.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + (this.dispatchPredicate == null ? 0 : this.dispatchPredicate.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoaderHolder)) {
                return false;
            }
            LoaderHolder loaderHolder = (LoaderHolder)other;
            if (!Intrinsics.areEqual(this.theLoader, loaderHolder.theLoader)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.annotation, (Object)loaderHolder.annotation)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)loaderHolder.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dispatchPredicate, (Object)loaderHolder.dispatchPredicate);
        }
    }
}

