/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.apollographql.federation.graphqljava.Federation;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.DgsCodeRegistry;
import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsDefaultTypeResolver;
import com.netflix.graphql.dgs.DgsEnableDataFetcherInstrumentation;
import com.netflix.graphql.dgs.DgsEntityFetcher;
import com.netflix.graphql.dgs.DgsFederationResolver;
import com.netflix.graphql.dgs.DgsRuntimeWiring;
import com.netflix.graphql.dgs.DgsScalar;
import com.netflix.graphql.dgs.DgsTypeDefinitionRegistry;
import com.netflix.graphql.dgs.DgsTypeResolver;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.exceptions.DgsInvalidInputArgumentException;
import com.netflix.graphql.dgs.exceptions.InvalidDgsConfigurationException;
import com.netflix.graphql.dgs.exceptions.InvalidTypeResolverException;
import com.netflix.graphql.dgs.exceptions.NoSchemaFoundException;
import com.netflix.graphql.dgs.federation.DefaultDgsFederationResolver;
import com.netflix.graphql.dgs.internal.DgsRequestData;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.mocking.DgsSchemaTransformer;
import com.netflix.graphql.mocking.MockProvider;
import graphql.TypeResolutionEnvironment;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0005\u00a2\u0006\u0002\u0010\fJ \u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0001H\u0002J,\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\bH\u0002J\u001c\u0010)\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010%H\u0002J\u001d\u0010*\u001a\u00020#2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J)\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\b\b\u0002\u00101\u001a\u00020\u000f2\b\b\u0002\u00102\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b3\u00104J,\u00105\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010%2\u0006\u0010+\u001a\u00020,2\u0006\u00106\u001a\u00020\bH\u0002J\"\u00107\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00012\u0006\u00108\u001a\u000209H\u0002J \u0010:\u001a\u00020#2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'2\u0006\u0010;\u001a\u00020\bH\u0002J\u0018\u0010<\u001a\u00020#2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u0001H\u0002J\u0012\u0010>\u001a\u00020?2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00170\u00160\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001b*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "federationResolver", "Ljava/util/Optional;", "Lcom/netflix/graphql/dgs/DgsFederationResolver;", "existingTypeDefinitionRegistry", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "mockProviders", "", "Lcom/netflix/graphql/mocking/MockProvider;", "(Lorg/springframework/context/ApplicationContext;Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;)V", "dataFetcherInstrumentationEnabled", "", "", "", "getDataFetcherInstrumentationEnabled", "()Ljava/util/Map;", "defaultParameterNameDiscoverer", "Lorg/springframework/core/DefaultParameterNameDiscoverer;", "entityFetchers", "Lkotlin/Pair;", "Ljava/lang/reflect/Method;", "getEntityFetchers", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "createBasicDataFetcher", "Lgraphql/schema/DataFetcher;", "method", "dgsComponent", "findDataFetchers", "", "dgsComponents", "", "codeRegistryBuilder", "Lgraphql/schema/GraphQLCodeRegistry$Builder;", "typeDefinitionRegistry", "findEntityFetchers", "findScalars", "runtimeWiringBuilder", "Lgraphql/schema/idl/RuntimeWiring$Builder;", "findScalars$graphql_dgs", "findSchemaFiles", "", "Lorg/springframework/core/io/Resource;", "basedir", "hasDynamicTypeRegistry", "findSchemaFiles$graphql_dgs", "(Ljava/lang/String;Z)[Lorg/springframework/core/io/Resource;", "findTypeResolvers", "mergedRegistry", "invokeDataFetcher", "environment", "Lgraphql/schema/DataFetchingEnvironment;", "invokeDgsCodeRegistry", "registry", "invokeDgsRuntimeWiring", "invokeDgsTypeDefinitionRegistry", "schema", "Lgraphql/schema/GraphQLSchema;", "graphql-dgs"})
public final class DgsSchemaProvider {
    @NotNull
    private final Map<String, Boolean> dataFetcherInstrumentationEnabled;
    @NotNull
    private final Map<String, Pair<Object, Method>> entityFetchers;
    private final DefaultParameterNameDiscoverer defaultParameterNameDiscoverer;
    private final Logger logger;
    private final ObjectMapper objectMapper;
    private final ApplicationContext applicationContext;
    private final Optional<DgsFederationResolver> federationResolver;
    private final Optional<TypeDefinitionRegistry> existingTypeDefinitionRegistry;
    private final Optional<Set<MockProvider>> mockProviders;

    @NotNull
    public final Map<String, Boolean> getDataFetcherInstrumentationEnabled() {
        return this.dataFetcherInstrumentationEnabled;
    }

    @NotNull
    public final Map<String, Pair<Object, Method>> getEntityFetchers() {
        return this.entityFetchers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final GraphQLSchema schema(@Nullable String schema2) {
        GraphQLSchema graphQLSchema2;
        Object dgsComponent;
        Object element$iv;
        void $this$fold$iv;
        void $this$mapNotNullTo$iv$iv;
        TypeDefinitionRegistry mergedRegistry;
        Object object;
        boolean hasDynamicTypeRegistry;
        boolean bl9;
        Object m;
        Method[] $this$any$iv;
        int $i$f$any3;
        Object element$iv2;
        Map dgsComponents;
        long startTime;
        block21: {
            boolean bl2;
            startTime = System.currentTimeMillis();
            dgsComponents = this.applicationContext.getBeansWithAnnotation(DgsComponent.class);
            Iterable $this$any$iv2 = dgsComponents.values();
            boolean $i$f$any2 = false;
            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                bl2 = false;
            } else {
                Iterator iterator = $this$any$iv2.iterator();
                while (iterator.hasNext()) {
                    boolean bl3;
                    block20: {
                        Object it = element$iv2 = iterator.next();
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it.getClass().getMethods(), (String)"it.javaClass.methods");
                        $i$f$any3 = 0;
                        for (Method element$iv3 : $this$any$iv) {
                            m = element$iv3;
                            bl9 = false;
                            if (!((AccessibleObject)m).isAnnotationPresent(DgsTypeDefinitionRegistry.class)) continue;
                            bl3 = true;
                            break block20;
                        }
                        bl3 = false;
                    }
                    if (!bl3) continue;
                    bl2 = true;
                    break block21;
                }
                bl2 = hasDynamicTypeRegistry = false;
            }
        }
        if (schema2 == null) {
            void $this$fold$iv2;
            Collection<InputStreamReader> collection;
            void $this$mapTo$iv$iv;
            Object $this$map$iv = DgsSchemaProvider.findSchemaFiles$graphql_dgs$default(this, null, hasDynamicTypeRegistry, 1, null);
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Resource[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            $this$any$iv = $this$mapTo$iv$iv;
            $i$f$any3 = $this$any$iv.length;
            for (int i = 0; i < $i$f$any3; ++i) {
                void it;
                Method item$iv$iv;
                Method method = item$iv$iv = $this$any$iv[i];
                collection = destination$iv$iv;
                boolean bl5 = false;
                m = new InputStreamReader(it.getInputStream(), StandardCharsets.UTF_8);
                bl9 = false;
                boolean bl6 = false;
                Throwable throwable = null;
                try {
                    InputStreamReader reader = (InputStreamReader)m;
                    boolean bl7 = false;
                    reader = new SchemaParser().parse((Reader)reader);
                }
                catch (Throwable reader) {
                    throwable = reader;
                    throw reader;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)m, (Throwable)throwable);
                }
                InputStreamReader inputStreamReader = reader;
                collection.add(inputStreamReader);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            TypeDefinitionRegistry initial$iv = new TypeDefinitionRegistry();
            boolean $i$f$fold = false;
            TypeDefinitionRegistry accumulator$iv = initial$iv;
            for (Object element$iv4 : $this$fold$iv2) {
                void b;
                TypeDefinitionRegistry $i$f$any3 = (TypeDefinitionRegistry)element$iv4;
                TypeDefinitionRegistry a = accumulator$iv;
                boolean bl8 = false;
                Intrinsics.checkNotNullExpressionValue((Object)a.merge((TypeDefinitionRegistry)b), (String)"a.merge(b)");
            }
            collection = accumulator$iv;
            object = collection;
        } else {
            object = mergedRegistry = new SchemaParser().parse(schema2);
        }
        if (this.existingTypeDefinitionRegistry.isPresent()) {
            mergedRegistry = mergedRegistry.merge(this.existingTypeDefinitionRegistry.get());
        }
        new DefaultDgsFederationResolver(this);
        DgsFederationResolver federationResolverInstance2 = this.federationResolver.orElseGet(new Supplier<DgsFederationResolver>(this){
            final /* synthetic */ DgsSchemaProvider this$0;

            public final DgsFederationResolver get() {
                return new DefaultDgsFederationResolver(this.this$0);
            }
            {
                this.this$0 = dgsSchemaProvider;
            }
        });
        DataFetcher<Object> entityFetcher = federationResolverInstance2.entitiesFetcher();
        TypeResolver typeResolver2 = federationResolverInstance2.typeResolver();
        GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry();
        RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring();
        Iterable $this$mapNotNull$iv = dgsComponents.values();
        boolean $i$f$mapNotNull = false;
        Iterable a = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator bl9 = $this$forEach$iv$iv$iv.iterator();
        while (bl9.hasNext()) {
            TypeDefinitionRegistry typeDefinitionRegistry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl9.next();
            boolean bl10 = false;
            Object dgsComponent2 = element$iv$iv;
            boolean bl11 = false;
            Object t = dgsComponent2;
            Intrinsics.checkNotNullExpressionValue(t, (String)"dgsComponent");
            if (this.invokeDgsTypeDefinitionRegistry(t) == null) continue;
            boolean bl12 = false;
            boolean bl13 = false;
            TypeDefinitionRegistry it$iv$iv = typeDefinitionRegistry;
            boolean bl14 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        TypeDefinitionRegistry initial$iv = mergedRegistry;
        boolean $i$f$fold = false;
        TypeDefinitionRegistry accumulator$iv = initial$iv;
        for (Method element$iv3 : $this$fold$iv) {
            void b;
            TypeDefinitionRegistry $i$f$forEach2 = (TypeDefinitionRegistry)element$iv3;
            TypeDefinitionRegistry a2 = accumulator$iv;
            boolean bl15 = false;
            accumulator$iv = a2.merge((TypeDefinitionRegistry)b);
        }
        RuntimeWiring.Builder builder = runtimeWiringBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"runtimeWiringBuilder");
        this.findScalars$graphql_dgs(this.applicationContext, builder);
        Map map = dgsComponents;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"dgsComponents");
        GraphQLCodeRegistry.Builder builder2 = codeRegistryBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"codeRegistryBuilder");
        TypeDefinitionRegistry typeDefinitionRegistry = mergedRegistry;
        Intrinsics.checkNotNullExpressionValue((Object)typeDefinitionRegistry, (String)"mergedRegistry");
        this.findDataFetchers(map, builder2, typeDefinitionRegistry);
        TypeDefinitionRegistry typeDefinitionRegistry2 = mergedRegistry;
        Intrinsics.checkNotNullExpressionValue((Object)typeDefinitionRegistry2, (String)"mergedRegistry");
        this.findTypeResolvers(dgsComponents, runtimeWiringBuilder, typeDefinitionRegistry2);
        this.findEntityFetchers(dgsComponents);
        Iterable $this$forEach$iv = dgsComponents.values();
        boolean $i$f$forEach3 = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            dgsComponent = element$iv = iterator.next();
            boolean bl16 = false;
            Object t = dgsComponent;
            Intrinsics.checkNotNullExpressionValue(t, (String)"dgsComponent");
            TypeDefinitionRegistry typeDefinitionRegistry3 = mergedRegistry;
            Intrinsics.checkNotNullExpressionValue((Object)typeDefinitionRegistry3, (String)"mergedRegistry");
            this.invokeDgsCodeRegistry(t, codeRegistryBuilder, typeDefinitionRegistry3);
        }
        runtimeWiringBuilder.codeRegistry(codeRegistryBuilder.build());
        $this$forEach$iv = dgsComponents.values();
        $i$f$forEach3 = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            dgsComponent = element$iv = iterator.next();
            boolean bl17 = false;
            Object t = dgsComponent;
            Intrinsics.checkNotNullExpressionValue(t, (String)"dgsComponent");
            this.invokeDgsRuntimeWiring(t, runtimeWiringBuilder);
        }
        GraphQLSchema graphQLSchema3 = Federation.transform((TypeDefinitionRegistry)mergedRegistry, (RuntimeWiring)runtimeWiringBuilder.build()).fetchEntities(entityFetcher).resolveEntityType(typeResolver2).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema3, (String)"Federation.transform(mer\u2026ype(typeResolver).build()");
        GraphQLSchema graphQLSchema4 = graphQLSchema3;
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        this.logger.debug("DGS initialized schema in {}ms", (Object)totalTime);
        if (this.mockProviders.isPresent()) {
            DgsSchemaTransformer dgsSchemaTransformer = new DgsSchemaTransformer();
            Set<MockProvider> set = this.mockProviders.get();
            Intrinsics.checkNotNullExpressionValue(set, (String)"mockProviders.get()");
            graphQLSchema2 = dgsSchemaTransformer.transformSchemaWithMockProviders(graphQLSchema4, set);
        } else {
            graphQLSchema2 = graphQLSchema4;
        }
        return graphQLSchema2;
    }

    public static /* synthetic */ GraphQLSchema schema$default(DgsSchemaProvider dgsSchemaProvider, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return dgsSchemaProvider.schema(string);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeDefinitionRegistry invokeDgsTypeDefinitionRegistry(Object dgsComponent) {
        Object v3;
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Method[] methodArray = dgsComponent.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"dgsComponent.javaClass.methods");
        Method[] $this$filter$iv = methodArray;
        boolean $i$f$filter = false;
        Method[] methodArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv;
        int n = ((void)iterator).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = iterator[i];
            boolean bl = false;
            if (!it.isAnnotationPresent(DgsTypeDefinitionRegistry.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void method;
            Method method2 = (Method)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = method;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"method");
            if (Intrinsics.areEqual(v1.getReturnType(), TypeDefinitionRegistry.class) ^ true) {
                throw (Throwable)new InvalidDgsConfigurationException("Method annotated with @DgsTypeDefinitionRegistry must have return type TypeDefinitionRegistry");
            }
            Object object = method.invoke(dgsComponent, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type graphql.schema.idl.TypeDefinitionRegistry");
            }
            TypeDefinitionRegistry typeDefinitionRegistry = (TypeDefinitionRegistry)object;
            collection.add(typeDefinitionRegistry);
        }
        Iterable $this$reduceOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void b;
                TypeDefinitionRegistry $i$f$mapTo2 = (TypeDefinitionRegistry)iterator$iv.next();
                TypeDefinitionRegistry a = (TypeDefinitionRegistry)accumulator$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)a.merge((TypeDefinitionRegistry)b), (String)"a.merge(b)");
            }
            v3 = accumulator$iv;
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     */
    private final void invokeDgsCodeRegistry(Object dgsComponent, GraphQLCodeRegistry.Builder codeRegistryBuilder, TypeDefinitionRegistry registry) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Method[] methodArray = dgsComponent.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"dgsComponent.javaClass.methods");
        Object $this$filter$iv = methodArray;
        boolean $i$f$filter = false;
        Method[] methodArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var9_10 = $this$filterTo$iv$iv;
        int n = ((void)var9_10).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var9_10[i];
            boolean bl = false;
            if (!it.isAnnotationPresent(DgsCodeRegistry.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method method = (Method)element$iv;
            boolean bl = false;
            Method method2 = method;
            Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
            if (Intrinsics.areEqual(method2.getReturnType(), GraphQLCodeRegistry.Builder.class) ^ true) {
                throw (Throwable)new InvalidDgsConfigurationException("Method annotated with @DgsCodeRegistry must have return type GraphQLCodeRegistry.Builder");
            }
            if (method.getParameterCount() != 2 || Intrinsics.areEqual(method.getParameterTypes()[0], GraphQLCodeRegistry.Builder.class) ^ true || Intrinsics.areEqual(method.getParameterTypes()[1], TypeDefinitionRegistry.class) ^ true) {
                StringBuilder stringBuilder = new StringBuilder().append("Method annotated with @DgsCodeRegistry must accept the following arguments: GraphQLCodeRegistry.Builder, TypeDefinitionRegistry. ").append(dgsComponent.getClass().getName()).append('.').append(method.getName()).append(" has the following arguments: ");
                Object[] objectArray = method.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(objectArray, (String)"method.parameterTypes");
                throw (Throwable)new InvalidDgsConfigurationException(stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, null, (int)63, null)).toString());
            }
            method.invoke(dgsComponent, codeRegistryBuilder, registry);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void invokeDgsRuntimeWiring(Object dgsComponent, RuntimeWiring.Builder runtimeWiringBuilder) {
        void $this$filterTo$iv$iv;
        Method[] methodArray = dgsComponent.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"dgsComponent.javaClass.methods");
        Method[] $this$filter$iv = methodArray;
        boolean $i$f$filter = false;
        Method[] methodArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var8_9 = $this$filterTo$iv$iv;
        int n = ((void)var8_9).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var8_9[i];
            boolean bl = false;
            if (!it.isAnnotationPresent(DgsRuntimeWiring.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Method method = (Method)element$iv;
            boolean bl = false;
            Method method2 = method;
            Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
            if (Intrinsics.areEqual(method2.getReturnType(), RuntimeWiring.Builder.class) ^ true) {
                throw (Throwable)new InvalidDgsConfigurationException("Method annotated with @DgsRuntimeWiring must have return type RuntimeWiring.Builder");
            }
            if (method.getParameterCount() != 1 || Intrinsics.areEqual(method.getParameterTypes()[0], RuntimeWiring.Builder.class) ^ true) {
                StringBuilder stringBuilder = new StringBuilder().append("Method annotated with @DgsRuntimeWiring must accept an argument of type RuntimeWiring.Builder. ").append(dgsComponent.getClass().getName()).append('.').append(method.getName()).append(" has the following arguments: ");
                Object[] objectArray = method.getParameterTypes();
                Intrinsics.checkNotNullExpressionValue(objectArray, (String)"method.parameterTypes");
                throw (Throwable)new InvalidDgsConfigurationException(stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, null, (int)63, null)).toString());
            }
            method.invoke(dgsComponent, runtimeWiringBuilder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findDataFetchers(Map<String, ? extends Object> dgsComponents, GraphQLCodeRegistry.Builder codeRegistryBuilder, TypeDefinitionRegistry typeDefinitionRegistry) {
        Iterable $this$forEach$iv = dgsComponents.values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Class javaClass;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class clazz = javaClass = AopUtils.getTargetClass(dgsComponent);
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"javaClass");
            Object[] objectArray = clazz.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"javaClass.methods");
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)findDataFetchers.1.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                boolean bl2;
                CharSequence charSequence;
                Method method = (Method)element$iv2;
                boolean bl3 = false;
                MergedAnnotation dgsDataAnnotation = MergedAnnotations.from((AnnotatedElement)method).get(DgsData.class);
                CharSequence charSequence2 = dgsDataAnnotation.getString("field");
                boolean bl4 = false;
                CharSequence charSequence3 = charSequence2;
                boolean bl5 = false;
                if (charSequence3.length() == 0) {
                    boolean bl6 = false;
                    Method method2 = method;
                    Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
                    charSequence = method2.getName();
                } else {
                    charSequence = charSequence2;
                }
                String field = (String)charSequence;
                String parentType = dgsDataAnnotation.getString("parentType");
                if (method.isAnnotationPresent(DgsEnableDataFetcherInstrumentation.class)) {
                    DgsEnableDataFetcherInstrumentation dgsEnableDataFetcherInstrumentation = method.getAnnotation(DgsEnableDataFetcherInstrumentation.class);
                    bl2 = dgsEnableDataFetcherInstrumentation.value();
                } else {
                    Method method3 = method;
                    Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"method");
                    bl2 = Intrinsics.areEqual(method3.getReturnType(), CompletionStage.class) ^ true && Intrinsics.areEqual(method.getReturnType(), CompletableFuture.class) ^ true;
                }
                boolean enableInstrumentation = bl2;
                this.dataFetcherInstrumentationEnabled.put(parentType + '.' + field, enableInstrumentation);
                try {
                    Optional optional = typeDefinitionRegistry.getType(parentType);
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"typeDefinitionRegistry.getType(parentType)");
                    if (!optional.isPresent()) {
                        this.logger.error("Parent type " + parentType + " not found, but it was referenced in " + javaClass.getName() + " in @DgsData annotation for field " + field);
                        throw (Throwable)new InvalidDgsConfigurationException("Parent type " + parentType + " not found, but it was referenced on " + javaClass.getName() + " in @DgsData annotation for field " + field);
                    }
                    Object t = typeDefinitionRegistry.getType(parentType).get();
                    Intrinsics.checkNotNullExpressionValue(t, (String)"typeDefinitionRegistry.getType(parentType).get()");
                    TypeDefinition type = (TypeDefinition)t;
                    if (type instanceof InterfaceTypeDefinition) {
                        List implementationsOf;
                        List list = implementationsOf = typeDefinitionRegistry.getImplementationsOf((InterfaceTypeDefinition)type);
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"implementationsOf");
                        Iterable $this$forEach$iv3 = list;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv3 : $this$forEach$iv3) {
                            ObjectTypeDefinition implType = (ObjectTypeDefinition)element$iv3;
                            boolean bl7 = false;
                            Method method4 = method;
                            Intrinsics.checkNotNullExpressionValue((Object)method4, (String)"method");
                            DataFetcher<Object> dataFetcher = this.createBasicDataFetcher(method4, dgsComponent);
                            ObjectTypeDefinition objectTypeDefinition = implType;
                            Intrinsics.checkNotNullExpressionValue((Object)objectTypeDefinition, (String)"implType");
                            codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)objectTypeDefinition.getName(), (String)field), dataFetcher);
                            this.dataFetcherInstrumentationEnabled.put(implType.getName() + '.' + field, enableInstrumentation);
                        }
                        continue;
                    }
                    if (type instanceof UnionTypeDefinition) {
                        void $this$forEach$iv4;
                        void $this$filterIsInstanceTo$iv$iv;
                        List list = ((UnionTypeDefinition)type).getMemberTypes();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"type.memberTypes");
                        Iterable $this$filterIsInstance$iv = list;
                        boolean $i$f$filterIsInstance = false;
                        Iterable $i$f$forEach3 = $this$filterIsInstance$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof TypeName)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach4 = false;
                        for (Object element$iv4 : $this$forEach$iv4) {
                            TypeName memberType = (TypeName)element$iv4;
                            boolean bl8 = false;
                            Method method5 = method;
                            Intrinsics.checkNotNullExpressionValue((Object)method5, (String)"method");
                            DataFetcher<Object> dataFetcher = this.createBasicDataFetcher(method5, dgsComponent);
                            codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)memberType.getName(), (String)field), dataFetcher);
                            this.dataFetcherInstrumentationEnabled.put(memberType.getName() + '.' + field, enableInstrumentation);
                        }
                        continue;
                    }
                    Method method6 = method;
                    Intrinsics.checkNotNullExpressionValue((Object)method6, (String)"method");
                    DataFetcher<Object> dataFetcher = this.createBasicDataFetcher(method6, dgsComponent);
                    codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)parentType, (String)field), dataFetcher);
                }
                catch (Exception ex) {
                    this.logger.error("Invalid parent type " + parentType);
                    throw (Throwable)ex;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findEntityFetchers(Map<String, ? extends Object> dgsComponents) {
        Iterable $this$forEach$iv = dgsComponents.values();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$forEach$iv2;
            Object element$iv;
            Object dgsComponent = element$iv = iterator.next();
            boolean bl = false;
            Class javaClass = AopUtils.getTargetClass(dgsComponent);
            Object[] objectArray = ReflectionUtils.getDeclaredMethods((Class)javaClass);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ReflectionUtils.getDeclaredMethods(javaClass)");
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)findEntityFetchers.1.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Method method = (Method)element$iv2;
                boolean bl2 = false;
                DgsEntityFetcher dgsEntityFetcherAnnotation = method.getAnnotation(DgsEntityFetcher.class);
                DgsEnableDataFetcherInstrumentation dgsEnableDataFetcherInstrumentation = method.getAnnotation(DgsEnableDataFetcherInstrumentation.class);
                boolean enableInstrumentation = dgsEnableDataFetcherInstrumentation != null ? dgsEnableDataFetcherInstrumentation.value() : false;
                this.dataFetcherInstrumentationEnabled.put("__entities." + dgsEntityFetcherAnnotation.name(), enableInstrumentation);
                this.entityFetchers.put(dgsEntityFetcherAnnotation.name(), (Pair<Object, Method>)TuplesKt.to(dgsComponent, (Object)method));
            }
        }
    }

    private final DataFetcher<Object> createBasicDataFetcher(Method method, Object dgsComponent) {
        return (DataFetcher)new DataFetcher<Object>(this, method, dgsComponent){
            final /* synthetic */ DgsSchemaProvider this$0;
            final /* synthetic */ Method $method;
            final /* synthetic */ Object $dgsComponent;

            /*
             * WARNING - void declaration
             */
            public final Object get(DataFetchingEnvironment environment) {
                void var2_2;
                DataFetchingEnvironment dataFetchingEnvironment = environment;
                Intrinsics.checkNotNullExpressionValue((Object)dataFetchingEnvironment, (String)"environment");
                Object result = DgsSchemaProvider.access$invokeDataFetcher(this.this$0, this.$method, this.$dgsComponent, new DgsDataFetchingEnvironment(dataFetchingEnvironment));
                return var2_2;
            }
            {
                this.this$0 = dgsSchemaProvider;
                this.$method = method;
                this.$dgsComponent = object;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final Object invokeDataFetcher(Method method, Object dgsComponent, DataFetchingEnvironment environment) {
        boolean bl = false;
        List args = new ArrayList();
        String[] stringArray = this.defaultParameterNameDiscoverer.getParameterNames(method);
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] parameterNames = stringArray;
        Parameter[] parameterArray = method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"method.parameters");
        Parameter[] $this$forEachIndexed$iv = parameterArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Parameter item$iv : $this$forEachIndexed$iv) {
            Object[] it;
            Object paramType;
            Object object;
            Collection<Object[]> collection;
            String parameterName;
            Object[] objectArray;
            InputArgument annotation;
            void parameter;
            int n = index$iv++;
            Parameter parameter2 = item$iv;
            int idx = n;
            boolean bl2 = false;
            if (parameter.isAnnotationPresent(InputArgument.class)) {
                Object object2;
                Iterable $this$map$iv;
                CharSequence charSequence;
                annotation = parameter.getAnnotation(InputArgument.class);
                objectArray = annotation.value();
                boolean bl3 = false;
                if (StringsKt.isBlank((CharSequence)objectArray)) {
                    boolean bl4 = false;
                    charSequence = parameterNames[idx];
                } else {
                    charSequence = objectArray;
                }
                parameterName = (String)charSequence;
                Class<?> collectionType = annotation.collectionType();
                Class<?> parameterValue = environment.getArgument(parameterName);
                if (parameterValue instanceof List && Intrinsics.areEqual(collectionType, Object.class) ^ true) {
                    try {
                        void $this$mapTo$iv$iv;
                        $this$map$iv = (Iterable)((Object)parameterValue);
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            void item;
                            Object item$iv$iv;
                            Object t = item$iv$iv = iterator2.next();
                            collection = destination$iv$iv;
                            boolean bl5 = false;
                            object = this.objectMapper.convertValue((Object)item, collectionType);
                            collection.add((Object[])object);
                        }
                        $this$map$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                    }
                    catch (Exception ex) {
                        throw (Throwable)new DgsInvalidInputArgumentException("Specified type '" + collectionType + "' is invalid for " + parameterName + '.', ex);
                    }
                    object2 = $this$map$iv;
                } else if (parameterValue instanceof List) {
                    object2 = parameterValue;
                } else if (parameterValue instanceof MultipartFile) {
                    object2 = parameterValue;
                } else {
                    Iterator iterator;
                    block39: {
                        GraphQLFieldDefinition graphQLFieldDefinition = environment.getFieldDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition, (String)"environment.fieldDefinition");
                        List list = graphQLFieldDefinition.getArguments();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"environment.fieldDefinition.arguments");
                        $this$map$iv = list;
                        boolean ex = false;
                        Iterable $this$mapTo$iv$iv = $this$map$iv;
                        boolean bl6 = false;
                        for (Iterator iterator2 : $this$mapTo$iv$iv) {
                            GraphQLArgument it2 = (GraphQLArgument)iterator2;
                            boolean bl7 = false;
                            GraphQLArgument graphQLArgument = it2;
                            Intrinsics.checkNotNullExpressionValue((Object)graphQLArgument, (String)"it");
                            if (!Intrinsics.areEqual((Object)graphQLArgument.getName(), (Object)parameterName)) continue;
                            iterator = iterator2;
                            break block39;
                        }
                        iterator = null;
                    }
                    GraphQLArgument graphQLArgument = (GraphQLArgument)iterator;
                    if ((graphQLArgument != null ? graphQLArgument.getType() : null) instanceof GraphQLScalarType) {
                        object2 = parameterValue;
                    } else {
                        void v10 = parameter;
                        Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"parameter");
                        object2 = this.objectMapper.convertValue(parameterValue, v10.getType());
                    }
                }
                Class<?> convertValue = object2;
                void v11 = parameter;
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"parameter");
                paramType = v11.getType();
                if (convertValue != null) {
                    Class<?> clazz = paramType;
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"paramType");
                    if (!clazz.isPrimitive() && !((Class)paramType).isAssignableFrom(convertValue.getClass())) {
                        Class<?> clazz2;
                        throw (Throwable)new DgsInvalidInputArgumentException("Specified type '" + parameter.getType() + "' is invalid. Found " + ((clazz2 = parameterValue) != null && (clazz2 = clazz2.getClass()) != null ? clazz2.getName() : null) + " instead.", null, 2, null);
                    }
                }
                if (convertValue == null) {
                    boolean bl8;
                    block40: {
                        GraphQLFieldDefinition graphQLFieldDefinition = environment.getFieldDefinition();
                        Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition, (String)"environment.fieldDefinition");
                        List list = graphQLFieldDefinition.getArguments();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"environment.fieldDefinition.arguments");
                        Iterable $this$none$iv = list;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl8 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                GraphQLArgument it3 = (GraphQLArgument)element$iv;
                                boolean bl9 = false;
                                GraphQLArgument graphQLArgument = it3;
                                Intrinsics.checkNotNullExpressionValue((Object)graphQLArgument, (String)"it");
                                if (!Intrinsics.areEqual((Object)graphQLArgument.getName(), (Object)parameterName)) continue;
                                bl8 = false;
                                break block40;
                            }
                            bl8 = true;
                        }
                    }
                    if (bl8) {
                        this.logger.warn("Unknown argument '" + parameterName + "' on data fetcher " + dgsComponent.getClass().getName() + '.' + method.getName());
                    }
                }
                args.add(convertValue);
                continue;
            }
            if (parameter.isAnnotationPresent(RequestHeader.class)) {
                Object[] objectArray2;
                CharSequence charSequence;
                annotation = parameter.getAnnotation(RequestHeader.class);
                objectArray = annotation.value();
                boolean bl10 = false;
                if (StringsKt.isBlank((CharSequence)objectArray)) {
                    boolean bl11 = false;
                    charSequence = parameterNames[idx];
                } else {
                    charSequence = objectArray;
                }
                parameterName = (String)charSequence;
                List list = args;
                Object object3 = DgsContext.Companion.getRequestData(environment);
                if (object3 != null && (object3 = ((DgsRequestData)object3).getHeaders()) != null && (object3 = (List)object3.get((Object)parameterName)) != null) {
                    Object object4;
                    objectArray = object3;
                    bl10 = false;
                    boolean bl11 = false;
                    paramType = objectArray;
                    collection = list;
                    boolean bl12 = false;
                    void v21 = parameter;
                    Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"parameter");
                    if (v21.getType().isAssignableFrom(List.class)) {
                        object4 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        object4 = CollectionsKt.joinToString$default((Iterable)((Iterable)it), null, null, null, (int)0, null, null, (int)63, null);
                    }
                    object = object4;
                    list = collection;
                    objectArray2 = object;
                } else {
                    objectArray2 = null;
                }
                list.add(objectArray2);
                continue;
            }
            if (parameter.isAnnotationPresent(RequestParam.class)) {
                Object object5;
                CharSequence charSequence;
                annotation = parameter.getAnnotation(RequestParam.class);
                objectArray = annotation.value();
                boolean bl13 = false;
                if (StringsKt.isBlank((CharSequence)objectArray)) {
                    boolean bl14 = false;
                    charSequence = parameterNames[idx];
                } else {
                    charSequence = objectArray;
                }
                parameterName = (String)charSequence;
                List list = args;
                Object[] objectArray3 = DgsContext.Companion.getRequestData(environment);
                if (objectArray3 != null && (objectArray3 = objectArray3.getWebRequest()) != null && (objectArray3 = objectArray3.getParameterMap()) != null && (objectArray3 = (String[])objectArray3.get(parameterName)) != null) {
                    objectArray = objectArray3;
                    bl13 = false;
                    boolean bl15 = false;
                    it = objectArray;
                    collection = list;
                    boolean bl16 = false;
                    void v27 = parameter;
                    Intrinsics.checkNotNullExpressionValue((Object)v27, (String)"parameter");
                    object = v27.getType().isAssignableFrom(List.class) ? (Serializable)it : (Serializable)((Object)ArraysKt.joinToString$default((Object[])it, null, null, null, (int)0, null, null, (int)63, null));
                    list = collection;
                    object5 = object;
                } else {
                    object5 = null;
                }
                list.add(object5);
                continue;
            }
            if (environment.containsArgument(parameterNames[idx])) {
                Object parameterValue;
                Intrinsics.checkNotNullExpressionValue((Object)environment.getArgument(parameterNames[idx]), (String)"environment.getArgument(parameterNames[idx])");
                void v29 = parameter;
                Intrinsics.checkNotNullExpressionValue((Object)v29, (String)"parameter");
                Object convertValue = this.objectMapper.convertValue(parameterValue, v29.getType());
                args.add(convertValue);
                continue;
            }
            void v30 = parameter;
            Intrinsics.checkNotNullExpressionValue((Object)v30, (String)"parameter");
            if (Intrinsics.areEqual(v30.getType(), DataFetchingEnvironment.class) || Intrinsics.areEqual(parameter.getType(), DgsDataFetchingEnvironment.class)) {
                args.add(environment);
                continue;
            }
            this.logger.warn("Unknown argument '" + parameterNames[idx] + "' on data fetcher " + dgsComponent.getClass().getName() + '.' + method.getName());
            args.add(null);
        }
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return ReflectionUtils.invokeMethod((Method)method, (Object)dgsComponent, (Object[])Arrays.copyOf(objectArray, objectArray.length));
    }

    /*
     * WARNING - void declaration
     */
    private final void findTypeResolvers(Map<String, ? extends Object> dgsComponents, RuntimeWiring.Builder runtimeWiringBuilder, TypeDefinitionRegistry mergedRegistry) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object it;
        Map $this$filterValues$iv;
        Iterator $this$forEach$iv;
        boolean bl;
        Object dgsComponent;
        boolean bl2 = false;
        Set registeredTypeResolvers = new LinkedHashSet();
        Iterable $this$forEach$iv2 = dgsComponents.values();
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv2.iterator();
        while (iterator.hasNext()) {
            Iterator $this$filterTo$iv$iv2;
            Object element$iv;
            dgsComponent = element$iv = iterator.next();
            bl = false;
            Method[] methodArray = dgsComponent.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"dgsComponent.javaClass.methods");
            Object $this$filter$iv2 = methodArray;
            boolean $i$f$filter = false;
            Method[] methodArray2 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var16_32 = $this$filterTo$iv$iv2;
            int n = ((void)var16_32).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it2 = element$iv$iv = var16_32[i];
                boolean bl3 = false;
                if (!it2.isAnnotationPresent(DgsTypeResolver.class)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                DgsDefaultTypeResolver defaultTypeResolver;
                boolean overrideTypeResolver;
                DgsTypeResolver annotation;
                Method method;
                block16: {
                    Object element$iv2 = $this$filterTo$iv$iv2.next();
                    method = (Method)element$iv2;
                    boolean bl4 = false;
                    annotation = method.getAnnotation(DgsTypeResolver.class);
                    Method method2 = method;
                    Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
                    if (Intrinsics.areEqual(method2.getReturnType(), String.class) ^ true) {
                        throw (Throwable)new InvalidTypeResolverException("@DgsTypeResolvers must return String");
                    }
                    if (method.getParameterCount() != 1) {
                        throw (Throwable)new InvalidTypeResolverException("@DgsTypeResolvers must take exactly one parameter");
                    }
                    if (!mergedRegistry.hasType(new TypeName(annotation.name()))) {
                        throw (Throwable)new InvalidTypeResolverException("could not find type name '" + annotation.name() + "' in schema");
                    }
                    overrideTypeResolver = false;
                    defaultTypeResolver = method.getAnnotation(DgsDefaultTypeResolver.class);
                    if (defaultTypeResolver != null) {
                        boolean bl5;
                        Iterable $this$any$iv = dgsComponents.values();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            Iterator iterator2 = $this$any$iv.iterator();
                            while (iterator2.hasNext()) {
                                boolean bl6;
                                block15: {
                                    Method[] $this$any$iv2;
                                    Object element$iv3;
                                    Object component = element$iv3 = iterator2.next();
                                    boolean bl7 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)component.getClass().getMethods(), (String)"component.javaClass.methods");
                                    boolean $i$f$any2 = false;
                                    Method[] methodArray3 = $this$any$iv2;
                                    int n2 = methodArray3.length;
                                    for (int i = 0; i < n2; ++i) {
                                        Method element$iv4;
                                        Method method3 = element$iv4 = methodArray3[i];
                                        boolean bl8 = false;
                                        if (!(method3.isAnnotationPresent(DgsTypeResolver.class) && Intrinsics.areEqual((Object)method3.getAnnotation(DgsTypeResolver.class).name(), (Object)annotation.name()) && Intrinsics.areEqual(component, dgsComponent) ^ true)) continue;
                                        bl6 = true;
                                        break block15;
                                    }
                                    bl6 = false;
                                }
                                if (!bl6) continue;
                                bl5 = true;
                                break block16;
                            }
                            bl5 = overrideTypeResolver = false;
                        }
                    }
                }
                if (defaultTypeResolver != null && overrideTypeResolver) continue;
                registeredTypeResolvers.add(annotation.name());
                runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)annotation.name()).typeResolver(new TypeResolver(method, dgsComponent, mergedRegistry, dgsComponents, registeredTypeResolvers, runtimeWiringBuilder){
                    final /* synthetic */ Method $method;
                    final /* synthetic */ Object $dgsComponent$inlined;
                    final /* synthetic */ TypeDefinitionRegistry $mergedRegistry$inlined;
                    final /* synthetic */ Map $dgsComponents$inlined;
                    final /* synthetic */ Set $registeredTypeResolvers$inlined;
                    final /* synthetic */ RuntimeWiring.Builder $runtimeWiringBuilder$inlined;
                    {
                        this.$method = method;
                        this.$dgsComponent$inlined = object;
                        this.$mergedRegistry$inlined = typeDefinitionRegistry;
                        this.$dgsComponents$inlined = map;
                        this.$registeredTypeResolvers$inlined = set;
                        this.$runtimeWiringBuilder$inlined = builder;
                    }

                    public final GraphQLObjectType getType(@NotNull TypeResolutionEnvironment env) {
                        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                        Object object = ReflectionUtils.invokeMethod((Method)this.$method, (Object)this.$dgsComponent$inlined, (Object[])new Object[]{env.getObject()});
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        String typeName = (String)object;
                        return env.getSchema().getObjectType(typeName);
                    }
                }));
            }
        }
        Map map = mergedRegistry.types();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"mergedRegistry.types()");
        Map $i$f$forEach22 = map;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        dgsComponent = $this$filterValues$iv;
        bl = false;
        for (Map.Entry entry$iv : dgsComponent.entrySet()) {
            it = (TypeDefinition)entry$iv.getValue();
            boolean bl9 = false;
            if (!(it instanceof InterfaceTypeDefinition || it instanceof UnionTypeDefinition)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterValues$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        $this$forEach$iv = $this$mapTo$iv$iv;
        boolean entry$iv = false;
        it = $this$forEach$iv.entrySet().iterator();
        while (it.hasNext()) {
            void it3;
            Map.Entry item$iv$iv;
            Map.Entry method = item$iv$iv = (Map.Entry)it.next();
            Collection collection = destination$iv$iv;
            boolean bl10 = false;
            String string = (String)it3.getKey();
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)((Object)element$iv$iv);
            boolean bl11 = false;
            if (!(!registeredTypeResolvers.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unregisteredTypes = (List)destination$iv$iv;
        Iterable $this$forEach$iv3 = unregisteredTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv3) {
            String it4 = (String)element$iv;
            boolean bl12 = false;
            runtimeWiringBuilder.type(TypeRuntimeWiring.newTypeWiring((String)it4).typeResolver((TypeResolver)findTypeResolvers.2.1.INSTANCE));
        }
    }

    public final void findScalars$graphql_dgs(@NotNull ApplicationContext applicationContext, @NotNull RuntimeWiring.Builder runtimeWiringBuilder) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)runtimeWiringBuilder, (String)"runtimeWiringBuilder");
        Map map = applicationContext.getBeansWithAnnotation(DgsScalar.class);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"applicationContext.getBe\u2026on(DgsScalar::class.java)");
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            Object scalarComponent = it.getValue();
            DgsScalar annotation = scalarComponent.getClass().getAnnotation(DgsScalar.class);
            Object v = scalarComponent;
            if (v instanceof Coercing) {
                runtimeWiringBuilder.scalar(GraphQLScalarType.newScalar().name(annotation.name()).coercing((Coercing)scalarComponent).build());
                continue;
            }
            throw (Throwable)new RuntimeException("Invalid @DgsScalar type: the class must implement graphql.schema.Coercing");
        }
    }

    @NotNull
    public final Resource[] findSchemaFiles$graphql_dgs(@NotNull String basedir, boolean hasDynamicTypeRegistry) {
        Object[] objectArray;
        Object[] ex2;
        Object[] resources;
        Intrinsics.checkNotNullParameter((Object)basedir, (String)"basedir");
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
        ClassLoader cl = thread.getContextClassLoader();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(cl);
        try {
            resources = resolver.getResources("classpath*:" + basedir + "/**/*.graphql*");
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
            Object[] objectArray2 = resources;
            boolean bl = false;
            if (objectArray2.length == 0) {
                throw (Throwable)new NoSchemaFoundException();
            }
        }
        catch (Exception ex2) {
            if (!this.existingTypeDefinitionRegistry.isPresent() && !hasDynamicTypeRegistry) {
                this.logger.error("No schema files found. Define schemas in src/main/resources/" + basedir + "/**/*.graphqls");
                throw (Throwable)new NoSchemaFoundException();
            }
            this.logger.info("No schema files found, but a schema was provided as an TypeDefinitionRegistry");
            resources = new Resource[]{};
        }
        Object[] schemas = resources;
        try {
            ex2 = resolver.getResources("classpath:" + basedir + "-test/**/*.graphql*");
        }
        catch (Exception ex3) {
            ex2 = new Resource[]{};
        }
        Object[] testSchemas = ex2;
        try {
            objectArray = resolver.getResources("classpath*:META-INF/" + basedir + "/**/*.graphql*");
        }
        catch (Exception ex4) {
            objectArray = new Resource[]{};
        }
        Object[] metaInfSchemas = objectArray;
        Intrinsics.checkNotNullExpressionValue((Object)testSchemas, (String)"testSchemas");
        Object[] objectArray3 = ArraysKt.plus((Object[])schemas, (Object[])testSchemas);
        Intrinsics.checkNotNullExpressionValue((Object)metaInfSchemas, (String)"metaInfSchemas");
        return (Resource[])ArraysKt.plus((Object[])objectArray3, (Object[])metaInfSchemas);
    }

    public static /* synthetic */ Resource[] findSchemaFiles$graphql_dgs$default(DgsSchemaProvider dgsSchemaProvider, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = "schema";
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return dgsSchemaProvider.findSchemaFiles$graphql_dgs(string, bl);
    }

    public DgsSchemaProvider(@NotNull ApplicationContext applicationContext, @NotNull Optional<DgsFederationResolver> federationResolver, @NotNull Optional<TypeDefinitionRegistry> existingTypeDefinitionRegistry, @NotNull Optional<Set<MockProvider>> mockProviders) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(federationResolver, (String)"federationResolver");
        Intrinsics.checkNotNullParameter(existingTypeDefinitionRegistry, (String)"existingTypeDefinitionRegistry");
        Intrinsics.checkNotNullParameter(mockProviders, (String)"mockProviders");
        this.applicationContext = applicationContext;
        this.federationResolver = federationResolver;
        this.existingTypeDefinitionRegistry = existingTypeDefinitionRegistry;
        this.mockProviders = mockProviders;
        boolean bl = false;
        this.dataFetcherInstrumentationEnabled = new LinkedHashMap();
        bl = false;
        this.entityFetchers = new LinkedHashMap();
        this.defaultParameterNameDiscoverer = new DefaultParameterNameDiscoverer();
        this.logger = LoggerFactory.getLogger(DgsSchemaProvider.class);
        this.objectMapper = ExtensionsKt.jacksonObjectMapper().registerModule((Module)new JavaTimeModule());
    }

    public static final /* synthetic */ Object access$invokeDataFetcher(DgsSchemaProvider $this, Method method, Object dgsComponent, DataFetchingEnvironment environment) {
        return $this.invokeDataFetcher(method, dgsComponent, environment);
    }
}

