/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.netflix.graphql.dgs.DgsContextBuilder;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.exceptions.DgsQueryExecutionDataExtractionException;
import com.netflix.graphql.dgs.exceptions.QueryException;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsRequestData;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.NonNullableFieldWasNullError;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.context.request.WebRequest;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001>BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J.\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020&0%2\b\u0010'\u001a\u0004\u0018\u00010#H\u0016JX\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020&0%2\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020&\u0018\u00010%2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010'\u001a\u0004\u0018\u00010#2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J#\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010.2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u00020#H\u0016\u00a2\u0006\u0002\u00100J7\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010.2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020&0%H\u0016\u00a2\u0006\u0002\u00101J1\u00102\u001a\u0002H.\"\u0004\b\u0000\u0010.2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u00020#2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H.04H\u0016\u00a2\u0006\u0002\u00105J1\u00102\u001a\u0002H.\"\u0004\b\u0000\u0010.2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u00020#2\f\u00106\u001a\b\u0012\u0004\u0012\u0002H.07H\u0016\u00a2\u0006\u0002\u00108JE\u00102\u001a\u0002H.\"\u0004\b\u0000\u0010.2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020&0%2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H.04H\u0016\u00a2\u0006\u0002\u00109JE\u00102\u001a\u0002H.\"\u0004\b\u0000\u0010.2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020&0%2\f\u00106\u001a\b\u0012\u0004\u0012\u0002H.07H\u0016\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020<2\u0006\u0010\"\u001a\u00020#H\u0016J$\u0010;\u001a\u00020<2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020&0%H\u0016J$\u0010=\u001a\u00020#2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020&0%H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00030\u00030\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor;", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "defaultSchema", "Lgraphql/schema/GraphQLSchema;", "schemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "dataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "contextBuilder", "Lcom/netflix/graphql/dgs/DgsContextBuilder;", "chainedInstrumentation", "Lgraphql/execution/instrumentation/ChainedInstrumentation;", "queryExecutionStrategy", "Lgraphql/execution/ExecutionStrategy;", "mutationExecutionStrategy", "idProvider", "Ljava/util/Optional;", "Lgraphql/execution/ExecutionIdProvider;", "reloadIndicator", "Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "(Lgraphql/schema/GraphQLSchema;Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;Lcom/netflix/graphql/dgs/DgsContextBuilder;Lgraphql/execution/instrumentation/ChainedInstrumentation;Lgraphql/execution/ExecutionStrategy;Lgraphql/execution/ExecutionStrategy;Ljava/util/Optional;Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "parseContext", "Lcom/jayway/jsonpath/ParseContext;", "schema", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "getSchema", "()Ljava/util/concurrent/atomic/AtomicReference;", "execute", "Lgraphql/ExecutionResult;", "query", "", "variables", "", "", "operationName", "extensions", "headers", "Lorg/springframework/http/HttpHeaders;", "webRequest", "Lorg/springframework/web/context/request/WebRequest;", "executeAndExtractJsonPath", "T", "jsonPath", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Ljava/lang/Object;", "executeAndExtractJsonPathAsObject", "typeRef", "Lcom/jayway/jsonpath/TypeRef;", "(Ljava/lang/String;Ljava/lang/String;Lcom/jayway/jsonpath/TypeRef;)Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lcom/jayway/jsonpath/TypeRef;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Class;)Ljava/lang/Object;", "executeAndGetDocumentContext", "Lcom/jayway/jsonpath/DocumentContext;", "getJsonResult", "ReloadSchemaIndicator", "graphql-dgs"})
public final class DefaultDgsQueryExecutor
implements DgsQueryExecutor {
    private final ParseContext parseContext;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicReference<GraphQLSchema> schema;
    private final DgsSchemaProvider schemaProvider;
    private final DgsDataLoaderProvider dataLoaderProvider;
    private final DgsContextBuilder contextBuilder;
    private final ChainedInstrumentation chainedInstrumentation;
    private final ExecutionStrategy queryExecutionStrategy;
    private final ExecutionStrategy mutationExecutionStrategy;
    private final Optional<ExecutionIdProvider> idProvider;
    private final ReloadSchemaIndicator reloadIndicator;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final AtomicReference<GraphQLSchema> getSchema() {
        return this.schema;
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable Map<String, ? extends Object> extensions, @Nullable HttpHeaders headers, @Nullable String operationName, @Nullable WebRequest webRequest) {
        ExecutionResult executionResult;
        ExecutionResult executionResult2;
        GraphQLSchema graphQLSchema2;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        if (this.reloadIndicator.reloadSchema()) {
            GraphQLSchema graphQLSchema3 = this.schema.updateAndGet(new UnaryOperator<GraphQLSchema>(this){
                final /* synthetic */ DefaultDgsQueryExecutor this$0;

                public final GraphQLSchema apply(GraphQLSchema it) {
                    return DgsSchemaProvider.schema$default(DefaultDgsQueryExecutor.access$getSchemaProvider$p(this.this$0), null, 1, null);
                }
                {
                    this.this$0 = defaultDgsQueryExecutor;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema3, (String)"schema.updateAndGet { schemaProvider.schema() }");
            graphQLSchema2 = graphQLSchema3;
        } else {
            GraphQLSchema graphQLSchema4 = this.schema.get();
            Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema4, (String)"schema.get()");
            graphQLSchema2 = graphQLSchema4;
        }
        GraphQLSchema graphQLSchema5 = graphQLSchema2;
        GraphQL.Builder graphQLBuilder = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema5).instrumentation((Instrumentation)this.chainedInstrumentation).queryExecutionStrategy(this.queryExecutionStrategy).mutationExecutionStrategy(this.mutationExecutionStrategy).subscriptionExecutionStrategy((ExecutionStrategy)new SubscriptionExecutionStrategy());
        if (this.idProvider.isPresent()) {
            graphQLBuilder.executionIdProvider(this.idProvider.get());
        }
        GraphQL graphQL = graphQLBuilder.build();
        DgsContext dgsContext = this.contextBuilder.build(new DgsRequestData(extensions, headers, webRequest));
        DataLoaderRegistry dataLoaderRegistry2 = this.dataLoaderProvider.buildRegistryWithContextSupplier(new Supplier<DgsContext>(dgsContext){
            final /* synthetic */ DgsContext $dgsContext;

            @NotNull
            public final DgsContext get() {
                return this.$dgsContext;
            }
            {
                this.$dgsContext = dgsContext;
            }
        });
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).dataLoaderRegistry(dataLoaderRegistry2).variables(variables).operationName(operationName).context((Object)dgsContext).build();
        Intrinsics.checkNotNullExpressionValue((Object)executionInput, (String)"ExecutionInput.newExecut\u2026ext)\n            .build()");
        ExecutionInput executionInput2 = executionInput;
        try {
            executionResult2 = graphQL.execute(executionInput2);
        }
        catch (Exception e) {
            this.logger.error("Encountered an exception while handling query " + query, (Throwable)e);
            List errors = e instanceof GraphQLError ? CollectionsKt.listOf((Object)e) : CollectionsKt.emptyList();
            executionResult2 = (ExecutionResult)new ExecutionResultImpl(null, errors);
        }
        ExecutionResult executionResult3 = executionResult = executionResult2;
        Intrinsics.checkNotNullExpressionValue((Object)executionResult3, (String)"executionResult");
        if (executionResult3.getErrors().size() > 0) {
            Object v6;
            block8: {
                List list = executionResult.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"executionResult.errors");
                Iterable iterable = list;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    GraphQLError it = (GraphQLError)t;
                    boolean bl3 = false;
                    if (!(it instanceof NonNullableFieldWasNullError)) continue;
                    v6 = t;
                    break block8;
                }
                v6 = null;
            }
            GraphQLError nullValueError = v6;
            if (nullValueError != null) {
                this.logger.error(nullValueError.getMessage());
            }
        }
        return executionResult;
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull String query, @NotNull Map<String, ? extends Object> variables, @Nullable String operationName) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        WebRequest webRequest = null;
        HttpHeaders httpHeaders = null;
        Map<String, ? extends Object> map = null;
        String string = operationName;
        return this.execute(query, variables, map, httpHeaders, string, webRequest);
    }

    @Override
    public <T> T executeAndExtractJsonPath(@NotNull String query, @NotNull String jsonPath) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        return (T)JsonPath.read((String)this.getJsonResult(query, MapsKt.emptyMap()), (String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    public <T> T executeAndExtractJsonPath(@NotNull String query, @NotNull String jsonPath, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return (T)JsonPath.read((String)this.getJsonResult(query, variables), (String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    public <T> T executeAndExtractJsonPathAsObject(@NotNull String query, @NotNull String jsonPath, @NotNull Class<T> clazz) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String jsonResult = this.getJsonResult(query, MapsKt.emptyMap());
        try {
            object = this.parseContext.parse(jsonResult).read(jsonPath, clazz, new Predicate[0]);
        }
        catch (MappingException ex) {
            throw (Throwable)new DgsQueryExecutionDataExtractionException(ex, jsonResult, jsonPath, clazz);
        }
        return (T)object;
    }

    @Override
    public <T> T executeAndExtractJsonPathAsObject(@NotNull String query, @NotNull String jsonPath, @NotNull Map<String, ? extends Object> variables, @NotNull Class<T> clazz) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String jsonResult = this.getJsonResult(query, variables);
        try {
            object = this.parseContext.parse(jsonResult).read(jsonPath, clazz, new Predicate[0]);
        }
        catch (MappingException ex) {
            throw (Throwable)new DgsQueryExecutionDataExtractionException(ex, jsonResult, jsonPath, clazz);
        }
        return (T)object;
    }

    @Override
    public <T> T executeAndExtractJsonPathAsObject(@NotNull String query, @NotNull String jsonPath, @NotNull TypeRef<T> typeRef) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter(typeRef, (String)"typeRef");
        String jsonResult = this.getJsonResult(query, MapsKt.emptyMap());
        try {
            object = this.parseContext.parse(jsonResult).read(jsonPath, typeRef);
        }
        catch (MappingException ex) {
            throw (Throwable)new DgsQueryExecutionDataExtractionException(ex, jsonResult, jsonPath, typeRef);
        }
        return (T)object;
    }

    @Override
    public <T> T executeAndExtractJsonPathAsObject(@NotNull String query, @NotNull String jsonPath, @NotNull Map<String, ? extends Object> variables, @NotNull TypeRef<T> typeRef) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter(typeRef, (String)"typeRef");
        String jsonResult = this.getJsonResult(query, variables);
        try {
            object = this.parseContext.parse(jsonResult).read(jsonPath, typeRef);
        }
        catch (MappingException ex) {
            throw (Throwable)new DgsQueryExecutionDataExtractionException(ex, jsonResult, jsonPath, typeRef);
        }
        return (T)object;
    }

    @Override
    @NotNull
    public DocumentContext executeAndGetDocumentContext(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        DocumentContext documentContext = this.parseContext.parse(this.getJsonResult(query, MapsKt.emptyMap()));
        Intrinsics.checkNotNullExpressionValue((Object)documentContext, (String)"parseContext.parse(getJs\u2026esult(query, emptyMap()))");
        return documentContext;
    }

    @Override
    @NotNull
    public DocumentContext executeAndGetDocumentContext(@NotNull String query, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        DocumentContext documentContext = this.parseContext.parse(this.getJsonResult(query, variables));
        Intrinsics.checkNotNullExpressionValue((Object)documentContext, (String)"parseContext.parse(getJs\u2026Result(query, variables))");
        return documentContext;
    }

    private final String getJsonResult(String query, Map<String, ? extends Object> variables) {
        ExecutionResult executionResult = this.execute(query, variables);
        if (executionResult.getErrors().size() > 0) {
            List list = executionResult.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"executionResult.errors");
            throw (Throwable)new QueryException(list);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String string = objectMapper.writeValueAsString((Object)executionResult.toSpecification());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectMapper.writeValueA\u2026Result.toSpecification())");
        return string;
    }

    public DefaultDgsQueryExecutor(@NotNull GraphQLSchema defaultSchema, @NotNull DgsSchemaProvider schemaProvider, @NotNull DgsDataLoaderProvider dataLoaderProvider, @NotNull DgsContextBuilder contextBuilder, @NotNull ChainedInstrumentation chainedInstrumentation, @NotNull ExecutionStrategy queryExecutionStrategy, @NotNull ExecutionStrategy mutationExecutionStrategy, @NotNull Optional<ExecutionIdProvider> idProvider, @NotNull ReloadSchemaIndicator reloadIndicator) {
        Intrinsics.checkNotNullParameter((Object)defaultSchema, (String)"defaultSchema");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        Intrinsics.checkNotNullParameter((Object)dataLoaderProvider, (String)"dataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)contextBuilder, (String)"contextBuilder");
        Intrinsics.checkNotNullParameter((Object)chainedInstrumentation, (String)"chainedInstrumentation");
        Intrinsics.checkNotNullParameter((Object)queryExecutionStrategy, (String)"queryExecutionStrategy");
        Intrinsics.checkNotNullParameter((Object)mutationExecutionStrategy, (String)"mutationExecutionStrategy");
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        Intrinsics.checkNotNullParameter((Object)reloadIndicator, (String)"reloadIndicator");
        this.schemaProvider = schemaProvider;
        this.dataLoaderProvider = dataLoaderProvider;
        this.contextBuilder = contextBuilder;
        this.chainedInstrumentation = chainedInstrumentation;
        this.queryExecutionStrategy = queryExecutionStrategy;
        this.mutationExecutionStrategy = mutationExecutionStrategy;
        this.idProvider = idProvider;
        this.reloadIndicator = reloadIndicator;
        ParseContext parseContext = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(ExtensionsKt.jacksonObjectMapper())).mappingProvider((MappingProvider)new JacksonMappingProvider(ExtensionsKt.jacksonObjectMapper().enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES))).build().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}));
        Intrinsics.checkNotNullExpressionValue((Object)parseContext, (String)"JsonPath.using(\n        \u2026H_LEAF_TO_NULL)\n        )");
        this.parseContext = parseContext;
        Logger logger = LoggerFactory.getLogger(DefaultDgsQueryExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026ueryExecutor::class.java)");
        this.logger = logger;
        this.schema = new AtomicReference<GraphQLSchema>(defaultSchema);
    }

    public /* synthetic */ DefaultDgsQueryExecutor(GraphQLSchema graphQLSchema2, DgsSchemaProvider dgsSchemaProvider, DgsDataLoaderProvider dgsDataLoaderProvider, DgsContextBuilder dgsContextBuilder, ChainedInstrumentation chainedInstrumentation, ExecutionStrategy executionStrategy, ExecutionStrategy executionStrategy2, Optional optional, ReloadSchemaIndicator reloadSchemaIndicator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            reloadSchemaIndicator = 1.INSTANCE;
        }
        this(graphQLSchema2, dgsSchemaProvider, dgsDataLoaderProvider, dgsContextBuilder, chainedInstrumentation, executionStrategy, executionStrategy2, optional, reloadSchemaIndicator);
    }

    public static final /* synthetic */ DgsSchemaProvider access$getSchemaProvider$p(DefaultDgsQueryExecutor $this) {
        return $this.schemaProvider;
    }

    @FunctionalInterface
    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/netflix/graphql/dgs/internal/DefaultDgsQueryExecutor$ReloadSchemaIndicator;", "", "reloadSchema", "", "graphql-dgs"})
    public static interface ReloadSchemaIndicator {
        public boolean reloadSchema();
    }
}

