/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal.method;

import com.netflix.graphql.dgs.exceptions.DgsInvalidInputArgumentException;
import com.netflix.graphql.dgs.internal.InputObjectMapper;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import com.netflix.graphql.dgs.internal.method.InputObjectMapperConverter;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\nH \u00a2\u0006\u0002\b\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/netflix/graphql/dgs/internal/method/AbstractInputArgumentResolver;", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "inputObjectMapper", "Lcom/netflix/graphql/dgs/internal/InputObjectMapper;", "<init>", "(Lcom/netflix/graphql/dgs/internal/InputObjectMapper;)V", "conversionService", "Lorg/springframework/core/convert/support/DefaultConversionService;", "argumentNameCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/springframework/core/MethodParameter;", "", "resolveArgument", "", "parameter", "dfe", "Lgraphql/schema/DataFetchingEnvironment;", "resolveArgumentName", "resolveArgumentName$graphql_dgs", "getArgumentName", "convertValue", "source", "target", "Lorg/springframework/core/convert/TypeDescriptor;", "Companion", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nAbstractInputArgumentResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractInputArgumentResolver.kt\ncom/netflix/graphql/dgs/internal/method/AbstractInputArgumentResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n2746#2,3:109\n*S KotlinDebug\n*F\n+ 1 AbstractInputArgumentResolver.kt\ncom/netflix/graphql/dgs/internal/method/AbstractInputArgumentResolver\n*L\n71#1:109,3\n*E\n"})
public abstract class AbstractInputArgumentResolver
implements ArgumentResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultConversionService conversionService;
    @NotNull
    private final ConcurrentMap<MethodParameter, String> argumentNameCache;
    @NotNull
    private static final Logger logger;

    public AbstractInputArgumentResolver(@NotNull InputObjectMapper inputObjectMapper) {
        Intrinsics.checkNotNullParameter((Object)inputObjectMapper, (String)"inputObjectMapper");
        this.conversionService = new DefaultConversionService();
        this.argumentNameCache = new ConcurrentHashMap();
        this.conversionService.addConverter((GenericConverter)new InputObjectMapperConverter(inputObjectMapper));
    }

    @Override
    @Nullable
    public Object resolveArgument(@NotNull MethodParameter parameter, @NotNull DataFetchingEnvironment dfe) {
        TypeDescriptor typeDescriptor;
        Object convertedValue;
        KFunction kfunc;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        String string = this.getArgumentName(parameter);
        if (string == null) {
            return null;
        }
        String argumentName = string;
        Object value = dfe.getArgument(argumentName);
        Method method = parameter.getMethod();
        Object object = kfunc = method != null ? ReflectJvmMapping.getKotlinFunction((Method)method) : null;
        if (kfunc != null) {
            int parameterIdx = ((KParameter)CollectionsKt.first((List)kfunc.getParameters())).getKind() == KParameter.Kind.INSTANCE ? parameter.getParameterIndex() + 1 : parameter.getParameterIndex();
            KParameter param = (KParameter)kfunc.getParameters().get(parameterIdx);
            if (param.getType().getArguments().isEmpty() && KTypesJvm.getJvmErasure((KType)param.getType()).isInstance(value)) {
                return value;
            }
        }
        if ((convertedValue = this.convertValue(value, typeDescriptor = new TypeDescriptor(parameter))) == null) {
            boolean bl;
            block8: {
                List list = dfe.getFieldDefinition().getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArguments(...)");
                Iterable $this$none$iv = list;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        GraphQLArgument it = (GraphQLArgument)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)argumentName)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (bl) {
                logger.warn("Unknown argument '{}'", (Object)argumentName);
            }
        }
        return convertedValue;
    }

    @Nullable
    public abstract String resolveArgumentName$graphql_dgs(@NotNull MethodParameter var1);

    private final String getArgumentName(MethodParameter parameter) {
        if (this.argumentNameCache.containsKey(parameter)) {
            return (String)this.argumentNameCache.get(parameter);
        }
        String name = this.resolveArgumentName$graphql_dgs(parameter);
        ((Map)this.argumentNameCache).put(parameter, name);
        return name;
    }

    private final Object convertValue(Object source, TypeDescriptor target) {
        if (target.getResolvableType().isInstance(source)) {
            return source;
        }
        TypeDescriptor sourceType = TypeDescriptor.forObject((Object)source);
        if (this.conversionService.canConvert(sourceType, target)) {
            return this.conversionService.convert(source, sourceType, target);
        }
        Object object = source;
        throw new DgsInvalidInputArgumentException("Unable to convert from " + (object != null ? object.getClass() : null) + " to " + target.getType(), null, 2, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(AbstractInputArgumentResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        AbstractInputArgumentResolver.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/internal/method/AbstractInputArgumentResolver$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "graphql-dgs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

