/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.internal;

import com.netflix.graphql.dgs.DgsDataLoaderCustomizer;
import com.netflix.graphql.dgs.DgsDataLoaderInstrumentation;
import com.netflix.graphql.dgs.DgsDataLoaderInstrumentationContext;
import com.netflix.graphql.dgs.DgsDataLoaderRegistryConsumer;
import com.netflix.graphql.dgs.exceptions.DgsDataLoaderInstrumentationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoader;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.MappedBatchLoader;
import org.dataloader.MappedBatchLoaderWithContext;

public class DgsDataLoaderInstrumentationDataLoaderCustomizer
implements DgsDataLoaderCustomizer {
    private final List<DgsDataLoaderInstrumentation> instrumentations;

    public DgsDataLoaderInstrumentationDataLoaderCustomizer(List<DgsDataLoaderInstrumentation> instrumentations) {
        this.instrumentations = instrumentations;
    }

    @Override
    public Object provide(BatchLoader<?, ?> original, String name) {
        throw new DgsDataLoaderInstrumentationException(name);
    }

    @Override
    public Object provide(BatchLoaderWithContext<?, ?> original, String name) {
        return new BatchLoaderWithContextInstrumentationDriver(original, name, this.instrumentations);
    }

    @Override
    public Object provide(MappedBatchLoader<?, ?> original, String name) {
        throw new DgsDataLoaderInstrumentationException(name);
    }

    @Override
    public Object provide(MappedBatchLoaderWithContext<?, ?> original, String name) {
        return new MappedBatchLoaderWithContextInstrumentationDriver(original, name, this.instrumentations);
    }

    static class BatchLoaderWithContextInstrumentationDriver<K, V>
    implements BatchLoaderWithContext<K, V>,
    DgsDataLoaderRegistryConsumer {
        private final BatchLoaderWithContext<K, V> original;
        private final String name;
        private final List<DgsDataLoaderInstrumentation> instrumentations;

        BatchLoaderWithContextInstrumentationDriver(BatchLoaderWithContext<K, V> original, String name, List<DgsDataLoaderInstrumentation> instrumentations) {
            this.original = original;
            this.name = name;
            this.instrumentations = instrumentations;
        }

        public CompletionStage<List<V>> load(List<K> keys, BatchLoaderEnvironment environment) {
            List<DgsDataLoaderInstrumentationContext> contexts = this.instrumentations.stream().map(it -> it.onDispatch(this.name, keys, environment)).toList();
            CompletionStage<List<V>> future = this.original.load(keys, environment).whenComplete((result, exception) -> {
                try {
                    ArrayList reversedContexts = new ArrayList(contexts);
                    Collections.reverse(reversedContexts);
                    for (DgsDataLoaderInstrumentationContext c : reversedContexts) {
                        c.onComplete(result, exception);
                    }
                }
                catch (Throwable ignored) {
                    System.out.println("Error");
                }
            });
            return future;
        }

        @Override
        public void setDataLoaderRegistry(DataLoaderRegistry dataLoaderRegistry) {
            if (this.original instanceof DgsDataLoaderRegistryConsumer) {
                ((DgsDataLoaderRegistryConsumer)this.original).setDataLoaderRegistry(dataLoaderRegistry);
            }
        }
    }

    static class MappedBatchLoaderWithContextInstrumentationDriver<K, V>
    implements MappedBatchLoaderWithContext<K, V>,
    DgsDataLoaderRegistryConsumer {
        private final MappedBatchLoaderWithContext<K, V> original;
        private final String name;
        private final List<DgsDataLoaderInstrumentation> instrumentations;

        MappedBatchLoaderWithContextInstrumentationDriver(MappedBatchLoaderWithContext<K, V> original, String name, List<DgsDataLoaderInstrumentation> instrumentations) {
            this.original = original;
            this.name = name;
            this.instrumentations = instrumentations;
        }

        public CompletionStage<Map<K, V>> load(Set<K> keys, BatchLoaderEnvironment environment) {
            List<DgsDataLoaderInstrumentationContext> contexts = this.instrumentations.stream().map(it -> it.onDispatch(this.name, new ArrayList(keys), environment)).toList();
            CompletionStage future = this.original.load(keys, environment);
            return future.whenComplete((result, exception) -> {
                try {
                    ArrayList reversedContexts = new ArrayList(contexts);
                    Collections.reverse(reversedContexts);
                    for (DgsDataLoaderInstrumentationContext c : reversedContexts) {
                        c.onComplete(result, exception);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }

        @Override
        public void setDataLoaderRegistry(DataLoaderRegistry dataLoaderRegistry) {
            if (this.original instanceof DgsDataLoaderRegistryConsumer) {
                ((DgsDataLoaderRegistryConsumer)this.original).setDataLoaderRegistry(dataLoaderRegistry);
            }
        }
    }
}

