/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs;

import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.exceptions.MultipleDataLoadersDefinedException;
import com.netflix.graphql.dgs.exceptions.NoDataLoaderFoundException;
import com.netflix.graphql.dgs.internal.utils.DataLoaderNameUtil;
import graphql.GraphQLContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.MergedField;
import graphql.execution.directives.QueryDirectives;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.type.StandardMethodMetadata;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\u0001J\u0006\u0010\b\u001a\u00020\tJ\u0011\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b\u00a2\u0006\u0002\u0010\fJ2\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u000e\"\b\b\u0000\u0010\u000f*\u00020\u0011\"\b\b\u0001\u0010\u0010*\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015J\u001f\u0010\u0019\u001a\u00020\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u001a\"\u00020\u0015\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u0019\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00172\u000b\u0010\u001f\u001a\u00070\u0015\u00a2\u0006\u0002\b H\u0096\u0001J6\u0010!\u001a\u000e\u0018\u0001H\u000b\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b \"\r\b\u0000\u0010\u000b*\u00070\u0011\u00a2\u0006\u0002\b 2\u000b\u0010\u001f\u001a\u00070\u0015\u00a2\u0006\u0002\b H\u0096\u0001\u00a2\u0006\u0002\u0010#J<\u0010$\u001a\u0007H\u000b\u00a2\u0006\u0002\b \"\r\b\u0000\u0010\u000b*\u00070\u0011\u00a2\u0006\u0002\b 2\u000b\u0010\u001f\u001a\u00070\u0015\u00a2\u0006\u0002\b 2\u000b\u0010%\u001a\u0007H\u000b\u00a2\u0006\u0002\b H\u0096\u0001\u00a2\u0006\u0002\u0010&JE\u0010'\u001a>\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b \u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b  **\u001d\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b \u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b 0)\u00a2\u0006\u0002\b 0(\u00a2\u0006\u0002\b H\u0096\u0001J)\u0010+\u001a\u000e\u0018\u0001H\u000b\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b \"\r\b\u0000\u0010\u000b*\u00070\u0011\u00a2\u0006\u0002\b H\u0097\u0001\u00a2\u0006\u0002\u0010\fJV\u0010\r\u001a$\u0012\t\u0012\u0007H\u000f\u00a2\u0006\u0002\b \u0012\t\u0012\u0007H\u0010\u00a2\u0006\u0002\b \u0018\u00010\u000e\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b \"\r\b\u0000\u0010\u000f*\u00070\u0011\u00a2\u0006\u0002\b \"\r\b\u0001\u0010\u0010*\u00070\u0011\u00a2\u0006\u0002\b 2\u000b\u0010,\u001a\u00070\u0015\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u0010-\u001a\u00070.\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u0010/\u001a\u000700\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u00101\u001a\u000702\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u00103\u001a\u000704\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u00105\u001a\u000706\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u00107\u001a\u000708\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u00109\u001a\u00070:\u00a2\u0006\u0002\b H\u0096\u0001J/\u0010;\u001a(\u0012\t\u0012\u000706\u00a2\u0006\u0002\b  **\u0012\u0012\t\u0012\u000706\u00a2\u0006\u0002\b 0=\u00a2\u0006\u0002\b 0<\u00a2\u0006\u0002\b H\u0097\u0001JE\u0010>\u001a>\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b \u0012\t\u0012\u00070?\u00a2\u0006\u0002\b  **\u001d\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b \u0012\t\u0012\u00070?\u00a2\u0006\u0002\b 0)\u00a2\u0006\u0002\b 0(\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u0010@\u001a\u00070A\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u0010B\u001a\u00070C\u00a2\u0006\u0002\b H\u0096\u0001J)\u0010D\u001a\u000e\u0018\u0001H\u000b\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b \"\r\b\u0000\u0010\u000b*\u00070\u0011\u00a2\u0006\u0002\b H\u0096\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010E\u001a\u00070F\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u0010G\u001a\u00070H\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u0010I\u001a\u00070J\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u0010K\u001a\u00070L\u00a2\u0006\u0002\b H\u0096\u0001J\u000e\u0010M\u001a\u00070N\u00a2\u0006\u0002\b H\u0096\u0001J)\u0010O\u001a\u000e\u0018\u0001H\u000b\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b \"\r\b\u0000\u0010\u000b*\u00070\u0011\u00a2\u0006\u0002\b H\u0096\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010P\u001a\u00070Q\u00a2\u0006\u0002\b H\u0096\u0001J)\u0010R\u001a\u000e\u0018\u0001H\u000b\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b \"\r\b\u0000\u0010\u000b*\u00070\u0011\u00a2\u0006\u0002\b H\u0096\u0001\u00a2\u0006\u0002\u0010\fJE\u0010S\u001a>\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b \u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b  **\u001d\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b \u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b 0)\u00a2\u0006\u0002\b 0(\u00a2\u0006\u0002\b H\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "Lgraphql/schema/DataFetchingEnvironment;", "dfe", "ctx", "Lorg/springframework/context/ApplicationContext;", "<init>", "(Lgraphql/schema/DataFetchingEnvironment;Lorg/springframework/context/ApplicationContext;)V", "getDfe", "getDgsContext", "Lcom/netflix/graphql/dgs/context/DgsContext;", "getSourceOrThrow", "T", "()Ljava/lang/Object;", "getDataLoader", "Lorg/dataloader/DataLoader;", "K", "V", "", "loaderClass", "Ljava/lang/Class;", "tryGetDataLoaderFromBeanDefinition", "", "isNestedArgumentSet", "", "path", "isArgumentSet", "", "([Ljava/lang/String;)Z", "keys", "Lkotlin/sequences/Sequence;", "containsArgument", "name", "Lkotlin/jvm/internal/EnhancedNullability;", "getArgument", "Lorg/jspecify/annotations/Nullable;", "(Ljava/lang/String;)Ljava/lang/Object;", "getArgumentOrDefault", "defaultValue", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getArguments", "", "", "kotlin.jvm.PlatformType", "getContext", "dataLoaderName", "getDataLoaderRegistry", "Lorg/dataloader/DataLoaderRegistry;", "getDocument", "Lgraphql/language/Document;", "getExecutionId", "Lgraphql/execution/ExecutionId;", "getExecutionStepInfo", "Lgraphql/execution/ExecutionStepInfo;", "getField", "Lgraphql/language/Field;", "getFieldDefinition", "Lgraphql/schema/GraphQLFieldDefinition;", "getFieldType", "Lgraphql/schema/GraphQLOutputType;", "getFields", "", "", "getFragmentsByName", "Lgraphql/language/FragmentDefinition;", "getGraphQLSchema", "Lgraphql/schema/GraphQLSchema;", "getGraphQlContext", "Lgraphql/GraphQLContext;", "getLocalContext", "getLocale", "Ljava/util/Locale;", "getMergedField", "Lgraphql/execution/MergedField;", "getOperationDefinition", "Lgraphql/language/OperationDefinition;", "getParentType", "Lgraphql/schema/GraphQLType;", "getQueryDirectives", "Lgraphql/execution/directives/QueryDirectives;", "getRoot", "getSelectionSet", "Lgraphql/schema/DataFetchingFieldSelectionSet;", "getSource", "getVariables", "graphql-dgs"})
@SourceDebugExtension(value={"SMAP\nDgsDataFetchingEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsDataFetchingEnvironment.kt\ncom/netflix/graphql/dgs/DgsDataFetchingEnvironment\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,119:1\n3919#2:120\n4434#2,2:121\n1563#3:123\n1634#3,3:124\n37#4,2:127\n*S KotlinDebug\n*F\n+ 1 DgsDataFetchingEnvironment.kt\ncom/netflix/graphql/dgs/DgsDataFetchingEnvironment\n*L\n50#1:120\n50#1:121,2\n93#1:123\n93#1:124,3\n94#1:127,2\n*E\n"})
public final class DgsDataFetchingEnvironment
implements DataFetchingEnvironment {
    @NotNull
    private final DataFetchingEnvironment dfe;
    @NotNull
    private final ApplicationContext ctx;

    public DgsDataFetchingEnvironment(@NotNull DataFetchingEnvironment dfe, @NotNull ApplicationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.dfe = dfe;
        this.ctx = ctx;
    }

    @NotNull
    public final DataFetchingEnvironment getDfe() {
        return this.dfe;
    }

    @NotNull
    public final DgsContext getDgsContext() {
        return DgsContext.Companion.from(this);
    }

    public final <T> T getSourceOrThrow() {
        T t = this.getSource();
        if (t == null) {
            throw new IllegalStateException("source is null");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <K, V> DataLoader<K, V> getDataLoader(@NotNull Class<?> loaderClass) {
        String string;
        Intrinsics.checkNotNullParameter(loaderClass, (String)"loaderClass");
        DgsDataLoader annotation = loaderClass.getAnnotation(DgsDataLoader.class);
        if (annotation != null) {
            string = DataLoaderNameUtil.INSTANCE.getDataLoaderName(loaderClass, annotation);
        } else {
            void $this$filterTo$iv$iv;
            Field[] fieldArray = loaderClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getFields(...)");
            Object[] $this$filter$iv = fieldArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Field it = (Field)element$iv$iv;
                boolean bl = false;
                if (!it.isAnnotationPresent(DgsDataLoader.class)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List loaders = (List)destination$iv$iv;
            if (loaders.isEmpty()) {
                string = this.tryGetDataLoaderFromBeanDefinition(loaderClass);
            } else {
                if (loaders.size() > 1) {
                    $this$filter$iv = new Class[]{loaderClass};
                    throw new MultipleDataLoadersDefinedException((Class<?>[])$this$filter$iv);
                }
                Field field = (Field)CollectionsKt.firstOrNull((List)loaders);
                if (field == null) {
                    throw new NoDataLoaderFoundException(loaderClass);
                }
                Field loaderField = field;
                DgsDataLoader theAnnotation = loaderField.getAnnotation(DgsDataLoader.class);
                string = theAnnotation.name();
            }
        }
        String loaderName = string;
        DataLoader<K, V> dataLoader = this.getDataLoader(loaderName);
        if (dataLoader == null) {
            throw new NoDataLoaderFoundException("DataLoader with name " + loaderName + " not found");
        }
        return dataLoader;
    }

    private final String tryGetDataLoaderFromBeanDefinition(Class<?> loaderClass) {
        String name = loaderClass.getSimpleName();
        if (this.ctx instanceof ConfigurableApplicationContext) {
            Map map = ((ConfigurableApplicationContext)this.ctx).getBeanFactory().getBeansOfType(loaderClass);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getBeansOfType(...)");
            Map beansOfType = map;
            if (beansOfType.isEmpty()) {
                throw new NoDataLoaderFoundException(loaderClass);
            }
            if (beansOfType.size() > 1) {
                Class[] classArray = new Class[]{loaderClass};
                throw new MultipleDataLoadersDefinedException(classArray);
            }
            Object object = CollectionsKt.first((Iterable)beansOfType.keySet());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            String beanName = (String)object;
            BeanDefinition beanDefinition = ((ConfigurableApplicationContext)this.ctx).getBeanFactory().getBeanDefinition(beanName);
            Intrinsics.checkNotNullExpressionValue((Object)beanDefinition, (String)"getBeanDefinition(...)");
            BeanDefinition beanDefinition2 = beanDefinition;
            if (beanDefinition2.getSource() instanceof StandardMethodMetadata) {
                Object object2 = beanDefinition2.getSource();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.springframework.core.type.StandardMethodMetadata");
                StandardMethodMetadata methodMetadata = (StandardMethodMetadata)object2;
                Method method = methodMetadata.getIntrospectedMethod();
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getIntrospectedMethod(...)");
                Method method2 = method;
                DgsDataLoader methodAnnotation = method2.getAnnotation(DgsDataLoader.class);
                Intrinsics.checkNotNull((Object)methodAnnotation);
                name = DataLoaderNameUtil.INSTANCE.getDataLoaderName(loaderClass, methodAnnotation);
            }
        }
        String string = name;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isNestedArgumentSet(@NotNull String path) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] stringArray = new String[]{".", "->"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)path, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void s;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)s))).toString());
        }
        List pathParts = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = pathParts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        return this.isArgumentSet(Arrays.copyOf(stringArray, stringArray.length));
    }

    public final boolean isArgumentSet(String ... path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.isArgumentSet((Sequence<String>)ArraysKt.asSequence((Object[])path));
    }

    private final boolean isArgumentSet(Sequence<String> keys) {
        Map map = this.dfe.getExecutionStepInfo().getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        Map args = map;
        Object value = null;
        for (String key : keys) {
            if (!args.containsKey(key)) {
                return false;
            }
            value = args.get(key);
            if (!(value instanceof Map)) {
                return true;
            }
            args = value;
        }
        return true;
    }

    @Nullable
    public <T> T getSource() {
        return (T)this.dfe.getSource();
    }

    @NotNull
    public Map<String, Object> getArguments() {
        Map map = this.dfe.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getArguments(...)");
        return map;
    }

    public boolean containsArgument(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.dfe.containsArgument(name);
    }

    @Nullable
    public <T> T getArgument(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (T)this.dfe.getArgument(name);
    }

    @NotNull
    public <T> T getArgumentOrDefault(@NotNull String name, @NotNull T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Object object = this.dfe.getArgumentOrDefault(name, defaultValue);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getArgumentOrDefault(...)");
        return (T)object;
    }

    @Deprecated(message="Deprecated in Java")
    @Nullable
    public <T> T getContext() {
        return (T)this.dfe.getContext();
    }

    @NotNull
    public GraphQLContext getGraphQlContext() {
        GraphQLContext graphQLContext = this.dfe.getGraphQlContext();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLContext, (String)"getGraphQlContext(...)");
        return graphQLContext;
    }

    @Nullable
    public <T> T getLocalContext() {
        return (T)this.dfe.getLocalContext();
    }

    @Nullable
    public <T> T getRoot() {
        return (T)this.dfe.getRoot();
    }

    @NotNull
    public GraphQLFieldDefinition getFieldDefinition() {
        GraphQLFieldDefinition graphQLFieldDefinition = this.dfe.getFieldDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLFieldDefinition, (String)"getFieldDefinition(...)");
        return graphQLFieldDefinition;
    }

    @Deprecated(message="Deprecated in Java")
    @NotNull
    public List<graphql.language.Field> getFields() {
        List list = this.dfe.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFields(...)");
        return list;
    }

    @NotNull
    public MergedField getMergedField() {
        MergedField mergedField = this.dfe.getMergedField();
        Intrinsics.checkNotNullExpressionValue((Object)mergedField, (String)"getMergedField(...)");
        return mergedField;
    }

    @NotNull
    public graphql.language.Field getField() {
        graphql.language.Field field = this.dfe.getField();
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"getField(...)");
        return field;
    }

    @NotNull
    public GraphQLOutputType getFieldType() {
        GraphQLOutputType graphQLOutputType = this.dfe.getFieldType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLOutputType, (String)"getFieldType(...)");
        return graphQLOutputType;
    }

    @NotNull
    public ExecutionStepInfo getExecutionStepInfo() {
        ExecutionStepInfo executionStepInfo = this.dfe.getExecutionStepInfo();
        Intrinsics.checkNotNullExpressionValue((Object)executionStepInfo, (String)"getExecutionStepInfo(...)");
        return executionStepInfo;
    }

    @NotNull
    public GraphQLType getParentType() {
        GraphQLType graphQLType = this.dfe.getParentType();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLType, (String)"getParentType(...)");
        return graphQLType;
    }

    @NotNull
    public GraphQLSchema getGraphQLSchema() {
        GraphQLSchema graphQLSchema = this.dfe.getGraphQLSchema();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema, (String)"getGraphQLSchema(...)");
        return graphQLSchema;
    }

    @NotNull
    public Map<String, FragmentDefinition> getFragmentsByName() {
        Map map = this.dfe.getFragmentsByName();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getFragmentsByName(...)");
        return map;
    }

    @NotNull
    public ExecutionId getExecutionId() {
        ExecutionId executionId = this.dfe.getExecutionId();
        Intrinsics.checkNotNullExpressionValue((Object)executionId, (String)"getExecutionId(...)");
        return executionId;
    }

    @NotNull
    public DataFetchingFieldSelectionSet getSelectionSet() {
        DataFetchingFieldSelectionSet dataFetchingFieldSelectionSet = this.dfe.getSelectionSet();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetchingFieldSelectionSet, (String)"getSelectionSet(...)");
        return dataFetchingFieldSelectionSet;
    }

    @NotNull
    public QueryDirectives getQueryDirectives() {
        QueryDirectives queryDirectives = this.dfe.getQueryDirectives();
        Intrinsics.checkNotNullExpressionValue((Object)queryDirectives, (String)"getQueryDirectives(...)");
        return queryDirectives;
    }

    @Nullable
    public <K, V> DataLoader<K, V> getDataLoader(@NotNull String dataLoaderName) {
        Intrinsics.checkNotNullParameter((Object)dataLoaderName, (String)"dataLoaderName");
        return this.dfe.getDataLoader(dataLoaderName);
    }

    @NotNull
    public DataLoaderRegistry getDataLoaderRegistry() {
        DataLoaderRegistry dataLoaderRegistry = this.dfe.getDataLoaderRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)dataLoaderRegistry, (String)"getDataLoaderRegistry(...)");
        return dataLoaderRegistry;
    }

    @NotNull
    public Locale getLocale() {
        Locale locale = this.dfe.getLocale();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocale(...)");
        return locale;
    }

    @NotNull
    public OperationDefinition getOperationDefinition() {
        OperationDefinition operationDefinition = this.dfe.getOperationDefinition();
        Intrinsics.checkNotNullExpressionValue((Object)operationDefinition, (String)"getOperationDefinition(...)");
        return operationDefinition;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.dfe.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return document;
    }

    @NotNull
    public Map<String, Object> getVariables() {
        Map map = this.dfe.getVariables();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getVariables(...)");
        return map;
    }
}

