/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.subscriptions.graphql.sse;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.types.subscription.Error;
import com.netflix.graphql.types.subscription.QueryPayload;
import com.netflix.graphql.types.subscription.SSEDataPayload;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.language.Document;
import graphql.language.OperationDefinition;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.validation.ValidationError;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerErrorException;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

@RestController
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001e\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\b\b\u0001\u0010\u0013\u001a\u00020\u000eH\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/graphql/sse/DgsGraphQLSSESubscriptionHandler;", "", "dgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "pollPeriod", "", "(Lcom/netflix/graphql/dgs/DgsQueryExecutor;J)V", "getDgsQueryExecutor", "()Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "getPollPeriod", "()J", "handleSubscription", "Lreactor/core/publisher/Flux;", "Lorg/springframework/http/codec/ServerSentEvent;", "", "query", "isSubscriptionQuery", "", "subscriptionFromPost", "body", "Companion", "graphql-dgs-subscriptions-graphql-sse"})
public class DgsGraphQLSSESubscriptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsQueryExecutor dgsQueryExecutor;
    private final long pollPeriod;
    @NotNull
    private static final ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
    @NotNull
    private static final Logger logger;

    public DgsGraphQLSSESubscriptionHandler(@NotNull DgsQueryExecutor dgsQueryExecutor, @Value(value="${dgs.graphql.sse.pollPeriod:12000}") long pollPeriod) {
        Intrinsics.checkNotNullParameter((Object)dgsQueryExecutor, (String)"dgsQueryExecutor");
        this.dgsQueryExecutor = dgsQueryExecutor;
        this.pollPeriod = pollPeriod;
    }

    @NotNull
    public DgsQueryExecutor getDgsQueryExecutor() {
        return this.dgsQueryExecutor;
    }

    public long getPollPeriod() {
        return this.pollPeriod;
    }

    @PostMapping(value={"${dgs.graphql.sse.path:/subscriptions}"}, produces={"text/event-stream"})
    @NotNull
    public final Flux<ServerSentEvent<String>> subscriptionFromPost(@RequestBody @NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return this.handleSubscription(body);
    }

    private final Flux<ServerSentEvent<String>> handleSubscription(String query) {
        Publisher $this$any$iv2;
        QueryPayload queryPayload;
        try {
            queryPayload = (QueryPayload)mapper.readValue(query, QueryPayload.class);
        }
        catch (Exception ex) {
            throw new ServerWebInputException("Error parsing query: " + ex.getMessage());
        }
        QueryPayload queryPayload2 = queryPayload;
        if (!this.isSubscriptionQuery(queryPayload2.getQuery())) {
            throw new ServerWebInputException("Invalid query. operation type is not a subscription");
        }
        DgsQueryExecutor dgsQueryExecutor = this.getDgsQueryExecutor();
        String string = queryPayload2.getQuery();
        Map map = queryPayload2.getVariables();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        ExecutionResult executionResult = dgsQueryExecutor.execute(string, map);
        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"dgsQueryExecutor.execute\u2026load.variables.orEmpty())");
        ExecutionResult executionResult2 = executionResult;
        List list = executionResult2.getErrors();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"executionResult.errors");
        if (!((Collection)list).isEmpty()) {
            String string2;
            boolean bl;
            block13: {
                List list2 = executionResult2.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"executionResult.errors");
                Iterable $this$any$iv2 = list2;
                boolean $i$f$any = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        GraphQLError error = (GraphQLError)element$iv;
                        boolean bl2 = false;
                        if (!(error instanceof ValidationError || error instanceof InvalidSyntaxError)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                List list3 = executionResult2.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"executionResult.errors");
                string2 = "Subscription query failed to validate: " + CollectionsKt.joinToString$default((Iterable)list3, null, null, null, (int)0, null, null, (int)63, null);
            } else {
                List list4 = executionResult2.getErrors();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"executionResult.errors");
                string2 = "Error executing subscription query: " + CollectionsKt.joinToString$default((Iterable)list4, null, null, null, (int)0, null, null, (int)63, null);
            }
            String errorMessage = string2;
            logger.error(errorMessage);
            throw new ServerWebInputException(errorMessage);
        }
        try {
            $this$any$iv2 = (Publisher)executionResult2.getData();
        }
        catch (ClassCastException exc) {
            logger.error("Invalid return type for subscription datafetcher. A subscription datafetcher must return a Publisher<ExecutionResult>. The query was {}", (Object)query, (Object)exc);
            throw new ServerErrorException("Invalid return type for subscription datafetcher. Was a non-subscription query send to the subscription endpoint?", (Throwable)exc);
        }
        Publisher publisher = $this$any$iv2;
        String string3 = Intrinsics.areEqual((Object)queryPayload2.getKey(), (Object)"") ? UUID.randomUUID().toString() : queryPayload2.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"if (queryPayload.key == \u2026ueryPayload.key\n        }");
        String subscriptionId = string3;
        Flux resultPublisher2 = Flux.from((Publisher)publisher).map(arg_0 -> DgsGraphQLSSESubscriptionHandler.handleSubscription$lambda$1((Function1)new Function1<ExecutionResult, ServerSentEvent<String>>(subscriptionId){
            final /* synthetic */ String $subscriptionId;
            {
                this.$subscriptionId = $subscriptionId;
                super(1);
            }

            public final ServerSentEvent<String> invoke(ExecutionResult it) {
                SSEDataPayload payload = new SSEDataPayload(it.getData(), it.getErrors(), this.$subscriptionId, null, 8, null);
                return ServerSentEvent.builder((Object)DgsGraphQLSSESubscriptionHandler.access$getMapper$cp().writeValueAsString((Object)payload)).id(UUID.randomUUID().toString()).event("next").build();
            }
        }, arg_0)).onErrorResume(arg_0 -> DgsGraphQLSSESubscriptionHandler.handleSubscription$lambda$2((Function1)new Function1<Throwable, Publisher<? extends ServerSentEvent<String>>>(subscriptionId){
            final /* synthetic */ String $subscriptionId;
            {
                this.$subscriptionId = $subscriptionId;
                super(1);
            }

            public final Publisher<? extends ServerSentEvent<String>> invoke(Throwable exc) {
                DgsGraphQLSSESubscriptionHandler.access$getLogger$cp().warn("An exception occurred on subscription {}", (Object)this.$subscriptionId, (Object)exc);
                String string = exc.getMessage();
                if (string == null) {
                    string = "An exception occurred";
                }
                String errorMessage = string;
                SSEDataPayload payload = new SSEDataPayload(null, CollectionsKt.listOf((Object)new Error(errorMessage)), this.$subscriptionId, null, 8, null);
                return (Publisher)Flux.just((Object)ServerSentEvent.builder((Object)DgsGraphQLSSESubscriptionHandler.access$getMapper$cp().writeValueAsString((Object)payload)).id(UUID.randomUUID().toString()).event("next").build());
            }
        }, arg_0));
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        List disposables = new ArrayList();
        Disposable dis2 = resultPublisher2.map(arg_0 -> DgsGraphQLSSESubscriptionHandler.handleSubscription$lambda$3((Function1)new Function1<ServerSentEvent<String>, Sinks.EmitResult>((Sinks.Many<ServerSentEvent<String>>)sink){
            final /* synthetic */ Sinks.Many<ServerSentEvent<String>> $sink;
            {
                this.$sink = $sink;
                super(1);
            }

            public final Sinks.EmitResult invoke(ServerSentEvent<String> it) {
                return this.$sink.tryEmitNext(it);
            }
        }, arg_0)).doFinally(arg_0 -> DgsGraphQLSSESubscriptionHandler.handleSubscription$lambda$4(sink, arg_0)).subscribeOn(Schedulers.boundedElastic()).subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)dis2, (String)"dis");
        disposables.add(dis2);
        if ((int)this.getPollPeriod() != 0) {
            Disposable pollDis2 = Flux.interval((Duration)Duration.ZERO, (Duration)Duration.ofMillis(this.getPollPeriod())).map(arg_0 -> DgsGraphQLSSESubscriptionHandler.handleSubscription$lambda$5((Function1)new Function1<Long, Sinks.EmitResult>((Sinks.Many<ServerSentEvent<String>>)sink){
                final /* synthetic */ Sinks.Many<ServerSentEvent<String>> $sink;
                {
                    this.$sink = $sink;
                    super(1);
                }

                public final Sinks.EmitResult invoke(Long it) {
                    return this.$sink.tryEmitNext((Object)ServerSentEvent.builder().comment("").build());
                }
            }, arg_0)).subscribeOn(Schedulers.boundedElastic()).subscribe();
            Intrinsics.checkNotNullExpressionValue((Object)pollDis2, (String)"pollDis");
            disposables.add(pollDis2);
        }
        Flux flux = sink.asFlux().doFinally(arg_0 -> DgsGraphQLSSESubscriptionHandler.handleSubscription$lambda$6(disposables, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"sink.asFlux().doFinally \u2026sable::dispose)\n        }");
        return flux;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSubscriptionQuery(String query) {
        boolean bl;
        Document document;
        try {
            document = new Parser().parseDocument(query);
        }
        catch (InvalidSyntaxException exc) {
            return false;
        }
        Document document2 = document;
        List definitions = document2.getDefinitionsOfType(OperationDefinition.class);
        Intrinsics.checkNotNullExpressionValue((Object)definitions, (String)"definitions");
        if (((Collection)definitions).isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = definitions;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            OperationDefinition def = (OperationDefinition)element$iv;
            boolean bl3 = false;
            if (def.getOperation() != OperationDefinition.Operation.SUBSCRIPTION) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private static final ServerSentEvent handleSubscription$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ServerSentEvent)$tmp0.invoke(p0);
    }

    private static final Publisher handleSubscription$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Sinks.EmitResult handleSubscription$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Sinks.EmitResult)$tmp0.invoke(p0);
    }

    private static final void handleSubscription$lambda$4(Sinks.Many $sink, SignalType it) {
        $sink.tryEmitNext((Object)ServerSentEvent.builder((Object)"").id(UUID.randomUUID().toString()).event("complete").build());
        $sink.tryEmitComplete();
    }

    private static final Sinks.EmitResult handleSubscription$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Sinks.EmitResult)$tmp0.invoke(p0);
    }

    private static final void handleSubscription$lambda$6(List $disposables, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)$disposables, (String)"$disposables");
        Iterable $this$forEach$iv = $disposables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable p0 = (Disposable)element$iv;
            boolean bl = false;
            p0.dispose();
        }
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$cp() {
        return mapper;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsGraphQLSSESubscriptionHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DgsGraphQLSSES\u2026ptionHandler::class.java)");
        DgsGraphQLSSESubscriptionHandler.logger = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/netflix/graphql/dgs/subscriptions/graphql/sse/DgsGraphQLSSESubscriptionHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "graphql-dgs-subscriptions-graphql-sse"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

