/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.webflux.autoconfiguration;

import com.netflix.graphql.dgs.webflux.autoconfiguration.DgsWebfluxConfigurationProperties;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.config.ResourceChainRegistration;
import org.springframework.web.reactive.config.ResourceHandlerRegistration;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.resource.PathResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.reactive.resource.TransformedResource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/GraphiQlConfigurer;", "Lorg/springframework/web/reactive/config/WebFluxConfigurer;", "configProps", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;", "(Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;)V", "addResourceHandlers", "", "registry", "Lorg/springframework/web/reactive/config/ResourceHandlerRegistry;", "TokenReplacingTransformer", "graphql-dgs-spring-webflux-autoconfigure"})
public final class GraphiQlConfigurer
implements WebFluxConfigurer {
    @NotNull
    private final DgsWebfluxConfigurationProperties configProps;

    public GraphiQlConfigurer(@NotNull DgsWebfluxConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        this.configProps = configProps;
    }

    public void addResourceHandlers(@NotNull ResourceHandlerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String graphqlPath = this.configProps.getPath();
        String graphiQLTitle = this.configProps.getGraphiql().getTitle();
        String[] stringArray = new String[]{this.configProps.getGraphiql().getPath() + "/**"};
        ResourceHandlerRegistration resourceHandlerRegistration = registry.addResourceHandler(stringArray);
        stringArray = new String[]{"classpath:/graphiql/"};
        ResourceChainRegistration resourceChainRegistration = resourceHandlerRegistration.addResourceLocations(stringArray).resourceChain(true).addResolver((ResourceResolver)new PathResourceResolver());
        stringArray = new Pair[]{TuplesKt.to((Object)"<DGS_GRAPHQL_PATH>", (Object)graphqlPath), TuplesKt.to((Object)"<DGS_GRAPHIQL_TITLE>", (Object)graphiQLTitle)};
        resourceChainRegistration.addTransformer((ResourceTransformer)new TokenReplacingTransformer(MapsKt.mapOf((Pair[])stringArray), this.configProps));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/dgs/webflux/autoconfiguration/GraphiQlConfigurer$TokenReplacingTransformer;", "Lorg/springframework/web/reactive/resource/ResourceTransformer;", "replaceMap", "", "", "configProps", "Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;", "(Ljava/util/Map;Lcom/netflix/graphql/dgs/webflux/autoconfiguration/DgsWebfluxConfigurationProperties;)V", "transform", "Lreactor/core/publisher/Mono;", "Lorg/springframework/core/io/Resource;", "exchange", "Lorg/springframework/web/server/ServerWebExchange;", "resource", "transformerChain", "Lorg/springframework/web/reactive/resource/ResourceTransformerChain;", "graphql-dgs-spring-webflux-autoconfigure"})
    public static final class TokenReplacingTransformer
    implements ResourceTransformer {
        @NotNull
        private final Map<String, String> replaceMap;
        @NotNull
        private final DgsWebfluxConfigurationProperties configProps;

        public TokenReplacingTransformer(@NotNull Map<String, String> replaceMap, @NotNull DgsWebfluxConfigurationProperties configProps) {
            Intrinsics.checkNotNullParameter(replaceMap, (String)"replaceMap");
            Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
            this.replaceMap = replaceMap;
            this.configProps = configProps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Mono<Resource> transform(@NotNull ServerWebExchange exchange, @NotNull Resource resource, @NotNull ResourceTransformerChain transformerChain) throws IOException {
            Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)transformerChain, (String)"transformerChain");
            String string = exchange.getRequest().getURI().toASCIIString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exchange.request.uri.toASCIIString()");
            if (StringsKt.endsWith$default((String)string, (String)(this.configProps.getGraphiql().getPath() + "/index.html"), (boolean)false, (int)2, null)) {
                Object content = null;
                InputStream inputStream = resource.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"resource.inputStream");
                Closeable closeable = inputStream;
                Object object = Charsets.UTF_8;
                Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                object = null;
                try {
                    BufferedReader p0 = (BufferedReader)closeable;
                    boolean bl = false;
                    object2 = TextStreamsKt.readText((Reader)p0);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                content = object2;
                Map<String, String> $this$forEach$iv = this.replaceMap;
                boolean $i$f$forEach = false;
                object2 = $this$forEach$iv.entrySet().iterator();
                while (object2.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> it = element$iv = object2.next();
                    boolean bl = false;
                    content = StringsKt.replace$default(content, (String)it.getKey(), (String)it.getValue(), (boolean)false, (int)4, null);
                }
                Iterator<Map.Entry<String, String>> iterator = content;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                object2 = charset;
                byte[] byArray = ((String)((Object)iterator)).getBytes((Charset)object2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                closeable = Mono.just((Object)new TransformedResource(resource, byArray));
                Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"just(\n                  \u2026      )\n                )");
                return closeable;
            }
            Mono mono = Mono.just((Object)resource);
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(resource)");
            return mono;
        }
    }
}

