/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.webflux;

import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.reactive.internal.DefaultDgsReactiveGraphQLContextBuilder;
import com.netflix.graphql.dgs.reactive.internal.DgsReactiveRequestData;
import graphql.ExecutionInput;
import graphql.GraphQLContext;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.web.filter.reactive.ServerWebExchangeContextFilter;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.util.context.ContextView;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/webflux/DgsWebFluxGraphQLInterceptor;", "Lorg/springframework/graphql/server/WebGraphQlInterceptor;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "dgsReactiveGraphQLContextBuilder", "Lcom/netflix/graphql/dgs/reactive/internal/DefaultDgsReactiveGraphQLContextBuilder;", "<init>", "(Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;Lcom/netflix/graphql/dgs/reactive/internal/DefaultDgsReactiveGraphQLContextBuilder;)V", "intercept", "Lreactor/core/publisher/Mono;", "Lorg/springframework/graphql/server/WebGraphQlResponse;", "request", "Lorg/springframework/graphql/server/WebGraphQlRequest;", "chain", "Lorg/springframework/graphql/server/WebGraphQlInterceptor$Chain;", "graphql-dgs-spring-graphql"})
public final class DgsWebFluxGraphQLInterceptor
implements WebGraphQlInterceptor {
    @NotNull
    private final DgsDataLoaderProvider dgsDataLoaderProvider;
    @NotNull
    private final DefaultDgsReactiveGraphQLContextBuilder dgsReactiveGraphQLContextBuilder;

    public DgsWebFluxGraphQLInterceptor(@NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsReactiveGraphQLContextBuilder dgsReactiveGraphQLContextBuilder) {
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter((Object)dgsReactiveGraphQLContextBuilder, (String)"dgsReactiveGraphQLContextBuilder");
        this.dgsDataLoaderProvider = dgsDataLoaderProvider;
        this.dgsReactiveGraphQLContextBuilder = dgsReactiveGraphQLContextBuilder;
    }

    @NotNull
    public Mono<WebGraphQlResponse> intercept(@NotNull WebGraphQlRequest request, @NotNull WebGraphQlInterceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Mono mono = Mono.deferContextual(arg_0 -> DgsWebFluxGraphQLInterceptor.intercept$lambda$0(this, request, arg_0)).flatMap(arg_0 -> DgsWebFluxGraphQLInterceptor.intercept$lambda$2(arg_0 -> DgsWebFluxGraphQLInterceptor.intercept$lambda$1(request, chain, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    private static final Mono intercept$lambda$0(DgsWebFluxGraphQLInterceptor this$0, WebGraphQlRequest $request, ContextView ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object t = ServerWebExchangeContextFilter.getExchange((ContextView)ctx).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        ServerWebExchange webExchange = (ServerWebExchange)t;
        ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)webExchange, (List)CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)serverRequest, (String)"create(...)");
        ServerRequest serverRequest2 = serverRequest;
        return this$0.dgsReactiveGraphQLContextBuilder.build(new DgsReactiveRequestData($request.getExtensions(), $request.getHeaders(), serverRequest2));
    }

    private static final Mono intercept$lambda$1(WebGraphQlRequest $request, WebGraphQlInterceptor.Chain $chain, DgsWebFluxGraphQLInterceptor this$0, DgsContext dgsContext) {
        Intrinsics.checkNotNullParameter((Object)dgsContext, (String)"dgsContext");
        Ref.ObjectRef dataLoaderRegistry = new Ref.ObjectRef();
        $request.configureExecutionInput((arg_0, arg_1) -> DgsWebFluxGraphQLInterceptor.intercept$lambda$1$0(dataLoaderRegistry, this$0, dgsContext, arg_0, arg_1));
        return $chain.next($request).doFinally(arg_0 -> DgsWebFluxGraphQLInterceptor.intercept$lambda$1$1(dataLoaderRegistry, arg_0));
    }

    private static final ExecutionInput intercept$lambda$1$0(Ref.ObjectRef $dataLoaderRegistry, DgsWebFluxGraphQLInterceptor this$0, DgsContext $dgsContext, ExecutionInput e, ExecutionInput.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        $dataLoaderRegistry.element = this$0.dgsDataLoaderProvider.buildRegistryWithContextSupplier(() -> DgsWebFluxGraphQLInterceptor.intercept$lambda$1$0$0(e));
        return builder.graphQLContext((Consumer)$dgsContext).dataLoaderRegistry((DataLoaderRegistry)$dataLoaderRegistry.element).build();
    }

    private static final GraphQLContext intercept$lambda$1$0$0(ExecutionInput $e) {
        return $e.getGraphQLContext();
    }

    private static final void intercept$lambda$1$1(Ref.ObjectRef $dataLoaderRegistry, SignalType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($dataLoaderRegistry.element instanceof AutoCloseable) {
            Object object = $dataLoaderRegistry.element;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.lang.AutoCloseable");
            ((AutoCloseable)object).close();
        }
    }

    private static final Mono intercept$lambda$2(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }
}

