/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.conditions;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/conditions/OnDgsReloadCondition;", "Lorg/springframework/boot/autoconfigure/condition/SpringBootCondition;", "<init>", "()V", "getMatchOutcome", "Lorg/springframework/boot/autoconfigure/condition/ConditionOutcome;", "context", "Lorg/springframework/context/annotation/ConditionContext;", "metadata", "Lorg/springframework/core/type/AnnotatedTypeMetadata;", "Companion", "graphql-dgs-spring-graphql"})
public final class OnDgsReloadCondition
extends SpringBootCondition {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ConditionOutcome getMatchOutcome(@NotNull ConditionContext context, @NotNull AnnotatedTypeMetadata metadata) {
        ConditionOutcome conditionOutcome;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Environment environment = context.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)environment, (String)"getEnvironment(...)");
        Environment environment2 = environment;
        boolean reloadEnabled = Companion.evaluate(environment2);
        if (reloadEnabled) {
            ConditionOutcome conditionOutcome2 = ConditionOutcome.match((String)"DgsReload enabled.");
            Intrinsics.checkNotNull((Object)conditionOutcome2);
            conditionOutcome = conditionOutcome2;
        } else {
            ConditionOutcome conditionOutcome3 = ConditionOutcome.noMatch((String)"DgsReload disabled");
            Intrinsics.checkNotNull((Object)conditionOutcome3);
            conditionOutcome = conditionOutcome3;
        }
        return conditionOutcome;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/conditions/OnDgsReloadCondition$Companion;", "", "<init>", "()V", "evaluate", "", "environment", "Lorg/springframework/core/env/Environment;", "graphql-dgs-spring-graphql"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean evaluate(@NotNull Environment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            String[] stringArray = environment.getActiveProfiles();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
            boolean isLaptopProfile = ArraysKt.contains((Object[])stringArray, (Object)"laptop");
            Object object = environment.getProperty("dgs.reload", Boolean.TYPE, (Object)isLaptopProfile);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProperty(...)");
            boolean reloadEnabled = (Boolean)object;
            return reloadEnabled;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

