/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.autoconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.EnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@Order(value=0x7FFFFFFE)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/ExcludeAutoConfigurationsEnvironmentPostProcessor;", "Lorg/springframework/boot/EnvironmentPostProcessor;", "<init>", "()V", "postProcessEnvironment", "", "environment", "Lorg/springframework/core/env/ConfigurableEnvironment;", "application", "Lorg/springframework/boot/SpringApplication;", "extractAllExcludes", "", "propertySources", "Lorg/springframework/core/env/MutablePropertySources;", "Companion", "graphql-dgs-spring-graphql"})
@SourceDebugExtension(value={"SMAP\nExcludeAutoConfigurationsEnvironmentPostProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExcludeAutoConfigurationsEnvironmentPostProcessor.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/ExcludeAutoConfigurationsEnvironmentPostProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,97:1\n1#2:98\n774#3:99\n865#3,2:100\n774#3:113\n865#3,2:114\n4225#4,11:102\n*S KotlinDebug\n*F\n+ 1 ExcludeAutoConfigurationsEnvironmentPostProcessor.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/ExcludeAutoConfigurationsEnvironmentPostProcessor\n*L\n73#1:99\n73#1:100,2\n74#1:113\n74#1:114,2\n74#1:102,11\n*E\n"})
public final class ExcludeAutoConfigurationsEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, String> DISABLE_AUTOCONFIG_PROPERTIES;
    @NotNull
    private static final String EXCLUDE = "spring.autoconfigure.exclude";
    @NotNull
    private static final String INLINED_TEST_PROPERTIES = "Inlined Test Properties";

    public void postProcessEnvironment(@NotNull ConfigurableEnvironment environment, @NotNull SpringApplication application) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        Intrinsics.checkNotNullExpressionValue((Object)mutablePropertySources, (String)"getPropertySources(...)");
        String existingExcludes = this.extractAllExcludes(mutablePropertySources);
        String disabled = SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.plus((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence(DISABLE_AUTOCONFIG_PROPERTIES), arg_0 -> ExcludeAutoConfigurationsEnvironmentPostProcessor.postProcessEnvironment$lambda$0(environment, arg_0)), ExcludeAutoConfigurationsEnvironmentPostProcessor::postProcessEnvironment$lambda$1), (Object)existingExcludes), ExcludeAutoConfigurationsEnvironmentPostProcessor::postProcessEnvironment$lambda$2), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("disableRefreshScope", Collections.singletonMap(EXCLUDE, disabled)));
    }

    private final String extractAllExcludes(MutablePropertySources propertySources) {
        Object testExclude;
        Object v0;
        block2: {
            Iterable iterable = (Iterable)propertySources;
            for (Object t : iterable) {
                PropertySource it = (PropertySource)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)INLINED_TEST_PROPERTIES)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        PropertySource propertySource = v0;
        Object object = testExclude = propertySource != null ? propertySource.getProperty(EXCLUDE) : null;
        if (testExclude != null && testExclude instanceof String && !StringsKt.isBlank((CharSequence)((CharSequence)testExclude))) {
            return (String)testExclude;
        }
        String string = propertySources.stream().filter(arg_0 -> ExcludeAutoConfigurationsEnvironmentPostProcessor.extractAllExcludes$lambda$2(ExcludeAutoConfigurationsEnvironmentPostProcessor::extractAllExcludes$lambda$1, arg_0)).flatMap(arg_0 -> ExcludeAutoConfigurationsEnvironmentPostProcessor.extractAllExcludes$lambda$4(ExcludeAutoConfigurationsEnvironmentPostProcessor::extractAllExcludes$lambda$3, arg_0)).collect(Collectors.joining(","));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collect(...)");
        return string;
    }

    private static final boolean postProcessEnvironment$lambda$0(ConfigurableEnvironment $environment, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)$environment.getProperty((String)it.getKey(), Boolean.TYPE, (Object)false) == false;
    }

    private static final String postProcessEnvironment$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getValue();
    }

    private static final boolean postProcessEnvironment$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    private static final boolean extractAllExcludes$lambda$1(PropertySource src) {
        return !ConfigurationPropertySources.isAttachedConfigurationPropertySource((PropertySource)src);
    }

    private static final boolean extractAllExcludes$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Stream extractAllExcludes$lambda$3(PropertySource src) {
        Stream stream;
        Object property = src.getProperty(EXCLUDE);
        Object object = property;
        if (object instanceof String) {
            void $this$filterTo$iv$iv;
            String[] stringArray = new String[]{","};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)((CharSequence)property), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                String it = (String)t;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(t);
            }
            stream = ((List)destination$iv$iv).stream();
        } else if (object instanceof Object[]) {
            Iterable $this$filterIsInstanceTo$iv$iv;
            Object[] $this$filterIsInstance$iv = (Object[])property;
            boolean $i$f$filterIsInstance = false;
            Object[] $this$filterTo$iv$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof String)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                String it = (String)t;
                boolean bl = false;
                boolean bl3 = !StringsKt.isBlank((CharSequence)it);
                if (!bl3) continue;
                destination$iv$iv.add(t);
            }
            stream = ((List)destination$iv$iv).stream();
        } else {
            stream = CollectionsKt.emptyList().stream();
        }
        return stream;
    }

    private static final Stream extractAllExcludes$lambda$4(Function1 $tmp0, Object p0) {
        return (Stream)$tmp0.invoke(p0);
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair((Object)"dgs.springgraphql.autoconfiguration.graphqlobservation.enabled", (Object)"org.springframework.boot.graphql.autoconfigure.observation.GraphQlObservationAutoConfiguration"), new Pair((Object)"dgs.springgraphql.autoconfiguration.graphqlwebmvcsecurity.enabled", (Object)"org.springframework.boot.graphql.autoconfigure.security.GraphQlWebMvcSecurityAutoConfiguration")};
        DISABLE_AUTOCONFIG_PROPERTIES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/ExcludeAutoConfigurationsEnvironmentPostProcessor$Companion;", "", "<init>", "()V", "DISABLE_AUTOCONFIG_PROPERTIES", "", "", "EXCLUDE", "INLINED_TEST_PROPERTIES", "graphql-dgs-spring-graphql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

