/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql.autoconfig;

import com.netflix.graphql.dgs.DataLoaderInstrumentationExtensionProvider;
import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsDataLoaderCustomizer;
import com.netflix.graphql.dgs.DgsDataLoaderInstrumentation;
import com.netflix.graphql.dgs.DgsDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.DgsDataLoaderReloadController;
import com.netflix.graphql.dgs.DgsDefaultPreparsedDocumentProvider;
import com.netflix.graphql.dgs.DgsExecutionResult;
import com.netflix.graphql.dgs.DgsFederationResolver;
import com.netflix.graphql.dgs.DgsQueryExecutor;
import com.netflix.graphql.dgs.DgsRuntimeWiring;
import com.netflix.graphql.dgs.DgsTypeDefinitionRegistry;
import com.netflix.graphql.dgs.ReloadSchemaIndicator;
import com.netflix.graphql.dgs.autoconfig.DgsConfigurationProperties;
import com.netflix.graphql.dgs.autoconfig.DgsDataloaderConfigurationProperties;
import com.netflix.graphql.dgs.autoconfig.DgsInputArgumentConfiguration;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilder;
import com.netflix.graphql.dgs.context.DgsCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.context.GraphQLContextContributor;
import com.netflix.graphql.dgs.context.GraphQLContextContributorInstrumentation;
import com.netflix.graphql.dgs.exceptions.DefaultDataFetcherExceptionHandler;
import com.netflix.graphql.dgs.internal.DataFetcherReference;
import com.netflix.graphql.dgs.internal.DataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.DefaultDataLoaderOptionsProvider;
import com.netflix.graphql.dgs.internal.DefaultDgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DefaultDgsDataLoaderReloadController;
import com.netflix.graphql.dgs.internal.DefaultDgsGraphQLContextBuilder;
import com.netflix.graphql.dgs.internal.DgsDataLoaderInstrumentationDataLoaderCustomizer;
import com.netflix.graphql.dgs.internal.DgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.DgsQueryExecutorRequestCustomizer;
import com.netflix.graphql.dgs.internal.DgsRequestData;
import com.netflix.graphql.dgs.internal.DgsSchemaProvider;
import com.netflix.graphql.dgs.internal.DgsWrapWithContextDataLoaderCustomizer;
import com.netflix.graphql.dgs.internal.EntityFetcherRegistry;
import com.netflix.graphql.dgs.internal.FlowDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.FluxDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.GraphQLJavaErrorInstrumentation;
import com.netflix.graphql.dgs.internal.MonoDataFetcherResultProcessor;
import com.netflix.graphql.dgs.internal.QueryValueCustomizer;
import com.netflix.graphql.dgs.internal.ReloadableDgsDataLoaderProvider;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import com.netflix.graphql.dgs.internal.method.MethodDataFetcherFactory;
import com.netflix.graphql.dgs.mvc.internal.method.HandlerMethodArgumentResolverAdapter;
import com.netflix.graphql.dgs.reactive.DgsReactiveCustomContextBuilderWithRequest;
import com.netflix.graphql.dgs.reactive.DgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.reactive.internal.DefaultDgsReactiveGraphQLContextBuilder;
import com.netflix.graphql.dgs.reactive.internal.method.SyncHandlerMethodArgumentResolverAdapter;
import com.netflix.graphql.dgs.springgraphql.DgsGraphQLSourceBuilder;
import com.netflix.graphql.dgs.springgraphql.ReloadableGraphQLSource;
import com.netflix.graphql.dgs.springgraphql.SpringGraphQLDgsQueryExecutor;
import com.netflix.graphql.dgs.springgraphql.SpringGraphQLDgsReactiveQueryExecutor;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsSpringGraphQLAutoConfiguration;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsSpringGraphQLConfigurationProperties;
import com.netflix.graphql.dgs.springgraphql.autoconfig.ExceptionHandlerResolverAdapter;
import com.netflix.graphql.dgs.springgraphql.conditions.ConditionalOnDgsReload;
import com.netflix.graphql.dgs.springgraphql.conditions.OnDgsReloadCondition;
import com.netflix.graphql.dgs.springgraphql.webflux.DgsWebFluxGraphQLInterceptor;
import com.netflix.graphql.dgs.springgraphql.webmvc.DgsWebMvcGraphQLInterceptor;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLContext;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactory;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ContextSnapshotFactory;
import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.context.integration.Slf4jThreadLocalAccessor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.graphql.autoconfigure.GraphQlProperties;
import org.springframework.boot.graphql.autoconfigure.GraphQlSourceBuilderCustomizer;
import org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration;
import org.springframework.boot.system.JavaVersion;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.support.ContextPropagatingTaskDecorator;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.execution.ConnectionTypeDefinitionConfigurer;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.graphql.execution.SchemaReport;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.filter.reactive.ServerWebExchangeContextFilter;
import org.springframework.web.method.annotation.RequestHeaderMapMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestHeaderMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.CookieValueMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ServletCookieValueMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.ServletRequestDataBinderFactory;
import reactor.core.publisher.Mono;

@AutoConfiguration(beforeName={"org.springframework.boot.graphql.autoconfigure.GraphQlAutoConfiguration"}, afterName={"org.springframework.boot.autoconfigure.task.TaskSchedulingAutoConfiguration"})
@EnableConfigurationProperties(value={DgsSpringGraphQLConfigurationProperties.class, DgsConfigurationProperties.class, DgsDataloaderConfigurationProperties.class})
@ImportAutoConfiguration(classes={JacksonAutoConfiguration.class, DgsInputArgumentConfiguration.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 u2\u00020\u0001:\tuvwxyz{|}B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0017J\b\u0010\r\u001a\u00020\tH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0017J\b\u0010\u0012\u001a\u00020\u0013H\u0017J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0017J>\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u0019H\u0017J\b\u0010$\u001a\u00020%H\u0017J\b\u0010&\u001a\u00020'H\u0017J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u0003H\u0017J,\u0010*\u001a\u00020+2\u0010\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030.0-2\u0010\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003000-H\u0017J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0017J\u0088\u0001\u00105\u001a\u0002062\u0006\u0010\u001d\u001a\u00020\u001e2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080-2\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0-2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0-2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u00192\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020'0-2\u0006\u0010$\u001a\u00020%2\u0012\b\u0002\u0010?\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030@0-2\u0006\u0010A\u001a\u00020B2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010DH\u0017J~\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u00105\u001a\u0002062\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J0\u000b2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020L0\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020N0\u000b2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u000b2\u0006\u0010Q\u001a\u0002022\u0006\u0010R\u001a\u00020'2\u000e\u0010S\u001a\n\u0012\u0004\u0012\u00020U\u0018\u00010TH\u0017J\b\u0010V\u001a\u00020WH\u0017J\b\u0010X\u001a\u00020YH\u0017J\b\u0010Z\u001a\u00020[H\u0017J\b\u0010\\\u001a\u00020]H\u0017J&\u0010A\u001a\u00020B2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020_0\u000b2\u000e\b\u0001\u0010`\u001a\b\u0012\u0004\u0012\u00020]0-H\u0017J\b\u0010a\u001a\u00020bH\u0017J\u0016\u0010c\u001a\u00020d2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020N0\u0019H\u0017J\u0010\u0010f\u001a\u00020g2\u0006\u00103\u001a\u000204H\u0017JF\u0010h\u001a\u00020P2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0-2\u000e\b\u0001\u0010i\u001a\b\u0012\u0004\u0012\u00020j0-2\u000e\b\u0001\u0010k\u001a\b\u0012\u0004\u0012\u00020j0-2\u0006\u0010&\u001a\u00020'2\u0006\u00103\u001a\u000204H\u0017J\b\u0010l\u001a\u00020\fH\u0017J<\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020p2\u0006\u0010q\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020b0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0017J\b\u0010s\u001a\u00020tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006~"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration;", "", "configProps", "Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;", "dataloaderConfigProps", "Lcom/netflix/graphql/dgs/autoconfig/DgsDataloaderConfigurationProperties;", "<init>", "(Lcom/netflix/graphql/dgs/autoconfig/DgsConfigurationProperties;Lcom/netflix/graphql/dgs/autoconfig/DgsDataloaderConfigurationProperties;)V", "graphQLContextContributionInstrumentation", "Lgraphql/execution/instrumentation/Instrumentation;", "graphQLContextContributors", "Lorg/springframework/beans/factory/ObjectProvider;", "Lcom/netflix/graphql/dgs/context/GraphQLContextContributor;", "graphqlJavaErrorInstrumentation", "defaultQueryValueCustomizer", "Lcom/netflix/graphql/dgs/internal/QueryValueCustomizer;", "dgsDataLoaderOptionsProvider", "Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;", "dgsScheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "dgsWrapWithContextDataLoaderCustomizer", "Lcom/netflix/graphql/dgs/internal/DgsWrapWithContextDataLoaderCustomizer;", "dgsDataLoaderInstrumentationDataLoaderCustomizer", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderInstrumentationDataLoaderCustomizer;", "instrumentations", "", "Lcom/netflix/graphql/dgs/DgsDataLoaderInstrumentation;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dataloaderOptionProvider", "extensionProviders", "Lcom/netflix/graphql/dgs/DataLoaderInstrumentationExtensionProvider;", "customizers", "Lcom/netflix/graphql/dgs/DgsDataLoaderCustomizer;", "entityFetcherRegistry", "Lcom/netflix/graphql/dgs/internal/EntityFetcherRegistry;", "dataFetcherExceptionHandler", "Lgraphql/execution/DataFetcherExceptionHandler;", "preparsedDocumentProvider", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "graphQLContextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "dgsCustomContextBuilder", "Ljava/util/Optional;", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilder;", "dgsCustomContextBuilderWithRequest", "Lcom/netflix/graphql/dgs/context/DgsCustomContextBuilderWithRequest;", "defaultReloadSchemaIndicator", "Lcom/netflix/graphql/dgs/ReloadSchemaIndicator;", "environment", "Lorg/springframework/core/env/Environment;", "dgsSchemaProvider", "Lcom/netflix/graphql/dgs/internal/DgsSchemaProvider;", "federationResolver", "Lcom/netflix/graphql/dgs/DgsFederationResolver;", "existingTypeDefinitionFactory", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "existingCodeRegistry", "Lgraphql/schema/GraphQLCodeRegistry;", "dataFetcherResultProcessors", "Lcom/netflix/graphql/dgs/internal/DataFetcherResultProcessor;", "defaultDataFetcherFactory", "Lgraphql/schema/DataFetcherFactory;", "methodDataFetcherFactory", "Lcom/netflix/graphql/dgs/internal/method/MethodDataFetcherFactory;", "fallbackTypeResolver", "Lgraphql/schema/TypeResolver;", "graphQlSource", "Lorg/springframework/graphql/execution/GraphQlSource;", "properties", "Lorg/springframework/boot/graphql/autoconfigure/GraphQlProperties;", "exceptionResolvers", "Lorg/springframework/graphql/execution/DataFetcherExceptionResolver;", "subscriptionExceptionResolvers", "Lorg/springframework/graphql/execution/SubscriptionExceptionResolver;", "wiringConfigurers", "Lorg/springframework/graphql/execution/RuntimeWiringConfigurer;", "sourceCustomizers", "Lorg/springframework/boot/graphql/autoconfigure/GraphQlSourceBuilderCustomizer;", "reloadSchemaIndicator", "defaultExceptionHandler", "reportConsumer", "Ljava/util/function/Consumer;", "Lorg/springframework/graphql/execution/SchemaReport;", "monoReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/MonoDataFetcherResultProcessor;", "flowReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/FlowDataFetcherResultProcessor;", "fluxReactiveDataFetcherResultProcessor", "Lcom/netflix/graphql/dgs/internal/FluxDataFetcherResultProcessor;", "virtualThreadsTaskExecutor", "Lorg/springframework/core/task/AsyncTaskExecutor;", "argumentResolvers", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "taskExecutorOptional", "mockRequestHeaderCustomizer", "Lcom/netflix/graphql/dgs/internal/DgsQueryExecutorRequestCustomizer;", "dgsRuntimeWiringConfigurerBridge", "Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsRuntimeWiringConfigurerBridge;", "configurers", "dgsTypeDefinitionConfigurerBridge", "Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsTypeDefinitionConfigurerBridge;", "sourceBuilderCustomizer", "providedQueryExecutionStrategy", "Lgraphql/execution/ExecutionStrategy;", "providedMutationExecutionStrategy", "disableIntrospectionContextContributor", "springGraphQLDgsQueryExecutor", "Lcom/netflix/graphql/dgs/DgsQueryExecutor;", "executionService", "Lorg/springframework/graphql/ExecutionGraphQlService;", "dgsContextBuilder", "requestCustomizer", "dgsHeadersInterceptor", "Lorg/springframework/graphql/server/WebGraphQlInterceptor;", "Companion", "DgsDataLoaderReloadAutoConfiguration", "DgsRuntimeWiringConfigurerBridge", "DgsTypeDefinitionConfigurerBridge", "WebMvcConfiguration", "WebMvcArgumentHandlerConfiguration", "ReactiveConfiguration", "WebFluxConfiguration", "WebFluxArgumentHandlerConfiguration", "graphql-dgs-spring-graphql"})
@SourceDebugExtension(value={"SMAP\nDgsSpringGraphQLAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsSpringGraphQLAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,845:1\n126#2:846\n153#2,3:847\n*S KotlinDebug\n*F\n+ 1 DgsSpringGraphQLAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration\n*L\n416#1:846\n416#1:847,3\n*E\n"})
public class DgsSpringGraphQLAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DgsConfigurationProperties configProps;
    @NotNull
    private final DgsDataloaderConfigurationProperties dataloaderConfigProps;
    @NotNull
    public static final String AUTO_CONF_PREFIX = "dgs.graphql";
    @NotNull
    private static final Logger LOG;

    public DgsSpringGraphQLAutoConfiguration(@NotNull DgsConfigurationProperties configProps, @NotNull DgsDataloaderConfigurationProperties dataloaderConfigProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        Intrinsics.checkNotNullParameter((Object)dataloaderConfigProps, (String)"dataloaderConfigProps");
        this.configProps = configProps;
        this.dataloaderConfigProps = dataloaderConfigProps;
    }

    @Bean
    @Order(value=-2147483648)
    @NotNull
    public Instrumentation graphQLContextContributionInstrumentation(@NotNull ObjectProvider<GraphQLContextContributor> graphQLContextContributors) {
        Intrinsics.checkNotNullParameter(graphQLContextContributors, (String)"graphQLContextContributors");
        List list = graphQLContextContributors.orderedStream().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return (Instrumentation)new GraphQLContextContributorInstrumentation(list);
    }

    @Bean
    @Order(value=0x7FFFFFFE)
    @ConditionalOnProperty(prefix="dgs.graphql.errors.classification", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public Instrumentation graphqlJavaErrorInstrumentation() {
        return (Instrumentation)new GraphQLJavaErrorInstrumentation();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public QueryValueCustomizer defaultQueryValueCustomizer() {
        return DgsSpringGraphQLAutoConfiguration::defaultQueryValueCustomizer$lambda$0;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsDataLoaderOptionsProvider dgsDataLoaderOptionsProvider() {
        return (DgsDataLoaderOptionsProvider)new DefaultDataLoaderOptionsProvider();
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(name={"dgsScheduledExecutorService"})
    @Qualifier(value="dgsScheduledExecutorService")
    @NotNull
    public ScheduledExecutorService dgsScheduledExecutorService() {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        return scheduledExecutorService;
    }

    @Bean
    @ConditionalOnProperty(prefix="dgs.graphql.convertAllDataLoadersToWithContext", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Order(value=0)
    @NotNull
    public DgsWrapWithContextDataLoaderCustomizer dgsWrapWithContextDataLoaderCustomizer() {
        return new DgsWrapWithContextDataLoaderCustomizer();
    }

    @Bean
    @Order(value=100)
    @NotNull
    public DgsDataLoaderInstrumentationDataLoaderCustomizer dgsDataLoaderInstrumentationDataLoaderCustomizer(@NotNull List<? extends DgsDataLoaderInstrumentation> instrumentations) {
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        return new DgsDataLoaderInstrumentationDataLoaderCustomizer(instrumentations);
    }

    @Bean
    @NotNull
    public DgsDataLoaderProvider dgsDataLoaderProvider(@NotNull ApplicationContext applicationContext, @NotNull DgsDataLoaderOptionsProvider dataloaderOptionProvider, @Qualifier(value="dgsScheduledExecutorService") @NotNull ScheduledExecutorService dgsScheduledExecutorService, @NotNull List<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders, @NotNull List<? extends DgsDataLoaderCustomizer> customizers) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)dataloaderOptionProvider, (String)"dataloaderOptionProvider");
        Intrinsics.checkNotNullParameter((Object)dgsScheduledExecutorService, (String)"dgsScheduledExecutorService");
        Intrinsics.checkNotNullParameter(extensionProviders, (String)"extensionProviders");
        Intrinsics.checkNotNullParameter(customizers, (String)"customizers");
        return (DgsDataLoaderProvider)new DefaultDgsDataLoaderProvider(applicationContext, extensionProviders, customizers, dataloaderOptionProvider, dgsScheduledExecutorService, this.dataloaderConfigProps.getScheduleDuration(), this.dataloaderConfigProps.getTickerModeEnabled());
    }

    @Bean
    @NotNull
    public EntityFetcherRegistry entityFetcherRegistry() {
        return new EntityFetcherRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DataFetcherExceptionHandler dataFetcherExceptionHandler() {
        return (DataFetcherExceptionHandler)new DefaultDataFetcherExceptionHandler();
    }

    @Bean
    @ConditionalOnProperty(prefix="dgs.graphql.preparsedDocumentProvider", name={"enabled"}, havingValue="true", matchIfMissing=false)
    @ConditionalOnMissingBean
    @NotNull
    public PreparsedDocumentProvider preparsedDocumentProvider(@NotNull DgsConfigurationProperties configProps) {
        Intrinsics.checkNotNullParameter((Object)configProps, (String)"configProps");
        long l = configProps.getPreparsedDocumentProvider().getMaximumCacheSize();
        Duration duration = Duration.parse(configProps.getPreparsedDocumentProvider().getCacheValidityDuration());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"parse(...)");
        return (PreparsedDocumentProvider)new DgsDefaultPreparsedDocumentProvider(l, duration);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DefaultDgsGraphQLContextBuilder graphQLContextBuilder(@NotNull Optional<DgsCustomContextBuilder<?>> dgsCustomContextBuilder, @NotNull Optional<DgsCustomContextBuilderWithRequest<?>> dgsCustomContextBuilderWithRequest) {
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilder, (String)"dgsCustomContextBuilder");
        Intrinsics.checkNotNullParameter(dgsCustomContextBuilderWithRequest, (String)"dgsCustomContextBuilderWithRequest");
        return new DefaultDgsGraphQLContextBuilder(dgsCustomContextBuilder, dgsCustomContextBuilderWithRequest);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public ReloadSchemaIndicator defaultReloadSchemaIndicator(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        boolean hotReloadSetting = OnDgsReloadCondition.Companion.evaluate(environment);
        return () -> DgsSpringGraphQLAutoConfiguration.defaultReloadSchemaIndicator$lambda$0(hotReloadSetting);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public DgsSchemaProvider dgsSchemaProvider(@NotNull ApplicationContext applicationContext, @NotNull Optional<DgsFederationResolver> federationResolver, @NotNull Optional<TypeDefinitionRegistry> existingTypeDefinitionFactory, @NotNull Optional<GraphQLCodeRegistry> existingCodeRegistry, @NotNull List<? extends DataFetcherResultProcessor> dataFetcherResultProcessors, @NotNull Optional<DataFetcherExceptionHandler> dataFetcherExceptionHandler, @NotNull EntityFetcherRegistry entityFetcherRegistry, @NotNull Optional<DataFetcherFactory<?>> defaultDataFetcherFactory, @NotNull MethodDataFetcherFactory methodDataFetcherFactory, @Nullable TypeResolver fallbackTypeResolver) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(federationResolver, (String)"federationResolver");
        Intrinsics.checkNotNullParameter(existingTypeDefinitionFactory, (String)"existingTypeDefinitionFactory");
        Intrinsics.checkNotNullParameter(existingCodeRegistry, (String)"existingCodeRegistry");
        Intrinsics.checkNotNullParameter(dataFetcherResultProcessors, (String)"dataFetcherResultProcessors");
        Intrinsics.checkNotNullParameter(dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)entityFetcherRegistry, (String)"entityFetcherRegistry");
        Intrinsics.checkNotNullParameter(defaultDataFetcherFactory, (String)"defaultDataFetcherFactory");
        Intrinsics.checkNotNullParameter((Object)methodDataFetcherFactory, (String)"methodDataFetcherFactory");
        return new DgsSchemaProvider(applicationContext, federationResolver, existingTypeDefinitionFactory, this.configProps.getSchemaLocations(), dataFetcherResultProcessors, dataFetcherExceptionHandler, entityFetcherRegistry, defaultDataFetcherFactory, methodDataFetcherFactory, null, this.configProps.getSchemaWiringValidationEnabled(), this.configProps.getEnableEntityFetcherCustomScalarParsing(), fallbackTypeResolver, this.configProps.getStrictMode().getEnabled(), 512, null);
    }

    public static /* synthetic */ DgsSchemaProvider dgsSchemaProvider$default(DgsSpringGraphQLAutoConfiguration dgsSpringGraphQLAutoConfiguration, ApplicationContext applicationContext, Optional optional, Optional optional2, Optional optional3, List list, Optional optional4, EntityFetcherRegistry entityFetcherRegistry, Optional optional5, MethodDataFetcherFactory methodDataFetcherFactory, TypeResolver typeResolver, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dgsSchemaProvider");
        }
        if ((n & 0x20) != 0) {
            Optional<DataFetcherExceptionHandler> optional6 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional6, (String)"empty(...)");
            optional4 = optional6;
        }
        if ((n & 0x80) != 0) {
            Optional<DataFetcherFactory<?>> optional7 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional7, (String)"empty(...)");
            optional5 = optional7;
        }
        if ((n & 0x200) != 0) {
            typeResolver = null;
        }
        return dgsSpringGraphQLAutoConfiguration.dgsSchemaProvider(applicationContext, optional, optional2, optional3, list, optional4, entityFetcherRegistry, optional5, methodDataFetcherFactory, typeResolver);
    }

    @Bean
    @NotNull
    public GraphQlSource graphQlSource(@NotNull GraphQlProperties properties, @NotNull DgsSchemaProvider dgsSchemaProvider, @NotNull ObjectProvider<DataFetcherExceptionResolver> exceptionResolvers, @NotNull ObjectProvider<SubscriptionExceptionResolver> subscriptionExceptionResolvers, @NotNull ObjectProvider<Instrumentation> instrumentations, @NotNull ObjectProvider<RuntimeWiringConfigurer> wiringConfigurers, @NotNull ObjectProvider<GraphQlSourceBuilderCustomizer> sourceCustomizers, @NotNull ReloadSchemaIndicator reloadSchemaIndicator, @NotNull DataFetcherExceptionHandler defaultExceptionHandler, @Nullable Consumer<SchemaReport> reportConsumer) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)dgsSchemaProvider, (String)"dgsSchemaProvider");
        Intrinsics.checkNotNullParameter(exceptionResolvers, (String)"exceptionResolvers");
        Intrinsics.checkNotNullParameter(subscriptionExceptionResolvers, (String)"subscriptionExceptionResolvers");
        Intrinsics.checkNotNullParameter(instrumentations, (String)"instrumentations");
        Intrinsics.checkNotNullParameter(wiringConfigurers, (String)"wiringConfigurers");
        Intrinsics.checkNotNullParameter(sourceCustomizers, (String)"sourceCustomizers");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        Intrinsics.checkNotNullParameter((Object)defaultExceptionHandler, (String)"defaultExceptionHandler");
        List list = exceptionResolvers.orderedStream().collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        List dataFetcherExceptionResolvers = list;
        ((Collection)dataFetcherExceptionResolvers).add(new ExceptionHandlerResolverAdapter(defaultExceptionHandler));
        GraphQlSource.Builder builder = ((GraphQlSource.SchemaResourceBuilder)((GraphQlSource.SchemaResourceBuilder)new DgsGraphQLSourceBuilder(dgsSchemaProvider, this.configProps.getIntrospection().getShowSdlComments()).exceptionResolvers(dataFetcherExceptionResolvers)).subscriptionExceptionResolvers(subscriptionExceptionResolvers.orderedStream().toList())).instrumentation(instrumentations.orderedStream().toList());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"instrumentation(...)");
        GraphQlSource.SchemaResourceBuilder builder2 = (GraphQlSource.SchemaResourceBuilder)builder;
        if (properties.getSchema().getInspection().isEnabled()) {
            if (reportConsumer != null) {
                builder2.inspectSchemaMappings(reportConsumer);
            } else if (LOG.isInfoEnabled()) {
                builder2.inspectSchemaMappings(DgsSpringGraphQLAutoConfiguration::graphQlSource$lambda$0);
            }
        }
        wiringConfigurers.orderedStream().forEach(arg_0 -> DgsSpringGraphQLAutoConfiguration.graphQlSource$lambda$2(arg_0 -> DgsSpringGraphQLAutoConfiguration.graphQlSource$lambda$1(builder2, arg_0), arg_0));
        sourceCustomizers.orderedStream().forEach(arg_0 -> DgsSpringGraphQLAutoConfiguration.graphQlSource$lambda$4(arg_0 -> DgsSpringGraphQLAutoConfiguration.graphQlSource$lambda$3(builder2, arg_0), arg_0));
        return new ReloadableGraphQLSource((GraphQlSource.Builder)builder2, reloadSchemaIndicator);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"reactor.core.publisher.Mono"})
    @NotNull
    public MonoDataFetcherResultProcessor monoReactiveDataFetcherResultProcessor() {
        return new MonoDataFetcherResultProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"kotlinx.coroutines.flow.Flow"})
    @NotNull
    public FlowDataFetcherResultProcessor flowReactiveDataFetcherResultProcessor() {
        return new FlowDataFetcherResultProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"reactor.core.publisher.Flux"})
    @NotNull
    public FluxDataFetcherResultProcessor fluxReactiveDataFetcherResultProcessor() {
        return new FluxDataFetcherResultProcessor();
    }

    @Bean
    @Qualifier(value="dgsAsyncTaskExecutor")
    @ConditionalOnJava(value=JavaVersion.TWENTY_ONE)
    @ConditionalOnMissingBean(name={"dgsAsyncTaskExecutor"})
    @ConditionalOnProperty(prefix="dgs.graphql.virtualthreads", name={"enabled"}, havingValue="true", matchIfMissing=false)
    @NotNull
    public AsyncTaskExecutor virtualThreadsTaskExecutor() {
        LOG.info("Enabling virtual threads for DGS");
        ContextRegistry contextRegistry = new ContextRegistry().loadContextAccessors().loadThreadLocalAccessors().registerThreadLocalAccessor((ThreadLocalAccessor)new Slf4jThreadLocalAccessor(new String[0]));
        Intrinsics.checkNotNullExpressionValue((Object)contextRegistry, (String)"registerThreadLocalAccessor(...)");
        ContextRegistry contextRegistry2 = contextRegistry;
        SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor("dgs-virtual-thread-");
        executor.setVirtualThreads(true);
        executor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator(ContextSnapshotFactory.builder().contextRegistry(contextRegistry2).build()));
        return (AsyncTaskExecutor)executor;
    }

    @Bean
    @NotNull
    public MethodDataFetcherFactory methodDataFetcherFactory(@NotNull ObjectProvider<ArgumentResolver> argumentResolvers, @Qualifier(value="dgsAsyncTaskExecutor") @NotNull Optional<AsyncTaskExecutor> taskExecutorOptional) {
        Intrinsics.checkNotNullParameter(argumentResolvers, (String)"argumentResolvers");
        Intrinsics.checkNotNullParameter(taskExecutorOptional, (String)"taskExecutorOptional");
        AsyncTaskExecutor taskExecutor = taskExecutorOptional.isPresent() ? taskExecutorOptional.get() : null;
        List list = argumentResolvers.orderedStream().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return new MethodDataFetcherFactory(list, (ParameterNameDiscoverer)new DefaultParameterNameDiscoverer(), taskExecutor);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.mock.web.MockHttpServletRequest"})
    @NotNull
    public DgsQueryExecutorRequestCustomizer mockRequestHeaderCustomizer() {
        return new DgsQueryExecutorRequestCustomizer(){

            public WebRequest apply(WebRequest request, HttpHeaders headers) {
                if (headers == null || headers.isEmpty() || !(request instanceof NativeWebRequest)) {
                    return request;
                }
                Object object = ((NativeWebRequest)request).getNativeRequest();
                MockHttpServletRequest mockHttpServletRequest = object instanceof MockHttpServletRequest ? (MockHttpServletRequest)object : null;
                if (mockHttpServletRequest == null) {
                    return request;
                }
                MockHttpServletRequest mockRequest = mockHttpServletRequest;
                headers.forEach((arg_0, arg_1) -> mockRequestHeaderCustomizer.1.apply$lambda$1((arg_0, arg_1) -> mockRequestHeaderCustomizer.1.apply$lambda$0(mockRequest, arg_0, arg_1), arg_0, arg_1));
                return request;
            }

            public String toString() {
                return "{MockRequestHeaderCustomizer}";
            }

            private static final Unit apply$lambda$0(MockHttpServletRequest $mockRequest, String key, List value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if ($mockRequest.getHeader(key) == null) {
                    $mockRequest.addHeader(key, (Object)value);
                }
                return Unit.INSTANCE;
            }

            private static final void apply$lambda$1(Function2 $tmp0, Object p0, Object p1) {
                $tmp0.invoke(p0, p1);
            }
        };
    }

    @Bean
    @DgsComponent
    @NotNull
    public DgsRuntimeWiringConfigurerBridge dgsRuntimeWiringConfigurerBridge(@NotNull List<? extends RuntimeWiringConfigurer> configurers) {
        Intrinsics.checkNotNullParameter(configurers, (String)"configurers");
        return new DgsRuntimeWiringConfigurerBridge(configurers);
    }

    @Bean
    @ConditionalOnProperty(value={"dgs.springgraphql.pagination.enabled"}, havingValue="true", matchIfMissing=true)
    @DgsComponent
    @NotNull
    public DgsTypeDefinitionConfigurerBridge dgsTypeDefinitionConfigurerBridge(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return new DgsTypeDefinitionConfigurerBridge();
    }

    @Bean
    @NotNull
    public GraphQlSourceBuilderCustomizer sourceBuilderCustomizer(@NotNull Optional<PreparsedDocumentProvider> preparsedDocumentProvider, @Qualifier(value="query") @NotNull Optional<ExecutionStrategy> providedQueryExecutionStrategy, @Qualifier(value="mutation") @NotNull Optional<ExecutionStrategy> providedMutationExecutionStrategy, @NotNull DataFetcherExceptionHandler dataFetcherExceptionHandler, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter(preparsedDocumentProvider, (String)"preparsedDocumentProvider");
        Intrinsics.checkNotNullParameter(providedQueryExecutionStrategy, (String)"providedQueryExecutionStrategy");
        Intrinsics.checkNotNullParameter(providedMutationExecutionStrategy, (String)"providedMutationExecutionStrategy");
        Intrinsics.checkNotNullParameter((Object)dataFetcherExceptionHandler, (String)"dataFetcherExceptionHandler");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        return arg_0 -> DgsSpringGraphQLAutoConfiguration.sourceBuilderCustomizer$lambda$0(environment, preparsedDocumentProvider, providedQueryExecutionStrategy, providedMutationExecutionStrategy, arg_0);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.graphql.schema.introspection.enabled"}, havingValue="false", matchIfMissing=false)
    @NotNull
    public GraphQLContextContributor disableIntrospectionContextContributor() {
        return DgsSpringGraphQLAutoConfiguration::disableIntrospectionContextContributor$lambda$0;
    }

    @Bean
    @NotNull
    public DgsQueryExecutor springGraphQLDgsQueryExecutor(@NotNull ExecutionGraphQlService executionService, @NotNull DefaultDgsGraphQLContextBuilder dgsContextBuilder, @NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull ObjectProvider<DgsQueryExecutorRequestCustomizer> requestCustomizer, @NotNull List<? extends GraphQLContextContributor> graphQLContextContributors) {
        Intrinsics.checkNotNullParameter((Object)executionService, (String)"executionService");
        Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
        Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
        Intrinsics.checkNotNullParameter(requestCustomizer, (String)"requestCustomizer");
        Intrinsics.checkNotNullParameter(graphQLContextContributors, (String)"graphQLContextContributors");
        Object object = requestCustomizer.getIfAvailable(() -> DgsSpringGraphQLAutoConfiguration.springGraphQLDgsQueryExecutor$lambda$0((KProperty0)new PropertyReference0Impl(DgsQueryExecutorRequestCustomizer.Companion){

            public Object get() {
                return ((DgsQueryExecutorRequestCustomizer.Companion)this.receiver).getDEFAULT_REQUEST_CUSTOMIZER();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIfAvailable(...)");
        return new SpringGraphQLDgsQueryExecutor(executionService, dgsContextBuilder, dgsDataLoaderProvider, (DgsQueryExecutorRequestCustomizer)object, graphQLContextContributors);
    }

    @Bean
    @ConditionalOnProperty(prefix="dgs.graphql.dgs-response-headers", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @NotNull
    public WebGraphQlInterceptor dgsHeadersInterceptor() {
        return DgsSpringGraphQLAutoConfiguration::dgsHeadersInterceptor$lambda$0;
    }

    private static final String defaultQueryValueCustomizer$lambda$0(String a) {
        return a;
    }

    private static final boolean defaultReloadSchemaIndicator$lambda$0(boolean $hotReloadSetting) {
        return $hotReloadSetting;
    }

    /*
     * WARNING - void declaration
     */
    private static final void graphQlSource$lambda$0(SchemaReport schemaReport) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)schemaReport, (String)"schemaReport");
        StringBuilder messageBuilder = new StringBuilder("***Schema Report***\n");
        MultiValueMap multiValueMap = schemaReport.unmappedArguments();
        Intrinsics.checkNotNullExpressionValue((Object)multiValueMap, (String)"unmappedArguments(...)");
        Map $this$map$iv = (Map)multiValueMap;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            void entry;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            DataFetcher key = (DataFetcher)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            List value = (List)v;
            if (key instanceof SelfDescribingDataFetcher) {
                DataFetcherReference dataFetcher = ((DgsGraphQLSourceBuilder.DgsSelfDescribingDataFetcher)key).getDataFetcher();
                object = dataFetcher.getMethod().getDeclaringClass().getName() + "." + dataFetcher.getMethod().getName() + " for arguments " + value;
            } else {
                object = entry.toString();
            }
            collection.add(object);
        }
        List arguments = (List)destination$iv$iv;
        messageBuilder.append("Unmapped fields: ").append(schemaReport.unmappedFields()).append('\n');
        messageBuilder.append("Unmapped registrations: ").append(schemaReport.unmappedRegistrations()).append('\n');
        messageBuilder.append("Unmapped arguments: ").append(arguments).append('\n');
        messageBuilder.append("Skipped types: ").append(schemaReport.skippedTypes()).append('\n');
        LOG.info("{}", (Object)messageBuilder);
    }

    private static final Unit graphQlSource$lambda$1(GraphQlSource.SchemaResourceBuilder $builder, RuntimeWiringConfigurer configurer) {
        Intrinsics.checkNotNullParameter((Object)configurer, (String)"configurer");
        $builder.configureRuntimeWiring(configurer);
        return Unit.INSTANCE;
    }

    private static final void graphQlSource$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit graphQlSource$lambda$3(GraphQlSource.SchemaResourceBuilder $builder, GraphQlSourceBuilderCustomizer customizer) {
        Intrinsics.checkNotNullParameter((Object)customizer, (String)"customizer");
        customizer.customize($builder);
        return Unit.INSTANCE;
    }

    private static final void graphQlSource$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void sourceBuilderCustomizer$lambda$0(Environment $environment, Optional $preparsedDocumentProvider, Optional $providedQueryExecutionStrategy, Optional $providedMutationExecutionStrategy, GraphQlSource.SchemaResourceBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.configureGraphQl(arg_0 -> DgsSpringGraphQLAutoConfiguration.sourceBuilderCustomizer$lambda$0$0($environment, $preparsedDocumentProvider, $providedQueryExecutionStrategy, $providedMutationExecutionStrategy, arg_0));
    }

    private static final void sourceBuilderCustomizer$lambda$0$0(Environment $environment, Optional $preparsedDocumentProvider, Optional $providedQueryExecutionStrategy, Optional $providedMutationExecutionStrategy, GraphQL.Builder graphQlBuilder) {
        Intrinsics.checkNotNullParameter((Object)graphQlBuilder, (String)"graphQlBuilder");
        Object object = $environment.getProperty("dgs.graphql.apq.enabled", Boolean.TYPE, (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProperty(...)");
        boolean apqEnabled = (Boolean)object;
        if ($preparsedDocumentProvider.isPresent() && !apqEnabled) {
            graphQlBuilder.preparsedDocumentProvider((PreparsedDocumentProvider)$preparsedDocumentProvider.get());
        }
        if ($providedQueryExecutionStrategy.isPresent()) {
            graphQlBuilder.queryExecutionStrategy((ExecutionStrategy)$providedQueryExecutionStrategy.get());
        }
        if ($providedMutationExecutionStrategy.isPresent()) {
            graphQlBuilder.mutationExecutionStrategy((ExecutionStrategy)$providedMutationExecutionStrategy.get());
        }
    }

    private static final void disableIntrospectionContextContributor$lambda$0(GraphQLContext.Builder builder, Map map, DgsRequestData dgsRequestData) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.put((Object)"INTROSPECTION_DISABLED", (Object)true);
    }

    private static final DgsQueryExecutorRequestCustomizer springGraphQLDgsQueryExecutor$lambda$0(KProperty0 $tmp0) {
        return (DgsQueryExecutorRequestCustomizer)((Function0)$tmp0).invoke();
    }

    private static final Mono dgsHeadersInterceptor$lambda$0(WebGraphQlRequest request, WebGraphQlInterceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        return chain.next(request).doOnNext(arg_0 -> DgsSpringGraphQLAutoConfiguration.dgsHeadersInterceptor$lambda$0$1(DgsSpringGraphQLAutoConfiguration::dgsHeadersInterceptor$lambda$0$0, arg_0));
    }

    private static final Unit dgsHeadersInterceptor$lambda$0$0(WebGraphQlResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Object responseHeadersExtension = response.getExtensions().get("dgs-response-headers");
        if (responseHeadersExtension instanceof HttpHeaders) {
            response.getResponseHeaders().addAll((HttpHeaders)responseHeadersExtension);
        }
        if (response.getExecutionResult() instanceof DgsExecutionResult) {
            HttpHeaders httpHeaders = response.getResponseHeaders();
            ExecutionResult executionResult = response.getExecutionResult();
            Intrinsics.checkNotNull((Object)executionResult, (String)"null cannot be cast to non-null type com.netflix.graphql.dgs.DgsExecutionResult");
            httpHeaders.addAll(((DgsExecutionResult)executionResult).getHeaders());
        }
        return Unit.INSTANCE;
    }

    private static final void dgsHeadersInterceptor$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DgsSpringGraphQLAutoConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$Companion;", "", "<init>", "()V", "AUTO_CONF_PREFIX", "", "LOG", "Lorg/slf4j/Logger;", "graphql-dgs-spring-graphql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @AutoConfiguration
    @ConditionalOnDgsReload
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J>\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsDataLoaderReloadAutoConfiguration;", "", "dataloaderConfigProps", "Lcom/netflix/graphql/dgs/autoconfig/DgsDataloaderConfigurationProperties;", "<init>", "(Lcom/netflix/graphql/dgs/autoconfig/DgsDataloaderConfigurationProperties;)V", "reloadableDgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/ReloadableDgsDataLoaderProvider;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "dataLoaderOptionProvider", "Lcom/netflix/graphql/dgs/DgsDataLoaderOptionsProvider;", "dgsScheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "extensionProviders", "", "Lcom/netflix/graphql/dgs/DataLoaderInstrumentationExtensionProvider;", "customizers", "Lcom/netflix/graphql/dgs/DgsDataLoaderCustomizer;", "dgsDataLoaderReloadController", "Lcom/netflix/graphql/dgs/DgsDataLoaderReloadController;", "graphql-dgs-spring-graphql"})
    public static class DgsDataLoaderReloadAutoConfiguration {
        @NotNull
        private final DgsDataloaderConfigurationProperties dataloaderConfigProps;

        public DgsDataLoaderReloadAutoConfiguration(@NotNull DgsDataloaderConfigurationProperties dataloaderConfigProps) {
            Intrinsics.checkNotNullParameter((Object)dataloaderConfigProps, (String)"dataloaderConfigProps");
            this.dataloaderConfigProps = dataloaderConfigProps;
        }

        @Bean
        @Primary
        @NotNull
        public ReloadableDgsDataLoaderProvider reloadableDgsDataLoaderProvider(@NotNull ApplicationContext applicationContext, @NotNull DgsDataLoaderOptionsProvider dataLoaderOptionProvider, @Qualifier(value="dgsScheduledExecutorService") @NotNull ScheduledExecutorService dgsScheduledExecutorService, @NotNull List<? extends DataLoaderInstrumentationExtensionProvider> extensionProviders, @NotNull List<? extends DgsDataLoaderCustomizer> customizers) {
            Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
            Intrinsics.checkNotNullParameter((Object)dataLoaderOptionProvider, (String)"dataLoaderOptionProvider");
            Intrinsics.checkNotNullParameter((Object)dgsScheduledExecutorService, (String)"dgsScheduledExecutorService");
            Intrinsics.checkNotNullParameter(extensionProviders, (String)"extensionProviders");
            Intrinsics.checkNotNullParameter(customizers, (String)"customizers");
            LOG.info("Creating reloadable data loader provider with reload support enabled");
            Duration duration = this.dataloaderConfigProps.getScheduleDuration();
            boolean bl = this.dataloaderConfigProps.getTickerModeEnabled();
            return new ReloadableDgsDataLoaderProvider(applicationContext, dgsScheduledExecutorService, extensionProviders, customizers, dataLoaderOptionProvider, duration, bl);
        }

        @Bean
        @ConditionalOnMissingBean
        @NotNull
        public DgsDataLoaderReloadController dgsDataLoaderReloadController(@NotNull ReloadableDgsDataLoaderProvider reloadableDgsDataLoaderProvider) {
            Intrinsics.checkNotNullParameter((Object)reloadableDgsDataLoaderProvider, (String)"reloadableDgsDataLoaderProvider");
            LOG.info("Creating data loader reload controller");
            return (DgsDataLoaderReloadController)new DefaultDgsDataLoaderReloadController(reloadableDgsDataLoaderProvider);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsRuntimeWiringConfigurerBridge;", "", "configurers", "", "Lorg/springframework/graphql/execution/RuntimeWiringConfigurer;", "<init>", "(Ljava/util/List;)V", "runtimeWiring", "Lgraphql/schema/idl/RuntimeWiring$Builder;", "builder", "graphql-dgs-spring-graphql"})
    @SourceDebugExtension(value={"SMAP\nDgsSpringGraphQLAutoConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DgsSpringGraphQLAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsRuntimeWiringConfigurerBridge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,845:1\n1869#2,2:846\n*S KotlinDebug\n*F\n+ 1 DgsSpringGraphQLAutoConfiguration.kt\ncom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsRuntimeWiringConfigurerBridge\n*L\n543#1:846,2\n*E\n"})
    public static final class DgsRuntimeWiringConfigurerBridge {
        @NotNull
        private final List<RuntimeWiringConfigurer> configurers;

        public DgsRuntimeWiringConfigurerBridge(@NotNull List<? extends RuntimeWiringConfigurer> configurers) {
            Intrinsics.checkNotNullParameter(configurers, (String)"configurers");
            this.configurers = configurers;
        }

        @DgsRuntimeWiring
        @NotNull
        public final RuntimeWiring.Builder runtimeWiring(@NotNull RuntimeWiring.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Iterable $this$forEach$iv = this.configurers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RuntimeWiringConfigurer it = (RuntimeWiringConfigurer)element$iv;
                boolean bl = false;
                it.configure(builder);
            }
            return builder;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$DgsTypeDefinitionConfigurerBridge;", "", "<init>", "()V", "typeDefinitionRegistry", "Lgraphql/schema/idl/TypeDefinitionRegistry;", "graphql-dgs-spring-graphql"})
    public static final class DgsTypeDefinitionConfigurerBridge {
        @DgsTypeDefinitionRegistry
        @NotNull
        public final TypeDefinitionRegistry typeDefinitionRegistry(@NotNull TypeDefinitionRegistry typeDefinitionRegistry) {
            Intrinsics.checkNotNullParameter((Object)typeDefinitionRegistry, (String)"typeDefinitionRegistry");
            TypeDefinitionRegistry newTypeDefinitionRegistry = new TypeDefinitionRegistry();
            new ConnectionTypeDefinitionConfigurer().configure(typeDefinitionRegistry);
            return newTypeDefinitionRegistry;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Publisher.class, ServerRequest.class})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001a\u0010\f\u001a\u00020\t2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0017\u00a8\u0006\u0012"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$ReactiveConfiguration;", "", "<init>", "()V", "springGraphQLDgsReactiveQueryExecutor", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveQueryExecutor;", "executionService", "Lorg/springframework/graphql/ExecutionGraphQlService;", "dgsContextBuilder", "Lcom/netflix/graphql/dgs/reactive/internal/DefaultDgsReactiveGraphQLContextBuilder;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "reactiveGraphQlContextBuilder", "dgsReactiveCustomContextBuilderWithRequest", "Ljava/util/Optional;", "Lcom/netflix/graphql/dgs/reactive/DgsReactiveCustomContextBuilderWithRequest;", "dgsServerWebExchangeContextFilter", "Lorg/springframework/web/filter/reactive/ServerWebExchangeContextFilter;", "graphql-dgs-spring-graphql"})
    public static class ReactiveConfiguration {
        @Bean
        @NotNull
        public DgsReactiveQueryExecutor springGraphQLDgsReactiveQueryExecutor(@NotNull ExecutionGraphQlService executionService, @NotNull DefaultDgsReactiveGraphQLContextBuilder dgsContextBuilder, @NotNull DgsDataLoaderProvider dgsDataLoaderProvider) {
            Intrinsics.checkNotNullParameter((Object)executionService, (String)"executionService");
            Intrinsics.checkNotNullParameter((Object)dgsContextBuilder, (String)"dgsContextBuilder");
            Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
            return new SpringGraphQLDgsReactiveQueryExecutor(executionService, dgsContextBuilder, dgsDataLoaderProvider);
        }

        @Bean
        @ConditionalOnMissingBean
        @NotNull
        public DefaultDgsReactiveGraphQLContextBuilder reactiveGraphQlContextBuilder(@NotNull Optional<DgsReactiveCustomContextBuilderWithRequest<?>> dgsReactiveCustomContextBuilderWithRequest) {
            Intrinsics.checkNotNullParameter(dgsReactiveCustomContextBuilderWithRequest, (String)"dgsReactiveCustomContextBuilderWithRequest");
            return new DefaultDgsReactiveGraphQLContextBuilder(dgsReactiveCustomContextBuilderWithRequest);
        }

        @Bean
        @ConditionalOnMissingBean
        @NotNull
        public ServerWebExchangeContextFilter dgsServerWebExchangeContextFilter() {
            return new ServerWebExchangeContextFilter();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0017J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0005H\u0017J\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0005H\u0017J\"\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0005H\u0017J\"\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0005H\u0017J\"\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0005H\u0017\u00a8\u0006\u0015"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebFluxArgumentHandlerConfiguration;", "", "<init>", "()V", "dgsBindingContext", "Lorg/springframework/web/reactive/BindingContext;", "adapter", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/web/reactive/result/method/annotation/RequestMappingHandlerAdapter;", "cookieValueArgumentResolver", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "registry", "Lorg/springframework/core/ReactiveAdapterRegistry;", "bindingContext", "requestHeaderMapArgumentResolver", "requestHeaderArgumentResolver", "requestParamArgumentResolver", "requestParamMapArgumentResolver", "Dgs", "graphql-dgs-spring-graphql"})
    public static class WebFluxArgumentHandlerConfiguration {
        @Dgs
        @Bean
        @NotNull
        public BindingContext dgsBindingContext(@NotNull ObjectProvider<RequestMappingHandlerAdapter> adapter) {
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            RequestMappingHandlerAdapter requestMappingHandlerAdapter = (RequestMappingHandlerAdapter)adapter.getIfAvailable();
            return new BindingContext((WebBindingInitializer)(requestMappingHandlerAdapter != null ? requestMappingHandlerAdapter.getWebBindingInitializer() : null));
        }

        @Bean
        @NotNull
        public ArgumentResolver cookieValueArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new CookieValueMethodArgumentResolver(beanFactory, registry), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderMapArgumentResolver(@NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new org.springframework.web.reactive.result.method.annotation.RequestHeaderMapMethodArgumentResolver(registry), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new org.springframework.web.reactive.result.method.annotation.RequestHeaderMethodArgumentResolver(beanFactory, registry), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new org.springframework.web.reactive.result.method.annotation.RequestParamMethodArgumentResolver(beanFactory, registry, false), bindingContext);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamMapArgumentResolver(@NotNull ConfigurableBeanFactory beanFactory, @NotNull ReactiveAdapterRegistry registry, @Dgs @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            return (ArgumentResolver)new SyncHandlerMethodArgumentResolverAdapter((SyncHandlerMethodArgumentResolver)new org.springframework.web.reactive.result.method.annotation.RequestParamMapMethodArgumentResolver(registry), bindingContext);
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebFluxArgumentHandlerConfiguration$Dgs;", "", "graphql-dgs-spring-graphql"})
        private static @interface Dgs {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebFluxConfiguration;", "", "<init>", "()V", "webFluxDgsGraphQLInterceptor", "Lcom/netflix/graphql/dgs/springgraphql/webflux/DgsWebFluxGraphQLInterceptor;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "defaultDgsReactiveGraphQLContextBuilder", "Lcom/netflix/graphql/dgs/reactive/internal/DefaultDgsReactiveGraphQLContextBuilder;", "graphql-dgs-spring-graphql"})
    public static class WebFluxConfiguration {
        @Bean
        @NotNull
        public DgsWebFluxGraphQLInterceptor webFluxDgsGraphQLInterceptor(@NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsReactiveGraphQLContextBuilder defaultDgsReactiveGraphQLContextBuilder) {
            Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
            Intrinsics.checkNotNullParameter((Object)defaultDgsReactiveGraphQLContextBuilder, (String)"defaultDgsReactiveGraphQLContextBuilder");
            return new DgsWebFluxGraphQLInterceptor(dgsDataLoaderProvider, defaultDgsReactiveGraphQLContextBuilder);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u000e\b\u0001\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0017J\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u0017J\u001a\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u0017J\u0012\u0010\u000f\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u0017J\u0012\u0010\u0010\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u0017J\u001a\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u0017\u00a8\u0006\u0013"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebMvcArgumentHandlerConfiguration;", "", "<init>", "()V", "dgsWebDataBinderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "adapter", "Lorg/springframework/beans/factory/ObjectProvider;", "Lorg/springframework/web/servlet/mvc/method/annotation/RequestMappingHandlerAdapter;", "requestHeaderMapResolver", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "dataBinderFactory", "requestHeaderResolver", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableBeanFactory;", "requestParamResolver", "requestParamMapResolver", "cookieValueResolver", "Dgs", "graphql-dgs-spring-graphql"})
    public static class WebMvcArgumentHandlerConfiguration {
        @Bean
        @Dgs
        @NotNull
        public WebDataBinderFactory dgsWebDataBinderFactory(@Qualifier(value="requestMappingHandlerAdapter") @NotNull ObjectProvider<org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter> adapter) {
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter requestMappingHandlerAdapter = (org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter)adapter.getIfAvailable();
            return (WebDataBinderFactory)new ServletRequestDataBinderFactory(CollectionsKt.emptyList(), (WebBindingInitializer)(requestMappingHandlerAdapter != null ? requestMappingHandlerAdapter.getWebBindingInitializer() : null));
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderMapResolver(@Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new RequestHeaderMapMethodArgumentResolver(), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestHeaderResolver(@NotNull ConfigurableBeanFactory beanFactory, @Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new RequestHeaderMethodArgumentResolver(beanFactory), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamResolver(@Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(false), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver requestParamMapResolver(@Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new RequestParamMapMethodArgumentResolver(), dataBinderFactory);
        }

        @Bean
        @NotNull
        public ArgumentResolver cookieValueResolver(@NotNull ConfigurableBeanFactory beanFactory, @Dgs @NotNull WebDataBinderFactory dataBinderFactory) {
            Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
            Intrinsics.checkNotNullParameter((Object)dataBinderFactory, (String)"dataBinderFactory");
            return new HandlerMethodArgumentResolverAdapter((HandlerMethodArgumentResolver)new ServletCookieValueMethodArgumentResolver(beanFactory), dataBinderFactory);
        }

        @Qualifier
        @Retention(value=RetentionPolicy.RUNTIME)
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0083\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebMvcArgumentHandlerConfiguration$Dgs;", "", "graphql-dgs-spring-graphql"})
        private static @interface Dgs {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLAutoConfiguration$WebMvcConfiguration;", "", "dgsSpringGraphQLConfigurationProperties", "Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLConfigurationProperties;", "<init>", "(Lcom/netflix/graphql/dgs/springgraphql/autoconfig/DgsSpringGraphQLConfigurationProperties;)V", "dgsGraphQlInterceptor", "Lcom/netflix/graphql/dgs/springgraphql/webmvc/DgsWebMvcGraphQLInterceptor;", "dgsDataLoaderProvider", "Lcom/netflix/graphql/dgs/internal/DgsDataLoaderProvider;", "dgsDefaultContextBuilder", "Lcom/netflix/graphql/dgs/internal/DefaultDgsGraphQLContextBuilder;", "graphQLContextContributors", "", "Lcom/netflix/graphql/dgs/context/GraphQLContextContributor;", "graphql-dgs-spring-graphql"})
    public static class WebMvcConfiguration {
        @NotNull
        private final DgsSpringGraphQLConfigurationProperties dgsSpringGraphQLConfigurationProperties;

        public WebMvcConfiguration(@NotNull DgsSpringGraphQLConfigurationProperties dgsSpringGraphQLConfigurationProperties) {
            Intrinsics.checkNotNullParameter((Object)dgsSpringGraphQLConfigurationProperties, (String)"dgsSpringGraphQLConfigurationProperties");
            this.dgsSpringGraphQLConfigurationProperties = dgsSpringGraphQLConfigurationProperties;
        }

        @Bean
        @NotNull
        public DgsWebMvcGraphQLInterceptor dgsGraphQlInterceptor(@NotNull DgsDataLoaderProvider dgsDataLoaderProvider, @NotNull DefaultDgsGraphQLContextBuilder dgsDefaultContextBuilder, @NotNull List<? extends GraphQLContextContributor> graphQLContextContributors) {
            Intrinsics.checkNotNullParameter((Object)dgsDataLoaderProvider, (String)"dgsDataLoaderProvider");
            Intrinsics.checkNotNullParameter((Object)dgsDefaultContextBuilder, (String)"dgsDefaultContextBuilder");
            Intrinsics.checkNotNullParameter(graphQLContextContributors, (String)"graphQLContextContributors");
            return new DgsWebMvcGraphQLInterceptor(dgsDataLoaderProvider, dgsDefaultContextBuilder, this.dgsSpringGraphQLConfigurationProperties, graphQLContextContributors);
        }
    }
}

