/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.springgraphql;

import com.netflix.graphql.dgs.ReloadSchemaIndicator;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.graphql.execution.GraphQlSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0001H\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/ReloadableGraphQLSource;", "Lorg/springframework/graphql/execution/GraphQlSource;", "graphQlSourceBuilder", "Lorg/springframework/graphql/execution/GraphQlSource$Builder;", "reloadSchemaIndicator", "Lcom/netflix/graphql/dgs/ReloadSchemaIndicator;", "<init>", "(Lorg/springframework/graphql/execution/GraphQlSource$Builder;Lcom/netflix/graphql/dgs/ReloadSchemaIndicator;)V", "graphQlSource", "graphQl", "Lgraphql/GraphQL;", "schema", "Lgraphql/schema/GraphQLSchema;", "getSource", "Companion", "graphql-dgs-spring-graphql"})
public final class ReloadableGraphQLSource
implements GraphQlSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private GraphQlSource.Builder<?> graphQlSourceBuilder;
    @NotNull
    private final ReloadSchemaIndicator reloadSchemaIndicator;
    @Nullable
    private GraphQlSource graphQlSource;
    @NotNull
    private static final Logger LOGGER;

    public ReloadableGraphQLSource(@NotNull GraphQlSource.Builder<?> graphQlSourceBuilder, @NotNull ReloadSchemaIndicator reloadSchemaIndicator) {
        Intrinsics.checkNotNullParameter(graphQlSourceBuilder, (String)"graphQlSourceBuilder");
        Intrinsics.checkNotNullParameter((Object)reloadSchemaIndicator, (String)"reloadSchemaIndicator");
        this.graphQlSourceBuilder = graphQlSourceBuilder;
        this.reloadSchemaIndicator = reloadSchemaIndicator;
    }

    @NotNull
    public GraphQL graphQl() {
        GraphQL graphQL = this.getSource().graphQl();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"graphQl(...)");
        return graphQL;
    }

    @NotNull
    public GraphQLSchema schema() {
        GraphQLSchema graphQLSchema = this.getSource().schema();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema, (String)"schema(...)");
        return graphQLSchema;
    }

    private final GraphQlSource getSource() {
        if (this.graphQlSource == null || this.reloadSchemaIndicator.reloadSchema()) {
            LOGGER.info("Rebuilding GraphQLSource");
            this.graphQlSource = this.graphQlSourceBuilder.build();
        }
        GraphQlSource graphQlSource = this.graphQlSource;
        Intrinsics.checkNotNull((Object)graphQlSource);
        return graphQlSource;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ReloadableGraphQLSource.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/netflix/graphql/dgs/springgraphql/ReloadableGraphQLSource$Companion;", "", "<init>", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "graphql-dgs-spring-graphql"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

