/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.apq;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.netflix.graphql.dgs.apq.AutomatedPersistedQueryCaffeineCache;
import com.netflix.graphql.dgs.apq.DgsAPQPreParsedDocumentProviderWrapper;
import com.netflix.graphql.dgs.apq.DgsAPQSupportProperties;
import com.netflix.graphql.dgs.springgraphql.autoconfig.DgsSpringGraphQLAutoConfiguration;
import graphql.GraphQL;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.execution.preparsed.persisted.PersistedQueryCache;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import java.time.Duration;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.graphql.autoconfigure.GraphQlSourceBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.graphql.execution.GraphQlSource;

@AutoConfiguration
@AutoConfigureAfter(value={DgsSpringGraphQLAutoConfiguration.class}, name={"org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration"})
@ConditionalOnProperty(prefix="dgs.graphql.apq", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={DgsAPQSupportProperties.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0004\u000b\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0017\u00a8\u0006\u000f"}, d2={"Lcom/netflix/graphql/dgs/apq/DgsAPQSupportAutoConfiguration;", "", "<init>", "()V", "apqSourceBuilderCustomizer", "Lorg/springframework/boot/graphql/autoconfigure/GraphQlSourceBuilderCustomizer;", "preparsedDocumentProvider", "Ljava/util/Optional;", "Lgraphql/execution/preparsed/PreparsedDocumentProvider;", "persistedQueryCache", "Lgraphql/execution/preparsed/persisted/PersistedQueryCache;", "APQCaffeineCacheConfiguration", "APQMicrometerMeteredCaffeineCacheConfiguration", "APQBasicCaffeineCacheConfiguration", "Companion", "graphql-dgs-spring-graphql"})
public class DgsAPQSupportAutoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String BEAN_APQ_CAFFEINE_CACHE_NAME = "apqCaffeineCache";

    @Bean
    @NotNull
    public GraphQlSourceBuilderCustomizer apqSourceBuilderCustomizer(@NotNull Optional<PreparsedDocumentProvider> preparsedDocumentProvider, @NotNull Optional<PersistedQueryCache> persistedQueryCache) {
        Intrinsics.checkNotNullParameter(preparsedDocumentProvider, (String)"preparsedDocumentProvider");
        Intrinsics.checkNotNullParameter(persistedQueryCache, (String)"persistedQueryCache");
        return arg_0 -> DgsAPQSupportAutoConfiguration.apqSourceBuilderCustomizer$lambda$0(persistedQueryCache, preparsedDocumentProvider, arg_0);
    }

    private static final void apqSourceBuilderCustomizer$lambda$0(Optional $persistedQueryCache, Optional $preparsedDocumentProvider, GraphQlSource.SchemaResourceBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.configureGraphQl(arg_0 -> DgsAPQSupportAutoConfiguration.apqSourceBuilderCustomizer$lambda$0$0($persistedQueryCache, $preparsedDocumentProvider, arg_0));
    }

    private static final void apqSourceBuilderCustomizer$lambda$0$0(Optional $persistedQueryCache, Optional $preparsedDocumentProvider, GraphQL.Builder graphQlBuilder) {
        Intrinsics.checkNotNullParameter((Object)graphQlBuilder, (String)"graphQlBuilder");
        Object t = $persistedQueryCache.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        DgsAPQPreParsedDocumentProviderWrapper apqPreParsedDocumentProvider = new DgsAPQPreParsedDocumentProviderWrapper((PersistedQueryCache)t, $preparsedDocumentProvider);
        graphQlBuilder.preparsedDocumentProvider((PreparsedDocumentProvider)apqPreParsedDocumentProvider);
    }

    @Configuration
    @ConditionalOnMissingBean(value={APQMicrometerMeteredCaffeineCacheConfiguration.class}, name={"io.micrometer.core.instrument.MeterRegistry::class"})
    @ConditionalOnMissingClass(value={"io.micrometer.core.instrument.MeterRegistry::class"})
    @ConditionalOnClass(name={"com.github.benmanes.caffeine.cache.Cache"})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0014\b\u0001\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0017\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/apq/DgsAPQSupportAutoConfiguration$APQBasicCaffeineCacheConfiguration;", "", "<init>", "()V", "meteredPersistedQueryCache", "Lgraphql/execution/preparsed/persisted/PersistedQueryCache;", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lgraphql/execution/preparsed/PreparsedDocumentEntry;", "graphql-dgs-spring-graphql"})
    public static class APQBasicCaffeineCacheConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={PersistedQueryCache.class})
        @NotNull
        public PersistedQueryCache meteredPersistedQueryCache(@Qualifier(value="apqCaffeineCache") @NotNull Cache<String, PreparsedDocumentEntry> cache) {
            Intrinsics.checkNotNullParameter(cache, (String)"cache");
            return new AutomatedPersistedQueryCaffeineCache(cache);
        }
    }

    @Configuration
    @ConditionalOnClass(name={"com.github.benmanes.caffeine.cache.Cache"})
    @ConditionalOnProperty(prefix="dgs.graphql.apq.default-cache", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\n"}, d2={"Lcom/netflix/graphql/dgs/apq/DgsAPQSupportAutoConfiguration$APQCaffeineCacheConfiguration;", "", "<init>", "()V", "apqCaffeineCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lgraphql/execution/preparsed/PreparsedDocumentEntry;", "properties", "Lcom/netflix/graphql/dgs/apq/DgsAPQSupportProperties;", "graphql-dgs-spring-graphql"})
    public static class APQCaffeineCacheConfiguration {
        @Bean(name={"apqCaffeineCache"})
        @ConditionalOnMissingBean(name={"apqCaffeineCache"})
        @NotNull
        public Cache<String, PreparsedDocumentEntry> apqCaffeineCache(@NotNull DgsAPQSupportProperties properties) {
            Cache cache;
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            if (!StringsKt.isBlank((CharSequence)properties.getDefaultCache().getCaffeineSpec())) {
                Cache cache2 = Caffeine.from((CaffeineSpec)CaffeineSpec.parse((String)properties.getDefaultCache().getCaffeineSpec())).build();
                Intrinsics.checkNotNull((Object)cache2);
                cache = cache2;
            } else {
                Cache cache3 = Caffeine.newBuilder().maximumSize(1000L).expireAfterAccess(Duration.ofHours(1L)).build();
                Intrinsics.checkNotNull((Object)cache3);
                cache = cache3;
            }
            return cache;
        }
    }

    @Configuration
    @ConditionalOnClass(name={"com.github.benmanes.caffeine.cache.Cache"})
    @ConditionalOnBean(value={MeterRegistry.class})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0014\b\u0001\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a8\u0006\f"}, d2={"Lcom/netflix/graphql/dgs/apq/DgsAPQSupportAutoConfiguration$APQMicrometerMeteredCaffeineCacheConfiguration;", "", "<init>", "()V", "meteredPersistedQueryCache", "Lgraphql/execution/preparsed/persisted/PersistedQueryCache;", "appCaffeine", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lgraphql/execution/preparsed/PreparsedDocumentEntry;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "graphql-dgs-spring-graphql"})
    public static class APQMicrometerMeteredCaffeineCacheConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={PersistedQueryCache.class})
        @NotNull
        public PersistedQueryCache meteredPersistedQueryCache(@Qualifier(value="apqCaffeineCache") @NotNull Cache<String, PreparsedDocumentEntry> appCaffeine, @NotNull MeterRegistry meterRegistry) {
            Intrinsics.checkNotNullParameter(appCaffeine, (String)"appCaffeine");
            Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
            Cache cache = CaffeineCacheMetrics.monitor((MeterRegistry)meterRegistry, appCaffeine, (String)DgsAPQSupportAutoConfiguration.BEAN_APQ_CAFFEINE_CACHE_NAME, (String[])new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"monitor(...)");
            Cache monitoredCache = cache;
            return new AutomatedPersistedQueryCaffeineCache((Cache<String, PreparsedDocumentEntry>)monitoredCache);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/graphql/dgs/apq/DgsAPQSupportAutoConfiguration$Companion;", "", "<init>", "()V", "BEAN_APQ_CAFFEINE_CACHE_NAME", "", "graphql-dgs-spring-graphql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

