/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.graphql.dgs.reactive.internal.method;

import com.netflix.graphql.dgs.context.DgsContext;
import com.netflix.graphql.dgs.internal.DgsRequestData;
import com.netflix.graphql.dgs.internal.method.ArgumentResolver;
import com.netflix.graphql.dgs.reactive.internal.DgsReactiveRequestData;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/netflix/graphql/dgs/reactive/internal/method/SyncHandlerMethodArgumentResolverAdapter;", "Lcom/netflix/graphql/dgs/internal/method/ArgumentResolver;", "delegate", "Lorg/springframework/web/reactive/result/method/SyncHandlerMethodArgumentResolver;", "bindingContext", "Lorg/springframework/web/reactive/BindingContext;", "<init>", "(Lorg/springframework/web/reactive/result/method/SyncHandlerMethodArgumentResolver;Lorg/springframework/web/reactive/BindingContext;)V", "supportsParameter", "", "parameter", "Lorg/springframework/core/MethodParameter;", "resolveArgument", "", "dfe", "Lgraphql/schema/DataFetchingEnvironment;", "graphql-dgs-reactive"})
public final class SyncHandlerMethodArgumentResolverAdapter
implements ArgumentResolver {
    @NotNull
    private final SyncHandlerMethodArgumentResolver delegate;
    @NotNull
    private final BindingContext bindingContext;

    public SyncHandlerMethodArgumentResolverAdapter(@NotNull SyncHandlerMethodArgumentResolver delegate, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        this.delegate = delegate;
        this.bindingContext = bindingContext;
    }

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return this.delegate.supportsParameter(parameter);
    }

    @Nullable
    public Object resolveArgument(@NotNull MethodParameter parameter, @NotNull DataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DgsRequestData dgsRequestData = DgsContext.Companion.getRequestData(dfe);
        DgsReactiveRequestData dgsReactiveRequestData = dgsRequestData instanceof DgsReactiveRequestData ? (DgsReactiveRequestData)dgsRequestData : null;
        if (dgsReactiveRequestData == null) {
            throw new IllegalStateException("DgsReactiveRequestData not found");
        }
        DgsReactiveRequestData requestData = dgsReactiveRequestData;
        ServerRequest serverRequest = requestData.getServerRequest();
        if (serverRequest == null) {
            throw new IllegalStateException("serverRequest is not set");
        }
        ServerRequest request = serverRequest;
        ServerWebExchange serverWebExchange = request.exchange();
        Intrinsics.checkNotNullExpressionValue((Object)serverWebExchange, (String)"exchange(...)");
        ServerWebExchange exchange = serverWebExchange;
        return this.delegate.resolveArgument(parameter, this.bindingContext, exchange).share().block();
    }
}

