/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.jetty;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.servlet.GuiceFilter;
import com.netflix.governator.DefaultLifecycleListener;
import com.netflix.governator.LifecycleListener;
import com.netflix.governator.LifecycleManager;
import com.netflix.governator.LifecycleShutdownSignal;
import com.netflix.governator.guice.jetty.DefaultJettyConfig;
import com.netflix.governator.guice.jetty.JettyConfig;
import com.netflix.governator.guice.jetty.JettyLifecycleShutdownSignal;
import java.util.EnumSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JettyModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(JettyModule.class);

    protected void configure() {
        this.bind(JettyRunner.class).asEagerSingleton();
        Multibinder.newSetBinder((Binder)this.binder(), LifecycleListener.class).addBinding().to(JettyShutdown.class);
        this.bind(LifecycleShutdownSignal.class).to(JettyLifecycleShutdownSignal.class);
    }

    @Provides
    @Singleton
    private JettyConfig getDefaultConfig() {
        return new DefaultJettyConfig();
    }

    @Provides
    @Singleton
    private Server getServer(JettyConfig config) {
        Server server = new Server(config.getPort());
        ServletContextHandler servletContextHandler = new ServletContextHandler((HandlerContainer)server, "/", 1);
        servletContextHandler.addFilter(GuiceFilter.class, "/*", EnumSet.allOf(DispatcherType.class));
        servletContextHandler.addServlet(DefaultServlet.class, "/");
        return server;
    }

    @Singleton
    public static class JettyShutdown
    extends DefaultLifecycleListener {
        private Server server;

        @Inject
        public JettyShutdown(Server server) {
            this.server = server;
        }

        public void onStopped() {
            LOG.info("Jetty Server shutting down");
            try {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JettyShutdown.this.server.stop();
                            LOG.info("Jetty Server shut down");
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to shut down Jetty server", (Throwable)e);
                        }
                    }
                });
                t.start();
            }
            catch (Exception e) {
                LOG.warn("Error shutting down Jetty server");
            }
        }
    }

    @Singleton
    public static class JettyRunner {
        @Inject
        public JettyRunner(Server server, LifecycleManager manager) {
            LOG.info("Jetty server starting");
            try {
                server.start();
                int port = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
                LOG.info("Jetty server on port {} started", (Object)port);
            }
            catch (Exception e) {
                try {
                    server.stop();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw new ProvisionException("Jetty server failed to start", (Throwable)e);
            }
        }
    }
}

