/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.guice.jetty;

import com.netflix.governator.AbstractLifecycleShutdownSignal;
import com.netflix.governator.LifecycleManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JettyLifecycleShutdownSignal
extends AbstractLifecycleShutdownSignal {
    private static final Logger LOG = LoggerFactory.getLogger(JettyLifecycleShutdownSignal.class);
    private final Server server;

    @Inject
    public JettyLifecycleShutdownSignal(Server server, LifecycleManager manager) {
        super(manager);
        this.server = server;
    }

    public void signal() {
        final int port = ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        LOG.info("Jetty Server on port {} shutting down", (Object)port);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JettyLifecycleShutdownSignal.this.shutdown();
                    JettyLifecycleShutdownSignal.this.server.stop();
                    LOG.info("Jetty Server on port {} shut down complete", (Object)port);
                }
                catch (Exception e) {
                    LOG.warn("Jetty Server on port {} failed to shut down", (Object)port, (Object)e);
                }
            }
        });
        t.setDaemon(true);
        t.start();
    }

    public void await() throws InterruptedException {
        int port = ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
        LOG.info("Joining Jetty server on port {}", (Object)port);
        this.server.join();
    }
}

