/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.es6.dao.query.parser.internal;

import com.netflix.conductor.es6.dao.query.parser.internal.AbstractNode;
import com.netflix.conductor.es6.dao.query.parser.internal.ParserException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

public class ListConst
extends AbstractNode {
    private List<Object> values;

    public ListConst(InputStream is) throws ParserException {
        super(is);
    }

    @Override
    protected void _parse() throws Exception {
        byte[] peeked = this.read(1);
        this.assertExpected(peeked, "(");
        this.values = this.readList();
    }

    private List<Object> readList() throws Exception {
        LinkedList<Object> list = new LinkedList<Object>();
        boolean valid = false;
        StringBuilder sb = new StringBuilder();
        while (this.is.available() > 0) {
            char c = (char)this.is.read();
            if (c == ')') {
                valid = true;
                break;
            }
            if (c == ',') {
                list.add(sb.toString().trim());
                sb = new StringBuilder();
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString().trim());
        if (!valid) {
            throw new ParserException("Expected ')' but never encountered in the stream");
        }
        return list;
    }

    public List<Object> getList() {
        return this.values;
    }

    public String toString() {
        return this.values.toString();
    }
}

