/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.conductor.es6.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.conductor.dao.IndexDAO;
import com.netflix.conductor.es6.config.ElasticSearchConditions;
import com.netflix.conductor.es6.config.ElasticSearchProperties;
import com.netflix.conductor.es6.config.IsHttpProtocol;
import com.netflix.conductor.es6.config.IsTcpProtocol;
import com.netflix.conductor.es6.dao.index.ElasticSearchDAOV6;
import com.netflix.conductor.es6.dao.index.ElasticSearchRestDAOV6;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ElasticSearchProperties.class})
@Conditional(value={ElasticSearchConditions.ElasticSearchV6Enabled.class})
public class ElasticSearchV6Configuration {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchV6Configuration.class);

    @Bean
    @Conditional(value={IsTcpProtocol.class})
    public Client client(ElasticSearchProperties properties) {
        Settings settings = Settings.builder().put("client.transport.ignore_cluster_name", true).put("client.transport.sniff", true).build();
        PreBuiltTransportClient transportClient = new PreBuiltTransportClient(settings, new Class[0]);
        List<URI> clusterAddresses = this.getURIs(properties);
        if (clusterAddresses.isEmpty()) {
            log.warn("workflow.elasticsearch.url is not set.  Indexing will remain DISABLED.");
        }
        for (URI hostAddress : clusterAddresses) {
            int port = Optional.ofNullable(hostAddress.getPort()).orElse(9200);
            try {
                transportClient.addTransportAddress(new TransportAddress(InetAddress.getByName(hostAddress.getHost()), port));
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid host" + hostAddress.getHost(), e);
            }
        }
        return transportClient;
    }

    @Bean
    @Conditional(value={IsHttpProtocol.class})
    public RestClient restClient(ElasticSearchProperties properties) {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])this.convertToHttpHosts(properties.toURLs()));
        if (properties.getRestClientConnectionRequestTimeout() > 0) {
            restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectionRequestTimeout(properties.getRestClientConnectionRequestTimeout()));
        }
        return restClientBuilder.build();
    }

    @Bean
    @Conditional(value={IsHttpProtocol.class})
    public RestClientBuilder restClientBuilder(ElasticSearchProperties properties) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.convertToHttpHosts(properties.toURLs()));
        if (properties.getUsername() != null && properties.getPassword() != null) {
            log.info("Configure ElasticSearch with BASIC authentication. User:{}", (Object)properties.getUsername());
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(properties.getUsername(), properties.getPassword()));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticSearchV6Configuration.lambda$restClientBuilder$1((CredentialsProvider)credentialsProvider, arg_0));
        } else {
            log.info("Configure ElasticSearch with no authentication.");
        }
        return builder;
    }

    @Bean
    @Conditional(value={IsHttpProtocol.class})
    public IndexDAO es6IndexRestDAO(RestClientBuilder restClientBuilder, ElasticSearchProperties properties, @Qualifier(value="es6RetryTemplate") RetryTemplate retryTemplate, ObjectMapper objectMapper) {
        return new ElasticSearchRestDAOV6(restClientBuilder, retryTemplate, properties, objectMapper);
    }

    @Bean
    @Conditional(value={IsTcpProtocol.class})
    public IndexDAO es6IndexDAO(Client client, @Qualifier(value="es6RetryTemplate") RetryTemplate retryTemplate, ElasticSearchProperties properties, ObjectMapper objectMapper) {
        return new ElasticSearchDAOV6(client, retryTemplate, properties, objectMapper);
    }

    @Bean
    public RetryTemplate es6RetryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        FixedBackOffPolicy fixedBackOffPolicy = new FixedBackOffPolicy();
        fixedBackOffPolicy.setBackOffPeriod(1000L);
        retryTemplate.setBackOffPolicy((BackOffPolicy)fixedBackOffPolicy);
        return retryTemplate;
    }

    private HttpHost[] convertToHttpHosts(List<URL> hosts) {
        return (HttpHost[])hosts.stream().map(host -> new HttpHost(host.getHost(), host.getPort(), host.getProtocol())).toArray(HttpHost[]::new);
    }

    public List<URI> getURIs(ElasticSearchProperties properties) {
        String clusterAddress = properties.getUrl();
        String[] hosts = clusterAddress.split(",");
        return Arrays.stream(hosts).map(host -> host.startsWith("http://") || host.startsWith("https://") || host.startsWith("tcp://") ? URI.create(host) : URI.create("tcp://" + host)).collect(Collectors.toList());
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$restClientBuilder$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

