/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.monitor;

import com.nepxion.discovery.plugin.strategy.service.monitor.ServiceStrategyMonitor;
import com.nepxion.matrix.proxy.aop.AbstractInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.InitBinder;

public class ServiceStrategyMonitorInterceptor
extends AbstractInterceptor {
    @Value(value="${spring.application.strategy.tracer.method.context.output.enabled:false}")
    protected Boolean tracerMethodContextOutputEnabled;
    @Autowired(required=false)
    protected ServiceStrategyMonitor serviceStrategyMonitor;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        boolean hasInitBinderAnnotation = this.getMethod(invocation).isAnnotationPresent(InitBinder.class);
        if (hasInitBinderAnnotation) {
            return invocation.proceed();
        }
        String className = this.getMethod(invocation).getDeclaringClass().getName();
        String methodName = this.getMethodName(invocation);
        boolean isMonitored = false;
        boolean isMethodContextMonitored = false;
        try {
            if (StringUtils.equals((CharSequence)className, (CharSequence)"com.nepxion.discovery.plugin.admincenter.endpoint.InspectorEndpoint") && StringUtils.equals((CharSequence)methodName, (CharSequence)"inspect")) {
                if (this.serviceStrategyMonitor != null) {
                    this.serviceStrategyMonitor.monitor(this, invocation);
                    isMonitored = true;
                    this.serviceStrategyMonitor.monitor(this, invocation, "* ignored");
                    isMethodContextMonitored = true;
                }
                Object object = invocation.proceed();
                return object;
            }
            if (this.serviceStrategyMonitor != null) {
                this.serviceStrategyMonitor.monitor(this, invocation);
                isMonitored = true;
            }
            Object returnValue = null;
            if (this.tracerMethodContextOutputEnabled.booleanValue()) {
                returnValue = invocation.proceed();
                if (this.serviceStrategyMonitor != null) {
                    this.serviceStrategyMonitor.monitor(this, invocation, returnValue);
                    isMethodContextMonitored = true;
                }
            } else {
                if (this.serviceStrategyMonitor != null) {
                    this.serviceStrategyMonitor.monitor(this, invocation, returnValue);
                    isMethodContextMonitored = true;
                }
                returnValue = invocation.proceed();
            }
            Object object = returnValue;
            return object;
        }
        catch (Throwable e) {
            if (this.serviceStrategyMonitor != null) {
                if (!isMonitored) {
                    this.serviceStrategyMonitor.monitor(this, invocation);
                }
                if (!isMethodContextMonitored) {
                    this.serviceStrategyMonitor.monitor(this, invocation, null);
                }
                this.serviceStrategyMonitor.error(this, invocation, e);
            }
            throw e;
        }
        finally {
            if (this.serviceStrategyMonitor != null) {
                this.serviceStrategyMonitor.release(this, invocation);
            }
        }
    }
}

