/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections4.MapUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class ServiceStrategyRouteFilterRequest
extends HttpServletRequestWrapper {
    private HttpServletRequest originalRequest;
    private Map<String, String> headers;

    public ServiceStrategyRouteFilterRequest(HttpServletRequest request) {
        super(request);
        this.originalRequest = request;
        this.headers = new LinkedCaseInsensitiveMap();
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        if (this.headers.containsKey(name)) {
            return this.headers.get(name);
        }
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        if (MapUtils.isNotEmpty(this.headers)) {
            ArrayList names = Collections.list(super.getHeaderNames());
            for (String name : this.headers.keySet()) {
                if (names.contains(name)) continue;
                names.add(name);
            }
            return Collections.enumeration(names);
        }
        return super.getHeaderNames();
    }

    public Enumeration<String> getHeaders(String name) {
        if (this.headers.containsKey(name)) {
            List<String> values = Arrays.asList(this.headers.get(name));
            return Collections.enumeration(values);
        }
        return super.getHeaders(name);
    }

    public HttpServletRequest getOriginalRequest() {
        return this.originalRequest;
    }
}

