/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.filter;

import com.nepxion.discovery.common.util.StringUtil;
import com.nepxion.discovery.plugin.strategy.service.filter.ServiceStrategyFilterExclusion;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class DefaultServiceStrategyFilterExclusion
implements ServiceStrategyFilterExclusion {
    @Value(value="${spring.application.strategy.uri.filter.exclusion:/actuator/}")
    protected String uriFilterExclusion;
    protected List<String> uriFilterExclusionList = new ArrayList<String>();

    @PostConstruct
    private void initialize() {
        if (StringUtils.isNotEmpty((CharSequence)this.uriFilterExclusion)) {
            this.uriFilterExclusionList = StringUtil.splitToList((String)this.uriFilterExclusion);
        }
    }

    @Override
    public boolean isExclusion(HttpServletRequest request, HttpServletResponse response) {
        String requestURI = request.getRequestURI();
        for (String uriFilterExclusionValue : this.uriFilterExclusionList) {
            if (!requestURI.contains(uriFilterExclusionValue)) continue;
            return true;
        }
        return false;
    }
}

