/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.filter;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.service.filter.ServiceStrategyFilterExclusion;
import com.nepxion.discovery.plugin.strategy.service.filter.ServiceStrategyFilterResolver;
import com.nepxion.discovery.plugin.strategy.service.filter.ServiceStrategyRouteFilter;
import com.nepxion.discovery.plugin.strategy.service.filter.ServiceStrategyRouteFilterRequest;
import com.nepxion.discovery.plugin.strategy.wrapper.StrategyWrapper;
import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractServiceStrategyRouteFilter
extends ServiceStrategyRouteFilter {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyWrapper strategyWrapper;
    @Autowired
    protected ServiceStrategyFilterExclusion serviceStrategyFilterExclusion;
    @Value(value="${spring.application.strategy.service.header.priority:true}")
    protected Boolean serviceHeaderPriority;
    @Value(value="${spring.application.strategy.feign.core.header.transmission.enabled:true}")
    protected Boolean feignCoreHeaderTransmissionEnabled;
    @Value(value="${spring.application.strategy.rest.template.core.header.transmission.enabled:true}")
    protected Boolean restTemplateCoreHeaderTransmissionEnabled;
    @Value(value="${spring.application.strategy.service.route.filter.order:0}")
    protected Integer filterOrder;

    public int getOrder() {
        return this.filterOrder;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean isExclusion = this.serviceStrategyFilterExclusion.isExclusion(request, response);
        if (isExclusion) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ServiceStrategyRouteFilterRequest serviceStrategyRouteFilterRequest = new ServiceStrategyRouteFilterRequest(request);
        this.applyInnerHeader(serviceStrategyRouteFilterRequest);
        this.applyOuterHeader(serviceStrategyRouteFilterRequest);
        filterChain.doFilter((ServletRequest)serviceStrategyRouteFilterRequest, (ServletResponse)response);
    }

    private void applyInnerHeader(ServiceStrategyRouteFilterRequest serviceStrategyRouteFilterRequest) {
    }

    private void applyOuterHeader(ServiceStrategyRouteFilterRequest serviceStrategyRouteFilterRequest) {
        String routeEnvironment = this.getRouteEnvironment();
        if (StringUtils.isNotEmpty((CharSequence)routeEnvironment)) {
            ServiceStrategyFilterResolver.setHeader(serviceStrategyRouteFilterRequest, "n-d-env", routeEnvironment, false);
        }
        if (this.feignCoreHeaderTransmissionEnabled.booleanValue() || this.restTemplateCoreHeaderTransmissionEnabled.booleanValue()) {
            Map headerMap = this.strategyWrapper.getHeaderMap();
            if (MapUtils.isNotEmpty((Map)headerMap)) {
                for (Map.Entry entry : headerMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    ServiceStrategyFilterResolver.setHeader(serviceStrategyRouteFilterRequest, key, value, this.serviceHeaderPriority);
                }
            }
            String routeVersion = this.getRouteVersion();
            String routeRegion = this.getRouteRegion();
            String routeAddress = this.getRouteAddress();
            String routeVersionWeight = this.getRouteVersionWeight();
            String routeRegionWeight = this.getRouteRegionWeight();
            String routeIdBlacklist = this.getRouteIdBlacklist();
            String routeAddressBlacklist = this.getRouteAddressBlacklist();
            if (StringUtils.isNotEmpty((CharSequence)routeVersion)) {
                ServiceStrategyFilterResolver.setHeader(serviceStrategyRouteFilterRequest, "n-d-version", routeVersion, this.serviceHeaderPriority);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeRegion)) {
                ServiceStrategyFilterResolver.setHeader(serviceStrategyRouteFilterRequest, "n-d-region", routeRegion, this.serviceHeaderPriority);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeAddress)) {
                ServiceStrategyFilterResolver.setHeader(serviceStrategyRouteFilterRequest, "n-d-address", routeAddress, this.serviceHeaderPriority);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeVersionWeight)) {
                ServiceStrategyFilterResolver.setHeader(serviceStrategyRouteFilterRequest, "n-d-version-weight", routeVersionWeight, this.serviceHeaderPriority);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeRegionWeight)) {
                ServiceStrategyFilterResolver.setHeader(serviceStrategyRouteFilterRequest, "n-d-region-weight", routeRegionWeight, this.serviceHeaderPriority);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeIdBlacklist)) {
                ServiceStrategyFilterResolver.setHeader(serviceStrategyRouteFilterRequest, "n-d-id-blacklist", routeIdBlacklist, this.serviceHeaderPriority);
            }
            if (StringUtils.isNotEmpty((CharSequence)routeAddressBlacklist)) {
                ServiceStrategyFilterResolver.setHeader(serviceStrategyRouteFilterRequest, "n-d-address-blacklist", routeAddressBlacklist, this.serviceHeaderPriority);
            }
        }
    }

    public PluginAdapter getPluginAdapter() {
        return this.pluginAdapter;
    }
}

