/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.context;

import com.nepxion.discovery.plugin.strategy.context.AbstractStrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.service.context.RestStrategyContext;
import com.nepxion.discovery.plugin.strategy.service.context.RpcStrategyContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServiceStrategyContextHolder
extends AbstractStrategyContextHolder {
    @Value(value="${spring.application.strategy.service.header.priority:true}")
    protected Boolean serviceHeaderPriority;

    public ServletRequestAttributes getRestAttributes() {
        RequestAttributes requestAttributes = RestStrategyContext.getCurrentContext().getRequestAttributes();
        if (requestAttributes == null) {
            requestAttributes = RequestContextHolder.getRequestAttributes();
        }
        return (ServletRequestAttributes)requestAttributes;
    }

    public Map<String, Object> getRpcAttributes() {
        return RpcStrategyContext.getCurrentContext().getAttributes();
    }

    public HttpServletRequest getHttpServletRequest() {
        ServletRequestAttributes attributes = this.getRestAttributes();
        if (attributes == null) {
            return null;
        }
        HttpServletRequest request = attributes.getRequest();
        if (request == null) {
            return null;
        }
        return request;
    }

    public Enumeration<String> getHeaderNames() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return null;
        }
        Enumeration headerNames = request.getHeaderNames();
        Map headerMap = this.strategyWrapper.getHeaderMap();
        if (MapUtils.isNotEmpty((Map)headerMap)) {
            ArrayList headerNameList = Collections.list(headerNames);
            for (Map.Entry entry : headerMap.entrySet()) {
                String headerName = (String)entry.getKey();
                if (headerNameList.contains(headerName)) continue;
                headerNameList.add(headerName);
            }
            return Collections.enumeration(headerNameList);
        }
        return headerNames;
    }

    public String getHeader(String name) {
        if (this.serviceHeaderPriority.booleanValue()) {
            HttpServletRequest request;
            String header = this.strategyWrapper.getHeader(name);
            if (StringUtils.isEmpty((CharSequence)header) && (request = this.getHttpServletRequest()) != null) {
                header = request.getHeader(name);
            }
            return header;
        }
        String header = null;
        HttpServletRequest request = this.getHttpServletRequest();
        if (request != null) {
            header = request.getHeader(name);
        }
        if (StringUtils.isEmpty(header)) {
            header = this.strategyWrapper.getHeader(name);
        }
        return header;
    }

    public String getParameter(String name) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return null;
        }
        return request.getParameter(name);
    }

    public Cookie getHttpCookie(String name) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            String cookieName = cookie.getName();
            if (!StringUtils.equals((CharSequence)cookieName, (CharSequence)name)) continue;
            return cookie;
        }
        return null;
    }

    public String getCookie(String name) {
        Cookie cookie = this.getHttpCookie(name);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public String getRequestURL() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return null;
        }
        return request.getRequestURL().toString();
    }

    public String getRequestURI() {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            return null;
        }
        return request.getRequestURI();
    }
}

