/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.service.configuration;

import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.strategy.extractor.StrategyPackagesExtractor;
import com.nepxion.discovery.plugin.strategy.service.filter.DefaultServiceStrategyFilterExclusion;
import com.nepxion.discovery.plugin.strategy.service.filter.DefaultServiceStrategyRouteFilter;
import com.nepxion.discovery.plugin.strategy.service.filter.ServiceStrategyFilterExclusion;
import com.nepxion.discovery.plugin.strategy.service.filter.ServiceStrategyRouteFilter;
import com.nepxion.discovery.plugin.strategy.service.isolation.ServiceProviderIsolationStrategyAutoScanProxy;
import com.nepxion.discovery.plugin.strategy.service.isolation.ServiceProviderIsolationStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.service.monitor.DefaultServiceStrategyMonitor;
import com.nepxion.discovery.plugin.strategy.service.monitor.ServiceStrategyMonitor;
import com.nepxion.discovery.plugin.strategy.service.monitor.ServiceStrategyMonitorAutoScanProxy;
import com.nepxion.discovery.plugin.strategy.service.monitor.ServiceStrategyMonitorInterceptor;
import com.nepxion.discovery.plugin.strategy.service.rpc.ServiceRpcStrategyAutoScanProxy;
import com.nepxion.discovery.plugin.strategy.service.rpc.ServiceRpcStrategyInterceptor;
import com.nepxion.discovery.plugin.strategy.service.wrapper.DefaultServiceStrategyCallableWrapper;
import com.nepxion.discovery.plugin.strategy.service.wrapper.ServiceStrategyCallableWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@AutoConfigureBefore(value={RibbonClientConfiguration.class})
public class ServiceStrategyAutoConfiguration {
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private StrategyPackagesExtractor strategyPackagesExtractor;

    @Bean
    @ConditionalOnProperty(value={"spring.application.strategy.rpc.intercept.enabled"}, matchIfMissing=false)
    public ServiceRpcStrategyAutoScanProxy serviceRpcStrategyAutoScanProxy() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            scanPackages = this.strategyPackagesExtractor.getAllPackages();
        }
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new ServiceRpcStrategyAutoScanProxy(scanPackages);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.application.strategy.rpc.intercept.enabled"}, matchIfMissing=false)
    public ServiceRpcStrategyInterceptor serviceRpcStrategyInterceptor() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            scanPackages = this.strategyPackagesExtractor.getAllPackages();
        }
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new ServiceRpcStrategyInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.provider.isolation.enabled"}, matchIfMissing=false)
    public ServiceProviderIsolationStrategyAutoScanProxy serviceProviderIsolationStrategyAutoScanProxy() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            scanPackages = this.strategyPackagesExtractor.getAllPackages();
        }
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new ServiceProviderIsolationStrategyAutoScanProxy(scanPackages);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.provider.isolation.enabled"}, matchIfMissing=false)
    public ServiceProviderIsolationStrategyInterceptor serviceProviderIsolationStrategyInterceptor() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            scanPackages = this.strategyPackagesExtractor.getAllPackages();
        }
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new ServiceProviderIsolationStrategyInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceStrategyRouteFilter serviceStrategyRouteFilter() {
        return new DefaultServiceStrategyRouteFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceStrategyFilterExclusion serviceStrategyFilterExclusion() {
        return new DefaultServiceStrategyFilterExclusion();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.monitor.enabled"}, matchIfMissing=false)
    public ServiceStrategyMonitor serviceStrategyMonitor() {
        return new DefaultServiceStrategyMonitor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.monitor.enabled"}, matchIfMissing=false)
    public ServiceStrategyMonitorAutoScanProxy serviceStrategyMonitorAutoScanProxy() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            scanPackages = this.strategyPackagesExtractor.getAllPackages();
        }
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new ServiceStrategyMonitorAutoScanProxy(scanPackages.endsWith(";") ? scanPackages + "com.nepxion.discovery.plugin.admincenter.endpoint" : scanPackages + ";" + "com.nepxion.discovery.plugin.admincenter.endpoint");
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.monitor.enabled"}, matchIfMissing=false)
    public ServiceStrategyMonitorInterceptor serviceStrategyMonitorInterceptor() {
        String scanPackages = this.environment.getProperty("spring.application.strategy.scan.packages");
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            scanPackages = this.strategyPackagesExtractor.getAllPackages();
        }
        if (StringUtils.isEmpty((CharSequence)scanPackages)) {
            throw new DiscoveryException("spring.application.strategy.scan.packages's value can't be empty");
        }
        if (scanPackages.contains("com.nepxion.discovery.plugin.admincenter.endpoint")) {
            throw new DiscoveryException("It can't scan packages for 'com.nepxion.discovery.plugin.admincenter.endpoint', please check 'spring.application.strategy.scan.packages'");
        }
        return new ServiceStrategyMonitorInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.application.strategy.hystrix.threadlocal.supported"}, matchIfMissing=false)
    public ServiceStrategyCallableWrapper serviceStrategyCallableWrapper() {
        return new DefaultServiceStrategyCallableWrapper();
    }
}

