/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.EnumSet;
import java.util.Objects;

public enum ByteSizeUnit {
    BYTES(new String[]{"B", "b"}, 1L),
    KILO_BYTES(new String[]{"K", "k", "KB"}, 1024L),
    MEGA_BYTES(new String[]{"M", "m", "MB"}, 0x100000L),
    GIGA_BYTES(new String[]{"G", "g", "GB"}, 0x40000000L),
    TERA_BYTES(new String[]{"T", "t", "TB"}, 0x10000000000L);

    private static final EnumSet<ByteSizeUnit> ALL;
    private static final long BYTES_SIZE = 1L;
    private static final long KILO_SIZE = 1024L;
    private static final long MEGA_SIZE = 0x100000L;
    private static final long GIGA_SIZE = 0x40000000L;
    private static final long TERA_SIZE = 0x10000000000L;
    private final String[] units;
    private final long unitSize;
    private final long maxSize;
    private final long intMaxSize;

    private ByteSizeUnit(String[] units, long unitSize) {
        this.units = Objects.requireNonNull(units, "units");
        this.unitSize = unitSize;
        this.maxSize = Long.MAX_VALUE / unitSize;
        this.intMaxSize = Integer.MAX_VALUE / unitSize;
    }

    public long toBytesSize(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value < 0");
        }
        if (value > this.maxSize) {
            throw new IllegalArgumentException("value > " + this.maxSize);
        }
        return value * this.unitSize;
    }

    public int toBytesSizeAsInt(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value < 0");
        }
        if (value > this.intMaxSize) {
            throw new IllegalArgumentException("value > " + this.intMaxSize);
        }
        return (int)(value * this.unitSize);
    }

    String getUnitChar1() {
        return this.units[0];
    }

    String getUnitChar2() {
        return this.units[1];
    }

    public long getUnitSize() {
        return this.unitSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public static long getByteSize(String value, long defaultValue) {
        try {
            return ByteSizeUnit.getByteSize(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static long getByteSize(String value) {
        if (StringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("size must not be empty");
        }
        if (ByteSizeUnit.endWithDataUnit(ByteSizeUnit.BYTES.units, value)) {
            return ByteSizeUnit.getByteSize0(value.substring(0, value.length() - 1));
        }
        return ByteSizeUnit.getByteSize0(value);
    }

    private static boolean endWithDataUnit(String[] units, String value) {
        for (String unit : units) {
            if (!value.endsWith(unit)) continue;
            return true;
        }
        return false;
    }

    private static long getByteSize0(String value) {
        if (StringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("size must not be empty");
        }
        for (ByteSizeUnit byteSizeUnit : ALL) {
            if (byteSizeUnit == BYTES || !ByteSizeUnit.endWithDataUnit(byteSizeUnit.units, value)) continue;
            long numberValue = ByteSizeUnit.getLong(value.substring(0, value.length() - 1));
            return byteSizeUnit.toBytesSize(numberValue);
        }
        long numberValue = ByteSizeUnit.getLong(value);
        return BYTES.toBytesSize(numberValue);
    }

    private static long getLong(String value) {
        try {
            return Long.parseLong(value, 10);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    static {
        ALL = EnumSet.allOf(ByteSizeUnit.class);
    }
}

