/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.internal.listeners;

import android.content.ContentValues;
import android.content.Context;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mparticle.SdkListener;
import com.mparticle.identity.AliasResponse;
import com.mparticle.internal.InternalSession;
import com.mparticle.internal.MPUtility;
import com.mparticle.internal.listeners.GraphListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class InternalListenerManager
implements com.mparticle.l {
    private static InternalListenerManager instance;
    private static final String INTERNAL_LISTENER_PROP = "debug.mparticle.listener";
    private Context context;
    final List<WeakReference<SdkListener>> sdkListeners;
    final List<WeakReference<GraphListener>> graphListeners;
    private boolean thrown;

    /*
     * WARNING - void declaration
     */
    private InternalListenerManager(Context context) {
        void var1_1;
        ArrayList arrayList;
        ArrayList arrayList2;
        Object this_ = arrayList2;
        arrayList2 = new ArrayList();
        v1.sdkListeners = this_;
        this_ = arrayList;
        arrayList = new ArrayList();
        v1.graphListeners = this_;
        v1.thrown = false;
        v1.context = var1_1;
    }

    @Nullable
    public static InternalListenerManager start(Context context) {
        Context context2;
        boolean bl = MPUtility.isAppDebuggable(context) || context2.getPackageName().equals(MPUtility.getProp(INTERNAL_LISTENER_PROP));
        if (instance == null && context2 != null && bl) {
            instance = new InternalListenerManager(context2.getApplicationContext());
        }
        return instance;
    }

    public static boolean isEnabled() {
        InternalListenerManager internalListenerManager = instance;
        return internalListenerManager != null && internalListenerManager.hasListeners();
    }

    @NonNull
    public static com.mparticle.l getListener() {
        if (instance != null && InternalListenerManager.isEnabled()) {
            return instance;
        }
        return com.mparticle.l.a;
    }

    /*
     * WARNING - void declaration
     */
    private void onKitApiCalled(StackTraceElement[] stackTrace, String methodName, int kitId, boolean used, Object ... objects) {
        void var4_4;
        void var2_2;
        void var3_3;
        n n2;
        n n3;
        ArrayList<void> arrayList;
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<void> arrayList2 = arrayList;
        arrayList = new ArrayList<void>();
        int n4 = objects.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            void var5_5;
            arrayList2.add(var5_5[i2]);
        }
        for (int i3 = 0; i3 < ((void)n3).length; ++i3) {
            if (!this.isExternalApiInvocation((StackTraceElement)n3[i3])) {
                bl = true;
            }
            if (bl && !bl2 && this.isExternalApiInvocation((StackTraceElement)((Object)n3[i3]))) {
                string = this.getApiName((StackTraceElement)((Object)n3[i3 - 1]));
                bl2 = true;
            }
            if (!((StackTraceElement)((Object)n3[i3])).getClassName().equals("com.mparticle.kits.KitManagerImpl")) continue;
            string2 = this.getApiName((StackTraceElement)((Object)n3[i3]));
        }
        n3 = n2;
        n2 = new n(this, (int)var3_3, (String)var2_2, string, string2, arrayList2, (boolean)var4_4){
            final /* synthetic */ int a;
            final /* synthetic */ String b;
            final /* synthetic */ String c;
            final /* synthetic */ String d;
            final /* synthetic */ List e;
            final /* synthetic */ boolean f;
            final /* synthetic */ InternalListenerManager g;
            {
                void var1_1;
                this.g = var1_1;
                this.a = n2;
                this.b = string;
                this.c = string2;
                this.d = string3;
                this.e = list;
                this.f = bl;
            }

            @Override
            public void a(SdkListener listener) {
                d d2 = this;
                int n2 = d2.a;
                String string = d2.b;
                String string2 = d2.c;
                String string3 = d2.d;
                List list = d2.e;
                boolean bl = d2.f;
                listener.onKitApiCalled(n2, string, string2, string3, list, bl);
            }
        };
        this.broadcast(n3);
    }

    /*
     * WARNING - void declaration
     */
    private void broadcast(n runnable) {
        for (WeakReference<SdkListener> weakReference : new ArrayList<WeakReference<SdkListener>>(this.sdkListeners)) {
            void var1_1;
            SdkListener sdkListener = (SdkListener)weakReference.get();
            if (sdkListener == null) {
                this.sdkListeners.remove(weakReference);
                continue;
            }
            var1_1.a(sdkListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void broadcast(m runnable) {
        for (WeakReference<GraphListener> weakReference : new ArrayList<WeakReference<GraphListener>>(this.graphListeners)) {
            void var1_1;
            GraphListener graphListener = (GraphListener)weakReference.get();
            if (graphListener == null) {
                this.graphListeners.remove(weakReference);
                continue;
            }
            var1_1.a(graphListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String getApiName(StackTraceElement element) {
        void var1_1;
        InternalListenerManager internalListenerManager = this_;
        void v1 = var1_1;
        String this_ = v1.getClassName();
        return InternalListenerManager.getApiFormattedName(internalListenerManager.getClassName(this_, v1.getMethodName()), var1_1.getMethodName());
    }

    /*
     * WARNING - void declaration
     */
    public static String getApiFormattedName(String className, String methodName) {
        void var1_1;
        String string;
        return string + "." + (String)var1_1 + "()";
    }

    /*
     * WARNING - void declaration
     */
    private String getClassName(String className, String methodName) {
        Object object;
        String[] stringArray = ((String)object).split("\\.");
        String string = stringArray[stringArray.length - 1];
        if (this.isObfuscated(string)) {
            int n2;
            ArrayList arrayList;
            void v1 = object;
            object = arrayList;
            arrayList = new ArrayList();
            Class<?> clazz = Class.forName((String)v1);
            object.add(clazz.getSuperclass());
            Object object2 = clazz.getInterfaces();
            int n3 = ((Class<?>[])object2).length;
            for (n2 = 0; n2 < n3; ++n2) {
                object.add(object2[n2]);
            }
            try {
                object = object.iterator();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            block16: while (true) {
                if (!object.hasNext()) break;
                object2 = (Class)object.next();
                Method[] methodArray = ((Class)object2).getMethods();
                n2 = methodArray.length;
                int n4 = 0;
                while (true) {
                    block20: {
                        void var2_2;
                        if (n4 >= n2) continue block16;
                        if (!methodArray[n4].getName().equals(var2_2)) break block20;
                        InternalListenerManager internalListenerManager = this;
                        InternalListenerManager internalListenerManager2 = internalListenerManager;
                        String string2 = internalListenerManager.getClassName(((Class)object2).getName(), (String)var2_2);
                        if (internalListenerManager2.isObfuscated(string2)) break block20;
                        return string2;
                    }
                    ++n4;
                }
                break;
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isObfuscated(@NonNull String className) {
        void var1_1;
        return Character.isLowerCase(className.toCharArray()[0]) && var1_1.length() <= 3;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isExternalApiInvocation(StackTraceElement element) {
        void var1_1;
        return !element.getClassName().startsWith("com.mparticle") || var1_1.getClassName().startsWith(this.context.getApplicationContext().getPackageName()) && this.context.getApplicationContext().getPackageName().length() > 1;
    }

    private boolean hasListeners() {
        return InternalListenerManager.instance.sdkListeners.size() > 0 || InternalListenerManager.instance.graphListeners.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public void addListener(SdkListener sdkListener) {
        void var1_1;
        Iterator<WeakReference<SdkListener>> iterator = this.sdkListeners.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().get() != var1_1) continue;
            return;
        }
        this.sdkListeners.add(new WeakReference<void>(var1_1));
        if (var1_1 instanceof GraphListener) {
            this.graphListeners.add(new WeakReference<GraphListener>((GraphListener)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeListener(SdkListener sdkListener) {
        void var1_1;
        for (WeakReference<SdkListener> weakReference : new ArrayList<WeakReference<SdkListener>>(this.sdkListeners)) {
            if (weakReference.get() != var1_1) continue;
            this.sdkListeners.remove(weakReference);
        }
        for (WeakReference<Object> weakReference : new ArrayList<WeakReference<GraphListener>>(this.graphListeners)) {
            if (weakReference.get() != var1_1) continue;
            this.graphListeners.remove(weakReference);
        }
    }

    public void onApiCalled(Object ... objects) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onKitApiCalled(int kitId, Boolean used, Object ... objects) {
        void var3_4;
        void var1_2;
        void var2_3;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = null;
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            if (!stackTraceElement.getClassName().equals(com.mparticle.internal.d.class.getName())) continue;
            string = stackTraceElement.getMethodName() + "()";
        }
        boolean bl = var2_3.booleanValue();
        this.onKitApiCalled(stackTraceElementArray, string, (int)var1_2, bl, (Object[])var3_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onKitApiCalled(String methodName, int kitId, Boolean used, Object ... objects) {
        void var4_5;
        void var2_2;
        void var1_1;
        void var3_3;
        StackTraceElement[] stackTraceElementArray = this_;
        StackTraceElement[] this_ = Thread.currentThread().getStackTrace();
        boolean bl = var3_3.booleanValue();
        super.onKitApiCalled(this_, (String)var1_1, (int)var2_2, bl, (Object[])var4_5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onCompositeObjects(Object child, Object parent) {
        void var2_2;
        void var1_1;
        m m2;
        m m3 = m2;
        m2 = new m(this, var1_1, var2_2){
            final /* synthetic */ Object a;
            final /* synthetic */ Object b;
            final /* synthetic */ InternalListenerManager c;
            {
                void var1_1;
                this.c = var1_1;
                this.a = object;
                this.b = object2;
            }

            @Override
            public void a(GraphListener listener) {
                e e2 = object;
                Object object = e2.a;
                listener.onCompositeObjects(object, e2.b);
            }
        };
        this.broadcast(m3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onThreadMessage(String handlerName, Message msg, boolean onNewThread) {
        void var3_3;
        void var2_2;
        void var1_1;
        m m2;
        StackTraceElement[] stackTraceElementArray = null;
        if (!onNewThread) {
            stackTraceElementArray = Thread.currentThread().getStackTrace();
        }
        m m3 = m2;
        m2 = new m(this, (String)var1_1, (Message)var2_2, (boolean)var3_3, stackTraceElementArray){
            final /* synthetic */ String a;
            final /* synthetic */ Message b;
            final /* synthetic */ boolean c;
            final /* synthetic */ StackTraceElement[] d;
            final /* synthetic */ InternalListenerManager e;
            {
                void var1_1;
                this.e = var1_1;
                this.a = string;
                this.b = message;
                this.c = bl;
                this.d = stackTraceElementArray;
            }

            @Override
            public void a(GraphListener listener) {
                f f2 = string;
                String string = f2.a;
                Message message = f2.b;
                boolean bl = f2.c;
                StackTraceElement[] stackTraceElementArray = f2.d;
                listener.onThreadMessage(string, message, bl, stackTraceElementArray);
            }
        };
        this.broadcast(m3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onEntityStored(Long primaryKey, String tableName, ContentValues contentValues) {
        SdkListener.DatabaseTable databaseTable;
        JSONObject jSONObject;
        void var1_1;
        JSONObject jSONObject2;
        Object object;
        this.onCompositeObjects(object, (String)jSONObject2 + var1_1);
        jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        try {
            databaseTable = SdkListener.DatabaseTable.valueOf(tableName.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            databaseTable = SdkListener.DatabaseTable.UNKNOWN;
        }
        object = object.valueSet().iterator();
        while (true) {
            if (!object.hasNext()) {
                n n2;
                object = n2;
                n2 = new n(this, databaseTable, (Long)var1_1, jSONObject2){
                    final /* synthetic */ SdkListener.DatabaseTable a;
                    final /* synthetic */ Long b;
                    final /* synthetic */ JSONObject c;
                    final /* synthetic */ InternalListenerManager d;
                    {
                        void var1_1;
                        this.d = var1_1;
                        this.a = databaseTable;
                        this.b = l2;
                        this.c = jSONObject;
                    }

                    @Override
                    public void a(SdkListener listener) {
                        g g2 = object;
                        Object object = g2.a;
                        long l2 = g2.b;
                        JSONObject jSONObject = g2.c;
                        listener.onEntityStored((SdkListener.DatabaseTable)((Object)object), l2, jSONObject);
                    }
                };
                this.broadcast((n)object);
                return;
            }
            Object object2 = (Map.Entry)object.next();
            try {
                JSONObject jSONObject3;
                if (object2.getValue() == null) {
                    jSONObject3 = jSONObject2.put((String)object2.getKey(), JSONObject.NULL);
                    continue;
                }
                Map.Entry entry = object2;
                object2 = (String)entry.getKey();
                jSONObject3 = jSONObject2.put((String)object2, entry.getValue());
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onNetworkRequestStarted(SdkListener.Endpoint type, String url, JSONObject body, Object ... objects) {
        void var2_2;
        void var1_1;
        n n2;
        ArrayList<void> arrayList;
        void var3_3;
        n n3;
        int n4;
        int n5 = objects.length;
        for (n4 = 0; n4 < n5; ++n4) {
            this.onCompositeObjects(n3[n4], var3_3);
        }
        ArrayList<void> arrayList2 = arrayList;
        arrayList = new ArrayList<void>();
        n4 = ((void)n3).length;
        for (int i2 = 0; i2 < n4; ++i2) {
            arrayList2.add(n3[i2]);
        }
        n3 = n2;
        n2 = new n(this, (SdkListener.Endpoint)var1_1, (String)var2_2, (JSONObject)var3_3){
            final /* synthetic */ SdkListener.Endpoint a;
            final /* synthetic */ String b;
            final /* synthetic */ JSONObject c;
            final /* synthetic */ InternalListenerManager d;
            {
                void var1_1;
                this.d = var1_1;
                this.a = endpoint;
                this.b = string;
                this.c = jSONObject;
            }

            @Override
            public void a(SdkListener listener) {
                h h2 = object;
                Object object = h2.a;
                String string = h2.b;
                JSONObject jSONObject = h2.c;
                listener.onNetworkRequestStarted((SdkListener.Endpoint)((Object)object), string, jSONObject);
            }
        };
        this.broadcast(n3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onNetworkRequestFinished(SdkListener.Endpoint type, String url, JSONObject response, int responseCode) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        n n2;
        n n3 = n2;
        n2 = new n(this, (SdkListener.Endpoint)var1_1, (String)var2_2, (JSONObject)var3_3, (int)var4_4){
            final /* synthetic */ SdkListener.Endpoint a;
            final /* synthetic */ String b;
            final /* synthetic */ JSONObject c;
            final /* synthetic */ int d;
            final /* synthetic */ InternalListenerManager e;
            {
                void var1_1;
                this.e = var1_1;
                this.a = endpoint;
                this.b = string;
                this.c = jSONObject;
                this.d = n2;
            }

            @Override
            public void a(SdkListener listener) {
                i i2 = object;
                Object object = i2.a;
                String string = i2.b;
                JSONObject jSONObject = i2.c;
                int n2 = i2.d;
                listener.onNetworkRequestFinished((SdkListener.Endpoint)((Object)object), string, jSONObject, n2);
            }
        };
        this.broadcast(n3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onSessionUpdated(InternalSession internalSession) {
        void var1_1;
        n n2;
        n n3 = n2;
        n2 = new n(this, (InternalSession)var1_1){
            final /* synthetic */ InternalSession a;
            final /* synthetic */ InternalListenerManager b;
            {
                void var1_1;
                this.b = var1_1;
                this.a = internalSession;
            }

            @Override
            public void a(SdkListener listener) {
                listener.onSessionUpdated(new InternalSession(this.a));
            }
        };
        this.broadcast(n3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onKitDetected(int kitId) {
        void var1_1;
        n n2;
        n n3 = n2;
        n2 = new n(this, (int)var1_1){
            final /* synthetic */ int a;
            final /* synthetic */ InternalListenerManager b;
            {
                void var1_1;
                this.b = var1_1;
                this.a = n2;
            }

            @Override
            public void a(SdkListener listener) {
                listener.onKitDetected(this.a);
            }
        };
        this.broadcast(n3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onKitConfigReceived(int kitId, String configuration) {
        void var1_1;
        n n2;
        n n3;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2;
        jSONObject2 = new JSONObject();
        JSONObject jSONObject4 = jSONObject;
        try {
            jSONObject = new JSONObject((String)((Object)n3));
            jSONObject3 = jSONObject4;
        }
        catch (JSONException jSONException) {}
        n3 = n2;
        n2 = new n(this, (int)var1_1, jSONObject3){
            final /* synthetic */ int a;
            final /* synthetic */ JSONObject b;
            final /* synthetic */ InternalListenerManager c;
            {
                void var1_1;
                this.c = var1_1;
                this.a = n2;
                this.b = jSONObject;
            }

            @Override
            public void a(SdkListener listener) {
                l l2 = this;
                int n2 = l2.a;
                listener.onKitConfigReceived(n2, l2.b);
            }
        };
        this.broadcast(n3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onKitExcluded(int kitId, String reason) {
        void var2_2;
        void var1_1;
        n n2;
        n n3 = n2;
        n2 = new n(this, (int)var1_1, (String)var2_2){
            final /* synthetic */ int a;
            final /* synthetic */ String b;
            final /* synthetic */ InternalListenerManager c;
            {
                void var1_1;
                this.c = var1_1;
                this.a = n2;
                this.b = string;
            }

            @Override
            public void a(SdkListener listener) {
                a a2 = this;
                int n2 = a2.a;
                listener.onKitExcluded(n2, a2.b);
            }
        };
        this.broadcast(n3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onKitStarted(int kitId) {
        void var1_1;
        n n2;
        n n3 = n2;
        n2 = new n(this, (int)var1_1){
            final /* synthetic */ int a;
            final /* synthetic */ InternalListenerManager b;
            {
                void var1_1;
                this.b = var1_1;
                this.a = n2;
            }

            @Override
            public void a(SdkListener listener) {
                listener.onKitStarted(this.a);
            }
        };
        this.broadcast(n3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onAliasRequestFinished(AliasResponse aliasResponse) {
        void var1_1;
        n n2;
        n n3 = n2;
        n2 = new n(this, (AliasResponse)var1_1){
            final /* synthetic */ AliasResponse a;
            final /* synthetic */ InternalListenerManager b;
            {
                void var1_1;
                this.b = var1_1;
                this.a = aliasResponse;
            }

            @Override
            public void a(SdkListener listener) {
                listener.onAliasRequestFinished(this.a);
            }
        };
        this.broadcast(n3);
    }

    static interface m {
        public void a(GraphListener var1);
    }

    static interface n {
        public void a(SdkListener var1);
    }
}

