/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.instantapps.InstantApps;
import com.mparticle.MParticle;
import com.mparticle.internal.Logger;
import com.mparticle.internal.b;
import com.mparticle.m;
import com.mparticle.u;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MPUtility {
    static final String NO_BLUETOOTH = "none";
    private static String sOpenUDID;
    private static final char[] HEX_CHARS;
    private static final String TAG;

    public static long getAvailableMemory(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = memoryInfo;
        memoryInfo = new ActivityManager.MemoryInfo();
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo((ActivityManager.MemoryInfo)context2);
        return context2.availMem;
    }

    public static boolean isSystemMemoryLow(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = memoryInfo;
        memoryInfo = new ActivityManager.MemoryInfo();
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo((ActivityManager.MemoryInfo)context2);
        return context2.lowMemory;
    }

    public static long getSystemMemoryThreshold(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = memoryInfo;
        memoryInfo = new ActivityManager.MemoryInfo();
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo((ActivityManager.MemoryInfo)context2);
        return context2.threshold;
    }

    public static long getRemainingHeapInBytes() {
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory() - runtime.freeMemory();
        return runtime.maxMemory() - l2;
    }

    public static boolean isEmpty(CharSequence str) {
        CharSequence charSequence;
        return str == null || charSequence.length() == 0;
    }

    public static boolean isEmpty(JSONArray jsonArray) {
        JSONArray jSONArray;
        return jsonArray == null || jSONArray.length() == 0;
    }

    public static boolean isEmpty(JSONObject jsonObject) {
        JSONObject jSONObject;
        return jsonObject == null || jSONObject.length() == 0;
    }

    public static boolean isEmpty(Map map) {
        Map map2;
        return map == null || map2.size() == 0;
    }

    public static boolean isEmpty(Collection collection) {
        Collection collection2;
        return collection == null || collection2.size() == 0;
    }

    @WorkerThread
    @Nullable
    public static AdIdInfo getAdIdInfo(Context context) {
        Context context2;
        Context context3 = context;
        Object object = context3.getPackageName();
        object = context3.getPackageManager().getInstallerPackageName((String)object);
        if (object != null && ((String)object).contains("com.amazon.venezia") || "Amazon".equals(Build.MANUFACTURER)) {
            object = MPUtility.getAmazonAdIdInfo(context2);
            if (object == null) {
                return MPUtility.getGoogleAdIdInfo(context2);
            }
            return object;
        }
        object = MPUtility.getGoogleAdIdInfo(context2);
        if (object == null) {
            return MPUtility.getAmazonAdIdInfo(context2);
        }
        return object;
    }

    private static AdIdInfo getGoogleAdIdInfo(Context context) {
        Object object;
        Class[] classArray;
        String string;
        Class<?> clazz;
        try {
            clazz = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
            string = "getAdvertisingIdInfo";
            classArray = new Class[1];
        }
        catch (Exception exception) {
            Logger.info(TAG, "Could not locate Google Play Ads Identifier library");
            return null;
        }
        classArray[0] = Context.class;
        Method method = clazz.getMethod(string, classArray);
        object = method.invoke(null, object);
        Boolean bl = (Boolean)object.getClass().getMethod("isLimitAdTrackingEnabled", new Class[0]).invoke(object, new Object[0]);
        object = (String)object.getClass().getMethod("getId", new Class[0]).invoke(object, new Object[0]);
        return new AdIdInfo((String)object, bl, AdIdInfo.Advertiser.GOOGLE);
    }

    private static AdIdInfo getAmazonAdIdInfo(Context context) {
        block6: {
            AdIdInfo adIdInfo;
            Object object = context.getContentResolver();
            boolean bl = Settings.Secure.getInt((ContentResolver)object, (String)"limit_ad_tracking", (int)0) != 0;
            object = Settings.Secure.getString((ContentResolver)object, (String)"advertising_id");
            if (object == null) break block6;
            AdIdInfo adIdInfo2 = adIdInfo;
            AdIdInfo adIdInfo3 = adIdInfo;
            AdIdInfo.Advertiser advertiser = AdIdInfo.Advertiser.AMAZON;
            try {
                adIdInfo2((String)object, bl, advertiser);
                return adIdInfo3;
            }
            catch (Exception exception) {
                Logger.info(TAG, "Could not locate Amazon ID on device: " + exception.getMessage());
            }
        }
        return null;
    }

    public static boolean isInDaylightSavings() {
        return TimeZone.getDefault().inDaylightTime(new Date());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isEqual(Object field, Object field1) {
        Object object;
        void var1_1;
        return field == var1_1 || object != null && object.equals(var1_1);
    }

    public static String getGpsEnabled(Context context) {
        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0) {
            Context context2;
            return Boolean.toString(((LocationManager)context2.getSystemService("location")).isProviderEnabled("gps"));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"MissingPermission"})
    public static Integer getNetworkType(Context context, TelephonyManager telephonyManager) {
        Context context2;
        if (telephonyManager != null && MPUtility.checkPermission(context2, "android.permission.READ_PHONE_STATE")) {
            void var1_1;
            return var1_1.getNetworkType();
        }
        return null;
    }

    public static long getAvailableInternalDisk(Context context) {
        return MPUtility.getDiskSpace(context, Environment.getDataDirectory());
    }

    public static long getAvailableExternalDisk(Context context) {
        Context context2;
        File file = context.getExternalFilesDir(null);
        if (file == null) {
            return 0L;
        }
        return MPUtility.getDiskSpace(context2, file);
    }

    public static String getAppVersionName(Context context) {
        try {
            Context context2;
            return context.getPackageManager().getPackageInfo((String)context2.getPackageName(), (int)0).versionName;
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String hmacSha256Encode(String key, String data) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        void var1_1;
        String string;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(string.getBytes("utf-8"), "HmacSHA256"));
        return MPUtility.asHex(mac.doFinal(var1_1.getBytes("utf-8")));
    }

    private static String asHex(byte[] buf) {
        byte[] byArray;
        char[] cArray = new char[buf.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = i2 * 2;
            char[] cArray2 = HEX_CHARS;
            byte by = byArray[i2];
            cArray[n2] = cArray2[(by & 0xF0) >>> 4];
            cArray[++n2] = HEX_CHARS[by & 0xF];
        }
        return new String(cArray);
    }

    public static JSONObject getJsonResponse(u u2) {
        try {
            return MPUtility.getJsonResponse(u2.c());
        }
        catch (IOException iOException) {
            return MPUtility.getJsonResponse(u2.a());
        }
    }

    public static JSONObject getJsonResponse(HttpURLConnection connection) {
        try {
            return MPUtility.getJsonResponse(connection.getInputStream());
        }
        catch (IOException iOException) {
            HttpURLConnection httpURLConnection;
            return MPUtility.getJsonResponse(httpURLConnection.getErrorStream());
        }
    }

    /*
     * Unable to fully structure code
     */
    public static JSONObject getJsonResponse(InputStream is) {
        v0 = is;
        var1_1 = v1;
        v1 = new StringBuilder();
        if (v0 == null) {
            return null;
        }
        var2_2 = v2;
        var3_3 = v3;
        v3 = new InputStreamReader((InputStream)var0);
        v2 = new BufferedReader(var3_3);
        ** while ((var0 = var2_2.readLine()) != null)
lbl-1000:
        // 1 sources

        {
            v4 = var1_1;
            v4.append((String)var0 + '\n');
            continue;
        }
lbl20:
        // 1 sources

        try {
            var2_2.close();
            return new JSONObject(var1_1.toString());
        }
        catch (JSONException v5) {
        }
        catch (IOException v6) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static long getDiskSpace(Context context, File path) {
        void var1_1;
        StatFs statFs;
        if (MPUtility.isInstantApp(context)) {
            return 0L;
        }
        long l2 = -1L;
        Context context2 = statFs;
        statFs = new StatFs(var1_1.getPath());
        if (Build.VERSION.SDK_INT > 17) {
            l2 = m.a((StatFs)context2);
        }
        if (l2 == 0L) {
            l2 = (long)context2.getAvailableBlocks() * (long)context2.getBlockSize();
        }
        return l2;
    }

    public static String getErrorMessage(HttpURLConnection connection) {
        InputStreamReader inputStreamReader;
        BufferedReader bufferedReader;
        StringBuilder stringBuilder;
        Object object = connection.getErrorStream();
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        BufferedReader bufferedReader2 = bufferedReader;
        InputStreamReader inputStreamReader2 = inputStreamReader;
        inputStreamReader = new InputStreamReader((InputStream)object);
        bufferedReader = new BufferedReader(inputStreamReader2);
        while (true) {
            object = bufferedReader2.readLine();
            if (object == null) break;
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append((String)object + '\n');
        }
        try {
            bufferedReader2.close();
            return stringBuilder2.toString();
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    public static long millitime() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @TargetApi(value=3)
    @Nullable
    public static String getAndroidID(Context context) {
        if (MParticle.isAndroidIdEnabled()) {
            Context context2;
            return Settings.Secure.getString((ContentResolver)context2.getContentResolver(), (String)"android_id");
        }
        return null;
    }

    public static String getTimeZone() {
        try {
            return TimeZone.getDefault().getDisplayName(false, 0);
        }
        catch (AssertionError assertionError) {
        }
        catch (Exception exception) {}
        return null;
    }

    public static int getOrientation(Context context) {
        Context context2 = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        return context2.getWidth() == context2.getHeight() ? 3 : (context2.getWidth() < context2.getHeight() ? 1 : 2);
    }

    public static long getTotalMemory(Context context) {
        if (Build.VERSION.SDK_INT > 15) {
            Context context2;
            return MPUtility.getTotalMemoryJB(context2);
        }
        return MPUtility.getTotalMemoryPreJB();
    }

    @TargetApi(value=16)
    public static long getTotalMemoryJB(Context context) {
        ActivityManager.MemoryInfo memoryInfo;
        Context context2 = memoryInfo;
        memoryInfo = new ActivityManager.MemoryInfo();
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo((ActivityManager.MemoryInfo)context2);
        return context2.totalMem;
    }

    public static long getTotalMemoryPreJB() {
        BufferedReader bufferedReader;
        FileReader fileReader;
        Object object = "/proc/meminfo";
        FileReader fileReader2 = fileReader;
        try {
            fileReader = new FileReader((String)object);
        }
        catch (IOException iOException) {
            return -1L;
        }
        object = bufferedReader;
        long l2 = Integer.valueOf(new BufferedReader(fileReader2, 8192).readLine().split("\\s+")[1]) * 1024;
        ((BufferedReader)object).close();
        return l2;
    }

    public static String getOpenUDID(Context context) {
        Context context2;
        SharedPreferences sharedPreferences;
        if (sOpenUDID == null && (sOpenUDID = (sharedPreferences = context2.getSharedPreferences("mParticlePrefs", 0)).getString("mp::openudid", null)) == null) {
            sOpenUDID = MPUtility.getAndroidID(context2);
            if (sOpenUDID == null) {
                sOpenUDID = MPUtility.getGeneratedUdid();
            }
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString("mp::openudid", sOpenUDID);
            editor.apply();
        }
        return sOpenUDID;
    }

    public static String getRampUdid(Context context) {
        Context context2 = context.getSharedPreferences("mParticlePrefs", 0);
        String string = context2.getString("mp::rampudid", null);
        if (string == null) {
            string = MPUtility.getGeneratedUdid();
            SharedPreferences.Editor editor = context2.edit();
            editor.putString("mp::rampudid", string);
            editor.apply();
        }
        return string;
    }

    static String getGeneratedUdid() {
        SecureRandom secureRandom;
        SecureRandom secureRandom2 = secureRandom;
        secureRandom = new SecureRandom();
        return new BigInteger(64, secureRandom2).toString(16);
    }

    static String getBuildUUID(String versionCode) {
        String string;
        if (versionCode == null) {
            string = "unknown";
        }
        try {
            return UUID.nameUUIDFromBytes(string.getBytes()).toString();
        }
        catch (AssertionError assertionError) {
            return "unknown";
        }
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean hasNfc(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.nfc");
    }

    public static String getBluetoothVersion(Context context) {
        Context context2;
        String string = NO_BLUETOOTH;
        if (Build.VERSION.SDK_INT >= 18 && context2.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            string = "ble";
        } else if (context2.getPackageManager().hasSystemFeature("android.hardware.bluetooth")) {
            string = "classic";
        }
        return string;
    }

    public static boolean isPhoneRooted() {
        String string = Build.TAGS;
        if (string != null && string.contains("test-keys")) {
            return true;
        }
        boolean bl = false;
        int n2 = 8;
        String[] stringArray = new String[8];
        String[] stringArray2 = stringArray;
        stringArray[0] = "/sbin/";
        stringArray[1] = "/system/bin/";
        stringArray[2] = "/system/xbin/";
        stringArray[3] = "/data/local/xbin/";
        stringArray[4] = "/data/local/bin/";
        stringArray[5] = "/system/sd/xbin/";
        stringArray[6] = "/system/bin/failsafe/";
        stringArray[7] = "/data/local/";
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray2[i2];
            if (!new File(string2 + "su").exists()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static int mpHash(String input) {
        Object object;
        int n2 = 0;
        if (input != null && ((String)object).length() != 0) {
            char[] cArray = ((String)object).toLowerCase().toCharArray();
            object = cArray;
            int n3 = cArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object2 = object[i2];
                n2 = (n2 << 5) - n2 + object2;
            }
            return n2;
        }
        return n2;
    }

    public static boolean hasTelephony(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isBluetoothEnabled(Context context) {
        Context context2;
        if (MPUtility.checkPermission(context, "android.permission.BLUETOOTH") && (context2 = BluetoothAdapter.getDefaultAdapter()) != null) {
            try {
                return context2.isEnabled();
            }
            catch (SecurityException securityException) {}
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkPermission(Context context, String permission2) {
        void var1_1;
        return context.checkCallingOrSelfPermission((String)var1_1) == 0;
    }

    public static boolean isGmsAdIdAvailable() {
        try {
            Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static boolean isSupportLibAvailable() {
        try {
            Class.forName("android.support.v4.app.FragmentActivity");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static boolean isFirebaseAvailable() {
        return MPUtility.isFirebaseAvailablePostV21().booleanValue() || MPUtility.isFirebaseAvailablePreV21().booleanValue();
        {
        }
    }

    public static Boolean isFirebaseAvailablePostV21() {
        try {
            Class.forName("com.google.firebase.messaging.FirebaseMessaging");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isFirebaseAvailablePreV21() {
        try {
            Class.forName("com.google.firebase.iid.FirebaseInstanceId");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean isInstallRefApiAvailable() {
        try {
            Class.forName("com.android.installreferrer.api.InstallReferrerStateListener");
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static BigInteger hashFnv1A(byte[] data) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3 = bigInteger2;
        bigInteger2 = new BigInteger("cbf29ce484222325", 16);
        BigInteger bigInteger4 = bigInteger;
        bigInteger = new BigInteger("100000001b3", 16);
        BigInteger bigInteger5 = new BigInteger("2").pow(64);
        int n2 = data.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray;
            bigInteger3 = bigInteger3.xor(BigInteger.valueOf(byArray[i2] & 0xFF)).multiply(bigInteger4).mod(bigInteger5);
        }
        return bigInteger3;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isServiceAvailable(Context context, Class<?> service) {
        void var1_1;
        Context context2;
        return context.getPackageManager().queryIntentServices(new Intent(context2, (Class)var1_1), 65536).size() > 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject wrapExtras(Bundle extras) {
        Bundle bundle;
        if (extras != null && !bundle.isEmpty()) {
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject();
            Iterator iterator = bundle.keySet().iterator();
            while (true) {
                JSONObject jSONObject3;
                if (!iterator.hasNext()) {
                    return jSONObject2;
                }
                String string = (String)iterator.next();
                Object object = bundle.getBundle(string);
                if (object != null) {
                    try {
                        jSONObject3 = jSONObject2.put(string, (Object)MPUtility.wrapExtras((Bundle)object));
                    }
                    catch (JSONException jSONException) {}
                    continue;
                }
                object = bundle.get(string);
                if (object == null || ((String)(object = object.toString())).length() >= 500) continue;
                {
                    jSONObject3 = jSONObject2.put(string, object);
                    continue;
                }
                break;
            }
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static JSONObject mapToJson(Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        v0 = var0;
        var0 = v1;
        v1 = new JSONObject();
        block10: for (Object var2_2 : v0.entrySet()) {
            block14: {
                var3_3 = var2_2.getValue();
                var2_2 = (String)var2_2.getKey();
                if (!(var3_3 instanceof List)) break block14;
                v2 = var3_3;
                var3_3 = v3;
                v3 = new JSONArray();
                var4_4 = ((List)v2).iterator();
                while (true) {
                    if (!var4_4.hasNext()) break;
                    var3_3.put(var4_4.next());
                }
                v4 = var0.put((String)var2_2, var3_3);
lbl28:
                // 3 sources

                continue block10;
            }
            if (var3_3 == null) ** GOTO lbl35
            try {
                v4 = var0.put((String)var2_2, (Object)var3_3.toString());
                ** GOTO lbl28
lbl35:
                // 1 sources

                v4 = var0.put((String)var2_2, var3_3);
                ** continue;
            }
            catch (JSONException v5) {
            }
        }
        return var0;
    }

    public static boolean isAppDebuggable(Context context) {
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    public static boolean isDevEnv() {
        return ((Object)((Object)b.u())).equals((Object)MParticle.Environment.Development);
    }

    public static JSONObject enforceAttributeConstraints(Map<String, String> attributes) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        if (attributes == null) {
            return null;
        }
        JSONObject jSONObject3 = jSONObject2;
        jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        for (Map.Entry entry : jSONObject3.entrySet()) {
            MPUtility.setCheckedAttribute(jSONObject2, (String)entry.getKey(), (String)entry.getValue(), false, false);
        }
        return jSONObject2;
    }

    /*
     * WARNING - void declaration
     */
    public static Boolean setCheckedAttribute(JSONObject attributes, String key, Object value, boolean increment, boolean userAttribute) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return MPUtility.setCheckedAttribute(attributes, (String)var1_1, var2_2, Boolean.FALSE, (boolean)var3_3, (boolean)var4_4);
    }

    /*
     * Unable to fully structure code
     */
    public static Boolean setCheckedAttribute(JSONObject attributes, String key, Object value, Boolean caseInsensitive, boolean increment, boolean userAttribute) {
        block24: {
            block23: {
                block22: {
                    block21: {
                        if (attributes == null || var1_2 == null) break block24;
                        if (!var3_5.booleanValue()) break block21;
                        var1_2 = MPUtility.findCaseInsensitiveKey(var0, var1_2);
                    }
                    if (100 != var0.length()) break block22;
                    if (var0.has(var1_2)) break block22;
                    v0 = new String[1];
                    v0[0] = "Attribute count exceeds limit. Discarding attribute: " + var1_2;
                    Logger.error(v0);
                    return Boolean.FALSE;
                }
                if (var2_3 == null) ** GOTO lbl27
                if (var2_3.toString().length() <= 4096) ** GOTO lbl27
                v1 = new String[1];
                v1[0] = "Attribute value length exceeds limit. Discarding attribute: " + var1_2;
                Logger.error(v1);
                return Boolean.FALSE;
lbl27:
                // 2 sources

                if (var1_2.length() <= 256) break block23;
                v2 = new String[1];
                v2[0] = "Attribute name length exceeds limit. Discarding attribute: " + var1_2;
                Logger.error(v2);
                return Boolean.FALSE;
            }
            if (var2_3 == null) {
                var2_3 = JSONObject.NULL;
            }
            if (var4_6 != false) {
                v3 = var2_3;
                var2_4 = Integer.parseInt(var0.optString(var1_2, "0"));
                v4 = (Integer)v3;
                var2_3 = Integer.toString(v4 + var2_4);
            }
            try {
                var0.put(var1_2, var2_3);
            }
            catch (Exception var0_1) {
                Logger.error(new String[]{"Failed to add attribute: " + var0_1.getMessage()});
                return Boolean.FALSE;
            }
            catch (NumberFormatException v5) {
                Logger.error(new String[]{"Attempted to increment a key that could not be parsed as an integer: " + var1_2});
                return Boolean.FALSE;
            }
            catch (JSONException v6) {
                Logger.error(new String[]{"JSON error processing attributes. Discarding attribute: " + var1_2});
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - void declaration
     */
    public static String findCaseInsensitiveKey(JSONObject jsonObject, String key) {
        void var1_1;
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.equalsIgnoreCase((String)var1_1)) continue;
            return string;
        }
        return var1_1;
    }

    public static boolean isInstantApp(Context context) {
        Context context2;
        if (Build.VERSION.SDK_INT >= 26) {
            return context2.getPackageManager().isInstantApp();
        }
        try {
            Class.forName("com.google.android.instantapps.InstantApps");
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("com.google.android.instantapps.supervisor.InstantAppsRuntime");
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return false;
            }
            return true;
        }
        return new SyncRunnable<Boolean>(){

            @Override
            public Boolean run() {
                return InstantApps.isInstantApp((Context)context2);
            }
        }.run();
    }

    public static boolean containsNullKey(Map map) {
        try {
            return map.containsKey(null);
        }
        catch (RuntimeException runtimeException) {
            Iterator iterator;
            iterator = new ArrayList(iterator.entrySet()).iterator();
            while (iterator.hasNext()) {
                if (((Map.Entry)iterator.next()).getKey() != null) continue;
                return true;
            }
            return false;
        }
    }

    @Nullable
    public static String getProp(String key) {
        Class<?> clazz = Class.forName("android.os.SystemProperties");
        String string = "get";
        Class[] classArray = new Class[1];
        try {
            String string2;
            classArray[0] = String.class;
            return clazz.getMethod(string, classArray).invoke(clazz, string2).toString();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Number addNumbers(Number number1, Number number2) {
        Number number;
        void var1_1;
        if (!(number1 instanceof Double) && !(var1_1 instanceof Double)) {
            if (!(number instanceof Float) && !(var1_1 instanceof Float)) {
                if (!(number instanceof Long) && !(var1_1 instanceof Long)) {
                    return number.intValue() + var1_1.intValue();
                }
                return number.longValue() + var1_1.longValue();
            }
            return Float.valueOf(number.floatValue() + var1_1.floatValue());
        }
        return number.doubleValue() + var1_1.doubleValue();
    }

    public static Object toNumberOrString(String stringValue) {
        String string;
        if (stringValue == null) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Character c2 = Character.valueOf(cArray[i2]);
            if (Character.isDigit(c2.charValue()) || c2.charValue() == '.' || c2.charValue() == '-') continue;
            return string;
        }
        try {
            return NumberFormat.getInstance().parse(string);
        }
        catch (ParseException parseException) {
            return string;
        }
    }

    static {
        HEX_CHARS = "0123456789abcdef".toCharArray();
        TAG = MPUtility.class.toString();
    }

    private static interface SyncRunnable<T> {
        public T run();
    }

    public static class AdIdInfo {
        public final String id;
        public final boolean isLimitAdTrackingEnabled;
        public final Advertiser advertiser;

        /*
         * WARNING - void declaration
         */
        public AdIdInfo(String id, boolean isLimitAdTrackingEnabled, Advertiser advertiser) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.id = var1_1;
            this.isLimitAdTrackingEnabled = var2_2;
            this.advertiser = var3_3;
        }

        public static final class Advertiser
        extends Enum<Advertiser> {
            public static final /* enum */ Advertiser AMAZON;
            public static final /* enum */ Advertiser GOOGLE;
            private static final /* synthetic */ Advertiser[] $VALUES;
            public String descriptiveName;

            public static Advertiser[] values() {
                return (Advertiser[])$VALUES.clone();
            }

            public static Advertiser valueOf(String name) {
                String string;
                return Enum.valueOf(Advertiser.class, string);
            }

            /*
             * WARNING - void declaration
             */
            private Advertiser(String name) {
                void var3_3;
                this.descriptiveName = var3_3;
            }

            static {
                Advertiser advertiser;
                Advertiser advertiser2;
                Advertiser advertiser3 = advertiser2;
                AMAZON = new Advertiser("Amazon");
                Advertiser advertiser4 = advertiser;
                GOOGLE = new Advertiser("Google Play Store");
                $VALUES = new Advertiser[]{advertiser3, advertiser4};
            }
        }
    }
}

