/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.identity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mparticle.internal.MPUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class IdentityHttpResponse {
    @NonNull
    public static final String MPID = "mpid";
    @NonNull
    public static final String CONTEXT = "context";
    @NonNull
    public static final String ERRORS = "errors";
    @NonNull
    public static final String LOGGED_IN = "is_logged_in";
    @NonNull
    public static final String CODE = "code";
    @NonNull
    public static final String MESSAGE = "message";
    @NonNull
    public static final String UNKNOWN = "UNKNOWN";
    private ArrayList<Error> errors;
    private long mpId;
    private String context;
    private int httpCode;
    private boolean loggedIn;

    private IdentityHttpResponse() {
        ArrayList arrayList;
        ArrayList this_ = arrayList;
        arrayList = new ArrayList();
        v1.errors = this_;
    }

    /*
     * WARNING - void declaration
     */
    public IdentityHttpResponse(int code, long mpid, @Nullable String context, @Nullable ArrayList<Error> errors) {
        ArrayList arrayList;
        void var4_4;
        void var2_3;
        void var1_1;
        ArrayList arrayList2;
        ArrayList arrayList3 = arrayList2;
        arrayList2 = new ArrayList();
        this.errors = arrayList3;
        this.httpCode = var1_1;
        this.mpId = var2_3;
        this.context = var4_4;
        if (errors == null) {
            ArrayList arrayList4;
            arrayList = arrayList4;
            arrayList4 = new ArrayList();
        } else {
            void var5_5;
            ArrayList arrayList5;
            arrayList = arrayList5;
            arrayList5 = new ArrayList(var5_5);
        }
        this.errors = arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public IdentityHttpResponse(int code, @NonNull String errorString) {
        void var2_2;
        Error error;
        void var1_1;
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2 = arrayList;
        IdentityHttpResponse identityHttpResponse = this_;
        arrayList2();
        identityHttpResponse.errors = arrayList2;
        identityHttpResponse.httpCode = var1_1;
        Error this_ = error;
        error = new Error(UNKNOWN, (String)var2_2);
        arrayList.add(this_);
    }

    /*
     * WARNING - void declaration
     */
    public IdentityHttpResponse(int httpCode, @Nullable JSONObject jsonObject) throws JSONException {
        void var1_1;
        ((IdentityHttpResponse)((Object)string)).errors = new ArrayList();
        ((IdentityHttpResponse)((Object)string)).httpCode = var1_1;
        if (!MPUtility.isEmpty(jsonObject)) {
            void var2_4;
            if (var2_4.has(MPID)) {
                ((IdentityHttpResponse)((Object)string)).mpId = Long.valueOf(var2_4.getString(MPID));
                ((IdentityHttpResponse)((Object)string)).context = var2_4.optString(CONTEXT);
                ((IdentityHttpResponse)((Object)string)).loggedIn = var2_4.optBoolean(LOGGED_IN);
            } else if (var2_4.has(ERRORS)) {
                JSONArray jSONArray = var2_4.optJSONArray(ERRORS);
                if (!MPUtility.isEmpty(jSONArray)) {
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        String string;
                        JSONObject jSONObject;
                        String string2;
                        try {
                            string2 = string;
                            JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                            jSONObject = jSONObject2;
                            string = jSONObject2.optString(CODE);
                        }
                        catch (JSONException jSONException) {}
                        String string3 = jSONObject.optString(MESSAGE);
                        ((IdentityHttpResponse)((Object)string2)).errors.add(new Error(string, string3));
                    }
                }
            } else {
                IdentityHttpResponse identityHttpResponse = string;
                void v5 = var2_4;
                String string = v5.optString(CODE);
                String string4 = v5.optString(MESSAGE);
                identityHttpResponse.errors.add(new Error(string, string4));
            }
        }
    }

    public boolean isSuccessful() {
        return this.httpCode == 200;
    }

    @NonNull
    public List<Error> getErrors() {
        return this.errors;
    }

    public long getMpId() {
        return this.mpId;
    }

    @Nullable
    public String getContext() {
        return this.context;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    @NonNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append("Identity Response:\n");
        stringBuilder2.append("Identity Response Code: " + ((IdentityHttpResponse)((Object)this_)).httpCode + "\n");
        if (((IdentityHttpResponse)((Object)this_)).isSuccessful()) {
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append("MPID: " + ((IdentityHttpResponse)((Object)this_)).mpId + "\n");
            stringBuilder3.append("Context: " + ((IdentityHttpResponse)((Object)this_)).context + "\n");
            stringBuilder3.append("Is Logged In: " + ((IdentityHttpResponse)((Object)this_)).loggedIn + "\n");
        } else {
            Iterator<Error> this_ = ((IdentityHttpResponse)((Object)this_)).errors.iterator();
            while (this_.hasNext()) {
                StringBuilder stringBuilder4 = stringBuilder2;
                Error error = (Error)this_.next();
                stringBuilder4.append("Code: " + error.code + "\n");
                stringBuilder4.append("Message: " + error.message + "\n");
            }
        }
        return stringBuilder2.toString();
    }

    public static class Error {
        @NonNull
        public final String message;
        @NonNull
        public final String code;

        /*
         * WARNING - void declaration
         */
        public Error(@NonNull String errorCode, @NonNull String message) {
            void var2_2;
            void var1_1;
            this.code = var1_1;
            this.message = var2_2;
        }
    }
}

