/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.identity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mparticle.MParticle;
import com.mparticle.identity.MParticleUser;
import com.mparticle.identity.UserAliasHandler;
import com.mparticle.internal.Logger;
import com.mparticle.internal.MPUtility;
import java.util.HashMap;
import java.util.Map;

public final class IdentityApiRequest {
    private UserAliasHandler userAliasHandler = null;
    private Map<MParticle.IdentityType, String> userIdentities = new HashMap<MParticle.IdentityType, String>();
    private Map<String, String> otherOldIdentities = new HashMap<String, String>();
    private Map<String, String> otherNewIdentities = new HashMap<String, String>();
    Long mpid;

    /*
     * WARNING - void declaration
     */
    private IdentityApiRequest(Builder builder) {
        void var1_1;
        if (builder.userIdentities != null) {
            this.userIdentities = ((Builder)var1_1).userIdentities;
        }
        if (((Builder)var1_1).userAliasHandler != null) {
            this.userAliasHandler = ((Builder)var1_1).userAliasHandler;
        }
        if (((Builder)var1_1).otherOldIdentities.size() == ((Builder)var1_1).otherNewIdentities.size()) {
            this.otherNewIdentities = ((Builder)var1_1).otherNewIdentities;
            this.otherOldIdentities = ((Builder)var1_1).otherOldIdentities;
        }
        if (((Builder)var1_1).mpid != null) {
            this.mpid = ((Builder)var1_1).mpid;
        }
    }

    @NonNull
    public static Builder withEmptyUser() {
        return new Builder();
    }

    @NonNull
    public static Builder withUser(@Nullable MParticleUser currentUser) {
        MParticleUser mParticleUser;
        return new Builder(mParticleUser);
    }

    @NonNull
    public Map<MParticle.IdentityType, String> getUserIdentities() {
        return this.userIdentities;
    }

    @NonNull
    protected Map<String, String> getOtherOldIdentities() {
        return this.otherOldIdentities;
    }

    @NonNull
    protected Map<String, String> getOtherNewIdentities() {
        return this.otherNewIdentities;
    }

    @Nullable
    public UserAliasHandler getUserAliasHandler() {
        return this.userAliasHandler;
    }

    public static class Builder {
        private Long mpid;
        private Map<MParticle.IdentityType, String> userIdentities;
        private Map<String, String> otherOldIdentities;
        private Map<String, String> otherNewIdentities;
        private UserAliasHandler userAliasHandler;

        /*
         * WARNING - void declaration
         */
        protected Builder(@Nullable MParticleUser currentUser) {
            HashMap<String, String> hashMap;
            HashMap<String, String> hashMap2;
            HashMap<String, String> hashMap3;
            HashMap<String, String> hashMap4 = hashMap3;
            hashMap3 = new HashMap<String, String>();
            this.userIdentities = hashMap4;
            hashMap4 = hashMap2;
            hashMap2 = new HashMap<String, String>();
            this.otherOldIdentities = hashMap4;
            hashMap4 = hashMap;
            hashMap = new HashMap<String, String>();
            this.otherNewIdentities = hashMap4;
            if (currentUser != null) {
                void var1_1;
                this.userIdentities = var1_1.getUserIdentities();
                this.mpid = var1_1.getId();
            }
        }

        protected Builder() {
            HashMap hashMap;
            HashMap hashMap2;
            HashMap hashMap3;
            Object this_ = hashMap3;
            hashMap3 = new HashMap();
            v1.userIdentities = this_;
            this_ = hashMap2;
            hashMap2 = new HashMap();
            v1.otherOldIdentities = this_;
            this_ = hashMap;
            hashMap = new HashMap();
            v1.otherNewIdentities = this_;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder email(@Nullable String email) {
            void var1_1;
            return this.userIdentity(MParticle.IdentityType.Email, (String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder customerId(@Nullable String customerId) {
            void var1_1;
            return this.userIdentity(MParticle.IdentityType.CustomerId, (String)var1_1);
        }

        @NonNull
        protected Builder pushToken(@Nullable String newPushToken, @Nullable String oldPushToken) {
            Object v2;
            Object v3;
            if (MPUtility.isEmpty(oldPushToken)) {
                v3 = null;
            }
            if (MPUtility.isEmpty((CharSequence)v2)) {
                v2 = null;
            }
            Builder builder = this;
            builder.otherOldIdentities.put("push_token", (String)v3);
            builder.otherNewIdentities.put("push_token", (String)v2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        protected Builder googleAdId(@Nullable String newGoogleAdId, @Nullable String oldGoogleAdId) {
            void var1_1;
            void var2_2;
            Builder builder = this;
            builder.otherOldIdentities.put("android_aaid", (String)var2_2);
            builder.otherNewIdentities.put("android_aaid", (String)var1_1);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder userIdentity(@NonNull MParticle.IdentityType identityType, @Nullable String identityValue) {
            void var2_2;
            void var1_1;
            if (this.userIdentities.containsKey(var1_1)) {
                Logger.warning("IdentityApiRequest already contains field with IdentityType of:" + var1_1 + ". It will be overwritten");
            }
            Builder builder = this;
            builder.userIdentities.put((MParticle.IdentityType)var1_1, (String)var2_2);
            return builder;
        }

        @NonNull
        public Builder userIdentities(@NonNull Map<MParticle.IdentityType, String> userIdentities) {
            for (Map.Entry<MParticle.IdentityType, String> entry : userIdentities.entrySet()) {
                this.userIdentity(entry.getKey(), entry.getValue());
            }
            return this;
        }

        @NonNull
        public IdentityApiRequest build() {
            return new IdentityApiRequest(this);
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder userAliasHandler(@Nullable UserAliasHandler userAliasHandler) {
            void var1_1;
            this.userAliasHandler = var1_1;
            return this;
        }
    }
}

