/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.commerce;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mparticle.internal.Logger;
import com.mparticle.internal.MPUtility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class Product {
    @NonNull
    public static final String ADD_TO_CART = "add_to_cart";
    @NonNull
    public static final String REMOVE_FROM_CART = "remove_from_cart";
    @NonNull
    public static final String ADD_TO_WISHLIST = "add_to_wishlist";
    @NonNull
    public static final String REMOVE_FROM_WISHLIST = "remove_from_wishlist";
    @NonNull
    public static final String CHECKOUT = "checkout";
    @NonNull
    public static final String CLICK = "click";
    @NonNull
    public static final String DETAIL = "view_detail";
    @NonNull
    public static final String PURCHASE = "purchase";
    @NonNull
    public static final String REFUND = "refund";
    @NonNull
    public static final String CHECKOUT_OPTION = "checkout_option";
    private static EqualityComparator mComparator = new b();
    private Map<String, String> mCustomAttributes;
    private String mName;
    private String mCategory;
    private String mCouponCode;
    private String mSku;
    protected long mTimeAdded;
    private Integer mPosition;
    private double mPrice;
    private double mQuantity;
    private String mBrand;
    private String mVariant;

    public static void setEqualityComparator(@Nullable EqualityComparator comparator) {
        EqualityComparator equalityComparator;
        mComparator = comparator == null ? new b() : equalityComparator;
    }

    private Product() {
        this.mName = null;
    }

    /*
     * WARNING - void declaration
     */
    private Product(Builder builder) {
        void var1_1;
        Product product = this;
        this.mName = null;
        this.mName = ((Builder)var1_1).mName;
        this.mCategory = ((Builder)var1_1).mCategory;
        this.mCouponCode = ((Builder)var1_1).mCouponCode;
        this.mSku = ((Builder)var1_1).mSku;
        this.mPosition = ((Builder)var1_1).mPosition;
        this.mPrice = ((Builder)var1_1).mPrice;
        this.mQuantity = ((Builder)var1_1).mQuantity;
        this.mBrand = ((Builder)var1_1).mBrand;
        this.mVariant = ((Builder)var1_1).mVariant;
        product.mCustomAttributes = ((Builder)var1_1).mCustomAttributes;
        product.updateTimeAdded();
        if (MPUtility.isEmpty(product.mName)) {
            this.mName = "Unknown";
            Logger.error("Product name is required.");
        } else if (MPUtility.isEmpty(this.mSku)) {
            this.mSku = "Unknown";
            Logger.error("Product SKU is required.");
        }
    }

    @Nullable
    public static Product fromString(@NonNull String json) {
        try {
            String string;
            return Product.fromJson(new JSONObject(string));
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Nullable
    static Product fromJson(JSONObject jsonObject) {
        JSONObject jSONObject;
        Builder builder;
        block26: {
            HashMap hashMap;
            Object object;
            String string;
            block25: {
                block24: {
                    Builder builder2;
                    JSONObject jSONObject2 = jsonObject;
                    builder = builder2;
                    JSONObject jSONObject3 = jSONObject;
                    Builder builder3 = builder;
                    JSONObject jSONObject4 = jSONObject;
                    Builder builder4 = builder;
                    JSONObject jSONObject5 = jSONObject;
                    JSONObject jSONObject6 = jSONObject5;
                    JSONObject jSONObject7 = jSONObject5;
                    string = jSONObject5.getString("nm");
                    object = jSONObject7.optString("id", null);
                    double d2 = jSONObject6.optDouble("pr", 0.0);
                    builder4(string, (String)object, d2);
                    builder3.category(jSONObject4.optString("ca", null));
                    builder2.couponCode(jSONObject3.optString("cc", null));
                    if (!jSONObject2.has("ps")) break block24;
                    builder.position(jSONObject.optInt("ps", 0));
                }
                if (!jSONObject.has("qt")) break block25;
                builder.quantity(jSONObject.optDouble("qt", 1.0));
            }
            JSONObject jSONObject8 = jSONObject;
            Builder builder5 = builder;
            JSONObject jSONObject9 = jSONObject;
            builder.brand(jSONObject.optString("br", null));
            builder5.variant(jSONObject9.optString("va", null));
            if (!jSONObject8.has("attrs")) break block26;
            string = jSONObject.getJSONObject("attrs");
            if (string.length() <= 0) break block26;
            String string2 = string;
            object = hashMap;
            hashMap = new HashMap();
            Iterator iterator = string2.keys();
            while (true) {
                if (!iterator.hasNext()) break;
                Object object2 = object;
                String string3 = string;
                String string4 = (String)iterator.next();
                object2.put(string4, string3.getString(string4));
            }
            try {
                builder.customAttributes((Map<String, String>)object);
            }
            catch (JSONException jSONException) {
                return null;
            }
        }
        builder.build().mTimeAdded = jSONObject.optLong("act", 0L);
        return builder.build();
    }

    @Nullable
    public Map<String, String> getCustomAttributes() {
        return this.mCustomAttributes;
    }

    public double getTotalAmount() {
        return this.getUnitPrice() * this.getQuantity();
    }

    void updateTimeAdded() {
        this.mTimeAdded = System.currentTimeMillis();
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @Nullable
    public String getCategory() {
        return this.mCategory;
    }

    @Nullable
    public String getCouponCode() {
        return this.mCouponCode;
    }

    @NonNull
    public String getSku() {
        return this.mSku;
    }

    @Nullable
    public Integer getPosition() {
        return this.mPosition;
    }

    public double getUnitPrice() {
        return this.mPrice;
    }

    public double getQuantity() {
        double d2;
        double d3 = this.mQuantity;
        if (d2 < 1.0) {
            return 1.0;
        }
        return d3;
    }

    public boolean equals(@Nullable Object object) {
        Product product;
        if (object == null) {
            return false;
        }
        if (product == this) {
            return true;
        }
        if (!(product instanceof Product)) {
            return false;
        }
        product = product;
        EqualityComparator equalityComparator = mComparator;
        if (equalityComparator == null) {
            return false;
        }
        return equalityComparator.equals(this, product);
    }

    @Nullable
    public String getBrand() {
        return this.mBrand;
    }

    @Nullable
    public String getVariant() {
        return this.mVariant;
    }

    @NonNull
    public String toString() {
        return this.toJson().toString();
    }

    @NonNull
    JSONObject toJson() {
        JSONObject jSONObject;
        block44: {
            JSONObject jSONObject2;
            Object object;
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        JSONObject jSONObject3;
                                        Product product = this_;
                                        jSONObject = jSONObject3;
                                        jSONObject3 = new JSONObject();
                                        object = product.mName;
                                        if (object == null) break block37;
                                        jSONObject.put("nm", object);
                                    }
                                    object = this_.mCategory;
                                    if (object == null) break block38;
                                    jSONObject.put("ca", object);
                                }
                                object = this_.mCouponCode;
                                if (object == null) break block39;
                                jSONObject.put("cc", object);
                            }
                            object = this_.mSku;
                            if (object == null) break block40;
                            jSONObject.put("id", object);
                        }
                        object = this_.mPosition;
                        if (object == null) break block41;
                        jSONObject.put("ps", object);
                    }
                    Product product = this_;
                    JSONObject jSONObject4 = jSONObject;
                    Product product2 = this_;
                    JSONObject jSONObject5 = jSONObject;
                    Product product3 = this_;
                    JSONObject jSONObject6 = jSONObject;
                    Product product4 = this_;
                    JSONObject jSONObject7 = jSONObject;
                    Product product5 = this_;
                    object = "pr";
                    double d2 = product5.mPrice;
                    jSONObject7.put((String)object, d2);
                    object = "qt";
                    d2 = product4.mQuantity;
                    jSONObject6.put((String)object, d2);
                    object = "act";
                    long l2 = product3.mTimeAdded;
                    jSONObject5.put((String)object, l2);
                    object = "tpa";
                    double d3 = product2.getTotalAmount();
                    jSONObject4.put((String)object, d3);
                    object = product.mBrand;
                    if (object == null) break block42;
                    jSONObject.put("br", object);
                }
                object = this_.mVariant;
                if (object == null) break block43;
                jSONObject.put("va", object);
            }
            object = this_.mCustomAttributes;
            if (object == null) break block44;
            if (object.size() <= 0) break block44;
            Product product = this_;
            Product this_ = jSONObject2;
            jSONObject2 = new JSONObject();
            object = product.mCustomAttributes.entrySet().iterator();
            while (true) {
                if (!object.hasNext()) break;
                Product product6 = this_;
                Map.Entry entry = (Map.Entry)object.next();
                Map.Entry entry2 = entry;
                String string = (String)entry.getKey();
                product6.put(string, entry2.getValue());
            }
            try {
                jSONObject.put("attrs", (Object)this_);
            }
            catch (JSONException jSONException) {
                return new JSONObject();
            }
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    void setQuantity(double quantity) {
        void var1_1;
        this.mQuantity = var1_1;
    }

    public static class Builder {
        private String mName;
        private String mCategory;
        private String mCouponCode;
        private String mSku;
        private Integer mPosition;
        private double mPrice;
        private double mQuantity;
        private String mBrand;
        private String mVariant;
        private Map<String, String> mCustomAttributes;

        Builder() {
            this.mName = null;
            this.mQuantity = 1.0;
            this.mCustomAttributes = null;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String name, @NonNull String sku, double unitPrice) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.mQuantity = 1.0;
            this.mCustomAttributes = null;
            this.mName = var1_1;
            this.mSku = var2_2;
            this.mPrice = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull Product product) {
            void var1_1;
            void v02 = var1_1;
            String string = v02.getName();
            String string2 = v02.getSku();
            double d2 = v02.getUnitPrice();
            this(string, string2, d2);
            this.mCategory = ((Product)var1_1).mCategory;
            this.mCouponCode = ((Product)var1_1).mCouponCode;
            this.mPosition = ((Product)var1_1).mPosition;
            this.mPrice = ((Product)var1_1).mPrice;
            this.mQuantity = ((Product)var1_1).mQuantity;
            this.mBrand = ((Product)var1_1).mBrand;
            this.mVariant = ((Product)var1_1).mVariant;
            if (product.getCustomAttributes() != null) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.putAll(var1_1.getCustomAttributes());
                this.mCustomAttributes = hashMap;
            }
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder customAttributes(@Nullable Map<String, String> attributes) {
            void var1_1;
            this.mCustomAttributes = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder category(@Nullable String category) {
            void var1_1;
            this.mCategory = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder couponCode(@Nullable String couponCode) {
            void var1_1;
            this.mCouponCode = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder sku(@NonNull String sku) {
            void var1_1;
            this.mSku = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder name(@NonNull String name) {
            void var1_1;
            this.mName = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder position(@Nullable Integer position) {
            void var1_1;
            this.mPosition = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder unitPrice(double price) {
            void var1_1;
            this.mPrice = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder quantity(double quantity) {
            void var1_1;
            this.mQuantity = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder brand(@Nullable String brand) {
            void var1_1;
            this.mBrand = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder variant(@Nullable String variant) {
            void var1_1;
            this.mVariant = var1_1;
            return this;
        }

        @NonNull
        public Product build() {
            return new Product(this);
        }
    }

    static class b
    implements EqualityComparator {
        b() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(@Nullable Product product1, @Nullable Product product2) {
            void var2_2;
            if (product1 != null && var2_2 != null) {
                void var1_1;
                return var1_1.toString().equals(var2_2.toString());
            }
            return false;
        }
    }

    public static interface EqualityComparator {
        public boolean equals(@Nullable Product var1, @Nullable Product var2);
    }
}

