/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mparticle.AttributionListener;
import com.mparticle.Configuration;
import com.mparticle.MParticle;
import com.mparticle.identity.BaseIdentityTask;
import com.mparticle.identity.IdentityApiRequest;
import com.mparticle.internal.Logger;
import com.mparticle.internal.MPUtility;
import com.mparticle.internal.PushRegistrationHelper;
import com.mparticle.internal.SideloadedKit;
import com.mparticle.internal.b;
import com.mparticle.networking.NetworkOptions;
import com.mparticle.networking.d;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MParticleOptions {
    private BaseIdentityTask mIdentityTask;
    private Context mContext;
    private MParticle.InstallType mInstallType;
    private MParticle.Environment mEnvironment;
    private String mApiKey;
    private String mApiSecret;
    private IdentityApiRequest mIdentifyRequest;
    private Boolean mDevicePerformanceMetricsDisabled;
    private Boolean mAndroidIdEnabled;
    private Integer mUploadInterval;
    private Integer mSessionTimeout;
    private Integer mConfigMaxAge;
    private Boolean mUnCaughtExceptionLogging;
    private MParticle.LogLevel mLogLevel;
    private AttributionListener mAttributionListener;
    private BatchCreationListener batchCreationListener;
    private LocationTracking mLocationTracking;
    private PushRegistrationHelper.PushRegistration mPushRegistration;
    private Integer mIdentityConnectionTimeout;
    private NetworkOptions mNetworkOptions;
    private String mDataplanId;
    private Integer mDataplanVersion;
    private MParticle.OperatingSystem mOperatingSystem;
    private DataplanOptions mDataplanOptions;
    private Map<Class, List<Configuration>> mConfigurations;
    private List<SideloadedKit> sideloadedKits;

    private MParticleOptions() {
        ((MParticleOptions)((Object)this_)).mInstallType = MParticle.InstallType.AutoDetect;
        ((MParticleOptions)((Object)this_)).mEnvironment = MParticle.Environment.AutoDetect;
        Boolean this_ = Boolean.FALSE;
        v0.mDevicePerformanceMetricsDisabled = this_;
        v0.mAndroidIdEnabled = this_;
        v0.mUploadInterval = 600;
        v0.mSessionTimeout = 60;
        v0.mConfigMaxAge = null;
        v0.mUnCaughtExceptionLogging = this_;
        v0.mLogLevel = MParticle.LogLevel.DEBUG;
        v0.batchCreationListener = null;
        v0.mIdentityConnectionTimeout = 30;
        v0.mOperatingSystem = MParticle.OperatingSystem.ANDROID;
        v0.mConfigurations = new HashMap<Class, List<Configuration>>();
        v0.sideloadedKits = new ArrayList<SideloadedKit>();
    }

    /*
     * WARNING - void declaration
     */
    public MParticleOptions(@NonNull Builder builder) {
        void var1_1;
        this.mInstallType = MParticle.InstallType.AutoDetect;
        Object[] objectArray = MParticle.Environment.AutoDetect;
        this.mEnvironment = objectArray;
        Object object = Boolean.FALSE;
        this.mDevicePerformanceMetricsDisabled = object;
        this.mAndroidIdEnabled = object;
        this.mUploadInterval = 600;
        this.mSessionTimeout = 60;
        this.mConfigMaxAge = null;
        this.mUnCaughtExceptionLogging = object;
        this.mLogLevel = MParticle.LogLevel.DEBUG;
        this.batchCreationListener = null;
        this.mIdentityConnectionTimeout = 30;
        this.mOperatingSystem = MParticle.OperatingSystem.ANDROID;
        this.mConfigurations = new HashMap<Class, List<Configuration>>();
        this.sideloadedKits = new ArrayList<SideloadedKit>();
        this.mContext = ((Builder)var1_1).context;
        object = builder.apiKey;
        if (object != null) {
            this.mApiKey = object;
        }
        if ((object = var1_1.apiSecret) != null) {
            this.mApiSecret = object;
        }
        if (((Builder)var1_1).installType != null) {
            this.mInstallType = ((Builder)var1_1).installType;
        }
        if (((Builder)var1_1).environment != null) {
            this.mEnvironment = ((Builder)var1_1).environment;
        }
        if ((object = this.mEnvironment) == null || object == objectArray) {
            this.mEnvironment = ((Builder)var1_1).isAppDebuggable ? MParticle.Environment.Development : MParticle.Environment.Production;
        }
        if (((Builder)var1_1).identifyRequest != null) {
            this.mIdentifyRequest = ((Builder)var1_1).identifyRequest;
        }
        if ((objectArray = var1_1.identityTask) != null) {
            this.mIdentityTask = objectArray;
        }
        if (((Builder)var1_1).devicePerformanceMetricsDisabled != null) {
            this.mDevicePerformanceMetricsDisabled = ((Builder)var1_1).devicePerformanceMetricsDisabled;
        }
        if (((Builder)var1_1).androidIdEnabled != null) {
            this.mAndroidIdEnabled = ((Builder)var1_1).androidIdEnabled;
        }
        objectArray = new String[1];
        int n2 = 0;
        String string = "ANDROID_ID will%s be collected based on %s settings";
        Object[] objectArray2 = new Object[2];
        int n3 = 0;
        String string2 = this.mAndroidIdEnabled != false ? "" : " not";
        objectArray2[n3] = string2;
        n3 = 1;
        string2 = ((Builder)var1_1).androidIdEnabled != null ? "MParticleOptions" : "default";
        objectArray2[n3] = string2;
        objectArray[n2] = String.format(string, objectArray2);
        Logger.info((String[])objectArray);
        if (((Builder)var1_1).uploadInterval != null) {
            if (((Builder)var1_1).uploadInterval <= 0) {
                Logger.warning("Upload Interval must be a positive number, disregarding value.");
            } else {
                this.mUploadInterval = ((Builder)var1_1).uploadInterval;
            }
        }
        if (((Builder)var1_1).sessionTimeout != null) {
            if (((Builder)var1_1).sessionTimeout <= 0) {
                Logger.warning("Session Timeout must be a positive number, disregarding value.");
            } else {
                this.mSessionTimeout = ((Builder)var1_1).sessionTimeout;
            }
        }
        if (((Builder)var1_1).configMaxAge != null) {
            if (((Builder)var1_1).configMaxAge < 0) {
                Logger.warning("Config Max Age must be a positive number, disregarding value.");
            } else {
                this.mConfigMaxAge = ((Builder)var1_1).configMaxAge;
            }
        }
        if (((Builder)var1_1).unCaughtExceptionLogging != null) {
            this.mUnCaughtExceptionLogging = ((Builder)var1_1).unCaughtExceptionLogging;
        }
        if ((objectArray = var1_1.logLevel) != null) {
            this.mLogLevel = objectArray;
        }
        if (((Builder)var1_1).attributionListener != null) {
            this.mAttributionListener = ((Builder)var1_1).attributionListener;
        }
        if (((Builder)var1_1).batchCreationListener != null) {
            this.batchCreationListener = ((Builder)var1_1).batchCreationListener;
        }
        if (((Builder)var1_1).locationTracking != null) {
            this.mLocationTracking = ((Builder)var1_1).locationTracking;
        }
        if (((Builder)var1_1).pushRegistration != null) {
            this.mPushRegistration = ((Builder)var1_1).pushRegistration;
        }
        if (((Builder)var1_1).identityConnectionTimeout != null && ((Builder)var1_1).identityConnectionTimeout >= 1) {
            this.mIdentityConnectionTimeout = ((Builder)var1_1).identityConnectionTimeout;
        } else if (((Builder)var1_1).identityConnectionTimeout != null) {
            String[] stringArray = new String[1];
            Object[] objectArray3 = new Object[2];
            objectArray = objectArray3;
            objectArray3[0] = String.valueOf(1);
            objectArray3[1] = String.valueOf(30);
            stringArray[0] = String.format("Connection Timeout milliseconds must be a positive number, greater than %s second. Defaulting to %s seconds", objectArray);
            Logger.warning(stringArray);
        }
        if (((Builder)var1_1).operatingSystem != null) {
            this.mOperatingSystem = ((Builder)var1_1).operatingSystem;
        }
        this.mNetworkOptions = d.a(((Builder)var1_1).networkOptions);
        this.mDataplanId = ((Builder)var1_1).dataplanId;
        this.mDataplanVersion = ((Builder)var1_1).dataplanVersion;
        this.mDataplanOptions = ((Builder)var1_1).dataplanOptions;
        this.mConfigurations = ((Builder)var1_1).configurations;
        this.sideloadedKits = ((Builder)var1_1).sideloadedKits;
    }

    @NonNull
    public static Builder builder(@NonNull Context context) {
        Context context2;
        return new Builder(context2);
    }

    @NonNull
    public Context getContext() {
        return this.mContext;
    }

    @NonNull
    public MParticle.InstallType getInstallType() {
        return this.mInstallType;
    }

    @NonNull
    public MParticle.Environment getEnvironment() {
        return this.mEnvironment;
    }

    @NonNull
    public List<SideloadedKit> getSideloadedKits() {
        return this.sideloadedKits;
    }

    @NonNull
    public String getApiKey() {
        return this.mApiKey;
    }

    @NonNull
    public String getApiSecret() {
        return this.mApiSecret;
    }

    @Nullable
    public IdentityApiRequest getIdentifyRequest() {
        return this.mIdentifyRequest;
    }

    @NonNull
    public Boolean isDevicePerformanceMetricsDisabled() {
        return this.mDevicePerformanceMetricsDisabled;
    }

    @Deprecated
    @NonNull
    public Boolean isAndroidIdDisabled() {
        return this.mAndroidIdEnabled ^ true;
    }

    @NonNull
    public Boolean isAndroidIdEnabled() {
        return this.mAndroidIdEnabled;
    }

    @NonNull
    public Integer getUploadInterval() {
        return this.mUploadInterval;
    }

    @NonNull
    public Integer getSessionTimeout() {
        return this.mSessionTimeout;
    }

    @NonNull
    public Integer getConfigMaxAge() {
        return this.mConfigMaxAge;
    }

    @NonNull
    public Boolean isUncaughtExceptionLoggingEnabled() {
        return this.mUnCaughtExceptionLogging;
    }

    @NonNull
    public MParticle.LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    @Nullable
    public BaseIdentityTask getIdentityTask() {
        return this.mIdentityTask;
    }

    @Nullable
    public AttributionListener getAttributionListener() {
        return this.mAttributionListener;
    }

    @Nullable
    public BatchCreationListener getBatchCreationListener() {
        return this.batchCreationListener;
    }

    public boolean hasLocationTracking() {
        return this.mLocationTracking != null;
    }

    @Nullable
    public LocationTracking getLocationTracking() {
        return this.mLocationTracking;
    }

    @Nullable
    public PushRegistrationHelper.PushRegistration getPushRegistration() {
        return this.mPushRegistration;
    }

    public int getConnectionTimeout() {
        return this.mIdentityConnectionTimeout;
    }

    @NonNull
    public NetworkOptions getNetworkOptions() {
        return this.mNetworkOptions;
    }

    @Nullable
    public String getDataplanId() {
        return this.mDataplanId;
    }

    @Nullable
    public Integer getDataplanVersion() {
        return this.mDataplanVersion;
    }

    @NonNull
    public MParticle.OperatingSystem getOperatingSystem() {
        return this.mOperatingSystem;
    }

    @Nullable
    public DataplanOptions getDataplanOptions() {
        return this.mDataplanOptions;
    }

    @NonNull
    public List<Configuration> getConfigurations() {
        return new ArrayList<List<Configuration>>(this.mConfigurations.values());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T extends Configuration> T getConfiguration(Class<T> clazz) {
        Iterator<List<Configuration>> this_ = ((MParticleOptions)((Object)this_)).mConfigurations.values().iterator();
        while (this_.hasNext()) {
            for (Configuration configuration : (List)this_.next()) {
                void var1_1;
                if (configuration.getClass() != var1_1) continue;
                return (T)configuration;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public <T> List<Configuration<T>> getConfigurationsForTarget(Class<T> clazz) {
        void var1_1;
        List<Configuration> this_ = ((MParticleOptions)((Object)this_)).mConfigurations.get(var1_1);
        if (this_ == null) {
            return new ArrayList<Configuration<T>>();
        }
        return new ArrayList<Configuration<T>>(this_);
    }

    public static interface BatchCreationListener {
        @Nullable
        public JSONObject onBatchCreated(@NonNull JSONObject var1);
    }

    public static class DataplanOptions {
        private JSONObject dataplan;
        private boolean blockUserAttributes;
        private boolean blockUserIdentities;
        private boolean blockEventAttributes;
        private boolean blockEvents;

        /*
         * WARNING - void declaration
         */
        private DataplanOptions(@NonNull Builder builder) {
            void var1_1;
            this.dataplan = ((Builder)var1_1).dataplanVersion;
            this.blockUserAttributes = ((Builder)var1_1).blockUserAttributes;
            this.blockUserIdentities = ((Builder)var1_1).blockUserIdentities;
            this.blockEventAttributes = ((Builder)var1_1).blockEventAttributes;
            this.blockEvents = ((Builder)var1_1).blockEvents;
        }

        public static Builder builder() {
            return new Builder();
        }

        @NonNull
        public JSONObject getDataplan() {
            return this.dataplan;
        }

        public boolean isBlockUserAttributes() {
            return this.blockUserAttributes;
        }

        public boolean isBlockUserIdentities() {
            return this.blockUserIdentities;
        }

        public boolean isBlockEventAttributes() {
            return this.blockEventAttributes;
        }

        public boolean isBlockEvents() {
            return this.blockEvents;
        }

        public String toString() {
            String string;
            try {
                string = this.dataplan.toString(4);
            }
            catch (JSONException jSONException) {
                string = "Unable to print Dataplan";
            }
            return "DataplanOptions {\n\tblockUserAttributes=" + this.blockUserAttributes + ", \n\tblockUserIdentities=" + this.blockUserIdentities + ", \n\tblockEventAttributes=" + this.blockEventAttributes + ", \n\tblockEvents=" + this.blockEvents + ",\n\tdataplan=" + string + "\n}";
        }

        public static class Builder {
            private JSONObject dataplanVersion;
            private boolean blockUserAttributes;
            private boolean blockUserIdentities;
            private boolean blockEventAttributes;
            private boolean blockEvents;

            private Builder() {
            }

            /*
             * WARNING - void declaration
             */
            public Builder dataplanVersion(String dataplanVersion) {
                JSONObject jSONObject;
                Builder builder = this;
                JSONObject jSONObject2 = jSONObject;
                try {
                    void var1_1;
                    jSONObject = new JSONObject((String)var1_1);
                    builder.dataplanVersion = jSONObject2;
                }
                catch (JSONException jSONException) {
                    Logger.error("Unable to parse dataplan json. Dataplan will not be applied");
                }
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder dataplanVersion(JSONObject dataplanVersion) {
                void var1_1;
                this.dataplanVersion = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder dataplanVersion(Map<String, Object> dataplanVersion) {
                JSONObject jSONObject;
                Builder builder = this;
                JSONObject jSONObject2 = jSONObject;
                try {
                    void var1_1;
                    jSONObject = new JSONObject((Map)var1_1);
                    builder.dataplanVersion = jSONObject2;
                }
                catch (Exception exception) {
                    Logger.error("Unable to parse dataplan json. Dataplan will not be applied");
                }
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder blockUserAttributes(boolean blockUserAttributes) {
                void var1_1;
                this.blockUserAttributes = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder blockUserIdentities(boolean blockUserIdentities) {
                void var1_1;
                this.blockUserIdentities = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder blockEventAttributes(boolean blockEventAttributes) {
                void var1_1;
                this.blockEventAttributes = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder blockEvents(boolean blockEvents) {
                void var1_1;
                this.blockEvents = var1_1;
                return this;
            }

            @Nullable
            public DataplanOptions build() {
                if (MPUtility.isEmpty(((Builder)((Object)this_)).dataplanVersion)) {
                    String this_ = "Configuration issue: dataplan is not required, but it may not be empty. Ignoring Dataplan";
                    if (!MPUtility.isDevEnv()) {
                        Logger.error(this_);
                        return null;
                    }
                    throw new IllegalArgumentException(this_);
                }
                return new DataplanOptions((Builder)((Object)this_));
            }
        }
    }

    static class LocationTracking {
        boolean enabled;
        String provider;
        long minTime;
        long minDistance;

        /*
         * WARNING - void declaration
         */
        protected LocationTracking(boolean enabled) {
            void var1_1;
            this.enabled = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected LocationTracking(String provider, long minTime, long minDistance) {
            void var4_3;
            void var2_2;
            void var1_1;
            this.enabled = true;
            this.provider = var1_1;
            this.minTime = var2_2;
            this.minDistance = var4_3;
        }
    }

    public static class Builder {
        private Context context;
        String apiKey;
        String apiSecret;
        private MParticle.InstallType installType;
        private MParticle.Environment environment;
        private IdentityApiRequest identifyRequest;
        private Boolean devicePerformanceMetricsDisabled = null;
        private Boolean androidIdEnabled = null;
        private Integer uploadInterval = null;
        private Integer sessionTimeout = null;
        private Integer configMaxAge = null;
        private Boolean unCaughtExceptionLogging = null;
        MParticle.LogLevel logLevel = null;
        BaseIdentityTask identityTask;
        private AttributionListener attributionListener;
        private BatchCreationListener batchCreationListener;
        private b configManager;
        private LocationTracking locationTracking;
        private PushRegistrationHelper.PushRegistration pushRegistration;
        private Integer identityConnectionTimeout = null;
        private NetworkOptions networkOptions;
        private String dataplanId;
        private Integer dataplanVersion;
        private MParticle.OperatingSystem operatingSystem;
        private DataplanOptions dataplanOptions;
        private Map<Class, List<Configuration>> configurations;
        private boolean isAppDebuggable;
        private List<SideloadedKit> sideloadedKits;

        /*
         * WARNING - void declaration
         */
        private Builder(Context context) {
            void var1_1;
            ArrayList arrayList;
            HashMap hashMap;
            Object this_ = hashMap;
            hashMap = new HashMap();
            v1.configurations = this_;
            this_ = arrayList;
            arrayList = new ArrayList();
            v1.sideloadedKits = this_;
            v1.context = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder credentials(@NonNull String apiKey, @NonNull String apiSecret) {
            void var2_2;
            void var1_1;
            this.apiKey = var1_1;
            this.apiSecret = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder installType(@NonNull MParticle.InstallType installType) {
            void var1_1;
            this.installType = var1_1;
            return this;
        }

        @NonNull
        public Builder sideloadedKits(@NonNull List<SideloadedKit> kits) {
            ArrayList<SideloadedKit> arrayList;
            ArrayList<SideloadedKit> arrayList2 = arrayList;
            arrayList = new ArrayList<SideloadedKit>();
            for (SideloadedKit sideloadedKit : kits) {
                if (sideloadedKit.kitId() < 1000000) {
                    Logger.error("Sideloaded kit " + sideloadedKit.getName() + " must have a kitId greater or equal than 1000000, current one is " + sideloadedKit.kitId() + " and will not be included.");
                    continue;
                }
                arrayList2.add(sideloadedKit);
            }
            this.sideloadedKits = arrayList2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder environment(@NonNull MParticle.Environment environment) {
            void var1_1;
            this.environment = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder identify(@NonNull IdentityApiRequest identifyRequest) {
            void var1_1;
            this.identifyRequest = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder identifyTask(@NonNull BaseIdentityTask task) {
            void var1_1;
            this.identityTask = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder devicePerformanceMetricsDisabled(boolean disabled) {
            void var1_1;
            this.devicePerformanceMetricsDisabled = (boolean)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder androidIdDisabled(boolean disabled) {
            void var1_1;
            this.androidIdEnabled = (var1_1 ^ 1) != 0;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder androidIdEnabled(boolean enabled) {
            void var1_1;
            this.androidIdEnabled = (boolean)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder uploadInterval(int uploadInterval) {
            void var1_1;
            this.uploadInterval = (int)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder sessionTimeout(int sessionTimeout) {
            void var1_1;
            this.sessionTimeout = (int)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder configMaxAgeSeconds(int configMaxAge) {
            void var1_1;
            this.configMaxAge = (int)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder enableUncaughtExceptionLogging(boolean enable) {
            void var1_1;
            this.unCaughtExceptionLogging = (boolean)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder logLevel(@NonNull MParticle.LogLevel logLevel) {
            void var1_1;
            this.logLevel = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder attributionListener(@Nullable AttributionListener attributionListener) {
            void var1_1;
            this.attributionListener = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder batchCreationListener(@Nullable BatchCreationListener batchCreationListener) {
            void var1_1;
            this.batchCreationListener = var1_1;
            return this;
        }

        @NonNull
        public Builder locationTrackingDisabled() {
            LocationTracking locationTracking;
            Builder builder = this_;
            LocationTracking this_ = locationTracking;
            locationTracking = new LocationTracking(false);
            builder.locationTracking = this_;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder locationTrackingEnabled(@NonNull String provider, long minTime, long minDistance) {
            void var4_3;
            void var2_2;
            void var1_1;
            LocationTracking locationTracking;
            Builder builder = this_;
            LocationTracking this_ = locationTracking;
            locationTracking = new LocationTracking((String)var1_1, (long)var2_2, (long)var4_3);
            builder.locationTracking = this_;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder pushRegistration(@NonNull String instanceId, @NonNull String senderId) {
            void var2_2;
            void var1_1;
            PushRegistrationHelper.PushRegistration pushRegistration;
            Builder builder = this_;
            PushRegistrationHelper.PushRegistration this_ = pushRegistration;
            pushRegistration = new PushRegistrationHelper.PushRegistration((String)var1_1, (String)var2_2);
            builder.pushRegistration = this_;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder identityConnectionTimeout(int identityConnectionTimeout) {
            void var1_1;
            this.identityConnectionTimeout = (int)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder networkOptions(@Nullable NetworkOptions networkOptions) {
            void var1_1;
            this.networkOptions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder dataplan(@Nullable String dataplanId, @Nullable Integer dataplanVersion) {
            void var2_2;
            void var1_1;
            this.dataplanId = var1_1;
            this.dataplanVersion = var2_2;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder operatingSystem(MParticle.OperatingSystem operatingSystem) {
            void var1_1;
            this.operatingSystem = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder dataplanOptions(DataplanOptions dataplanOptions) {
            void var1_1;
            this.dataplanOptions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder configuration(Configuration configuration) {
            void var1_1;
            ArrayList<void> arrayList = this.configurations.get(var1_1.configures());
            if (arrayList == null) {
                ArrayList<void> arrayList2;
                arrayList = arrayList2;
                arrayList2 = new ArrayList<void>();
            }
            Builder builder = this;
            arrayList.add(var1_1);
            builder.configurations.put(var1_1.configures(), arrayList);
            return builder;
        }

        @NonNull
        public MParticleOptions build() {
            Context context = this.context;
            if (context != null) {
                this.isAppDebuggable = MPUtility.isAppDebuggable(context);
                boolean bl = ((Object)((Object)MParticle.Environment.Development)).equals((Object)this.environment) || this.isAppDebuggable;
                if (MPUtility.isEmpty(this.apiKey)) {
                    String string = "Configuration issue: No API key passed to start()!";
                    if (!bl) {
                        Logger.error(string);
                    } else {
                        throw new IllegalArgumentException(string);
                    }
                }
                if (MPUtility.isEmpty(this.apiSecret)) {
                    String string = "Configuration issue: No API secret passed to start()!";
                    if (!bl) {
                        Logger.error(string);
                    } else {
                        throw new IllegalArgumentException(string);
                    }
                }
                return new MParticleOptions(this);
            }
            throw new IllegalArgumentException("mParticle failed to start: context is required.");
        }

        MParticleOptions buildForInternalRestart() {
            return new MParticleOptions(this);
        }
    }
}

