/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mparticle.BaseEvent;
import com.mparticle.MParticle;
import com.mparticle.d;
import com.mparticle.internal.Logger;
import com.mparticle.internal.MPUtility;
import com.mparticle.internal.listeners.InternalListenerManager;
import com.mparticle.y;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MPEvent
extends BaseEvent {
    private MParticle.EventType eventType;
    private String eventName;
    private String category;
    private Double duration = null;
    private Double startTime = null;
    private Double endTime = null;
    private int eventHash;
    private boolean entering = true;
    private boolean screenEvent;

    private MPEvent() {
        super(BaseEvent.Type.EVENT);
    }

    /*
     * WARNING - void declaration
     */
    private MPEvent(Builder builder) {
        super(BaseEvent.Type.EVENT);
        void var1_1;
        if (builder.eventType == null) {
            Logger.error("MPEvent created with no event type!");
        } else {
            this.eventType = ((Builder)var1_1).eventType;
        }
        if (((Builder)var1_1).eventName == null) {
            Logger.error("MPEvent created with no event name!");
        } else if (((Builder)var1_1).eventName.length() > 256) {
            Logger.error("MPEvent created with too long of a name and will be truncated, the limit is: 256");
            this.eventName = ((Builder)var1_1).eventName.substring(0, 256);
        } else {
            this.eventName = ((Builder)var1_1).eventName;
        }
        this.entering = ((Builder)var1_1).entering;
        this.setCustomAttributes(((Builder)var1_1).customAttributes);
        if (((Builder)var1_1).category != null) {
            this.category = ((Builder)var1_1).category;
            if (this.getCustomAttributeStrings() == null) {
                HashMap hashMap;
                HashMap hashMap2 = hashMap;
                hashMap = new HashMap();
                this.setCustomAttributes(hashMap2);
            }
            this.getCustomAttributeStrings().put("$Category", ((Builder)var1_1).category);
        }
        if (((Builder)var1_1).duration != null) {
            this.duration = ((Builder)var1_1).duration;
        }
        if (((Builder)var1_1).endTime != null) {
            this.endTime = ((Builder)var1_1).endTime;
        }
        if (((Builder)var1_1).startTime != null) {
            this.startTime = ((Builder)var1_1).startTime;
        }
        if (((Builder)var1_1).customFlags != null) {
            this.setCustomFlags(((Builder)var1_1).customFlags);
        }
        if (((Builder)var1_1).shouldUploadEvent != null) {
            this.setShouldUploadEvent(((Builder)var1_1).shouldUploadEvent);
        }
        this.screenEvent = ((Builder)var1_1).screenEvent;
    }

    /*
     * WARNING - void declaration
     */
    public MPEvent(@NonNull MPEvent mpEvent) {
        super(BaseEvent.Type.EVENT);
        void var1_1;
        this.eventType = var1_1.eventType;
        this.eventName = var1_1.eventName;
        if (mpEvent.getCustomAttributes() != null) {
            this.setCustomAttributes(var1_1.getCustomAttributes());
        } else {
            this.setCustomAttributes(null);
        }
        this.category = var1_1.category;
        this.duration = var1_1.duration;
        this.endTime = var1_1.endTime;
        this.startTime = var1_1.startTime;
        this.setCustomFlags(var1_1.getCustomFlags());
        this.entering = var1_1.entering;
        this.screenEvent = var1_1.screenEvent;
        this.setShouldUploadEvent(var1_1.isShouldUploadEvent());
        InternalListenerManager.getListener().onCompositeObjects(var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object o2) {
        void var1_1;
        return super.equals(var1_1) || var1_1 != null && this.toString().equals(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setInfo(@Nullable Map<String, String> info) {
        void var1_1;
        this.setCustomAttributes((Map<String, ?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCustomAttributes(@NonNull Map<String, ?> customAttributes) {
        void var1_1;
        super.setCustomAttributes((Map<String, ?>)var1_1);
    }

    @NonNull
    public String toString() {
        Object object;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (this.eventName != null) {
            stringBuilder2.append("Event name: ").append(this.eventName).append("\n");
        }
        if (this.eventType != null) {
            stringBuilder2.append("type: ").append(this.eventType.name()).append("\n");
        }
        if ((object = this.getLength()) != null && (Double)object > 0.0) {
            stringBuilder2.append("length: ").append(object).append("ms").append("\n");
        }
        if (this.getCustomAttributeStrings() != null) {
            stringBuilder2.append("customAttributes:\n");
            ArrayList<String> arrayList = new ArrayList<String>(this.getCustomAttributeStrings().keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                stringBuilder2.append(string).append(":").append(this.getCustomAttributeStrings().get(string)).append("\n");
            }
        }
        if (this.getCustomFlags() != null) {
            stringBuilder2.append("custom flags:\n");
            stringBuilder2.append(this.getCustomFlags().toString());
        }
        return stringBuilder2.toString();
    }

    @NonNull
    public String getEventName() {
        return this.eventName;
    }

    public boolean isScreenEvent() {
        return this.screenEvent;
    }

    /*
     * WARNING - void declaration
     */
    protected MPEvent setScreenEvent(boolean screenEvent) {
        void var1_1;
        this.screenEvent = var1_1;
        BaseEvent.Type type = screenEvent ? BaseEvent.Type.SCREEN_VIEW : BaseEvent.Type.EVENT;
        MPEvent mPEvent = this;
        mPEvent.setType(type);
        return mPEvent;
    }

    public int getEventHash() {
        if (this.eventHash == 0) {
            this.eventHash = MPUtility.mpHash(this.eventType.ordinal() + this.eventName);
        }
        return this.eventHash;
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    @Deprecated
    @Nullable
    public Map<String, String> getInfo() {
        return this.getCustomAttributeStrings();
    }

    @NonNull
    public MParticle.EventType getEventType() {
        return this.eventType;
    }

    @Nullable
    public Double getLength() {
        Double d2 = this.duration;
        if (d2 != null) {
            return d2;
        }
        d2 = this.endTime;
        if (d2 != null && this.startTime != null) {
            double d3;
            double d4 = d2 - this.startTime;
            if (!(d3 > 0.0)) {
                d4 = 0.0;
            }
            return d4;
        }
        return null;
    }

    boolean getNavigationDirection() {
        return this.entering;
    }

    @Override
    @NonNull
    public d getMessage() {
        return new y.a("e").a(this.getEventType()).b(this.getEventName()).b(this.getLength()).a(this.getCustomFlags()).a(MPUtility.enforceAttributeConstraints(this.getCustomAttributeStrings()));
    }

    public static class Builder {
        private static final String EVENT_TYPE = "eventType";
        private static final String EVENT_CUSTOM_FLAGS = "customFlags";
        private static final String EVENT_NAME = "eventName";
        private static final String EVENT_CATEGORY = "category";
        private static final String EVENT_DURATION = "duration";
        private static final String EVENT_INFO = "customAttributes";
        private static final String EVENT_START_TIME = "startTime";
        private static final String EVENT_END_TIME = "endTime";
        private static final String EVENT_SHOULD_UPLOAD_EVENT = "shouldUploadEvent";
        private boolean screenEvent;
        private MParticle.EventType eventType;
        private String eventName;
        private String category;
        private Map<String, ?> customAttributes;
        private Double duration;
        private Double startTime;
        private Double endTime;
        private Map<String, List<String>> customFlags;
        private boolean entering;
        private Boolean shouldUploadEvent;

        private Builder() {
            this.duration = null;
            this.startTime = null;
            this.endTime = null;
            this.customFlags = null;
            this.entering = true;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String eventName, @NonNull MParticle.EventType eventType) {
            void var2_2;
            void var1_1;
            this.duration = null;
            this.startTime = null;
            this.endTime = null;
            this.customFlags = null;
            this.entering = true;
            this.eventName = var1_1;
            this.eventType = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String eventName) {
            void var1_1;
            Builder builder = this;
            this.duration = null;
            this.startTime = null;
            this.endTime = null;
            this.customFlags = null;
            this.entering = true;
            builder.eventName = var1_1;
            builder.eventType = MParticle.EventType.Other;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull MPEvent event) {
            void var1_1;
            this.duration = null;
            this.startTime = null;
            this.endTime = null;
            this.customFlags = null;
            this.entering = true;
            this.eventName = var1_1.getEventName();
            this.eventType = var1_1.getEventType();
            this.category = var1_1.getCategory();
            this.customAttributes = var1_1.getCustomAttributes();
            this.duration = ((MPEvent)var1_1).duration;
            this.startTime = ((MPEvent)var1_1).startTime;
            this.endTime = ((MPEvent)var1_1).endTime;
            this.customFlags = var1_1.getCustomFlags();
            this.entering = ((MPEvent)var1_1).entering;
            this.screenEvent = ((MPEvent)var1_1).screenEvent;
            this.shouldUploadEvent = var1_1.isShouldUploadEvent();
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        private Builder startTime(double startTimeMillis) {
            void var1_1;
            this.startTime = (double)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private Builder endTime(double endTimeMillis) {
            void var1_1;
            this.endTime = (double)var1_1;
            return this;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public static Builder parseString(@NonNull String builderString) {
            block34: {
                block33: {
                    var1_2 /* !! */  = null;
                    var2_4 = v0;
                    v0 = new JSONObject((String)var0);
                    var0 = v1;
                    v2 = var2_4;
                    v3 = var0;
                    v4 = var2_4;
                    v5 = v4;
                    var3_5 = v4.getString("eventName");
                    v3((String)var3_5, MParticle.EventType.valueOf(v5.getString("eventType")));
                    v1.category = v2.optString("category");
                    if (!v0.has("duration")) ** GOTO lbl19
                    var0.duration = var2_4.getDouble("duration");
lbl19:
                    // 2 sources

                    if (!var2_4.has("startTime")) ** GOTO lbl22
                    var0.startTime = var2_4.getDouble("startTime");
lbl22:
                    // 2 sources

                    if (!var2_4.has("endTime")) ** GOTO lbl25
                    var0.endTime = var2_4.getDouble("endTime");
lbl25:
                    // 2 sources

                    if (!var2_4.has("customAttributes")) ** GOTO lbl49
                    var1_2 /* !! */  = var2_4.getJSONObject("customAttributes");
                    var3_5 = v6;
                    v6 = new HashMap<K, V>();
                    var4_6 = var1_2 /* !! */ .keys();
                    while (true) {
                        if (!var4_6.hasNext()) break;
                        v7 = var3_5;
                        v8 = var1_2 /* !! */ ;
                        var5_7 = (String)var4_6.next();
                        v7.put(var5_7, v8.getString(var5_7));
                    }
                    v9 = var0;
                    var1_2 /* !! */  = v10;
                    v10 = new HashMap<K, V>(var3_5);
                    v9.customAttributes = var1_2 /* !! */ ;
lbl49:
                    // 2 sources

                    if (!var2_4.has("customFlags")) ** GOTO lbl83
                    var1_2 /* !! */  = var2_4.getJSONObject("customFlags");
                    var3_5 = v11;
                    v11 = new HashMap<K, V>();
                    var4_6 = var1_2 /* !! */ .keys();
                    block31: while (true) {
                        if (!var4_6.hasNext()) break;
                        v12 = var3_5;
                        v13 /* !! */  = var1_2 /* !! */ ;
                        var5_7 = (String)var4_6.next();
                        var6_8 = v13 /* !! */ .getJSONArray(var5_7);
                        v14 = var5_7;
                        var7_10 = v15;
                        v15 = new LinkedList<E>();
                        v12.put(v14, var7_10);
                        var7_9 = 0;
                        while (true) {
                            if (var7_9 >= var6_8.length()) continue block31;
                            ((List)var3_5.get(var5_7)).add(var6_8.getString(var7_9));
                            ++var7_9;
                        }
                        break;
                    }
                    try {
                        var0.customFlags = var3_5;
lbl83:
                        // 2 sources

                        if (!var2_4.has("shouldUploadEvent")) break block33;
                    }
                    catch (Exception var1_3) {}
                    var0.shouldUploadEvent = var2_4.getBoolean("shouldUploadEvent");
                }
                return var0;
                break block34;
                catch (Exception var0_1) {
                    var0 = var1_2 /* !! */ ;
                    var1_2 /* !! */  = var0_1;
                }
            }
            Logger.warning(new String[]{"Failed to deserialize MPEvent.Builder: " + var1_2 /* !! */ .toString()});
            return var0;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder eventName(@NonNull String eventName) {
            if (eventName != null) {
                void var1_1;
                this.eventName = var1_1;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder eventType(@NonNull MParticle.EventType eventType) {
            if (eventType != null) {
                void var1_1;
                this.eventType = var1_1;
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addCustomFlag(@Nullable String key, @Nullable String value) {
            void var2_2;
            void var1_1;
            Cloneable cloneable;
            if (this.customFlags == null) {
                HashMap<String, List<String>> hashMap;
                cloneable = hashMap;
                hashMap = new HashMap<String, List<String>>();
                this.customFlags = cloneable;
            }
            if (!this.customFlags.containsKey(var1_1)) {
                LinkedList linkedList;
                cloneable = linkedList;
                linkedList = new LinkedList();
                this.customFlags.put((String)var1_1, (List<String>)((Object)cloneable));
            }
            Builder builder = this;
            builder.customFlags.get(var1_1).add((String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder customFlags(@Nullable Map<String, List<String>> customFlags) {
            void var1_1;
            this.customFlags = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder category(@Nullable String category) {
            void var1_1;
            this.category = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder duration(double durationMillis) {
            void var1_1;
            this.duration = (double)var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        @NonNull
        public Builder info(@Nullable Map<String, String> info) {
            void var1_1;
            this.customAttributes = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder customAttributes(@Nullable Map<String, ?> customAttributes) {
            void var1_1;
            this.customAttributes = var1_1;
            return this;
        }

        @NonNull
        public Builder startTime() {
            return this.startTime(System.currentTimeMillis());
        }

        @NonNull
        public Builder endTime() {
            return this.endTime(System.currentTimeMillis());
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder internalNavigationDirection(boolean entering) {
            void var1_1;
            this.entering = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder shouldUploadEvent(boolean shouldUploadEvent) {
            void var1_1;
            this.shouldUploadEvent = (boolean)var1_1;
            return this;
        }

        @NonNull
        public MPEvent build() {
            return new MPEvent(this);
        }

        @NonNull
        public String toString() {
            JSONObject jSONObject;
            block39: {
                Object object;
                block38: {
                    JSONObject jSONObject2;
                    Object object2;
                    Iterator<Map.Entry<String, Object>> iterator;
                    block37: {
                        block36: {
                            block35: {
                                JSONObject jSONObject3;
                                block34: {
                                    block33: {
                                        JSONObject jSONObject4;
                                        Builder builder = this;
                                        jSONObject = jSONObject4;
                                        Builder builder2 = this;
                                        JSONObject jSONObject5 = jSONObject;
                                        jSONObject5();
                                        jSONObject5.put(EVENT_TYPE, (Object)this.eventType.toString());
                                        object = EVENT_NAME;
                                        jSONObject4.put((String)object, (Object)builder2.eventName);
                                        object = builder.category;
                                        if (object == null) break block33;
                                        jSONObject.put(EVENT_CATEGORY, object);
                                    }
                                    object = this.duration;
                                    if (object == null) break block34;
                                    jSONObject.put(EVENT_DURATION, object);
                                }
                                if (this.customAttributes == null) break block35;
                                Builder builder = this;
                                object = jSONObject3;
                                jSONObject3 = new JSONObject();
                                iterator = builder.customAttributes.entrySet().iterator();
                                while (true) {
                                    if (!iterator.hasNext()) break;
                                    Object object3 = object;
                                    Map.Entry<String, ?> entry = iterator.next();
                                    Map.Entry<String, ?> entry2 = entry;
                                    object2 = entry.getKey();
                                    object3.put((String)object2, entry2.getValue());
                                }
                                jSONObject.put(EVENT_INFO, object);
                            }
                            object = this.startTime;
                            if (object == null) break block36;
                            jSONObject.put(EVENT_START_TIME, object);
                        }
                        object = this.endTime;
                        if (object == null) break block37;
                        jSONObject.put(EVENT_END_TIME, object);
                    }
                    if (this.customFlags == null) break block38;
                    Builder builder = this;
                    object = jSONObject2;
                    jSONObject2 = new JSONObject();
                    iterator = builder.customFlags.entrySet().iterator();
                    while (true) {
                        JSONArray jSONArray;
                        if (!iterator.hasNext()) break;
                        Object object4 = object;
                        Map.Entry<String, Object> entry = iterator.next();
                        Map.Entry<String, Object> entry3 = entry;
                        object2 = (List)entry.getValue();
                        JSONArray jSONArray2 = jSONArray;
                        jSONArray = new JSONArray((Collection)object2);
                        object4.put(entry3.getKey(), (Object)jSONArray2);
                    }
                    try {
                        jSONObject.put(EVENT_CUSTOM_FLAGS, object);
                    }
                    catch (JSONException jSONException) {
                        Logger.warning("Failed to serialize MPEvent.Builder: " + ((Object)((Object)jSONException)).toString());
                        return super.toString();
                    }
                }
                object = this.shouldUploadEvent;
                if (object == null) break block39;
                jSONObject.put(EVENT_SHOULD_UPLOAD_EVENT, object);
            }
            return jSONObject.toString();
        }
    }
}

