/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.jhlabs.image.UnsharpFilter;
import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ProgressListener;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.List;

public abstract class AdvancedResizeOp
implements BufferedImageOp {
    private List<ProgressListener> listeners = new ArrayList<ProgressListener>();
    private final DimensionConstrain dimensionConstrain;
    private UnsharpenMask unsharpenMask = UnsharpenMask.None;

    public AdvancedResizeOp(DimensionConstrain dimensionConstrain) {
        this.dimensionConstrain = dimensionConstrain;
    }

    public UnsharpenMask getUnsharpenMask() {
        return this.unsharpenMask;
    }

    public void setUnsharpenMask(UnsharpenMask unsharpenMask) {
        this.unsharpenMask = unsharpenMask;
    }

    protected void fireProgressChanged(float fraction) {
        for (ProgressListener progressListener : this.listeners) {
            progressListener.notifyProgress(fraction);
        }
    }

    public final void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    public final boolean removeProgressListener(ProgressListener progressListener) {
        return this.listeners.remove(progressListener);
    }

    public final BufferedImage filter(BufferedImage src, BufferedImage dest) {
        Dimension dstDimension = this.dimensionConstrain.getDimension(new Dimension(src.getWidth(), src.getHeight()));
        int dstWidth = dstDimension.width;
        int dstHeight = dstDimension.height;
        BufferedImage bufferedImage = this.doFilter(src, dest, dstWidth, dstHeight);
        if (this.unsharpenMask != UnsharpenMask.None) {
            UnsharpFilter unsharpFilter = new UnsharpFilter();
            unsharpFilter.setRadius(2.0f);
            unsharpFilter.setAmount(this.unsharpenMask.factor);
            unsharpFilter.setThreshold(10);
            return unsharpFilter.filter(bufferedImage, null);
        }
        return bufferedImage;
    }

    protected abstract BufferedImage doFilter(BufferedImage var1, BufferedImage var2, int var3, int var4);

    public final Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(0, 0, src.getWidth(), src.getHeight());
    }

    public final BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        return new BufferedImage(destCM, destCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), destCM.isAlphaPremultiplied(), null);
    }

    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return (Point2D)srcPt.clone();
    }

    public final RenderingHints getRenderingHints() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnsharpenMask {
        None(0.0f),
        Soft(0.15f),
        Normal(0.3f),
        VerySharp(0.45f),
        Oversharpened(0.6f);

        private final float factor;

        private UnsharpenMask(float factor) {
            this.factor = factor;
        }
    }
}

