/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen;

import com.mockrunner.gen.VersionGenerator;
import com.mockrunner.gen.proc.JavaLineProcessor;
import java.util.HashMap;
import java.util.Map;

public class JDKVersionGenerator {
    public static void main(String[] args) throws Exception {
        VersionGenerator generator = new VersionGenerator(JDKVersionGenerator.prepareProcessorMapJDK13(), JDKVersionGenerator.getGeneratorNameJDK13(), JDKVersionGenerator.getRootTargetDirJDK13(), JDKVersionGenerator.getRootSourceDir(), JDKVersionGenerator.getProcessedPackagesJDK13());
        generator.doSynchronize();
        generator = new VersionGenerator(JDKVersionGenerator.prepareProcessorMapJDK14(), JDKVersionGenerator.getGeneratorNameJDK14(), JDKVersionGenerator.getRootTargetDirJDK14(), JDKVersionGenerator.getRootSourceDir(), JDKVersionGenerator.getProcessedPackagesJDK14());
        generator.doSynchronize();
    }

    private static String getGeneratorNameJDK13() {
        return "JDBC JDK1.3";
    }

    private static String getGeneratorNameJDK14() {
        return "JDBC JDK1.4";
    }

    private static String getRootTargetDirJDK13() {
        return "srcjdk1.3";
    }

    private static String getRootTargetDirJDK14() {
        return "srcjdk1.4";
    }

    private static String getRootSourceDir() {
        return "src";
    }

    private static String[] getProcessedPackagesJDK13() {
        return new String[]{"com/mockrunner/jdbc", "com/mockrunner/mock/jdbc"};
    }

    private static String[] getProcessedPackagesJDK14() {
        return new String[]{"com/mockrunner/mock/jdbc"};
    }

    private static Map prepareProcessorMapJDK13() {
        HashMap<String, Object> jdbcFiles = new HashMap<String, Object>();
        jdbcFiles.putAll(JDKVersionGenerator.prepareProcessorMapJDK14());
        JavaLineProcessor mockConnectionProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockConnection", jdbcFiles);
        mockConnectionProc.addLine("import java.sql.Savepoint;");
        mockConnectionProc.addLine("private int holdability;");
        mockConnectionProc.addLine("holdability = ResultSet.HOLD_CURSORS_OVER_COMMIT;");
        mockConnectionProc.addBlock("public int getHoldability()");
        mockConnectionProc.addBlock("public void setHoldability(int holdability)");
        mockConnectionProc.addBlock("public Savepoint setSavepoint()");
        mockConnectionProc.addBlock("public Savepoint setSavepoint(String name)");
        mockConnectionProc.addBlock("public void releaseSavepoint(Savepoint savepoint)");
        mockConnectionProc.addBlock("public void rollback(Savepoint savepoint)");
        mockConnectionProc.addBlock("public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys)");
        mockConnectionProc.addBlock("public PreparedStatement prepareStatement(String sql, int[] columnIndexes)");
        mockConnectionProc.addBlock("public PreparedStatement prepareStatement(String sql, String[] columnNames)");
        mockConnectionProc.addBlock("private void verifyAutoGeneratedKeysParameter(int autoGeneratedKeys)");
        JavaLineProcessor mockResultSetProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockResultSet", jdbcFiles);
        mockResultSetProc.addLine("private int resultSetHoldability = ResultSet.HOLD_CURSORS_OVER_COMMIT;");
        mockResultSetProc.addLine("resultSetHoldability = statement.getResultSetHoldability();");
        mockResultSetProc.addBlock("public void setResultSetHoldability(int resultSetHoldability)");
        mockResultSetProc.addBlock("public int getHoldability()");
        JavaLineProcessor mockDatabaseMetadataProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockDatabaseMetaData", jdbcFiles);
        mockDatabaseMetadataProc.addLine("private int sqlStateType = sqlStateSQL99;");
        mockDatabaseMetadataProc.addBlock("public int getSQLStateType()");
        mockDatabaseMetadataProc.addBlock("public void setSQLStateType(int sqlStateType)");
        JavaLineProcessor mockPreparedStatementProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockPreparedStatement", jdbcFiles);
        mockPreparedStatementProc.addLine("import java.sql.ParameterMetaData;");
        mockPreparedStatementProc.addLine("private MockParameterMetaData parameterMetaData;");
        mockPreparedStatementProc.addLine("prepareParameterMetaData();");
        mockPreparedStatementProc.addLine("prepareParameterMetaData();");
        mockPreparedStatementProc.addLine("prepareParameterMetaData();");
        mockPreparedStatementProc.addBlock("private void prepareParameterMetaData()");
        mockPreparedStatementProc.addBlock("public ParameterMetaData getParameterMetaData()");
        JavaLineProcessor mockStatementProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockStatement", jdbcFiles);
        mockStatementProc.addLine("private int resultSetHoldability = ResultSet.HOLD_CURSORS_OVER_COMMIT;");
        mockStatementProc.addBlock("try");
        mockStatementProc.addBlock("catch(SQLException exc)");
        mockStatementProc.addBlock("try");
        mockStatementProc.addBlock("catch(SQLException exc)");
        mockStatementProc.addLine("this.resultSetHoldability = resultSetHoldability;");
        mockStatementProc.addBlock("public int getResultSetHoldability()");
        mockStatementProc.addBlock("public int executeUpdate(String sql, int autoGeneratedKeys)");
        mockStatementProc.addBlock("public int executeUpdate(String sql, int[] columnIndexes)");
        mockStatementProc.addBlock("public int executeUpdate(String sql, String[] columnNames)");
        mockStatementProc.addBlock("public boolean execute(String sql, int autoGeneratedKeys)");
        mockStatementProc.addBlock("public boolean execute(String sql, int[] columnIndexes)");
        mockStatementProc.addBlock("public boolean execute(String sql, String[] columnNames)");
        mockStatementProc.addBlock("private void setGeneratedKeysResultSet(String sql, int autoGeneratedKeys)");
        mockStatementProc.addBlock("public boolean getMoreResults(int current)");
        JavaLineProcessor jdbcTestCaseAdapterProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.jdbc.JDBCTestCaseAdapter", jdbcFiles);
        jdbcTestCaseAdapterProc.addLine("import com.mockrunner.mock.jdbc.MockSavepoint;");
        jdbcTestCaseAdapterProc.addBlock("protected List getSavepoints()");
        jdbcTestCaseAdapterProc.addBlock("protected MockSavepoint getSavepoint(int index)");
        jdbcTestCaseAdapterProc.addBlock("protected MockSavepoint getSavepoint(String name)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointPresent(int index)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointPresent(String name)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointReleased(int index)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointReleased(String name)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointNotReleased(int index)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointNotReleased(String name)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointRollbacked(int index)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointRollbacked(String name)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointNotRollbacked(int index)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointNotRollbacked(String name)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointRolledBack(int index)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointRolledBack(String name)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointNotRolledBack(int index)");
        jdbcTestCaseAdapterProc.addBlock("protected void verifySavepointNotRolledBack(String name)");
        jdbcFiles.put("com.mockrunner.jdbc.BasicJDBCTestCaseAdapter", jdbcTestCaseAdapterProc);
        JavaLineProcessor jdbcTestModuleProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.jdbc.JDBCTestModule", jdbcFiles);
        jdbcTestModuleProc.addLine("import com.mockrunner.mock.jdbc.MockSavepoint;");
        jdbcTestModuleProc.addBlock("public List getSavepoints()");
        jdbcTestModuleProc.addBlock("public MockSavepoint getSavepoint(int index)");
        jdbcTestModuleProc.addBlock("public MockSavepoint getSavepoint(String name)");
        jdbcTestModuleProc.addBlock("public void verifySavepointPresent(int index)");
        jdbcTestModuleProc.addBlock("public void verifySavepointPresent(String name)");
        jdbcTestModuleProc.addBlock("public void verifySavepointReleased(int index)");
        jdbcTestModuleProc.addBlock("public void verifySavepointReleased(String name)");
        jdbcTestModuleProc.addBlock("public void verifySavepointNotReleased(int index)");
        jdbcTestModuleProc.addBlock("public void verifySavepointNotReleased(String name)");
        jdbcTestModuleProc.addBlock("public void verifySavepointRollbacked(int index)");
        jdbcTestModuleProc.addBlock("public void verifySavepointRollbacked(String name)");
        jdbcTestModuleProc.addBlock("public void verifySavepointNotRollbacked(int index)");
        jdbcTestModuleProc.addBlock("public void verifySavepointNotRollbacked(String name)");
        jdbcTestModuleProc.addBlock("public void verifySavepointRolledBack(int index)");
        jdbcTestModuleProc.addBlock("public void verifySavepointRolledBack(String name)");
        jdbcTestModuleProc.addBlock("public void verifySavepointNotRolledBack(int index)");
        jdbcTestModuleProc.addBlock("public void verifySavepointNotRolledBack(String name)");
        JavaLineProcessor polyResultSetProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.PolyResultSet", jdbcFiles);
        polyResultSetProc.addBlock("public URL getURL(int columnIndex)");
        polyResultSetProc.addBlock("public URL getURL(String columnName)");
        polyResultSetProc.addBlock("public void updateRef(int columnIndex, Ref value)");
        polyResultSetProc.addBlock("public void updateRef(String columnName, Ref value)");
        polyResultSetProc.addBlock("public void updateBlob(int columnIndex, Blob value)");
        polyResultSetProc.addBlock("public void updateBlob(String columnName, Blob value)");
        polyResultSetProc.addBlock("public void updateClob(int columnIndex, Clob value)");
        polyResultSetProc.addBlock("public void updateClob(String columnName, Clob value)");
        polyResultSetProc.addBlock("public void updateArray(int columnIndex, Array value)");
        polyResultSetProc.addBlock("public void updateArray(String columnName, Array value)");
        jdbcFiles.put("com.mockrunner.mock.jdbc.MockSavepoint", Boolean.FALSE);
        jdbcFiles.put("com.mockrunner.mock.jdbc.MockParameterMetaData", Boolean.FALSE);
        return jdbcFiles;
    }

    private static Map prepareProcessorMapJDK14() {
        HashMap<String, Boolean> jdbcFiles = new HashMap<String, Boolean>();
        JavaLineProcessor mockDriverProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockDriver", jdbcFiles);
        mockDriverProc.addLine("import java.sql.SQLFeatureNotSupportedException;");
        mockDriverProc.addLine("import java.util.logging.Logger;");
        mockDriverProc.addLine("private Logger parentLogger = null;");
        mockDriverProc.addBlock("public Logger getParentLogger()");
        mockDriverProc.addBlock("public void setParentLogger(Logger parentLogger)");
        JavaLineProcessor mockDataSourceProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockDataSource", jdbcFiles);
        mockDataSourceProc.addLine("import java.sql.SQLFeatureNotSupportedException;");
        mockDataSourceProc.addLine("import java.util.logging.Logger;");
        mockDataSourceProc.addLine("private Logger parentLogger = null;");
        mockDataSourceProc.addBlock("public Logger getParentLogger()");
        mockDataSourceProc.addBlock("public void setParentLogger(Logger parentLogger)");
        JavaLineProcessor mockConnectionProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockConnection", jdbcFiles);
        mockConnectionProc.addLine("import java.sql.NClob;");
        mockConnectionProc.addLine("import java.sql.SQLXML;");
        mockConnectionProc.addLine("import java.util.concurrent.Executor;");
        mockConnectionProc.addBlock("public void abort(Executor executor)");
        mockConnectionProc.addBlock("public void setNetworkTimeout(Executor executor, int milliseconds)");
        mockConnectionProc.addBlock("public NClob createNClob()");
        mockConnectionProc.addBlock("public SQLXML createSQLXML()");
        JavaLineProcessor mockResultSetProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockResultSet", jdbcFiles);
        mockResultSetProc.addLine("import java.sql.NClob;");
        mockResultSetProc.addLine("import java.sql.RowId;");
        mockResultSetProc.addLine("import java.sql.SQLXML;");
        mockResultSetProc.addBlock("public NClob getNClob(int columnIndex)");
        mockResultSetProc.addBlock("public NClob getNClob(String columnName)");
        mockResultSetProc.addBlock("private NClob getNClobFromClob(Clob clobValue)");
        mockResultSetProc.addBlock("public void updateNClob(int columnIndex, NClob nClob)");
        mockResultSetProc.addBlock("public void updateNClob(String columnName, NClob nClob)");
        mockResultSetProc.addBlock("public void updateNClob(int columnIndex, Reader reader, long length)");
        mockResultSetProc.addBlock("public void updateNClob(String columnName, Reader reader, long length)");
        mockResultSetProc.addBlock("public void updateNClob(int columnIndex, Reader reader)");
        mockResultSetProc.addBlock("public void updateNClob(String columnName, Reader reader)");
        mockResultSetProc.addBlock("public RowId getRowId(int columnIndex)");
        mockResultSetProc.addBlock("public RowId getRowId(String columnName)");
        mockResultSetProc.addBlock("public void updateRowId(int columnIndex, RowId rowId)");
        mockResultSetProc.addBlock("public void updateRowId(String columnName, RowId rowId)");
        mockResultSetProc.addBlock("public SQLXML getSQLXML(int columnIndex)");
        mockResultSetProc.addBlock("public SQLXML getSQLXML(String columnName)");
        mockResultSetProc.addBlock("public void updateSQLXML(int columnIndex, SQLXML xmlObject)");
        mockResultSetProc.addBlock("public void updateSQLXML(String columnName, SQLXML xmlObject)");
        JavaLineProcessor mockPreparedStatementProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockPreparedStatement", jdbcFiles);
        mockPreparedStatementProc.addLine("import java.sql.NClob;");
        mockPreparedStatementProc.addLine("import java.sql.RowId;");
        mockPreparedStatementProc.addLine("import java.sql.SQLXML;");
        mockPreparedStatementProc.addBlock("public void setNClob(int parameterIndex, NClob nClob)");
        mockPreparedStatementProc.addBlock("public void setNClob(int parameterIndex, Reader reader)");
        mockPreparedStatementProc.addBlock("public void setNClob(int parameterIndex, Reader reader, long length)");
        mockPreparedStatementProc.addBlock("public void setRowId(int parameterIndex, RowId rowId)");
        mockPreparedStatementProc.addBlock("public void setSQLXML(int parameterIndex, SQLXML xmlObject)");
        JavaLineProcessor mockCallableStatementProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockCallableStatement", jdbcFiles);
        mockCallableStatementProc.addLine("import java.sql.NClob;");
        mockCallableStatementProc.addLine("import java.sql.RowId;");
        mockCallableStatementProc.addLine("import java.sql.SQLXML;");
        mockCallableStatementProc.addBlock("public NClob getNClob(int parameterIndex)");
        mockCallableStatementProc.addBlock("public SQLXML getSQLXML(int parameterIndex)");
        mockCallableStatementProc.addBlock("public RowId getRowId(int parameterIndex)");
        mockCallableStatementProc.addBlock("public NClob getNClob(String parameterName)");
        mockCallableStatementProc.addBlock("public SQLXML getSQLXML(String parameterName)");
        mockCallableStatementProc.addBlock("public RowId getRowId(String parameterName)");
        mockCallableStatementProc.addBlock("public void setNClob(String parameterName, NClob nClob)");
        mockCallableStatementProc.addBlock("public void setNClob(String parameterName, Reader reader)");
        mockCallableStatementProc.addBlock("public void setNClob(String parameterName, Reader reader, long length)");
        mockCallableStatementProc.addBlock("public void setSQLXML(String parameterName, SQLXML xmlObject)");
        mockCallableStatementProc.addBlock("public void setRowId(String parameterName, RowId rowId)");
        mockCallableStatementProc.addBlock("private NClob getNClobFromClob(Clob clobValue)");
        JavaLineProcessor mockDatabaseMetadataProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.MockDatabaseMetaData", jdbcFiles);
        mockDatabaseMetadataProc.addLine("import java.sql.RowIdLifetime;");
        mockDatabaseMetadataProc.addLine("private RowIdLifetime rowIdLifetime = RowIdLifetime.ROWID_VALID_TRANSACTION;");
        mockDatabaseMetadataProc.addBlock("public RowIdLifetime getRowIdLifetime()");
        mockDatabaseMetadataProc.addBlock("public void setRowIdLifetime(RowIdLifetime rowIdLifetime)");
        JavaLineProcessor polyResultSetProc = JDKVersionGenerator.getProcessorForClass("com.mockrunner.mock.jdbc.PolyResultSet", jdbcFiles);
        polyResultSetProc.addLine("import java.sql.NClob;");
        polyResultSetProc.addLine("import java.sql.RowId;");
        polyResultSetProc.addLine("import java.sql.SQLXML;");
        polyResultSetProc.addBlock("public String getNString(int columnIndex)");
        polyResultSetProc.addBlock("public RowId getRowId(int columnIndex)");
        polyResultSetProc.addBlock("public NClob getNClob(int columnIndex)");
        polyResultSetProc.addBlock("public SQLXML getSQLXML(int columnIndex)");
        polyResultSetProc.addBlock("public RowId getRowId(String columnName)");
        polyResultSetProc.addBlock("public NClob getNClob(String columnName)");
        polyResultSetProc.addBlock("public SQLXML getSQLXML(String columnName)");
        polyResultSetProc.addBlock("public int getHoldability()");
        polyResultSetProc.addBlock("public void updateRowId(int columnIndex, RowId x)");
        polyResultSetProc.addBlock("public void updateNClob(int columnIndex, NClob nClob)");
        polyResultSetProc.addBlock("public void updateSQLXML(int columnIndex, SQLXML xmlObject)");
        polyResultSetProc.addBlock("public void updateRowId(String columnName, RowId value)");
        polyResultSetProc.addBlock("public void updateNClob(String columnName, NClob nClob)");
        polyResultSetProc.addBlock("public void updateSQLXML(String columnName, SQLXML xmlObject)");
        jdbcFiles.put("com.mockrunner.mock.jdbc.MockSQLXML", Boolean.FALSE);
        jdbcFiles.put("com.mockrunner.mock.jdbc.MockNClob", Boolean.FALSE);
        jdbcFiles.put("com.mockrunner.mock.jdbc.MockRowId", Boolean.FALSE);
        return jdbcFiles;
    }

    private static JavaLineProcessor getProcessorForClass(String className, Map jdbcFiles) {
        JavaLineProcessor processor = (JavaLineProcessor)jdbcFiles.get(className);
        if (null == processor) {
            processor = new JavaLineProcessor();
            jdbcFiles.put(className, processor);
        }
        return processor;
    }
}

