/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.utils;

import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ValidationUtils {
    public static int parseAsInteger(String propertyValue, String property) {
        ValidationUtils.parseAsString(propertyValue, property);
        if (propertyValue.matches("\\d+")) {
            try {
                int value = Integer.parseInt(propertyValue);
                return value;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalStateException(String.format("%s property has to be an positive integer.", property));
    }

    public static boolean parseAsBoolean(String propertyValue, String property) {
        ValidationUtils.parseAsString(propertyValue, property);
        if (propertyValue.equalsIgnoreCase("true") || propertyValue.equalsIgnoreCase("false")) {
            return Boolean.parseBoolean(propertyValue);
        }
        throw new IllegalStateException(String.format("%s property has to be a boolean valid.", property));
    }

    public static String parseAsString(String propertyValue, String property) {
        if (ValidationUtils.isBlank(propertyValue)) {
            throw new IllegalStateException(String.format("%s property has to be a valid String.", property));
        }
        return propertyValue;
    }

    public static int parseAsPort(String propertyValue, String property) {
        int value = ValidationUtils.parseAsInteger(propertyValue, property);
        if (value == 0 || value > 65536) {
            throw new IllegalStateException(String.format("%s property has to be a valid port.", property));
        }
        return value;
    }

    public static String parseAsHttpProtocol(String httpProtocol) {
        ValidationUtils.parseAsString(httpProtocol, "client.config.http-protocol");
        if (!httpProtocol.equalsIgnoreCase("http") && !httpProtocol.equalsIgnoreCase("https")) {
            throw new IllegalStateException(String.format("%s has to be equal to \"http\" or \"https\"", "client.config.http-protocol"));
        }
        return httpProtocol;
    }

    public static boolean validNotNull(Object object, String objectName) {
        if (object == null) {
            throw new IllegalStateException(String.format("%s cannot be null.", objectName));
        }
        return true;
    }

    public static boolean validIsFile(File fileName) {
        ValidationUtils.validNotNull(fileName, "configuration file");
        if (!fileName.exists() || fileName.isDirectory()) {
            throw new IllegalStateException(String.format("This file, %s does not exist or is a folder", fileName.getAbsolutePath()));
        }
        return true;
    }

    public static boolean notBlank(String object, String message) {
        if (ValidationUtils.isBlank(object)) {
            throw new IllegalStateException(message);
        }
        return true;
    }

    public static boolean notNullNorEmpty(List list, String message) {
        if (list == null || list.isEmpty()) {
            throw new IllegalStateException(message);
        }
        return true;
    }

    public static boolean isBlank(String object) {
        return StringUtils.isBlank((CharSequence)object);
    }
}

