/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.utils;

import com.google.common.collect.Lists;
import com.mnubo.java.sdk.client.models.result.BooleanValue;
import com.mnubo.java.sdk.client.models.result.DoubleValue;
import com.mnubo.java.sdk.client.models.result.FloatValue;
import com.mnubo.java.sdk.client.models.result.IntegerValue;
import com.mnubo.java.sdk.client.models.result.LongValue;
import com.mnubo.java.sdk.client.models.result.ResultValue;
import com.mnubo.java.sdk.client.models.result.StringValue;
import java.util.ArrayList;
import java.util.List;

public class Convert {
    public static String highLevelToPrimitiveType(String highLevelType) {
        String primitiveType = "unknown";
        switch (highLevelType.toUpperCase()) {
            case "INT": 
            case "TIME": {
                primitiveType = "INT";
                break;
            }
            case "COUNTRY_ISO": 
            case "DATETIME": 
            case "EMAIL": 
            case "STATE": 
            case "TEXT": 
            case "TIME_ZONE": {
                primitiveType = "STRING";
                break;
            }
            case "LONG": 
            case "DURATION": {
                primitiveType = "LONG";
                break;
            }
            case "ACCELERATION": 
            case "AREA": 
            case "DOUBLE": 
            case "LENGTH": 
            case "SPEED": 
            case "TEMPERATURE": 
            case "VOLUME": {
                primitiveType = "DOUBLE";
                break;
            }
            case "BOOLEAN": {
                primitiveType = "BOOLEAN";
                break;
            }
            case "MASS": 
            case "FLOAT": {
                primitiveType = "FLOAT";
                break;
            }
            case "PREDICTIVE_MODEL": {
                primitiveType = "BLOB";
            }
        }
        return primitiveType;
    }

    public static ResultValue toResultValue(Object value) {
        ResultValue resultValue;
        if (value instanceof String) {
            resultValue = new StringValue((String)value);
        } else if (value instanceof Integer) {
            resultValue = new IntegerValue((Integer)value);
        } else if (value instanceof Long) {
            resultValue = new LongValue((Long)value);
        } else if (value instanceof Float) {
            resultValue = new FloatValue(((Float)value).floatValue());
        } else if (value instanceof Double) {
            resultValue = new DoubleValue((Double)value);
        } else if (value instanceof Boolean) {
            resultValue = new BooleanValue((Boolean)value);
        } else {
            throw new NumberFormatException(String.format("Unsupported type for value '%s'", value.toString()));
        }
        return resultValue;
    }

    public static List<ResultValue> toResultValueList(List<Object> values) {
        ArrayList resultValues = Lists.newArrayList();
        for (Object value : values) {
            resultValues.add(Convert.toResultValue(value));
        }
        return resultValues;
    }
}

