/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.services;

import com.mnubo.java.sdk.client.models.DataSet;
import com.mnubo.java.sdk.client.models.result.ResultSet;
import com.mnubo.java.sdk.client.models.result.Row;
import com.mnubo.java.sdk.client.models.result.SearchResult;
import com.mnubo.java.sdk.client.models.result.SearchResultSet;
import com.mnubo.java.sdk.client.models.result.SearchRow;
import com.mnubo.java.sdk.client.services.SDKService;
import com.mnubo.java.sdk.client.spi.SearchSDK;
import com.mnubo.java.sdk.client.utils.Convert;
import com.mnubo.java.sdk.client.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.List;

class SearchSDKServices
implements SearchSDK {
    public static final String BASIC_SEARCH_PATH = "/search/basic";
    public static final String DATASETS_SEARCH_PATH = "/search/datasets";
    private final SDKService sdkCommonServices;

    SearchSDKServices(SDKService sdkCommonServices) {
        this.sdkCommonServices = sdkCommonServices;
    }

    public SDKService getSdkCommonServices() {
        return this.sdkCommonServices;
    }

    @Override
    public ResultSet search(String query) {
        String url = this.sdkCommonServices.getRestitutionBaseUri().path(BASIC_SEARCH_PATH).build().toString();
        ValidationUtils.validNotNull(query, "Query body");
        SearchResult searchResult = this.sdkCommonServices.postRequest(url, SearchResult.class, query);
        if (searchResult == null) {
            return null;
        }
        return new SearchResultSet(SearchSDKServices.extractDefinitions(searchResult), SearchSDKServices.extractRows(searchResult));
    }

    @Override
    public List<DataSet> getDatasets() {
        String url = this.sdkCommonServices.getRestitutionBaseUri().path(DATASETS_SEARCH_PATH).build().toString();
        return this.sdkCommonServices.getRequest(url, List.class);
    }

    private static List<ResultSet.ColumnDefinition> extractDefinitions(SearchResult result) {
        ArrayList<ResultSet.ColumnDefinition> columnDefinitions = new ArrayList<ResultSet.ColumnDefinition>();
        for (SearchResult.Column column : result.getColumns()) {
            columnDefinitions.add(new ResultSet.ColumnDefinition(column.getLabel(), column.getType()));
        }
        return columnDefinitions;
    }

    private static List<Row> extractRows(SearchResult result) {
        ArrayList<Row> rows = new ArrayList<Row>();
        ArrayList<ResultSet.ColumnDefinition> columnDefinitions = new ArrayList<ResultSet.ColumnDefinition>();
        for (SearchResult.Column column : result.getColumns()) {
            columnDefinitions.add(new ResultSet.ColumnDefinition(column.getLabel(), column.getType()));
        }
        for (List list : result.getRows()) {
            SearchRow searchRow = new SearchRow(columnDefinitions, Convert.toResultValueList(list));
            rows.add(searchRow);
        }
        return rows;
    }
}

