/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.services;

import com.mnubo.java.sdk.client.config.MnuboSDKConfig;
import com.mnubo.java.sdk.client.services.CredentialHandler;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

class SDKService {
    private RestTemplate template;
    private final CredentialHandler credential;
    private final MnuboSDKConfig config;

    SDKService(RestTemplate template, CredentialHandler credential, MnuboSDKConfig config) {
        this.credential = credential;
        this.template = template;
        this.config = config;
    }

    void postRequest(String url) {
        HttpEntity request = new HttpEntity((MultiValueMap)this.buildHeaders());
        this.template.postForEntity(url, (Object)request, String.class, new Object[0]);
    }

    <T> T postRequest(String url, Class<T> objectClass, Object object) {
        HttpEntity request = new HttpEntity(object, (MultiValueMap)this.buildHeaders());
        return (T)this.template.postForObject(url, (Object)request, objectClass, new Object[0]);
    }

    void putRequest(String url, Object object) {
        HttpEntity request = new HttpEntity(object, (MultiValueMap)this.buildHeaders());
        this.template.put(url, (Object)request, new Object[0]);
    }

    <T> ResponseEntity<T> getRequestResponseEntity(String url, Class<T> objectClass) {
        HttpEntity request = new HttpEntity((MultiValueMap)this.buildHeaders());
        return this.template.exchange(url, HttpMethod.GET, request, objectClass, new Object[0]);
    }

    <T> T getRequest(String url, Class<T> objectClass) {
        HttpEntity request = new HttpEntity((MultiValueMap)this.buildHeaders());
        ResponseEntity response = this.template.exchange(url, HttpMethod.GET, request, objectClass, new Object[0]);
        if (response == null) {
            return null;
        }
        return (T)response.getBody();
    }

    void deleteRequest(String url) {
        HttpEntity request = new HttpEntity((MultiValueMap)this.buildHeaders());
        this.template.exchange(url, HttpMethod.DELETE, request, String.class, new Object[0]);
    }

    HttpHeaders buildHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", this.credential.getAutorizationToken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    MnuboSDKConfig getConfig() {
        return this.config;
    }

    UriComponentsBuilder getIngestionBaseUri() {
        return UriComponentsBuilder.newInstance().host(this.getConfig().getHostName()).port(this.getConfig().getPlatformPort()).scheme(this.getConfig().getHttpProtocol()).path(this.getConfig().getHttpBasePath());
    }

    UriComponentsBuilder getRestitutionBaseUri() {
        return UriComponentsBuilder.newInstance().host(this.getConfig().getHostName()).port(this.getConfig().getRestitutionPort()).scheme(this.getConfig().getHttpProtocol()).path(this.getConfig().getHttpBasePath());
    }
}

