/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.services;

import com.mnubo.java.sdk.client.models.Owner;
import com.mnubo.java.sdk.client.services.SDKService;
import com.mnubo.java.sdk.client.spi.OwnersSDK;
import com.mnubo.java.sdk.client.utils.ValidationUtils;

class OwnersSDKServices
implements OwnersSDK {
    public static final String OWNER_PATH = "/owners";
    private final SDKService sdkCommonServices;

    OwnersSDKServices(SDKService sdkCommonServices) {
        this.sdkCommonServices = sdkCommonServices;
    }

    @Override
    public void create(Owner owner) {
        String url = this.sdkCommonServices.getIngestionBaseUri().path(OWNER_PATH).build().toString();
        ValidationUtils.validNotNull(owner, "Owner body");
        ValidationUtils.notBlank(owner.getUsername(), "usermame cannot be blank.");
        this.sdkCommonServices.postRequest(url, Owner.class, owner);
    }

    @Override
    public void claim(String username, String deviceId) {
        ValidationUtils.notBlank(username, "usermame cannot be blank.");
        ValidationUtils.notBlank(deviceId, "x_deviceId cannot be blank.");
        String url = this.sdkCommonServices.getIngestionBaseUri().path(OWNER_PATH).pathSegment(new String[]{username, "objects", deviceId, "claim"}).build().toString();
        this.sdkCommonServices.postRequest(url);
    }

    @Override
    public void update(Owner owner, String username) {
        ValidationUtils.notBlank(username, "usermame cannot be blank.");
        ValidationUtils.validNotNull(owner, "Owner body");
        String url = this.sdkCommonServices.getIngestionBaseUri().path(OWNER_PATH).pathSegment(new String[]{username}).build().toString();
        this.sdkCommonServices.putRequest(url, owner);
    }

    @Override
    public void delete(String username) {
        ValidationUtils.notBlank(username, "usermame cannot be blank.");
        String url = this.sdkCommonServices.getIngestionBaseUri().path(OWNER_PATH).pathSegment(new String[]{username}).build().toString();
        this.sdkCommonServices.deleteRequest(url);
    }
}

