/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.services;

import com.mnubo.java.sdk.client.models.SmartObject;
import com.mnubo.java.sdk.client.services.SDKService;
import com.mnubo.java.sdk.client.spi.ObjectsSDK;
import com.mnubo.java.sdk.client.utils.ValidationUtils;

class ObjectsSDKServices
implements ObjectsSDK {
    private final SDKService sdkCommonServices;

    ObjectsSDKServices(SDKService sdkCommonServices) {
        this.sdkCommonServices = sdkCommonServices;
    }

    @Override
    public void create(SmartObject object) {
        String url = this.sdkCommonServices.getIngestionBaseUri().path("/objects").build().toString();
        ValidationUtils.validNotNull(object, "Object body");
        ValidationUtils.notBlank(object.getObjectType(), "x_object_Type cannot be blank.");
        ValidationUtils.notBlank(object.getDeviceId(), "x_device_Id cannot be blank.");
        this.sdkCommonServices.postRequest(url, SmartObject.class, object);
    }

    @Override
    public void update(SmartObject object, String deviceId) {
        ValidationUtils.notBlank(deviceId, "x_device_Id cannot be blank.");
        ValidationUtils.validNotNull(object, "Object body");
        String url = this.sdkCommonServices.getIngestionBaseUri().path("/objects").pathSegment(new String[]{deviceId}).build().toString();
        this.sdkCommonServices.putRequest(url, object);
    }

    @Override
    public void delete(String deviceId) {
        ValidationUtils.notBlank(deviceId, "x_device_Id cannot be blank.");
        String url = this.sdkCommonServices.getIngestionBaseUri().path("/objects").pathSegment(new String[]{deviceId}).build().toString();
        this.sdkCommonServices.deleteRequest(url);
    }
}

