/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.services;

import com.mnubo.java.sdk.client.config.MnuboSDKConfig;
import com.mnubo.java.sdk.client.services.CredentialHandler;
import com.mnubo.java.sdk.client.services.HttpRestTemplate;
import com.mnubo.java.sdk.client.services.MnuboSDKClientImpl;
import com.mnubo.java.sdk.client.spi.MnuboSDKClient;
import com.mnubo.java.sdk.client.utils.ValidationUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.web.client.RestTemplate;

public abstract class MnuboSDKFactory {
    public static MnuboSDKClient getClient(String hostName, String securityConsumerKey, String securityConsumerSecret) {
        MnuboSDKConfig.Builder configBuilder = MnuboSDKConfig.builder();
        ValidationUtils.notBlank(hostName, "hostname property cannot be empty or null.");
        ValidationUtils.notBlank(securityConsumerKey, "securityConsumerKey property cannot be empty or null.");
        ValidationUtils.notBlank(securityConsumerSecret, "securityConsumerSecret property cannot be empty or null.");
        configBuilder.withHostName(hostName);
        configBuilder.withSecurityConsumerKey(securityConsumerKey);
        configBuilder.withSecurityConsumerSecret(securityConsumerSecret);
        return MnuboSDKFactory.generateClients(configBuilder.build());
    }

    public static MnuboSDKClient getAdvanceClient(Properties properties) {
        MnuboSDKConfig.Builder configBuilder = MnuboSDKConfig.builder();
        ValidationUtils.validNotNull(properties, "Configuration properties instance");
        if (properties.containsKey("client.config.hostname")) {
            configBuilder.withHostName(properties.getProperty("client.config.hostname"));
        }
        if (properties.containsKey("client.config.ingestion-port")) {
            configBuilder.withIngestionPort(properties.getProperty("client.config.ingestion-port"));
        }
        if (properties.containsKey("client.config.autentication-port")) {
            configBuilder.withAuthenticationPort(properties.getProperty("client.config.autentication-port"));
        }
        if (properties.containsKey("client.security.consumer-key")) {
            configBuilder.withSecurityConsumerKey(properties.getProperty("client.security.consumer-key"));
        }
        if (properties.containsKey("client.security.consumer-secret")) {
            configBuilder.withSecurityConsumerSecret(properties.getProperty("client.security.consumer-secret"));
        }
        if (properties.containsKey("client.config.http-protocol")) {
            configBuilder.withHttpProtocol(properties.getProperty("client.config.http-protocol"));
        }
        if (properties.containsKey("client.http.client.disable-redirect-handling")) {
            configBuilder.withHttpDisableRedirectHandling(properties.getProperty("client.http.client.disable-redirect-handling"));
        }
        if (properties.containsKey("client.http.client.disable-automatic-retries")) {
            configBuilder.withHttpDisableAutomaticRetries(properties.getProperty("client.http.client.disable-automatic-retries"));
        }
        if (properties.containsKey("client.http.client.max-connections-per-route")) {
            configBuilder.withHttpMaxConnectionPerRoute(properties.getProperty("client.http.client.max-connections-per-route"));
        }
        if (properties.containsKey("client.http.client.http.client.default-timeout")) {
            configBuilder.withHttpDefaultTimeout(properties.getProperty("client.http.client.http.client.default-timeout"));
        }
        if (properties.containsKey("client.http.client.http.client.connect-timeout")) {
            configBuilder.withHttpConnectionTimeout(properties.getProperty("client.http.client.http.client.connect-timeout"));
        }
        if (properties.containsKey("client.http.client.connection-request-timeout")) {
            configBuilder.withHttpConnectionRequestTimeout(properties.getProperty("client.http.client.connection-request-timeout"));
        }
        if (properties.containsKey("client.http.client.http.client.socket-timeout")) {
            configBuilder.withHttpSocketTimeout(properties.getProperty("client.http.client.http.client.socket-timeout"));
        }
        if (properties.containsKey("client.http.client.max-total-connection")) {
            configBuilder.withHttpMaxTotalConnection(properties.getProperty("client.http.client.max-total-connection"));
        }
        if (properties.containsKey("client.http.client.base-path")) {
            configBuilder.withHttpBasePath(properties.getProperty("client.http.client.base-path"));
        }
        return MnuboSDKFactory.generateClients(configBuilder.build());
    }

    public static MnuboSDKClient getAdvanceClient(InputStream config) throws IOException {
        ValidationUtils.validNotNull(config, "configuration streaming instance");
        Properties properties = new Properties();
        properties.load(config);
        return MnuboSDKFactory.getAdvanceClient(properties);
    }

    public static MnuboSDKClient getAdvanceClient(File configFile) throws IOException {
        ValidationUtils.validIsFile(configFile);
        FileInputStream config = new FileInputStream(configFile);
        return MnuboSDKFactory.getAdvanceClient(config);
    }

    private static MnuboSDKClient generateClients(MnuboSDKConfig config) {
        RestTemplate restTemplate = new HttpRestTemplate(config).getRestTemplate();
        CredentialHandler credentials = new CredentialHandler(config, restTemplate);
        return new MnuboSDKClientImpl(config, restTemplate, credentials);
    }
}

