/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.services;

import com.mnubo.java.sdk.client.config.MnuboSDKConfig;
import com.mnubo.java.sdk.client.services.CredentialHandler;
import com.mnubo.java.sdk.client.services.EventsSDKServices;
import com.mnubo.java.sdk.client.services.ObjectsSDKServices;
import com.mnubo.java.sdk.client.services.OwnersSDKServices;
import com.mnubo.java.sdk.client.services.SDKService;
import com.mnubo.java.sdk.client.services.SearchSDKServices;
import com.mnubo.java.sdk.client.spi.EventsSDK;
import com.mnubo.java.sdk.client.spi.MnuboSDKClient;
import com.mnubo.java.sdk.client.spi.ObjectsSDK;
import com.mnubo.java.sdk.client.spi.OwnersSDK;
import com.mnubo.java.sdk.client.spi.SearchSDK;
import org.springframework.web.client.RestTemplate;

final class MnuboSDKClientImpl
implements MnuboSDKClient {
    private final ObjectsSDK objectCLient;
    private final OwnersSDK ownerCLient;
    private final EventsSDK eventCLient;
    private final SearchSDK searchCLient;
    private final SDKService sdkService;

    MnuboSDKClientImpl(MnuboSDKConfig config, RestTemplate restTemplate, CredentialHandler credentials) {
        this.sdkService = new SDKService(restTemplate, credentials, config);
        this.objectCLient = new ObjectsSDKServices(this.sdkService);
        this.eventCLient = new EventsSDKServices(this.sdkService);
        this.ownerCLient = new OwnersSDKServices(this.sdkService);
        this.searchCLient = new SearchSDKServices(this.sdkService);
    }

    @Override
    public ObjectsSDK getObjectClient() {
        return this.objectCLient;
    }

    @Override
    public EventsSDK getEventClient() {
        return this.eventCLient;
    }

    @Override
    public OwnersSDK getOwnerClient() {
        return this.ownerCLient;
    }

    @Override
    public SearchSDK getSearchClient() {
        return this.searchCLient;
    }

    public SDKService getSdkService() {
        return this.sdkService;
    }
}

