/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mnubo.java.sdk.client.config.MnuboSDKConfig;
import com.mnubo.java.sdk.client.mapper.ObjectMapperConfig;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

class HttpRestTemplate {
    private RestTemplate restTemplate;

    HttpRestTemplate(MnuboSDKConfig config) {
        HttpClient httpClient = this.getHttpClient(config);
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory(httpClient);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        this.configureMapper(ObjectMapperConfig.getObjectMapper());
    }

    private void configureMapper(ObjectMapper objectMapper) {
        List converters = this.restTemplate.getMessageConverters();
        for (HttpMessageConverter converter : converters) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter jsonConverter = (MappingJackson2HttpMessageConverter)converter;
            jsonConverter.setObjectMapper(objectMapper);
        }
    }

    private HttpClient getHttpClient(MnuboSDKConfig config) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.getHttpDefaultTimeout()).setConnectionRequestTimeout(config.getHttpConnectionRequestTimeout()).setSocketTimeout(config.getHttpSoketTimeout()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(config.getHttpMaxTotalConnection());
        connectionManager.setDefaultMaxPerRoute(config.getHttpMaxConnectionPerRoute());
        connectionManager.setMaxPerRoute(new HttpRoute(new HttpHost(config.getHostName())), config.getHttpMaxConnectionPerRoute());
        connectionManager.setValidateAfterInactivity(1000);
        HttpClientBuilder httpClientsBuilder = HttpClients.custom().setDefaultRequestConfig(requestConfig);
        if (config.isHttpDisableCockieManagement()) {
            httpClientsBuilder.disableCookieManagement();
        }
        if (config.isHttpDisableRedirectHandling()) {
            httpClientsBuilder.disableRedirectHandling();
        }
        if (config.isHttpDisableAutomaticRetries()) {
            httpClientsBuilder.disableAutomaticRetries();
        }
        if (config.isHttpSystemPropertiesEnable()) {
            httpClientsBuilder.useSystemProperties();
        }
        httpClientsBuilder.setMaxConnPerRoute(config.getHttpMaxConnectionPerRoute()).setMaxConnTotal(config.getHttpMaxConnectionPerRoute() * 2).setConnectionManager((HttpClientConnectionManager)connectionManager);
        return httpClientsBuilder.build();
    }

    RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

