/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.services;

import com.mnubo.java.sdk.client.models.Event;
import com.mnubo.java.sdk.client.services.SDKService;
import com.mnubo.java.sdk.client.spi.EventsSDK;
import com.mnubo.java.sdk.client.utils.ValidationUtils;
import java.util.List;

class EventsSDKServices
implements EventsSDK {
    public static final String EVENT_PATH = "/events";
    public static final String EVENT_PATH_SEGMENT = "events";
    private final SDKService sdkCommonServices;

    EventsSDKServices(SDKService sdkCommonServices) {
        this.sdkCommonServices = sdkCommonServices;
    }

    @Override
    public void send(String deviceId, List<Event> events) {
        ValidationUtils.notBlank(deviceId, "x_device_Id cannot be blank.");
        ValidationUtils.notNullNorEmpty(events, "Event list cannot be null or empty.");
        String url = this.sdkCommonServices.getIngestionBaseUri().path("/objects").pathSegment(new String[]{deviceId, EVENT_PATH_SEGMENT}).build().toString();
        this.sdkCommonServices.postRequest(url, Event.class, events);
    }

    @Override
    public void send(List<Event> events) {
        ValidationUtils.notNullNorEmpty(events, "Event list cannot be null or empty.");
        String url = this.sdkCommonServices.getIngestionBaseUri().path(EVENT_PATH).build().toString();
        this.sdkCommonServices.postRequest(url, Event.class, events);
    }
}

