/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.services;

import com.mnubo.java.sdk.client.config.MnuboSDKConfig;
import com.mnubo.java.sdk.client.services.Token;
import com.mnubo.java.sdk.client.utils.ValidationUtils;
import org.joda.time.DateTime;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Base64Utils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

class CredentialHandler {
    private MnuboSDKConfig config;
    private Token credentials;
    private RestTemplate restTemplate;
    private DateTime expireTime;

    CredentialHandler(MnuboSDKConfig aConfig, RestTemplate template) {
        this.config = aConfig;
        this.restTemplate = template;
        this.requestToken();
    }

    private void setExpireTime(int seconds) {
        this.expireTime = DateTime.now().plusSeconds(seconds);
    }

    private void setCredentials(Token credential) {
        this.credentials = credential;
    }

    private void requestToken() {
        try {
            String url = UriComponentsBuilder.newInstance().host(this.config.getHostName()).port(this.config.getAuthenticationPort()).scheme(this.config.getHttpProtocol()).path("/oauth/token").queryParam("grant_type", new Object[]{"client_credentials"}).queryParam("scope", new Object[]{this.config.getScope()}).build().toString();
            HttpHeaders headers = new HttpHeaders();
            String autentication = this.config.getSecurityConsumerKey() + ":" + this.config.getSecurityConsumerSecret();
            headers.set("Authorization", "Basic " + Base64Utils.encodeToString((byte[])autentication.getBytes()));
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request, Token.class, new Object[0]);
            ValidationUtils.notBlank(((Token)response.getBody()).getAccessToken(), "Token not valid, check autentication server or credentials");
            ValidationUtils.notBlank(((Token)response.getBody()).getTokenType(), "Token not valid, check autentication server or credentials");
            this.setCredentials((Token)response.getBody());
            this.setExpireTime(this.credentials.getExpiresIn());
        }
        catch (Exception ex) {
            this.setExpireTime(0);
            System.out.print(ex.getMessage());
            throw new IllegalStateException(ex.getCause() + ex.getMessage());
        }
    }

    String getAutorizationToken() {
        if (DateTime.now().getMillis() + 5000L > this.expireTime.getMillis()) {
            this.requestToken();
        }
        return this.credentials.getTokenType() + " " + this.credentials.getAccessToken();
    }
}

