/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.models.result;

import com.google.common.base.Preconditions;
import com.mnubo.java.sdk.client.models.result.ResultSet;
import com.mnubo.java.sdk.client.models.result.Row;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;

public class SearchResultSet
implements ResultSet {
    private final List<ResultSet.ColumnDefinition> columnsMetadata;
    private final Queue<Row> queueRows;

    public SearchResultSet(List<ResultSet.ColumnDefinition> columnsMetadata, List<Row> rowValues) {
        Preconditions.checkNotNull(columnsMetadata, (Object)"columnsMetadata must not be null");
        Preconditions.checkNotNull(rowValues, (Object)"rowValues must not be null");
        this.columnsMetadata = columnsMetadata;
        this.queueRows = new ArrayDeque<Row>();
        for (Row row : rowValues) {
            this.queueRows.add(row);
        }
    }

    @Override
    public List<ResultSet.ColumnDefinition> getColumnDefinitions() {
        return this.columnsMetadata;
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return !SearchResultSet.this.isExhausted();
            }

            @Override
            public Row next() {
                return SearchResultSet.this.one();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Row one() {
        return this.queueRows.poll();
    }

    @Override
    public boolean isExhausted() {
        return this.queueRows.isEmpty();
    }

    @Override
    public List<Row> all() {
        if (this.isExhausted()) {
            return Collections.emptyList();
        }
        return new ArrayList<Row>(this.queueRows);
    }
}

