/*
 * Decompiled with CFR 0.152.
 */
package com.mnubo.java.sdk.client.models.result;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;

public class SearchResult {
    List<Column> columns;
    List<List<Object>> rows;

    @JsonCreator
    public SearchResult(@JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="rows") List<List<Object>> rows) {
        Preconditions.checkNotNull(columns, (Object)"columns must not be null");
        Preconditions.checkNotNull(rows, (Object)"rows must not be null");
        this.columns = columns;
        this.rows = rows;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<List<Object>> getRows() {
        return this.rows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)o;
        if (!this.columns.equals(that.columns)) {
            return false;
        }
        return this.rows.equals(that.rows);
    }

    public int hashCode() {
        int result = this.columns.hashCode();
        result = 31 * result + this.rows.hashCode();
        return result;
    }

    public static class Column {
        private final String label;
        private final String type;

        @JsonCreator
        public Column(@JsonProperty(value="label") String label, @JsonProperty(value="type") String type) {
            Preconditions.checkNotNull((Object)label, (Object)"label must not be null");
            Preconditions.checkNotNull((Object)type, (Object)"type must not be null");
            this.label = label;
            this.type = type;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            if (this.label != null ? !this.label.equals(column.label) : column.label != null) {
                return false;
            }
            return this.type != null ? this.type.equals(column.type) : column.type == null;
        }

        public int hashCode() {
            int result = this.label != null ? this.label.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}

